/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.builders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intabulas.sandler.builders.SyndicationBuilder;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.AbstractEntryElement;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.FeedImpl;
import org.intabulas.sandler.elements.impl.GeneratorImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.elements.impl.PersonImpl;
import org.intabulas.sandler.util.SandlerUtilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XPPBuilder
implements SyndicationBuilder {
    private Logger _logger = Logger.getLogger((class$org$intabulas$sandler$builders$XPPBuilder == null ? (class$org$intabulas$sandler$builders$XPPBuilder = XPPBuilder.class$("org.intabulas.sandler.builders.XPPBuilder")) : class$org$intabulas$sandler$builders$XPPBuilder).getName());
    static /* synthetic */ Class class$org$intabulas$sandler$builders$XPPBuilder;

    public Feed parseInput(InputStream in) {
        return this.parseInput(in, "UTF-8");
    }

    public Feed parseInput(InputStream in, String encoding) {
        FeedImpl result = null;
        try {
            XmlPullParser parser = this.getXPPInstance(in, encoding);
            result = new FeedImpl();
            this.loadFeedDocument(parser, result);
        }
        catch (XmlPullParserException e) {
            this._logger.log(Level.SEVERE, "Unable to load feed", e);
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Unable to load feed", e);
        }
        return result;
    }

    public Entry parseEntryInput(InputStream in) {
        return this.parseEntryInput(in, "UTF-8");
    }

    public Entry parseEntryInput(InputStream in, String encoding) {
        EntryImpl result = null;
        try {
            XmlPullParser parser = this.getXPPInstance(in, encoding);
            result = new EntryImpl();
            this.loadEntryDocument(parser, result);
        }
        catch (XmlPullParserException e) {
            this._logger.log(Level.SEVERE, "Unable to load entry", e);
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Unable to load entry", e);
        }
        return result;
    }

    private XmlPullParser getXPPInstance(InputStream in, String encoding) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        try {
            parser.setInput(new InputStreamReader(in, encoding));
        }
        catch (UnsupportedEncodingException e) {
            this._logger.log(Level.WARNING, "Unable to set encoding to " + encoding + ". Using default platform encoding", e);
            parser.setInput(new InputStreamReader(in));
        }
        return parser;
    }

    public void loadFeedDocument(XmlPullParser parser, Feed feed) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType != 2 || !parser.getName().equalsIgnoreCase("feed")) continue;
            this.processFeedDocumentAttributes(parser, feed);
            this.processFeedDocumentElements(parser, feed);
        } while ((eventType = parser.next()) != 1);
    }

    private void processFeedDocumentElements(XmlPullParser parser, Feed feed) throws XmlPullParserException, IOException {
        String entityName = null;
        int eventType = parser.nextTag();
        do {
            if (eventType == 2) {
                entityName = parser.getName();
                if (entityName.equalsIgnoreCase("title")) {
                    this.processTitleTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    this.loadLinkDocument(parser, link);
                    feed.addLink(link);
                } else if (entityName.equalsIgnoreCase("id")) {
                    this.processIdTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("tagline")) {
                    this.processTaglineTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("info")) {
                    this.processInfoTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("copyright")) {
                    this.processCopyrightTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("generator")) {
                    GeneratorImpl generator = new GeneratorImpl();
                    this.loadGeneratorDocument(parser, generator);
                    feed.setGenerator(generator);
                } else if (entityName.equalsIgnoreCase("entry")) {
                    EntryImpl entry = new EntryImpl();
                    this.loadEntryDocument(parser, entry);
                    feed.addEntry(entry);
                } else if (entityName.equalsIgnoreCase("author")) {
                    PersonImpl author = new PersonImpl();
                    this.loadPersonDocument(parser, author);
                    feed.setAuthor(author);
                } else if (entityName.equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    this.loadPersonDocument(parser, contrib);
                    feed.addContributor(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                this._logger.log(Level.SEVERE, "Unable to process feed document elements", e);
                throw e;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Unable to process feed document elements", e);
                throw e;
            }
        } while (eventType != 3 || !"feed".equals(parser.getName()));
    }

    private void processFeedDocumentAttributes(XmlPullParser parser, Feed feed) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("version")) {
                feed.setVersion(parser.getAttributeValue(x));
            }
            if (!parser.getAttributeName(x).equals("lang")) continue;
            feed.setLanguage(parser.getAttributeValue(x));
        }
    }

    private void processTitleTag(XmlPullParser parser, AbstractEntryElement element) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        element.setTitle(content);
    }

    private void processCopyrightTag(XmlPullParser parser, Feed feed) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setCopyright(content);
    }

    private void processIdTag(XmlPullParser parser, AbstractEntryElement element) throws XmlPullParserException, IOException {
        element.setId(parser.nextText());
    }

    private void processTaglineTag(XmlPullParser parser, Feed feed) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setTagline(content);
    }

    private void processInfoTag(XmlPullParser parser, Feed feed) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setInfo(content);
    }

    private void processModifiedTag(XmlPullParser parser, AbstractEntryElement feed) throws XmlPullParserException, IOException {
        try {
            feed.setModified(SandlerUtilities.getDateFromUTCDate(parser.nextText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.WARNING, "Unable to process modified tag", e);
            feed.setModified(new Date());
        }
    }

    public void loadGeneratorDocument(XmlPullParser parser, Generator generator) throws XmlPullParserException {
        try {
            this.processGeneratorAttributes(parser, generator);
            generator.setName(parser.nextText());
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Unable to process generator element", e);
        }
    }

    private void processGeneratorAttributes(XmlPullParser parser, Generator generator) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("url")) {
                generator.setUri(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeName(x).equals("version")) continue;
            generator.setVersion(parser.getAttributeValue(x));
        }
    }

    public void loadPersonDocument(XmlPullParser parser, Person person) throws XmlPullParserException, IOException {
        String elementName = parser.getName();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (parser.getName().equals("name")) {
                    try {
                        person.setName(parser.nextText());
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person element name", e);
                    }
                } else if (parser.getName().equals("email")) {
                    try {
                        person.setEmail(parser.nextText());
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person element e-mail", e);
                    }
                } else if (parser.getName().equals("url")) {
                    try {
                        person.setUrl(parser.nextText());
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person element URL", e);
                    }
                } else if (parser.getName().equals("homepage")) {
                    try {
                        person.setUrl(parser.nextText());
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person element homepage", e);
                    }
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                this._logger.log(Level.SEVERE, "Unable to process person element", e);
                throw e;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Unable to process person element", e);
                throw e;
            }
        } while (eventType != 3 || !elementName.equals(parser.getName()));
    }

    public void loadLinkDocument(XmlPullParser parser, Link link) throws XmlPullParserException {
        this.processLinkAttributes(parser, link);
    }

    private void processLinkAttributes(XmlPullParser parser, Link link) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("rel")) {
                link.setRelationship(parser.getAttributeValue(x));
                continue;
            }
            if (parser.getAttributeName(x).equals("type")) {
                link.setType(parser.getAttributeValue(x));
                continue;
            }
            if (parser.getAttributeName(x).equals("href")) {
                link.setHref(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeName(x).equals("title")) continue;
            link.setTitle(parser.getAttributeValue(x));
        }
    }

    public void loadContentDocument(XmlPullParser parser, Content content) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        String elementName = parser.getName();
        StringBuffer buffer = new StringBuffer();
        do {
            if (eventType == 2) {
                if (elementName == null) {
                    elementName = parser.getName();
                }
                this.processDocumentAttributes(parser, content);
            } else if (eventType != 0) {
                buffer.append(parser.getText());
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                this._logger.log(Level.SEVERE, "Unable to process content element", e);
                throw e;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Unable to process content element", e);
                throw e;
            }
        } while (eventType != 3 || !elementName.equals(parser.getName()));
        content.setBody(buffer.toString());
    }

    private void processDocumentAttributes(XmlPullParser parser, Content content) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("mode")) {
                content.setMode(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeName(x).equals("type")) continue;
            content.setMimeType(parser.getAttributeValue(x));
        }
    }

    public void loadEntryDocument(XmlPullParser parser, Entry element) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                ContentImpl content;
                if (parser.getName().equalsIgnoreCase("title")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.setTitle(content);
                } else if (parser.getName().equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    this.loadLinkDocument(parser, link);
                    element.addLink(link);
                } else if (parser.getName().equalsIgnoreCase("id")) {
                    try {
                        element.setId(parser.nextText());
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Unable to process entry element ID", e);
                    }
                } else if (parser.getName().equalsIgnoreCase("summary")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.setSummary(content);
                } else if (parser.getName().equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser, (AbstractEntryElement)((Object)element));
                } else if (parser.getName().equalsIgnoreCase("issued")) {
                    this.processIssuedTag(parser, element);
                } else if (parser.getName().equalsIgnoreCase("created")) {
                    this.processCreatedTag(parser, element);
                } else if (parser.getName().equalsIgnoreCase("author")) {
                    PersonImpl author = new PersonImpl();
                    this.loadPersonDocument(parser, author);
                    element.setAuthor(author);
                } else if (parser.getName().equalsIgnoreCase("content")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.addContent(content);
                } else if (parser.getName().equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    this.loadPersonDocument(parser, contrib);
                    element.addContributor(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                this._logger.log(Level.SEVERE, "Unable to process entry element", e);
                throw e;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Unable to process entry element", e);
                throw e;
            }
        } while (eventType != 3 || !"entry".equals(parser.getName()));
    }

    private void processCreatedTag(XmlPullParser parser, Entry entry) throws XmlPullParserException {
        try {
            entry.setCreated(SandlerUtilities.getDateFromUTCDate(parser.nextText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.WARNING, "Unable to process created date. Setting date to today", e);
            entry.setCreated(new Date());
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Unable to process created date. Setting date to today", e);
            entry.setCreated(new Date());
        }
    }

    private void processIssuedTag(XmlPullParser parser, Entry entry) throws XmlPullParserException {
        try {
            entry.setIssued(SandlerUtilities.getDateFromUTCDate(parser.nextText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.WARNING, "Unable to process issued date. Setting date to today", e);
            entry.setIssued(new Date());
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Unable to process created date. Setting date to today", e);
            entry.setIssued(new Date());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

