/*-*- mode:c;indent-tabs-mode:nil;c-basic-offset:2;tab-width:8;coding:utf-8 -*-│
│ vi: set et ft=c ts=2 sts=2 sw=2 fenc=utf-8                               :vi │
╞══════════════════════════════════════════════════════════════════════════════╡
│ Copyright 2022 Justine Alexandra Roberts Tunney                              │
│                                                                              │
│ Permission to use, copy, modify, and/or distribute this software for         │
│ any purpose with or without fee is hereby granted, provided that the         │
│ above copyright notice and this permission notice appear in all copies.      │
│                                                                              │
│ THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL                │
│ WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                │
│ WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE             │
│ AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL         │
│ DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR        │
│ PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER               │
│ TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR             │
│ PERFORMANCE OF THIS SOFTWARE.                                                │
╚─────────────────────────────────────────────────────────────────────────────*/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include "blink/debug.h"
#include "blink/log.h"
#include "blink/tsan.h"

#define APPEND(...) oi += snprintf(ob + oi, oi > on ? 0 : on - oi, __VA_ARGS__)

void DumpHex(u8 *p, size_t n) {
  int oi = 0;
  int on = n * 100;
  char *ob = (char *)malloc(on);
  size_t i, j;
  IGNORE_RACES_START();
  for (i = 0; i < n; i += 16) {
    APPEND("\n\t%04zx:", i);
    for (j = 0; j < 16; ++j) {
      if (i + j < n) {
        APPEND(" %02x", p[i + j]);
      } else {
        APPEND("   ");
      }
    }
    APPEND(" ");
    for (j = 0; j < 16 && i + j < n; ++j) {
      APPEND("%c", isprint(p[i + j]) ? p[i + j] : '.');
    }
  }
  IGNORE_RACES_END();
  LOGF("hex dump%s", ob);
  free(ob);
}
