#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 80:
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ 857:
/***/ ((module) => {

module.exports = require("url");

/***/ }),

/***/ 330:
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2024.7.2","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"SEE LICENSE IN LICENSE.txt","scripts":{"clean":"rimraf dist","build:oss":"webpack","build:oss:debug":"npm run build:oss && node --inspect ./build/bw.js","build:oss:watch":"webpack --watch","build:oss:prod":"cross-env NODE_ENV=production webpack","build:oss:prod:watch":"cross-env NODE_ENV=production webpack --watch","debug":"node --inspect ./build/bw.js","publish:npm":"npm run build:oss:prod && npm publish --access public","build:bit":"webpack -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:debug":"npm run build:bit && node --inspect ./build/bw.js","build:bit:watch":"webpack --watch -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:prod":"cross-env NODE_ENV=production npm run build:bit","build:bit:prod:watch":"cross-env NODE_ENV=production npm run build:bit:watch","dist:oss:win":"npm run build:oss:prod && npm run clean && npm run package:oss:win","dist:oss:mac":"npm run build:oss:prod && npm run clean && npm run package:oss:mac","dist:oss:lin":"npm run build:oss:prod && npm run clean && npm run package:oss:lin","dist:bit:win":"npm run build:bit:prod && npm run clean && npm run package:bit:win","dist:bit:mac":"npm run build:bit:prod && npm run clean && npm run package:bit:mac","dist:bit:lin":"npm run build:bit:prod && npm run clean && npm run package:bit:lin","package:oss:win":"pkg . --targets win-x64 --output ./dist/oss/windows/bw.exe","package:oss:mac":"pkg . --targets macos-x64 --output ./dist/oss/macos/bw","package:oss:lin":"pkg . --targets linux-x64 --output ./dist/oss/linux/bw","package:bit:win":"pkg . --targets win-x64 --output ./dist/bit/windows/bw.exe","package:bit:mac":"pkg . --targets macos-x64 --output ./dist/bit/macos/bw","package:bit:lin":"pkg . --targets linux-x64 --output ./dist/bit/linux/bw","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*","../../node_modules/argon2/**/*"]},"dependencies":{"@koa/multer":"3.0.2","@koa/router":"12.0.1","argon2":"0.40.1","big-integer":"1.6.51","browser-hrtime":"1.1.8","chalk":"4.1.2","commander":"11.1.0","form-data":"4.0.0","https-proxy-agent":"7.0.2","inquirer":"8.2.6","jsdom":"23.0.1","jszip":"3.10.1","koa":"2.15.0","koa-bodyparser":"4.4.1","koa-json":"2.0.2","lowdb":"1.0.0","lunr":"2.3.9","multer":"1.4.5-lts.1","node-fetch":"2.6.12","node-forge":"1.3.1","open":"8.4.2","papaparse":"5.4.1","proper-lockfile":"4.1.2","rxjs":"7.8.1","tldts":"6.1.29","zxcvbn":"4.4.2"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

;// CONCATENATED MODULE: external "commander"
const external_commander_namespaceObject = require("commander");
;// CONCATENATED MODULE: external "chalk"
const external_chalk_namespaceObject = require("chalk");
;// CONCATENATED MODULE: external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-status.ts
var authentication_status_AuthenticationStatus;
(function (AuthenticationStatus) {
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(authentication_status_AuthenticationStatus || (authentication_status_AuthenticationStatus = {}));

;// CONCATENATED MODULE: ./src/models/response.ts
class Response {
    static error(error, data) {
        const res = new Response();
        res.success = false;
        if (typeof error === "string") {
            res.message = error;
        }
        else {
            res.message =
                error.message != null
                    ? error.message
                    : error.toString() === "[object Object]"
                        ? JSON.stringify(error)
                        : error.toString();
        }
        res.data = data;
        return res;
    }
    static notFound() {
        return Response.error("Not found.");
    }
    static badRequest(message) {
        return Response.error(message);
    }
    static multipleResults(ids) {
        let msg = "More than one result was found. Try getting a specific object by `id` instead. " +
            "The following objects were found:";
        ids.forEach((id) => {
            msg += "\n" + id;
        });
        return Response.error(msg, ids);
    }
    static success(data) {
        const res = new Response();
        res.success = true;
        res.data = data;
        return res;
    }
}

;// CONCATENATED MODULE: ./src/models/response/message.response.ts
class MessageResponse {
    constructor(title, message) {
        this.noColor = false;
        this.object = "message";
        this.title = title;
        this.message = message;
    }
}

;// CONCATENATED MODULE: ./src/auth/commands/lock.command.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class LockCommand {
    constructor(vaultTimeoutService) {
        this.vaultTimeoutService = vaultTimeoutService;
    }
    run() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.vaultTimeoutService.lock();
            process.env.BW_SESSION = null;
            const res = new MessageResponse("Your vault is locked.", null);
            return Response.success(res);
        });
    }
}

;// CONCATENATED MODULE: external "http"
const external_http_namespaceObject = require("http");
;// CONCATENATED MODULE: external "inquirer"
const external_inquirer_namespaceObject = require("inquirer");
;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-type.ts
var AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApiKey"] = 2] = "UserApiKey";
    AuthenticationType[AuthenticationType["AuthRequest"] = 3] = "AuthRequest";
    AuthenticationType[AuthenticationType["WebAuthn"] = 4] = "WebAuthn";
})(AuthenticationType || (AuthenticationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// CONCATENATED MODULE: external "path"
const external_path_namespaceObject = require("path");
;// CONCATENATED MODULE: external "buffer/"
const _namespaceObject = require("buffer/");
;// CONCATENATED MODULE: external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/utils.ts
/* eslint-disable no-useless-escape */




const nodeURL = typeof self === "undefined" ? __webpack_require__(857) : null;
class Utils {
    static init() {
        if (Utils.inited) {
            return;
        }
        Utils.inited = true;
        Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        Utils.isBrowser = typeof window !== "undefined";
        Utils.isMobileBrowser = Utils.isBrowser && this.isMobile(window);
        Utils.isAppleMobileBrowser = Utils.isBrowser && this.isAppleMobile(window);
        if (Utils.isNode) {
            Utils.global = global;
        }
        else if (Utils.isBrowser) {
            Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return Utils.fromB64ToArray(Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return Utils.fromB64toUrlB64(Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        return _namespaceObject.Buffer.from(buffer).toString("utf8");
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    /**
     * Converts a hex string to an ArrayBuffer.
     * Note: this doesn't need any Node specific code as parseInt() / ArrayBuffer / Uint8Array
     * work the same in Node and the browser.
     * @param {string} hexString - A string of hexadecimal characters.
     * @returns {ArrayBuffer} The ArrayBuffer representation of the hex string.
     */
    static hexStringToArrayBuffer(hexString) {
        // Check if the hexString has an even length, as each hex digit represents half a byte (4 bits),
        // and it takes two hex digits to represent a full byte (8 bits).
        if (hexString.length % 2 !== 0) {
            throw "HexString has to be an even length";
        }
        // Create an ArrayBuffer with a length that is half the length of the hex string,
        // because each pair of hex digits will become a single byte.
        const arrayBuffer = new ArrayBuffer(hexString.length / 2);
        // Create a Uint8Array view on top of the ArrayBuffer (each position represents a byte)
        // as ArrayBuffers cannot be edited directly.
        const uint8Array = new Uint8Array(arrayBuffer);
        // Loop through the bytes
        for (let i = 0; i < uint8Array.length; i++) {
            // Extract two hex characters (1 byte)
            const hexByte = hexString.substr(i * 2, 2);
            // Convert hexByte into a decimal value from base 16. (ex: ff --> 255)
            const byteValue = parseInt(hexByte, 16);
            // Place the byte value into the uint8Array
            uint8Array[i] = byteValue;
        }
        return arrayBuffer;
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return Utils.fromB64ToUtf8(Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return decodeURIComponent(escape(Utils.global.btoa(utfStr)));
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return Utils.fromBufferToUrlB64(Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return decodeURIComponent(escape(Utils.global.atob(b64Str)));
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static isGuid(id) {
        return RegExp(Utils.guidRegex, "i").test(id);
    }
    static getHostname(uriString) {
        if (Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, {
                validHosts: this.validHosts,
                allowPrivateDomains: true,
            });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    /**
     * Return the number of days remaining before a target date arrives.
     * Returns 0 if the day has already passed.
     */
    static daysRemaining(targetDate) {
        const diffTime = targetDate.getTime() - Date.now();
        const msPerDay = 86400000;
        return Math.max(0, Math.floor(diffTime / msPerDay));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
Utils.inited = false;
Utils.isNode = false;
Utils.isBrowser = true;
Utils.isMobileBrowser = false;
Utils.isAppleMobileBrowser = false;
Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
Utils.validHosts = ["localhost"];
Utils.originalMinimumPasswordLength = 8;
Utils.minimumPasswordLength = 12;
Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
Utils.guidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/;
Utils.init();

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-response.request.ts

class WebAuthnLoginResponseRequest {
    constructor(credential) {
        this.id = credential.id;
        this.rawId = Utils.fromBufferToUrlB64(credential.rawId);
        this.type = credential.type;
        // WARNING: do not add PRF information here by mapping
        // credential.getClientExtensionResults() into the extensions property,
        // as it will be sent to the server (leaking credentials).
        this.extensions = {}; // Extensions are handled client-side
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-assertion-response.request.ts


class WebAuthnLoginAssertionResponseRequest extends WebAuthnLoginResponseRequest {
    constructor(credential) {
        super(credential);
        if (!(credential.response instanceof AuthenticatorAssertionResponse)) {
            throw new Error("Invalid authenticator response");
        }
        this.response = {
            authenticatorData: Utils.fromBufferToUrlB64(credential.response.authenticatorData),
            signature: Utils.fromBufferToUrlB64(credential.response.signature),
            clientDataJSON: Utils.fromBufferToUrlB64(credential.response.clientDataJSON),
            userHandle: Utils.fromBufferToUrlB64(credential.response.userHandle),
        };
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/encryption-type.enum.ts
var EncryptionType;
(function (EncryptionType) {
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    EncryptionType[EncryptionType["AesCbc128_HmacSha256_B64"] = 1] = "AesCbc128_HmacSha256_B64";
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(EncryptionType || (EncryptionType = {}));
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts, and an EncString of type
 * AesCbc128_HmacSha256_B64 will have 3 parts.
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 1.iv|data|mac
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [EncryptionType.AesCbc256_B64]: 2,
    [EncryptionType.AesCbc128_HmacSha256_B64]: 3,
    [EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
};

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/file-upload-type.enum.ts
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/hash-purpose.enum.ts
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/html-storage-location.enum.ts
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/kdf-type.enum.ts
var KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(KdfType || (KdfType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/key-suffix-options.enum.ts
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Biometric"] = "biometric";
    KeySuffixOptions["Pin"] = "pin";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/log-level-type.enum.ts
var LogLevelType;
(function (LogLevelType) {
    LogLevelType[LogLevelType["Debug"] = 0] = "Debug";
    LogLevelType[LogLevelType["Info"] = 1] = "Info";
    LogLevelType[LogLevelType["Warning"] = 2] = "Warning";
    LogLevelType[LogLevelType["Error"] = 3] = "Error";
})(LogLevelType || (LogLevelType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/storage-location.enum.ts
var StorageLocation;
(function (StorageLocation) {
    StorageLocation["Both"] = "both";
    StorageLocation["Disk"] = "disk";
    StorageLocation["Memory"] = "memory";
})(StorageLocation || (StorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/theme-type.enum.ts
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
    ThemeType["Nord"] = "nord";
    ThemeType["SolarizedDark"] = "solarizedDark";
})(ThemeType || (ThemeType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/index.ts










;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts


class SymmetricCryptoKey {
    constructor(key, encType) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (encType == null) {
            if (key.byteLength === 32) {
                encType = EncryptionType.AesCbc256_B64;
            }
            else if (key.byteLength === 64) {
                encType = EncryptionType.AesCbc256_HmacSha256_B64;
            }
            else {
                throw new Error("Unable to determine encType.");
            }
        }
        this.key = key;
        this.encType = encType;
        if (encType === EncryptionType.AesCbc256_B64 && key.byteLength === 32) {
            this.encKey = key;
            this.macKey = null;
        }
        else if (encType === EncryptionType.AesCbc128_HmacSha256_B64 && key.byteLength === 32) {
            this.encKey = key.slice(0, 16);
            this.macKey = key.slice(16, 32);
        }
        else if (encType === EncryptionType.AesCbc256_HmacSha256_B64 && key.byteLength === 64) {
            this.encKey = key.slice(0, 32);
            this.macKey = key.slice(32, 64);
        }
        else {
            throw new Error("Unsupported encType/key length.");
        }
        if (this.key != null) {
            this.keyB64 = Utils.fromBufferToB64(this.key);
        }
        if (this.encKey != null) {
            this.encKeyB64 = Utils.fromBufferToB64(this.encKey);
        }
        if (this.macKey != null) {
            this.macKeyB64 = Utils.fromBufferToB64(this.macKey);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = Utils.fromB64ToArray(s);
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/login-credentials.ts




class PasswordLoginCredentials {
    constructor(email, masterPassword, captchaToken, twoFactor) {
        this.email = email;
        this.masterPassword = masterPassword;
        this.captchaToken = captchaToken;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Password;
    }
}
class SsoLoginCredentials {
    constructor(code, codeVerifier, redirectUrl, orgId, 
    /**
     * Optional email address for SSO login.
     * Used for looking up 2FA token on clients that support remembering 2FA token.
     */
    email, twoFactor) {
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUrl = redirectUrl;
        this.orgId = orgId;
        this.email = email;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Sso;
    }
}
class UserApiLoginCredentials {
    constructor(clientId, clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.type = AuthenticationType.UserApiKey;
    }
}
class AuthRequestLoginCredentials {
    constructor(email, accessCode, authRequestId, decryptedUserKey, decryptedMasterKey, decryptedMasterKeyHash, twoFactor) {
        this.email = email;
        this.accessCode = accessCode;
        this.authRequestId = authRequestId;
        this.decryptedUserKey = decryptedUserKey;
        this.decryptedMasterKey = decryptedMasterKey;
        this.decryptedMasterKeyHash = decryptedMasterKeyHash;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.AuthRequest;
    }
    static fromJSON(json) {
        return Object.assign(new AuthRequestLoginCredentials(json.email, json.accessCode, json.authRequestId, null, null, json.decryptedMasterKeyHash, json.twoFactor
            ? new TokenTwoFactorRequest(json.twoFactor.provider, json.twoFactor.token, json.twoFactor.remember)
            : json.twoFactor), {
            decryptedUserKey: SymmetricCryptoKey.fromJSON(json.decryptedUserKey),
            decryptedMasterKey: SymmetricCryptoKey.fromJSON(json.decryptedMasterKey),
        });
    }
}
class WebAuthnLoginCredentials {
    constructor(token, deviceResponse, prfKey) {
        this.token = token;
        this.deviceResponse = deviceResponse;
        this.prfKey = prfKey;
        this.type = AuthenticationType.WebAuthn;
    }
    static fromJSON(json) {
        return new WebAuthnLoginCredentials(json.token, Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json.deviceResponse), SymmetricCryptoKey.fromJSON(json.prfKey));
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/user-decryption-options.ts
/**
 * Key Connector decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class KeyConnectorUserDecryptionOption {
    /**
     * Initializes a new instance of the KeyConnectorUserDecryptionOption from a response object.
     * @param response The key connector user decryption option response object.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a;
        if (response == null) {
            return undefined;
        }
        const options = new KeyConnectorUserDecryptionOption();
        options.keyConnectorUrl = (_a = response === null || response === void 0 ? void 0 : response.keyConnectorUrl) !== null && _a !== void 0 ? _a : null;
        return options;
    }
    /**
     * Initializes a new instance of a KeyConnectorUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new KeyConnectorUserDecryptionOption(), obj);
    }
}
/**
 * Trusted device decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class TrustedDeviceUserDecryptionOption {
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a response object.
     * @param response The trusted device user decryption option response object.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a, _b, _c;
        if (response == null) {
            return undefined;
        }
        const options = new TrustedDeviceUserDecryptionOption();
        options.hasAdminApproval = (_a = response === null || response === void 0 ? void 0 : response.hasAdminApproval) !== null && _a !== void 0 ? _a : false;
        options.hasLoginApprovingDevice = (_b = response === null || response === void 0 ? void 0 : response.hasLoginApprovingDevice) !== null && _b !== void 0 ? _b : false;
        options.hasManageResetPasswordPermission = (_c = response === null || response === void 0 ? void 0 : response.hasManageResetPasswordPermission) !== null && _c !== void 0 ? _c : false;
        return options;
    }
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new TrustedDeviceUserDecryptionOption(), obj);
    }
}
/**
 * Represents the decryption options the user has configured on the server. This is intended to be sent
 * to the client on authentication, and can be used to determine how to decrypt the user's vault.
 */
class UserDecryptionOptions {
    /**
     * Initializes a new instance of the UserDecryptionOptions from a response object.
     * @param response user decryption options response object
     * @returns A new instance of the UserDecryptionOptions.
     * @throws If the response is nullish, this method will throw an error. User decryption options
     * are required for client initialization.
     */
    // TODO: Change response type to `UserDecryptionOptionsResponse` after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
    static fromResponse(response) {
        if (response == null) {
            throw new Error("User Decryption Options are required for client initialization.");
        }
        const decryptionOptions = new UserDecryptionOptions();
        if (response.userDecryptionOptions) {
            // If the response has userDecryptionOptions, this means it's on a post-TDE server version and can interrogate
            // the new decryption options.
            const responseOptions = response.userDecryptionOptions;
            decryptionOptions.hasMasterPassword = responseOptions.hasMasterPassword;
            decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromResponse(responseOptions.trustedDeviceOption);
            decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromResponse(responseOptions.keyConnectorOption);
        }
        else {
            // If the response does not have userDecryptionOptions, this means it's on a pre-TDE server version and so
            // we must base our decryption options on the presence of the keyConnectorUrl.
            // Note that the presence of keyConnectorUrl implies that the user does not have a master password, as in pre-TDE
            // server versions, a master password short-circuited the addition of the keyConnectorUrl to the response.
            // TODO: remove this check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const usingKeyConnector = response.keyConnectorUrl != null;
            decryptionOptions.hasMasterPassword = !usingKeyConnector;
            if (usingKeyConnector) {
                decryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption();
                decryptionOptions.keyConnectorOption.keyConnectorUrl = response.keyConnectorUrl;
            }
        }
        return decryptionOptions;
    }
    /**
     * Initializes a new instance of the UserDecryptionOptions from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the UserDecryptionOptions. Will initialize even if the JSON object is nullish.
     */
    static fromJSON(obj) {
        const decryptionOptions = Object.assign(new UserDecryptionOptions(), obj);
        decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.trustedDeviceOption);
        decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.keyConnectorOption);
        return decryptionOptions;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/index.ts




;// CONCATENATED MODULE: ../../libs/auth/src/common/models/spec/fake-user-decryption-options.ts

// To discourage creating new user decryption options, we don't expose a constructor.
// These helpers are for testing purposes only.
/** Testing helper for creating new instances of `UserDecryptionOptions` */
class FakeUserDecryptionOptions extends UserDecryptionOptions {
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/** Testing helper for creating new instances of `KeyConnectorUserDecryptionOption` */
class FakeKeyConnectorUserDecryptionOption extends KeyConnectorUserDecryptionOption {
    constructor(keyConnectorUrl) {
        super();
        this.keyConnectorUrl = keyConnectorUrl;
    }
}
/** Testing helper for creating new instances of `TrustedDeviceUserDecryptionOption` */
class FakeTrustedDeviceUserDecryptionOption extends TrustedDeviceUserDecryptionOption {
    constructor(hasAdminApproval, hasLoginApprovingDevice, hasManageResetPasswordPermission) {
        super();
        this.hasAdminApproval = hasAdminApproval;
        this.hasLoginApprovingDevice = hasLoginApprovingDevice;
        this.hasManageResetPasswordPermission = hasManageResetPasswordPermission;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/spec/index.ts


;// CONCATENATED MODULE: ../../libs/auth/src/common/models/index.ts



;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-string.ts
var enc_string_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : Utils.fromB64ToArray(this.iv);
    }
    get macBytes() {
        return this.mac == null ? null : Utils.fromB64ToArray(this.mac);
    }
    get dataBytes() {
        return this.data == null ? null : Utils.fromB64ToArray(this.data);
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = (encType + "." + iv + "|" + data);
        }
        else {
            this.encryptedString = (encType + "." + data);
        }
        // mac
        if (mac != null) {
            this.encryptedString = (this.encryptedString + "|" + mac);
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case EncryptionType.Rsa2048_OaepSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                this.data = encPieces[0];
                this.mac = encPieces[1];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
            }
            catch (e) {
                return { encType: NaN, encPieces: [] };
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType =
                encPieces.length === 3
                    ? EncryptionType.AesCbc128_HmacSha256_B64
                    : EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        if (s == null) {
            return false;
        }
        const { encType, encPieces } = this.parseEncryptedString(s);
        if (isNaN(encType) || encPieces.length === 0) {
            return false;
        }
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    decrypt(orgId, key = null) {
        return enc_string_awaiter(this, void 0, void 0, function* () {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key);
            }
            catch (e) {
                this.decryptedValue = "[error: cannot decrypt]";
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return enc_string_awaiter(this, void 0, void 0, function* () {
            const cryptoService = Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getUserKeyWithLegacySupport();
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/derive-definition.ts
/**
 * DeriveDefinitions describe state derived from another observable, the value type of which is given by `TFrom`.
 *
 * The StateDefinition is used to describe the domain of the state, and the DeriveDefinition
 * sub-divides that domain into specific keys. These keys are used to cache data in memory and enables derived state to
 * be calculated once regardless of multiple execution contexts.
 */
class DeriveDefinition {
    /**
     * Creates a new instance of a DeriveDefinition. Derived state is always stored in memory, so the storage location
     * defined in @link{StateDefinition} is ignored.
     *
     * @param stateDefinition The state definition for which this key belongs to.
     * @param uniqueDerivationName The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, uniqueDerivationName, options) {
        this.stateDefinition = stateDefinition;
        this.uniqueDerivationName = uniqueDerivationName;
        this.options = options;
    }
    /**
     * Factory that produces a {@link DeriveDefinition} from a {@link KeyDefinition} or {@link DeriveDefinition} and new name.
     *
     * If a `KeyDefinition` is passed in, the returned definition will have the same key as the given key definition, but
     * will not collide with it in storage, even if they both reside in memory.
     *
     * If a `DeriveDefinition` is passed in, the returned definition will instead use the name given in the second position
     * of the tuple. It is up to you to ensure this is unique within the domain of derived state.
     *
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     * @param definition
     * @param options
     * @returns
     */
    static from(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    static fromWithUserId(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    get derive() {
        return this.options.derive;
    }
    deserialize(serialized) {
        return this.options.deserializer(serialized);
    }
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    get clearOnCleanup() {
        var _a;
        return (_a = this.options.clearOnCleanup) !== null && _a !== void 0 ? _a : true;
    }
    buildCacheKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
    /**
     * Creates a {@link StorageKey} that points to the data for the given derived definition.
     * @returns A key that is ready to be used in a storage service to get data.
     */
    get storageKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
}
function isFromDeriveDefinition(definition) {
    return Array.isArray(definition);
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/deserialization-helpers.ts
/**
 *
 * @param elementDeserializer
 * @returns
 */
function array(elementDeserializer) {
    return (array) => {
        if (array == null) {
            return null;
        }
        return array.map((element) => elementDeserializer(element));
    };
}
/**
 *
 * @param valueDeserializer
 */
function record(valueDeserializer) {
    return (jsonValue) => {
        if (jsonValue == null) {
            return null;
        }
        const output = {};
        Object.entries(jsonValue).forEach(([key, value]) => {
            output[key] = valueDeserializer(value);
        });
        return output;
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/key-definition.ts

/**
 * KeyDefinitions describe the precise location to store data for a given piece of state.
 * The StateDefinition is used to describe the domain of the state, and the KeyDefinition
 * sub-divides that domain into specific keys.
 */
class KeyDefinition {
    /**
     * Creates a new instance of a KeyDefinition
     * @param stateDefinition The state definition for which this key belongs to.
     * @param key The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link KeyDefinition}. All options are required.
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs <= 0) {
            throw new Error(`'cleanupDelayMs' must be greater than 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    /**
     * Creates a {@link KeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link KeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
/**
 * Creates a {@link StorageKey}
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/user-key-definition.ts
var _a;


const USER_KEY_DEFINITION_MARKER = Symbol("UserKeyDefinition");
class UserKeyDefinition {
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        this[_a] = true;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs <= 0) {
            throw new Error(`'cleanupDelayMs' must be greater than 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Filter out repeat values
        this.clearOn = Array.from(new Set(options.clearOn));
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _b;
        return this.options.cleanupDelayMs < 0 ? 0 : (_b = this.options.cleanupDelayMs) !== null && _b !== void 0 ? _b : 1000;
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array
     * **unless that array is null, in which case it will return an empty list.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string **unless that record is null, in which case it will return an record.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    buildKey(userId) {
        if (!Utils.isGuid(userId)) {
            throw new Error(`You cannot build a user key without a valid UserId, building for key ${this.fullName}`);
        }
        return `user_${userId}_${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
_a = USER_KEY_DEFINITION_MARKER;

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definition.ts
/**
 * Defines the base location and instruction of where this state is expected to be located.
 */
class StateDefinition {
    /**
     * Creates a new instance of {@link StateDefinition}, the creation of which is owned by the platform team.
     * @param name The name of the state, this needs to be unique from all other {@link StateDefinition}'s.
     * @param defaultStorageLocation The location of where this state should be stored.
     */
    constructor(name, defaultStorageLocation, storageLocationOverrides) {
        this.name = name;
        this.defaultStorageLocation = defaultStorageLocation;
        this.storageLocationOverrides = storageLocationOverrides !== null && storageLocationOverrides !== void 0 ? storageLocationOverrides : {};
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definitions.ts

/**
 * `StateDefinition`s comes with some rules, to facilitate a quick review from
 * platform of this file, ensure you follow these rules, the ones marked with (tested)
 * have unit tests that you can run locally.
 *
 * 1. (tested) Names should not be null or undefined
 * 2. (tested) Name and storage location should be unique
 * 3. (tested) Name and storage location can't differ from another export by only casing
 * 4. (tested) Name should be longer than 3 characters. It should be descriptive, but brief.
 * 5. (tested) Name should not contain spaces or underscores
 * 6. Name should be human readable
 * 7. Name should be in camelCase format (unit tests ensure the first character is lowercase)
 * 8. Teams should only use state definitions they have created
 * 9. StateDefinitions should only be used for keys relating to the state name they chose
 *
 */
// Admin Console
const ORGANIZATIONS_DISK = new StateDefinition("organizations", "disk");
const POLICIES_DISK = new StateDefinition("policies", "disk");
const PROVIDERS_DISK = new StateDefinition("providers", "disk");
const ORGANIZATION_MANAGEMENT_PREFERENCES_DISK = new StateDefinition("organizationManagementPreferences", "disk", {
    web: "disk-local",
});
const AC_BANNERS_DISMISSED_DISK = new StateDefinition("acBannersDismissed", "disk", {
    web: "disk-local",
});
// Billing
const BILLING_DISK = new StateDefinition("billing", "disk");
// Auth
const ACCOUNT_DISK = new StateDefinition("account", "disk");
const ACCOUNT_MEMORY = new StateDefinition("account", "memory");
const AUTH_REQUEST_DISK_LOCAL = new StateDefinition("authRequestLocal", "disk", {
    web: "disk-local",
});
const AVATAR_DISK = new StateDefinition("avatar", "disk", { web: "disk-local" });
const DEVICE_TRUST_DISK_LOCAL = new StateDefinition("deviceTrust", "disk", {
    web: "disk-local",
});
const KDF_CONFIG_DISK = new StateDefinition("kdfConfig", "disk");
const KEY_CONNECTOR_DISK = new StateDefinition("keyConnector", "disk");
const LOGIN_EMAIL_DISK = new StateDefinition("loginEmail", "disk", {
    web: "disk-local",
});
const LOGIN_STRATEGY_MEMORY = new StateDefinition("loginStrategy", "memory");
const MASTER_PASSWORD_DISK = new StateDefinition("masterPassword", "disk");
const MASTER_PASSWORD_MEMORY = new StateDefinition("masterPassword", "memory");
const PIN_DISK = new StateDefinition("pinUnlock", "disk");
const PIN_MEMORY = new StateDefinition("pinUnlock", "memory");
const ROUTER_DISK = new StateDefinition("router", "disk");
const SSO_DISK = new StateDefinition("ssoLogin", "disk");
const TOKEN_DISK = new StateDefinition("token", "disk");
const TOKEN_DISK_LOCAL = new StateDefinition("tokenDiskLocal", "disk", {
    web: "disk-local",
});
const TOKEN_MEMORY = new StateDefinition("token", "memory");
const TWO_FACTOR_MEMORY = new StateDefinition("twoFactor", "memory");
const USER_DECRYPTION_OPTIONS_DISK = new StateDefinition("userDecryptionOptions", "disk");
const ORGANIZATION_INVITE_DISK = new StateDefinition("organizationInvite", "disk");
const VAULT_TIMEOUT_SETTINGS_DISK_LOCAL = new StateDefinition("vaultTimeoutSettings", "disk", {
    web: "disk-local",
});
// Autofill
const BADGE_SETTINGS_DISK = new StateDefinition("badgeSettings", "disk");
const USER_NOTIFICATION_SETTINGS_DISK = new StateDefinition("userNotificationSettings", "disk");
const DOMAIN_SETTINGS_DISK = new StateDefinition("domainSettings", "disk");
const AUTOFILL_SETTINGS_DISK = new StateDefinition("autofillSettings", "disk");
const AUTOFILL_SETTINGS_DISK_LOCAL = new StateDefinition("autofillSettingsLocal", "disk", {
    web: "disk-local",
});
// Components
const NEW_WEB_LAYOUT_BANNER_DISK = new StateDefinition("newWebLayoutBanner", "disk", {
    web: "disk-local",
});
// Platform
const APPLICATION_ID_DISK = new StateDefinition("applicationId", "disk", {
    web: "disk-local",
});
const BIOMETRIC_SETTINGS_DISK = new StateDefinition("biometricSettings", "disk");
const CLEAR_EVENT_DISK = new StateDefinition("clearEvent", "disk");
const CONFIG_DISK = new StateDefinition("config", "disk", {
    web: "disk-local",
});
const CRYPTO_DISK = new StateDefinition("crypto", "disk");
const CRYPTO_MEMORY = new StateDefinition("crypto", "memory");
const DESKTOP_SETTINGS_DISK = new StateDefinition("desktopSettings", "disk");
const ENVIRONMENT_DISK = new StateDefinition("environment", "disk");
const ENVIRONMENT_MEMORY = new StateDefinition("environment", "memory");
const THEMING_DISK = new StateDefinition("theming", "disk", { web: "disk-local" });
const TRANSLATION_DISK = new StateDefinition("translation", "disk", { web: "disk-local" });
const TASK_SCHEDULER_DISK = new StateDefinition("taskScheduler", "disk");
// Secrets Manager
const SM_ONBOARDING_DISK = new StateDefinition("smOnboarding", "disk", {
    web: "disk-local",
});
// Tools
const GENERATOR_DISK = new StateDefinition("generator", "disk");
const GENERATOR_MEMORY = new StateDefinition("generator", "memory");
const BROWSER_SEND_MEMORY = new StateDefinition("sendBrowser", "memory");
const EVENT_COLLECTION_DISK = new StateDefinition("eventCollection", "disk");
const SEND_DISK = new StateDefinition("encryptedSend", "disk", {
    web: "memory",
});
const SEND_MEMORY = new StateDefinition("decryptedSend", "memory", {
    browser: "memory-large-object",
});
// Vault
const COLLECTION_DATA = new StateDefinition("collection", "disk", {
    web: "memory",
});
const FOLDER_DISK = new StateDefinition("folder", "disk", { web: "memory" });
const VAULT_FILTER_DISK = new StateDefinition("vaultFilter", "disk", {
    web: "disk-local",
});
const VAULT_ONBOARDING = new StateDefinition("vaultOnboarding", "disk", {
    web: "disk-local",
});
const VAULT_SETTINGS_DISK = new StateDefinition("vaultSettings", "disk", {
    web: "disk-local",
});
const VAULT_BROWSER_MEMORY = new StateDefinition("vaultBrowser", "memory", {
    browser: "memory-large-object",
});
const VAULT_SEARCH_MEMORY = new StateDefinition("vaultSearch", "memory", {
    browser: "memory-large-object",
});
const CIPHERS_DISK = new StateDefinition("ciphers", "disk", { web: "memory" });
const CIPHERS_DISK_LOCAL = new StateDefinition("ciphersLocal", "disk", {
    web: "disk-local",
});
const CIPHERS_MEMORY = new StateDefinition("ciphersMemory", "memory", {
    browser: "memory-large-object",
});
const PREMIUM_BANNER_DISK_LOCAL = new StateDefinition("premiumBannerReprompt", "disk", {
    web: "disk-local",
});
const BANNERS_DISMISSED_DISK = new StateDefinition("bannersDismissed", "disk");

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-event-registrar.service.ts
var state_event_registrar_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const STATE_LOCK_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "lock", {
    deserializer: (e) => e,
});
const STATE_LOGOUT_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "logout", {
    deserializer: (e) => e,
});
class StateEventRegistrarService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventStateMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    registerEvents(keyDefinition) {
        return state_event_registrar_service_awaiter(this, void 0, void 0, function* () {
            for (const clearEvent of keyDefinition.clearOn) {
                const eventState = this.stateEventStateMap[clearEvent];
                // Determine the storage location for this
                const [storageLocation] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
                const newEvent = {
                    state: keyDefinition.stateDefinition.name,
                    key: keyDefinition.key,
                    location: storageLocation,
                };
                // Only update the event state if the existing list doesn't have a matching entry
                yield eventState.update((existingTickets) => {
                    existingTickets !== null && existingTickets !== void 0 ? existingTickets : (existingTickets = []);
                    existingTickets.push(newEvent);
                    return existingTickets;
                }, {
                    shouldUpdate: (currentTickets) => {
                        return (
                        // If the current tickets are null, then it will for sure be added
                        currentTickets == null ||
                            // If an existing match couldn't be found, we also need to add one
                            currentTickets.findIndex((e) => e.state === newEvent.state &&
                                e.key === newEvent.key &&
                                e.location === newEvent.location) === -1);
                    },
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-event-runner.service.ts
var state_event_runner_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class StateEventRunnerService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    handleEvent(event, userId) {
        return state_event_runner_service_awaiter(this, void 0, void 0, function* () {
            let tickets = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateEventMap[event].state$);
            tickets !== null && tickets !== void 0 ? tickets : (tickets = []);
            const failures = [];
            for (const ticket of tickets) {
                try {
                    const [, service] = this.storageServiceProvider.get(ticket.location, {});
                    const ticketStorageKey = this.storageKeyFor(userId, ticket);
                    // Evaluate current value so we can avoid writing to state if we don't need to
                    const currentValue = yield service.get(ticketStorageKey);
                    if (currentValue != null) {
                        yield service.remove(ticketStorageKey);
                    }
                }
                catch (err) {
                    let errorMessage = "Unknown Error";
                    if (typeof err === "object" && "message" in err && typeof err.message === "string") {
                        errorMessage = err.message;
                    }
                    failures.push(`${errorMessage} in ${ticket.state} > ${ticket.key} located ${ticket.location}`);
                }
            }
            if (failures.length > 0) {
                // Throw aggregated error
                throw new Error(`One or more errors occurred while handling event '${event}' for user ${userId}.\n${failures.join("\n")}`);
            }
        });
    }
    storageKeyFor(userId, ticket) {
        const userKey = new UserKeyDefinition(new StateDefinition(ticket.state, ticket.location), ticket.key, {
            deserializer: (v) => v,
            clearOn: [],
        });
        return userKey.buildKey(userId);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/index.ts










;// CONCATENATED MODULE: ../../libs/auth/src/common/services/pin/pin.service.implementation.ts
var pin_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




/**
 * The persistent (stored on disk) version of the UserKey, encrypted by the PinKey.
 *
 * @remarks Persists through a client reset. Used when `requireMasterPasswordOnClientRestart` is disabled.
 * @see SetPinComponent.setPinForm.requireMasterPasswordOnClientRestart
 */
const PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT = new UserKeyDefinition(PIN_DISK, "pinKeyEncryptedUserKeyPersistent", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
/**
 * The ephemeral (stored in memory) version of the UserKey, encrypted by the PinKey.
 *
 * @remarks Does NOT persist through a client reset. Used when `requireMasterPasswordOnClientRestart` is enabled.
 * @see SetPinComponent.setPinForm.requireMasterPasswordOnClientRestart
 */
const PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL = new UserKeyDefinition(PIN_MEMORY, "pinKeyEncryptedUserKeyEphemeral", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
/**
 * The PIN, encrypted by the UserKey.
 */
const USER_KEY_ENCRYPTED_PIN = new UserKeyDefinition(PIN_DISK, "userKeyEncryptedPin", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
/**
 * The old MasterKey, encrypted by the PinKey (formerly called `pinProtected`).
 * Deprecated and used for migration purposes only.
 */
const OLD_PIN_KEY_ENCRYPTED_MASTER_KEY = new UserKeyDefinition(PIN_DISK, "oldPinKeyEncryptedMasterKey", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
class PinService {
    constructor(accountService, cryptoFunctionService, encryptService, kdfConfigService, keyGenerationService, logService, masterPasswordService, stateProvider, stateService) {
        this.accountService = accountService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.kdfConfigService = kdfConfigService;
        this.keyGenerationService = keyGenerationService;
        this.logService = logService;
        this.masterPasswordService = masterPasswordService;
        this.stateProvider = stateProvider;
        this.stateService = stateService;
    }
    getPinKeyEncryptedUserKeyPersistent(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get pinKeyEncryptedUserKeyPersistent.");
            return EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, userId)));
        });
    }
    /**
     * Sets the persistent (stored on disk) version of the UserKey, encrypted by the PinKey.
     */
    setPinKeyEncryptedUserKeyPersistent(pinKeyEncryptedUserKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set pinKeyEncryptedUserKeyPersistent.");
            if (pinKeyEncryptedUserKey == null) {
                throw new Error("No pinKeyEncryptedUserKey provided. Cannot set pinKeyEncryptedUserKeyPersistent.");
            }
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, pinKeyEncryptedUserKey === null || pinKeyEncryptedUserKey === void 0 ? void 0 : pinKeyEncryptedUserKey.encryptedString, userId);
        });
    }
    clearPinKeyEncryptedUserKeyPersistent(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear pinKeyEncryptedUserKeyPersistent.");
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, null, userId);
        });
    }
    getPinKeyEncryptedUserKeyEphemeral(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get pinKeyEncryptedUserKeyEphemeral.");
            return EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, userId)));
        });
    }
    /**
     * Sets the ephemeral (stored in memory) version of the UserKey, encrypted by the PinKey.
     */
    setPinKeyEncryptedUserKeyEphemeral(pinKeyEncryptedUserKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set pinKeyEncryptedUserKeyEphemeral.");
            if (pinKeyEncryptedUserKey == null) {
                throw new Error("No pinKeyEncryptedUserKey provided. Cannot set pinKeyEncryptedUserKeyEphemeral.");
            }
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, pinKeyEncryptedUserKey === null || pinKeyEncryptedUserKey === void 0 ? void 0 : pinKeyEncryptedUserKey.encryptedString, userId);
        });
    }
    clearPinKeyEncryptedUserKeyEphemeral(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear pinKeyEncryptedUserKeyEphemeral.");
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, null, userId);
        });
    }
    createPinKeyEncryptedUserKey(pin, userKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot create pinKeyEncryptedUserKey.");
            if (!userKey) {
                throw new Error("No UserKey provided. Cannot create pinKeyEncryptedUserKey.");
            }
            const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => accounts[userId].email)));
            const kdfConfig = yield this.kdfConfigService.getKdfConfig();
            const pinKey = yield this.makePinKey(pin, email, kdfConfig);
            return yield this.encryptService.encrypt(userKey.key, pinKey);
        });
    }
    storePinKeyEncryptedUserKey(pinKeyEncryptedUserKey, storeAsEphemeral, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot store pinKeyEncryptedUserKey.");
            if (storeAsEphemeral) {
                yield this.setPinKeyEncryptedUserKeyEphemeral(pinKeyEncryptedUserKey, userId);
            }
            else {
                yield this.setPinKeyEncryptedUserKeyPersistent(pinKeyEncryptedUserKey, userId);
            }
        });
    }
    getUserKeyEncryptedPin(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get userKeyEncryptedPin.");
            return EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY_ENCRYPTED_PIN, userId)));
        });
    }
    setUserKeyEncryptedPin(userKeyEncryptedPin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set userKeyEncryptedPin.");
            yield this.stateProvider.setUserState(USER_KEY_ENCRYPTED_PIN, userKeyEncryptedPin === null || userKeyEncryptedPin === void 0 ? void 0 : userKeyEncryptedPin.encryptedString, userId);
        });
    }
    clearUserKeyEncryptedPin(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear userKeyEncryptedPin.");
            yield this.stateProvider.setUserState(USER_KEY_ENCRYPTED_PIN, null, userId);
        });
    }
    createUserKeyEncryptedPin(pin, userKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userKey) {
                throw new Error("No UserKey provided. Cannot create userKeyEncryptedPin.");
            }
            return yield this.encryptService.encrypt(pin, userKey);
        });
    }
    getOldPinKeyEncryptedMasterKey(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get oldPinKeyEncryptedMasterKey.");
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(OLD_PIN_KEY_ENCRYPTED_MASTER_KEY, userId));
        });
    }
    clearOldPinKeyEncryptedMasterKey(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear oldPinKeyEncryptedMasterKey.");
            yield this.stateProvider.setUserState(OLD_PIN_KEY_ENCRYPTED_MASTER_KEY, null, userId);
        });
    }
    makePinKey(pin, salt, kdfConfig) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            const pinKey = yield this.keyGenerationService.deriveKeyFromPassword(pin, salt, kdfConfig);
            return (yield this.keyGenerationService.stretchKey(pinKey));
        });
    }
    getPinLockType(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get PinLockType.");
            /**
             * We can't check the `userKeyEncryptedPin` (formerly called `protectedPin`) for both because old
             * accounts only used it for MP on Restart
             */
            const aUserKeyEncryptedPinIsSet = !!(yield this.getUserKeyEncryptedPin(userId));
            const aPinKeyEncryptedUserKeyPersistentIsSet = !!(yield this.getPinKeyEncryptedUserKeyPersistent(userId));
            const anOldPinKeyEncryptedMasterKeyIsSet = !!(yield this.getOldPinKeyEncryptedMasterKey(userId));
            if (aPinKeyEncryptedUserKeyPersistentIsSet || anOldPinKeyEncryptedMasterKeyIsSet) {
                return "PERSISTENT";
            }
            else if (aUserKeyEncryptedPinIsSet &&
                !aPinKeyEncryptedUserKeyPersistentIsSet &&
                !anOldPinKeyEncryptedMasterKeyIsSet) {
                return "EPHEMERAL";
            }
            else {
                return "DISABLED";
            }
        });
    }
    isPinSet(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot determine if PIN is set.");
            return (yield this.getPinLockType(userId)) !== "DISABLED";
        });
    }
    decryptUserKeyWithPin(pin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt user key with PIN.");
            try {
                const pinLockType = yield this.getPinLockType(userId);
                const requireMasterPasswordOnClientRestart = pinLockType === "EPHEMERAL";
                const { pinKeyEncryptedUserKey, oldPinKeyEncryptedMasterKey } = yield this.getPinKeyEncryptedKeys(pinLockType, userId);
                const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => accounts[userId].email)));
                const kdfConfig = yield this.kdfConfigService.getKdfConfig();
                let userKey;
                if (oldPinKeyEncryptedMasterKey) {
                    userKey = yield this.decryptAndMigrateOldPinKeyEncryptedMasterKey(userId, pin, email, kdfConfig, requireMasterPasswordOnClientRestart, oldPinKeyEncryptedMasterKey);
                }
                else {
                    userKey = yield this.decryptUserKey(userId, pin, email, kdfConfig, pinKeyEncryptedUserKey);
                }
                if (!userKey) {
                    this.logService.warning(`User key null after pin key decryption.`);
                    return null;
                }
                if (!(yield this.validatePin(userKey, pin, userId))) {
                    this.logService.warning(`Pin key decryption successful but pin validation failed.`);
                    return null;
                }
                return userKey;
            }
            catch (error) {
                this.logService.error(`Error decrypting user key with pin: ${error}`);
                return null;
            }
        });
    }
    /**
     * Decrypts the UserKey with the provided PIN.
     */
    decryptUserKey(userId, pin, salt, kdfConfig, pinKeyEncryptedUserKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt user key.");
            pinKeyEncryptedUserKey || (pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyPersistent(userId));
            pinKeyEncryptedUserKey || (pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyEphemeral(userId));
            if (!pinKeyEncryptedUserKey) {
                throw new Error("No pinKeyEncryptedUserKey found.");
            }
            const pinKey = yield this.makePinKey(pin, salt, kdfConfig);
            const userKey = yield this.encryptService.decryptToBytes(pinKeyEncryptedUserKey, pinKey);
            return new SymmetricCryptoKey(userKey);
        });
    }
    /**
     * Creates a new `pinKeyEncryptedUserKey` and clears the `oldPinKeyEncryptedMasterKey`.
     * @returns UserKey
     */
    decryptAndMigrateOldPinKeyEncryptedMasterKey(userId, pin, email, kdfConfig, requireMasterPasswordOnClientRestart, oldPinKeyEncryptedMasterKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt and migrate oldPinKeyEncryptedMasterKey.");
            const masterKey = yield this.decryptMasterKeyWithPin(userId, pin, email, kdfConfig, oldPinKeyEncryptedMasterKey);
            const encUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey({ userId: userId });
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, encUserKey ? new EncString(encUserKey) : undefined);
            const pinKeyEncryptedUserKey = yield this.createPinKeyEncryptedUserKey(pin, userKey, userId);
            yield this.storePinKeyEncryptedUserKey(pinKeyEncryptedUserKey, requireMasterPasswordOnClientRestart, userId);
            const userKeyEncryptedPin = yield this.createUserKeyEncryptedPin(pin, userKey);
            yield this.setUserKeyEncryptedPin(userKeyEncryptedPin, userId);
            yield this.clearOldPinKeyEncryptedMasterKey(userId);
            // This also clears the old Biometrics key since the new Biometrics key will be created when the user key is set.
            yield this.stateService.setCryptoMasterKeyBiometric(null, { userId: userId });
            return userKey;
        });
    }
    // Only for migration purposes
    decryptMasterKeyWithPin(userId, pin, salt, kdfConfig, oldPinKeyEncryptedMasterKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt master key with PIN.");
            if (!oldPinKeyEncryptedMasterKey) {
                const oldPinKeyEncryptedMasterKeyString = yield this.getOldPinKeyEncryptedMasterKey(userId);
                if (oldPinKeyEncryptedMasterKeyString == null) {
                    throw new Error("No oldPinKeyEncrytedMasterKey found.");
                }
                oldPinKeyEncryptedMasterKey = new EncString(oldPinKeyEncryptedMasterKeyString);
            }
            const pinKey = yield this.makePinKey(pin, salt, kdfConfig);
            const masterKey = yield this.encryptService.decryptToBytes(oldPinKeyEncryptedMasterKey, pinKey);
            return new SymmetricCryptoKey(masterKey);
        });
    }
    /**
     * Gets the user's `pinKeyEncryptedUserKey` (persistent or ephemeral) and `oldPinKeyEncryptedMasterKey`
     * (if one exists) based on the user's PinLockType.
     *
     * @remarks The `oldPinKeyEncryptedMasterKey` (formerly `pinProtected`) is only used for migration and
     *          will be null for all migrated accounts.
     * @throws If PinLockType is 'DISABLED' or if userId is not provided
     */
    getPinKeyEncryptedKeys(pinLockType, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get PinKey encrypted keys.");
            switch (pinLockType) {
                case "PERSISTENT": {
                    const pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyPersistent(userId);
                    const oldPinKeyEncryptedMasterKey = yield this.getOldPinKeyEncryptedMasterKey(userId);
                    return {
                        pinKeyEncryptedUserKey,
                        oldPinKeyEncryptedMasterKey: oldPinKeyEncryptedMasterKey
                            ? new EncString(oldPinKeyEncryptedMasterKey)
                            : undefined,
                    };
                }
                case "EPHEMERAL": {
                    const pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyEphemeral(userId);
                    return {
                        pinKeyEncryptedUserKey,
                        oldPinKeyEncryptedMasterKey: undefined, // Going forward, we only migrate non-ephemeral version
                    };
                }
                case "DISABLED":
                    throw new Error("Pin is disabled");
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = pinLockType;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    validatePin(userKey, pin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot validate PIN.");
            const userKeyEncryptedPin = yield this.getUserKeyEncryptedPin(userId);
            const decryptedPin = yield this.encryptService.decryptToUtf8(userKeyEncryptedPin, userKey);
            const isPinValid = this.cryptoFunctionService.compareFast(decryptedPin, pin);
            return isPinValid;
        });
    }
    /**
     * Throws a custom error message if user ID is not provided.
     */
    validateUserId(userId, errorMessage = "") {
        if (!userId) {
            throw new Error(`User ID is required. ${errorMessage}`);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-email/login-email.service.ts
var login_email_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const STORED_EMAIL = new KeyDefinition(LOGIN_EMAIL_DISK, "storedEmail", {
    deserializer: (value) => value,
});
class LoginEmailService {
    constructor(accountService, authService, stateProvider) {
        this.accountService = accountService;
        this.authService = authService;
        this.stateProvider = stateProvider;
        this.storedEmailState = this.stateProvider.getGlobal(STORED_EMAIL);
        // In order to determine if an account is being added, we check if any account is not logged out
        this.addingAccount$ = this.authService.authStatuses$.pipe(switchMap((statuses) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // We don't want to consider the active account since it may have just changed auth status to logged in
            // which would make this observable think an account is being added
            const activeUser = yield firstValueFrom(this.accountService.activeAccount$);
            if (activeUser) {
                delete statuses[activeUser.id];
            }
            return Object.values(statuses).some((status) => status !== AuthenticationStatus.LoggedOut);
        })));
        this.storedEmail$ = this.storedEmailState.state$.pipe(switchMap((storedEmail) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // When adding an account, we don't show the stored email
            if (yield firstValueFrom(this.addingAccount$)) {
                return null;
            }
            return storedEmail;
        })));
    }
    getEmail() {
        return this.email;
    }
    setEmail(email) {
        this.email = email;
    }
    getRememberEmail() {
        return this.rememberEmail;
    }
    setRememberEmail(value) {
        this.rememberEmail = value !== null && value !== void 0 ? value : false;
    }
    // Note: only clear values on successful login or you are sure they are not needed.
    // Browser uses these values to maintain the email between login and 2fa components so
    // we do not want to clear them too early.
    clearValues() {
        this.email = null;
        this.rememberEmail = false;
    }
    saveEmailSettings() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            const addingAccount = yield firstValueFrom(this.addingAccount$);
            yield this.storedEmailState.update((storedEmail) => {
                // If we're adding an account, only overwrite the stored email when rememberEmail is true
                if (addingAccount) {
                    if (this.rememberEmail) {
                        return this.email;
                    }
                    return storedEmail;
                }
                // Saving with rememberEmail set to false will clear the stored email
                if (this.rememberEmail) {
                    return this.email;
                }
                return null;
            });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/range-with-default.ts
/**
 * A range with a default value.
 *
 * Enforces constraints to ensure min > default > max.
 */
class RangeWithDefault {
    constructor(min, max, defaultValue) {
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        if (min > max) {
            throw new Error(`${min} is greater than ${max}.`);
        }
        if (this.inRange(defaultValue) === false) {
            throw new Error("Default value is not in range.");
        }
    }
    inRange(value) {
        return value >= this.min && value <= this.max;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/kdf-config.ts


/**
 * Password-Based Key Derivation Function 2 (PBKDF2) KDF configuration.
 */
class PBKDF2KdfConfig {
    constructor(iterations) {
        this.kdfType = KdfType.PBKDF2_SHA256;
        this.iterations = iterations !== null && iterations !== void 0 ? iterations : PBKDF2KdfConfig.ITERATIONS.defaultValue;
    }
    /**
     * Validates the PBKDF2 KDF configuration.
     * A Valid PBKDF2 KDF configuration has KDF iterations between the 600_000 and 2_000_000.
     */
    validateKdfConfig() {
        if (!PBKDF2KdfConfig.ITERATIONS.inRange(this.iterations)) {
            throw new Error(`PBKDF2 iterations must be between ${PBKDF2KdfConfig.ITERATIONS.min} and ${PBKDF2KdfConfig.ITERATIONS.max}`);
        }
    }
    static fromJSON(json) {
        return new PBKDF2KdfConfig(json.iterations);
    }
}
PBKDF2KdfConfig.ITERATIONS = new RangeWithDefault(600000, 2000000, 600000);
/**
 * Argon2 KDF configuration.
 */
class Argon2KdfConfig {
    constructor(iterations, memory, parallelism) {
        this.kdfType = KdfType.Argon2id;
        this.iterations = iterations !== null && iterations !== void 0 ? iterations : Argon2KdfConfig.ITERATIONS.defaultValue;
        this.memory = memory !== null && memory !== void 0 ? memory : Argon2KdfConfig.MEMORY.defaultValue;
        this.parallelism = parallelism !== null && parallelism !== void 0 ? parallelism : Argon2KdfConfig.PARALLELISM.defaultValue;
    }
    /**
     * Validates the Argon2 KDF configuration.
     * A Valid Argon2 KDF configuration has iterations between 2 and 10, memory between 16mb and 1024mb, and parallelism between 1 and 16.
     */
    validateKdfConfig() {
        if (!Argon2KdfConfig.ITERATIONS.inRange(this.iterations)) {
            throw new Error(`Argon2 iterations must be between ${Argon2KdfConfig.ITERATIONS.min} and ${Argon2KdfConfig.ITERATIONS.max}`);
        }
        if (!Argon2KdfConfig.MEMORY.inRange(this.memory)) {
            throw new Error(`Argon2 memory must be between ${Argon2KdfConfig.MEMORY.min}mb and ${Argon2KdfConfig.MEMORY.max}mb`);
        }
        if (!Argon2KdfConfig.PARALLELISM.inRange(this.parallelism)) {
            throw new Error(`Argon2 parallelism must be between ${Argon2KdfConfig.PARALLELISM.min} and ${Argon2KdfConfig.PARALLELISM.max}.`);
        }
    }
    static fromJSON(json) {
        return new Argon2KdfConfig(json.iterations, json.memory, json.parallelism);
    }
}
Argon2KdfConfig.MEMORY = new RangeWithDefault(16, 1024, 64);
Argon2KdfConfig.PARALLELISM = new RangeWithDefault(1, 16, 4);
Argon2KdfConfig.ITERATIONS = new RangeWithDefault(2, 10, 3);
const DEFAULT_KDF_CONFIG = new PBKDF2KdfConfig(PBKDF2KdfConfig.ITERATIONS.defaultValue);

;// CONCATENATED MODULE: ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/base.response.ts
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/error.response.ts


class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        var _a, _b;
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
            this.captchaSiteKey = (_b = (_a = this.validationErrors) === null || _a === void 0 ? void 0 : _a.HCaptcha_SiteKey) === null || _b === void 0 ? void 0 : _b[0];
            this.captchaRequired = !Utils.isNullOrWhitespace(this.captchaSiteKey);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/scheduling/task-scheduler.service.ts
class TaskSchedulerService {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/scheduling/default-task-scheduler.service.ts
var default_task_scheduler_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class DefaultTaskSchedulerService extends TaskSchedulerService {
    constructor(logService) {
        super();
        this.logService = logService;
        this.taskHandlers = new Map();
    }
    /**
     * Sets a timeout and returns the timeout id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param delayInMs - The delay in milliseconds.
     */
    setTimeout(taskName, delayInMs) {
        this.validateRegisteredTask(taskName);
        const timeoutHandle = globalThis.setTimeout(() => this.triggerTask(taskName), delayInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearTimeout(timeoutHandle));
    }
    /**
     * Sets an interval and returns the interval id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param intervalInMs - The interval in milliseconds.
     * @param _initialDelayInMs - The initial delay in milliseconds. Unused in the base implementation.
     */
    setInterval(taskName, intervalInMs, _initialDelayInMs) {
        this.validateRegisteredTask(taskName);
        const intervalHandle = globalThis.setInterval(() => this.triggerTask(taskName), intervalInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearInterval(intervalHandle));
    }
    /**
     * Registers a task handler.
     *
     * @param taskName - The name of the task.
     * @param handler - The task handler.
     */
    registerTaskHandler(taskName, handler) {
        const existingHandler = this.taskHandlers.get(taskName);
        if (existingHandler) {
            this.logService.warning(`Task handler for ${taskName} already exists. Overwriting.`);
            this.unregisterTaskHandler(taskName);
        }
        this.taskHandlers.set(taskName, handler);
    }
    /**
     * Unregisters a task handler.
     *
     * @param taskName - The name of the task.
     */
    unregisterTaskHandler(taskName) {
        this.taskHandlers.delete(taskName);
    }
    /**
     * Triggers a task.
     *
     * @param taskName - The name of the task.
     * @param _periodInMinutes - The period in minutes. Unused in the base implementation.
     */
    triggerTask(taskName, _periodInMinutes) {
        return default_task_scheduler_service_awaiter(this, void 0, void 0, function* () {
            const handler = this.taskHandlers.get(taskName);
            if (handler) {
                handler();
            }
        });
    }
    /**
     * Validates that a task handler is registered.
     *
     * @param taskName - The name of the task.
     */
    validateRegisteredTask(taskName) {
        if (!this.taskHandlers.has(taskName)) {
            throw new Error(`Task handler for ${taskName} not registered. Unable to schedule task.`);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/scheduling/scheduled-task-name.enum.ts
const ScheduledTaskNames = {
    generatePasswordClearClipboardTimeout: "generatePasswordClearClipboardTimeout",
    systemClearClipboardTimeout: "systemClearClipboardTimeout",
    loginStrategySessionTimeout: "loginStrategySessionTimeout",
    notificationsReconnectTimeout: "notificationsReconnectTimeout",
    fido2ClientAbortTimeout: "fido2ClientAbortTimeout",
    scheduleNextSyncInterval: "scheduleNextSyncInterval",
    eventUploadsInterval: "eventUploadsInterval",
    vaultTimeoutCheckInterval: "vaultTimeoutCheckInterval",
};

;// CONCATENATED MODULE: ../../libs/common/src/platform/scheduling/index.ts




;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/device.request.ts
class DeviceRequest {
    constructor(appId, platformUtilsService) {
        this.type = platformUtilsService.getDevice();
        this.name = platformUtilsService.getDeviceString();
        this.identifier = appId;
        this.pushToken = null;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(DeviceRequest.prototype), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token.request.ts
class TokenRequest {
    constructor(twoFactor, device) {
        this.twoFactor = twoFactor;
        this.device = device != null ? device : null;
    }
    // eslint-disable-next-line
    alterIdentityTokenHeaders(headers) {
        // Implemented in subclass if required
    }
    setTwoFactor(twoFactor) {
        this.twoFactor = twoFactor;
    }
    setAuthRequestAccessCode(accessCode) {
        this.authRequest = accessCode;
    }
    toIdentityToken(clientId) {
        const obj = {
            scope: "api offline_access",
            client_id: clientId,
        };
        if (this.device) {
            obj.deviceType = this.device.type;
            obj.deviceIdentifier = this.device.identifier;
            obj.deviceName = this.device.name;
            // no push tokens for browser apps yet
            // obj.devicePushToken = this.device.pushToken;
        }
        //passswordless login
        if (this.authRequest) {
            obj.authRequest = this.authRequest;
        }
        if (this.twoFactor) {
            if (this.twoFactor.token && this.twoFactor.provider != null) {
                obj.twoFactorToken = this.twoFactor.token;
                obj.twoFactorProvider = this.twoFactor.provider;
                obj.twoFactorRemember = this.twoFactor.remember ? "1" : "0";
            }
        }
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/password-token.request.ts




class PasswordTokenRequest extends TokenRequest {
    constructor(email, masterPasswordHash, captchaResponse, twoFactor, device) {
        super(twoFactor, device);
        this.email = email;
        this.masterPasswordHash = masterPasswordHash;
        this.captchaResponse = captchaResponse;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "password";
        obj.username = this.email;
        obj.password = this.masterPasswordHash;
        if (this.captchaResponse != null) {
            obj.captchaResponse = this.captchaResponse;
        }
        return obj;
    }
    alterIdentityTokenHeaders(headers) {
        headers.set("Auth-Email", Utils.fromUtf8ToUrlB64(this.email));
    }
    static fromJSON(json) {
        return Object.assign(Object.create(PasswordTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/two-factor-provider-type.ts
var TwoFactorProviderType;
(function (TwoFactorProviderType) {
    TwoFactorProviderType[TwoFactorProviderType["Authenticator"] = 0] = "Authenticator";
    TwoFactorProviderType[TwoFactorProviderType["Email"] = 1] = "Email";
    TwoFactorProviderType[TwoFactorProviderType["Duo"] = 2] = "Duo";
    TwoFactorProviderType[TwoFactorProviderType["Yubikey"] = 3] = "Yubikey";
    TwoFactorProviderType[TwoFactorProviderType["U2f"] = 4] = "U2f";
    TwoFactorProviderType[TwoFactorProviderType["Remember"] = 5] = "Remember";
    TwoFactorProviderType[TwoFactorProviderType["OrganizationDuo"] = 6] = "OrganizationDuo";
    TwoFactorProviderType[TwoFactorProviderType["WebAuthn"] = 7] = "WebAuthn";
})(TwoFactorProviderType || (TwoFactorProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/force-set-password-reason.ts
/*
 * This enum is used to determine if a user should be forced to initially set or reset their password
 * on login (server flag) or unlock via MP (client evaluation).
 */
var ForceSetPasswordReason;
(function (ForceSetPasswordReason) {
    /**
     * A password reset should not be forced.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["None"] = 0] = "None";
    /**
     * Occurs when an organization admin forces a user to reset their password.
     * Communicated via server flag.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["AdminForcePasswordReset"] = 1] = "AdminForcePasswordReset";
    /**
     * Occurs when a user logs in / unlocks their vault with a master password that does not meet an organization's
     * master password policy that is enforced on login/unlock.
     * Only set client side b/c server can't evaluate MP.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["WeakMasterPassword"] = 2] = "WeakMasterPassword";
    /**
     * Occurs when a TDE user without a password obtains the password reset permission.
     * Set post login & decryption client side and by server in sync (to catch logged in users).
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeUserWithoutPasswordHasPasswordResetPermission"] = 3] = "TdeUserWithoutPasswordHasPasswordResetPermission";
})(ForceSetPasswordReason || (ForceSetPasswordReason = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/auth-result.ts


class AuthResult {
    constructor() {
        this.captchaSiteKey = "";
        // TODO: PM-3287 - Remove this after 3 releases of backwards compatibility. - Target release 2023.12 for removal
        /**
         * @deprecated
         * Replace with using UserDecryptionOptions to determine if the user does
         * not have a master password and is not using Key Connector.
         * */
        this.resetMasterPassword = false;
        this.forcePasswordReset = ForceSetPasswordReason.None;
        this.twoFactorProviders = null;
    }
    get requiresCaptcha() {
        return !Utils.isNullOrWhitespace(this.captchaSiteKey);
    }
    get requiresTwoFactor() {
        return this.twoFactorProviders != null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-captcha.response.ts

class IdentityCaptchaResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.siteKey = this.getResponseProperty("HCaptcha_SiteKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/master-password-policy.response.ts

class MasterPasswordPolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.minComplexity = this.getResponseProperty("MinComplexity");
        this.minLength = this.getResponseProperty("MinLength");
        this.requireUpper = this.getResponseProperty("RequireUpper");
        this.requireLower = this.getResponseProperty("RequireLower");
        this.requireNumbers = this.getResponseProperty("RequireNumbers");
        this.requireSpecial = this.getResponseProperty("RequireSpecial");
        this.enforceOnLogin = this.getResponseProperty("EnforceOnLogin");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/key-connector-user-decryption-option.response.ts

class KeyConnectorUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/trusted-device-user-decryption-option.response.ts


class TrustedDeviceUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasAdminApproval = this.getResponseProperty("HasAdminApproval");
        this.hasLoginApprovingDevice = this.getResponseProperty("HasLoginApprovingDevice");
        this.hasManageResetPasswordPermission = this.getResponseProperty("HasManageResetPasswordPermission");
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/webauthn-prf-decryption-option.response.ts


class WebAuthnPrfDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/user-decryption-options.response.ts




class UserDecryptionOptionsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        if (response.TrustedDeviceOption) {
            this.trustedDeviceOption = new TrustedDeviceUserDecryptionOptionResponse(this.getResponseProperty("TrustedDeviceOption"));
        }
        if (response.KeyConnectorOption) {
            this.keyConnectorOption = new KeyConnectorUserDecryptionOptionResponse(this.getResponseProperty("KeyConnectorOption"));
        }
        if (response.WebAuthnPrfOption) {
            this.webAuthnPrfOption = new WebAuthnPrfDecryptionOptionResponse(this.getResponseProperty("WebAuthnPrfOption"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-token.response.ts



class IdentityTokenResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.accessToken = response.access_token;
        this.expiresIn = response.expires_in;
        this.refreshToken = response.refresh_token;
        this.tokenType = response.token_type;
        this.resetMasterPassword = this.getResponseProperty("ResetMasterPassword");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.key = this.getResponseProperty("Key");
        this.twoFactorToken = this.getResponseProperty("TwoFactorToken");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.forcePasswordReset = this.getResponseProperty("ForcePasswordReset");
        this.apiUseKeyConnector = this.getResponseProperty("ApiUseKeyConnector");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        if (response.UserDecryptionOptions) {
            this.userDecryptionOptions = new UserDecryptionOptionsResponse(this.getResponseProperty("UserDecryptionOptions"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-two-factor.response.ts


class IdentityTwoFactorResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.captchaToken = this.getResponseProperty("CaptchaBypassToken");
        this.twoFactorProviders = this.getResponseProperty("TwoFactorProviders");
        this.twoFactorProviders2 = this.getResponseProperty("TwoFactorProviders2");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        this.ssoEmail2faSessionToken = this.getResponseProperty("SsoEmail2faSessionToken");
        this.email = this.getResponseProperty("Email");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/client-type.enum.ts
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    // Mobile = "mobile",
    ClientType["Cli"] = "cli";
    // DirectoryConnector = "connector",
})(ClientType || (ClientType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/device-type.enum.ts
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
    DeviceType[DeviceType["WindowsCLI"] = 23] = "WindowsCLI";
    DeviceType[DeviceType["MacOsCLI"] = 24] = "MacOsCLI";
    DeviceType[DeviceType["LinuxCLI"] = 25] = "LinuxCLI";
})(DeviceType || (DeviceType = {}));
const MobileDeviceTypes = new Set([
    DeviceType.Android,
    DeviceType.iOS,
    DeviceType.AndroidAmazon,
]);
const DesktopDeviceTypes = new Set([
    DeviceType.WindowsDesktop,
    DeviceType.MacOsDesktop,
    DeviceType.LinuxDesktop,
    DeviceType.UWP,
    DeviceType.WindowsCLI,
    DeviceType.MacOsCLI,
    DeviceType.LinuxCLI,
]);

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
})(EventSystemUser || (EventSystemUser = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["User_RequestedDeviceApproval"] = 1010] = "User_RequestedDeviceApproval";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Cipher_ClientToggledTOTPSeedVisible"] = 1118] = "Cipher_ClientToggledTOTPSeedVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["OrganizationUser_ApprovedAuthRequest"] = 1513] = "OrganizationUser_ApprovedAuthRequest";
    EventType[EventType["OrganizationUser_RejectedAuthRequest"] = 1514] = "OrganizationUser_RejectedAuthRequest";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Organization_CollectionManagementUpdated"] = 1609] = "Organization_CollectionManagementUpdated";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
})(EventType || (EventType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    // 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // **********************************************************************************************************
    // 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // **********************************************************************************************************
    // 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // **********************************************************************************************************
    // 500s - Server messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/integration-type.enum.ts
var IntegrationType;
(function (IntegrationType) {
    IntegrationType["Integration"] = "integration";
    IntegrationType["SDK"] = "sdk";
})(IntegrationType || (IntegrationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/native-messaging-version.enum.ts
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/notification-type.enum.ts
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
    NotificationType[NotificationType["SyncOrganizations"] = 17] = "SyncOrganizations";
})(NotificationType || (NotificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/index.ts









;// CONCATENATED MODULE: ../../libs/common/src/models/request/keys.request.ts
class KeysRequest {
    constructor(publicKey, encryptedPrivateKey) {
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/account.ts


class EncryptionPair {
    toJSON() {
        return {
            encrypted: this.encrypted,
            decrypted: this.decrypted instanceof ArrayBuffer
                ? Utils.fromBufferToByteString(this.decrypted)
                : this.decrypted,
        };
    }
    static fromJSON(obj, decryptedFromJson, encryptedFromJson) {
        if (obj == null) {
            return null;
        }
        const pair = new EncryptionPair();
        if ((obj === null || obj === void 0 ? void 0 : obj.encrypted) != null) {
            pair.encrypted = encryptedFromJson
                ? encryptedFromJson(obj.encrypted)
                : obj.encrypted;
        }
        if ((obj === null || obj === void 0 ? void 0 : obj.decrypted) != null) {
            pair.decrypted = decryptedFromJson
                ? decryptedFromJson(obj.decrypted)
                : obj.decrypted;
        }
        return pair;
    }
}
class AccountKeys {
    constructor() {
        /** @deprecated July 2023, left for migration purposes*/
        this.cryptoSymmetricKey = new EncryptionPair();
    }
    toJSON() {
        // If you pass undefined into fromBufferToByteString, you will get an empty string back
        // which will cause all sorts of headaches down the line when you try to getPublicKey
        // and expect a Uint8Array and get an empty string instead.
        return Utils.merge(this, {
            publicKey: this.publicKey ? Utils.fromBufferToByteString(this.publicKey) : undefined,
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountKeys(), obj, {
            cryptoSymmetricKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoSymmetricKey, SymmetricCryptoKey.fromJSON),
            publicKey: Utils.fromByteStringToArray(obj === null || obj === void 0 ? void 0 : obj.publicKey),
        });
    }
    static initRecordEncryptionPairsFromJSON(obj) {
        return EncryptionPair.fromJSON(obj, (decObj) => {
            if (obj == null) {
                return null;
            }
            const record = {};
            for (const id in decObj) {
                record[id] = SymmetricCryptoKey.fromJSON(decObj[id]);
            }
            return record;
        });
    }
}
class AccountProfile {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountProfile(), obj);
    }
}
class Account {
    constructor(init) {
        this.keys = new AccountKeys();
        this.profile = new AccountProfile();
        Object.assign(this, {
            keys: Object.assign(Object.assign({}, new AccountKeys()), init === null || init === void 0 ? void 0 : init.keys),
            profile: Object.assign(Object.assign({}, new AccountProfile()), init === null || init === void 0 ? void 0 : init.profile),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Account({}), json, {
            keys: AccountKeys.fromJSON(json === null || json === void 0 ? void 0 : json.keys),
            profile: AccountProfile.fromJSON(json === null || json === void 0 ? void 0 : json.profile),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/login.strategy.ts
var login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class LoginStrategyData {
}
class LoginStrategy {
    constructor(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService, vaultTimeoutSettingsService, KdfConfigService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.KdfConfigService = KdfConfigService;
    }
    logInTwoFactor(twoFactor, captchaResponse = null) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.setTwoFactor(twoFactor);
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    startLogIn() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.twoFactorService.clearSelectedProvider();
            const tokenRequest = this.cache.value.tokenRequest;
            const response = yield this.apiService.postIdentityToken(tokenRequest);
            if (response instanceof IdentityTwoFactorResponse) {
                return [yield this.processTwoFactorResponse(response), response];
            }
            else if (response instanceof IdentityCaptchaResponse) {
                return [yield this.processCaptchaResponse(response), response];
            }
            else if (response instanceof IdentityTokenResponse) {
                return [yield this.processTokenResponse(response), response];
            }
            throw new Error("Invalid response object.");
        });
    }
    buildDeviceRequest() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const appId = yield this.appIdService.getAppId();
            return new DeviceRequest(appId, this.platformUtilsService);
        });
    }
    /**
     * Builds the TokenTwoFactorRequest to be used within other login strategies token requests
     * to the server.
     * If the user provided a 2FA token in an already created TokenTwoFactorRequest, it will be used.
     * If not, and the user has previously remembered a 2FA token, it will be used.
     * If neither of these are true, an empty TokenTwoFactorRequest will be returned.
     * @param userProvidedTwoFactor - optional - The 2FA token request provided by the caller
     * @param email - optional - ensure that email is provided for any login strategies that support remember 2FA functionality
     * @returns a promise which resolves to a TokenTwoFactorRequest to be sent to the server
     */
    buildTwoFactor(userProvidedTwoFactor, email) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (userProvidedTwoFactor != null) {
                return userProvidedTwoFactor;
            }
            if (email) {
                const storedTwoFactorToken = yield this.tokenService.getTwoFactorToken(email);
                if (storedTwoFactorToken != null) {
                    return new TokenTwoFactorRequest(TwoFactorProviderType.Remember, storedTwoFactorToken, false);
                }
            }
            return new TokenTwoFactorRequest();
        });
    }
    /**
     * Initializes the account with information from the IdTokenResponse after successful login.
     * It also sets the access token and refresh token in the token service.
     *
     * @param {IdentityTokenResponse} tokenResponse - The response from the server containing the identity token.
     * @returns {Promise<UserId>} - A promise that resolves the the UserId when the account information has been successfully saved.
     */
    saveAccountInformation(tokenResponse) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const accountInformation = yield this.tokenService.decodeAccessToken(tokenResponse.accessToken);
            const userId = accountInformation.sub;
            yield this.accountService.addAccount(userId, {
                name: accountInformation.name,
                email: accountInformation.email,
                emailVerified: accountInformation.email_verified,
            });
            yield this.accountService.switchAccount(userId);
            yield this.stateService.addAccount(new Account({
                profile: Object.assign(Object.assign({}, new AccountProfile()), {
                    userId,
                    name: accountInformation.name,
                    email: accountInformation.email,
                }),
            }));
            yield this.verifyAccountAdded(userId);
            // We must set user decryption options before retrieving vault timeout settings
            // as the user decryption options help determine the available timeout actions.
            yield this.userDecryptionOptionsService.setUserDecryptionOptions(UserDecryptionOptions.fromResponse(tokenResponse));
            const vaultTimeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutActionByUserId$(userId));
            const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutByUserId$(userId));
            // User id will be derived from the access token.
            yield this.tokenService.setTokens(tokenResponse.accessToken, vaultTimeoutAction, vaultTimeout, tokenResponse.refreshToken);
            yield this.KdfConfigService.setKdfConfig(userId, tokenResponse.kdf === KdfType.PBKDF2_SHA256
                ? new PBKDF2KdfConfig(tokenResponse.kdfIterations)
                : new Argon2KdfConfig(tokenResponse.kdfIterations, tokenResponse.kdfMemory, tokenResponse.kdfParallelism));
            yield this.billingAccountProfileStateService.setHasPremium(accountInformation.premium, false);
            return userId;
        });
    }
    processTokenResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            // Old encryption keys must be migrated, but is currently only available on web.
            // Other clients shouldn't continue the login process.
            if (this.encryptionKeyMigrationRequired(response)) {
                result.requiresEncryptionKeyMigration = true;
                if (this.platformUtilsService.getClientType() !== ClientType.Web) {
                    return result;
                }
            }
            result.resetMasterPassword = response.resetMasterPassword;
            // Convert boolean to enum
            if (response.forcePasswordReset) {
                result.forcePasswordReset = ForceSetPasswordReason.AdminForcePasswordReset;
            }
            // Must come before setting keys, user key needs email to update additional keys
            const userId = yield this.saveAccountInformation(response);
            result.userId = userId;
            if (response.twoFactorToken != null) {
                // note: we can read email from access token b/c it was saved in saveAccountInformation
                const userEmail = yield this.tokenService.getEmail();
                yield this.tokenService.setTwoFactorToken(userEmail, response.twoFactorToken);
            }
            yield this.setMasterKey(response, userId);
            yield this.setUserKey(response, userId);
            yield this.setPrivateKey(response, userId);
            this.messagingService.send("loggedIn");
            return result;
        });
    }
    // Old accounts used master key for encryption. We are forcing migrations but only need to
    // check on password logins
    encryptionKeyMigrationRequired(response) {
        return false;
    }
    createKeyPairForOldAccount(userId) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            try {
                const userKey = yield this.cryptoService.getUserKeyWithLegacySupport(userId);
                const [publicKey, privateKey] = yield this.cryptoService.makeKeyPair(userKey);
                yield this.apiService.postAccountKeys(new KeysRequest(publicKey, privateKey.encryptedString));
                return privateKey.encryptedString;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    /**
     * Handles the response from the server when a 2FA is required.
     * It clears any existing 2FA token, as it's no longer valid, and sets up the necessary data for the 2FA process.
     *
     * @param {IdentityTwoFactorResponse} response - The response from the server indicating that 2FA is required.
     * @returns {Promise<AuthResult>} - A promise that resolves to an AuthResult object
     */
    processTwoFactorResponse(response) {
        var _a;
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            // If we get a 2FA required response, then we should clear the 2FA token
            // just in case as it is no longer valid.
            yield this.clearTwoFactorToken();
            const result = new AuthResult();
            result.twoFactorProviders = response.twoFactorProviders2;
            yield this.twoFactorService.setProviders(response);
            this.cache.next(Object.assign(Object.assign({}, this.cache.value), { captchaBypassToken: (_a = response.captchaToken) !== null && _a !== void 0 ? _a : null }));
            result.ssoEmail2FaSessionToken = response.ssoEmail2faSessionToken;
            result.email = response.email;
            return result;
        });
    }
    /**
     * Clears the 2FA token from the token service using the user's email if it exists
     */
    clearTwoFactorToken() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const email = this.cache.value.userEnteredEmail;
            if (email) {
                yield this.tokenService.clearTwoFactorToken(email);
            }
        });
    }
    processCaptchaResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.captchaSiteKey = response.siteKey;
            return result;
        });
    }
    /**
     * Verifies that the active account is set after initialization.
     * Note: In browser there is a slight delay between when active account emits in background,
     * and when it emits in foreground. We're giving the foreground 1 second to catch up.
     * If nothing is emitted, we throw an error.
     */
    verifyAccountAdded(expectedUserId) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.filter)((account) => (account === null || account === void 0 ? void 0 : account.id) === expectedUserId), (0,external_rxjs_namespaceObject.timeout)({
                first: 1000,
                with: () => {
                    throw new Error("Expected user never made active user after initialization.");
                },
            })));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/auth-request-login.strategy.ts
var auth_request_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class AuthRequestLoginStrategyData {
    static fromJSON(obj) {
        const data = Object.assign(new AuthRequestLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            authRequestCredentials: AuthRequestLoginCredentials.fromJSON(obj.authRequestCredentials),
        });
        return data;
    }
}
class AuthRequestLoginStrategy extends LoginStrategy {
    constructor(data, deviceTrustService, ...sharedDeps) {
        super(...sharedDeps);
        this.deviceTrustService = deviceTrustService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.tokenRequest.email));
        this.accessCode$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.accessCode));
        this.authRequestId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.authRequestId));
    }
    logIn(credentials) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new AuthRequestLoginStrategyData();
            data.tokenRequest = new PasswordTokenRequest(credentials.email, credentials.accessCode, null, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), yield this.buildDeviceRequest());
            data.tokenRequest.setAuthRequestAccessCode(credentials.authRequestId);
            data.authRequestCredentials = credentials;
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : data.captchaBypassToken;
            this.cache.next(data);
            return _super.logInTwoFactor.call(this, twoFactor);
        });
    }
    setMasterKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            if (authRequestCredentials.decryptedMasterKey &&
                authRequestCredentials.decryptedMasterKeyHash) {
                yield this.masterPasswordService.setMasterKey(authRequestCredentials.decryptedMasterKey, userId);
                yield this.masterPasswordService.setMasterKeyHash(authRequestCredentials.decryptedMasterKeyHash, userId);
            }
        });
    }
    setUserKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            // User now may or may not have a master password
            // but set the master key encrypted user key if it exists regardless
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (authRequestCredentials.decryptedUserKey) {
                yield this.cryptoService.setUserKey(authRequestCredentials.decryptedUserKey);
            }
            else {
                yield this.trySetUserKeyWithMasterKey(userId);
                // Establish trust if required after setting user key
                yield this.deviceTrustService.trustDeviceIfRequired(userId);
            }
        });
    }
    trySetUserKeyWithMasterKey(userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    setPrivateKey(response, userId) {
        var _a;
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    exportCache() {
        return {
            authRequest: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(viewModel, map, orgId, key = null) {
        return domain_base_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const self = this;
            for (const prop in map) {
                // eslint-disable-next-line
                if (!map.hasOwnProperty(prop)) {
                    continue;
                }
                (function (theProp) {
                    const p = Promise.resolve()
                        .then(() => {
                        const mapProp = map[theProp] || theProp;
                        if (self[mapProp]) {
                            return self[mapProp].decrypt(orgId, key);
                        }
                        return null;
                    })
                        .then((val) => {
                        viewModel[theProp] = val;
                    });
                    promises.push(p);
                })(prop);
            }
            yield Promise.all(promises);
            return viewModel;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/master-password-policy-options.ts

class MasterPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.minComplexity = 0;
        this.minLength = 0;
        this.requireUpper = false;
        this.requireLower = false;
        this.requireNumbers = false;
        this.requireSpecial = false;
        /**
         * Flag to indicate if the policy should be enforced on login.
         * If true, and the user's password does not meet the policy requirements,
         * the user will be forced to update their password.
         */
        this.enforceOnLogin = false;
    }
    static fromResponse(policy) {
        if (policy == null) {
            return null;
        }
        const options = new MasterPasswordPolicyOptions();
        options.minComplexity = policy.minComplexity;
        options.minLength = policy.minLength;
        options.requireUpper = policy.requireUpper;
        options.requireLower = policy.requireLower;
        options.requireNumbers = policy.requireNumbers;
        options.requireSpecial = policy.requireSpecial;
        options.enforceOnLogin = policy.enforceOnLogin;
        return options;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/password-login.strategy.ts
var password_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









class PasswordLoginStrategyData {
    constructor() {
        /**
         * Tracks if the user needs to update their password due to
         * a password that does not meet an organization's master password policy.
         */
        this.forcePasswordResetReason = ForceSetPasswordReason.None;
    }
    static fromJSON(obj) {
        const data = Object.assign(new PasswordLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            masterKey: SymmetricCryptoKey.fromJSON(obj.masterKey),
        });
        return data;
    }
}
class PasswordLoginStrategy extends LoginStrategy {
    constructor(data, passwordStrengthService, policyService, loginStrategyService, ...sharedDeps) {
        super(...sharedDeps);
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.loginStrategyService = loginStrategyService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.email));
        this.serverMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.masterPasswordHash));
        this.localMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.localMasterKeyHash));
    }
    logIn(credentials) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { email, masterPassword, captchaToken, twoFactor } = credentials;
            const data = new PasswordLoginStrategyData();
            data.masterKey = yield this.loginStrategyService.makePreloginKey(masterPassword, email);
            data.userEnteredEmail = email;
            // Hash the password early (before authentication) so we don't persist it in memory in plaintext
            data.localMasterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, data.masterKey, HashPurpose.LocalAuthorization);
            const serverMasterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, data.masterKey);
            data.tokenRequest = new PasswordTokenRequest(email, serverMasterKeyHash, captchaToken, yield this.buildTwoFactor(twoFactor, email), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult, identityResponse] = yield this.startLogIn();
            if (identityResponse instanceof IdentityCaptchaResponse) {
                return authResult;
            }
            const masterPasswordPolicyOptions = this.getMasterPasswordPolicyOptionsFromResponse(identityResponse);
            // The identity result can contain master password policies for the user's organizations
            if (masterPasswordPolicyOptions === null || masterPasswordPolicyOptions === void 0 ? void 0 : masterPasswordPolicyOptions.enforceOnLogin) {
                // If there is a policy active, evaluate the supplied password before its no longer in memory
                const meetsRequirements = this.evaluateMasterPassword(credentials, masterPasswordPolicyOptions);
                if (meetsRequirements) {
                    return authResult;
                }
                if (identityResponse instanceof IdentityTwoFactorResponse) {
                    // Save the flag to this strategy for use in 2fa login as the master password is about to pass out of scope
                    this.cache.next(Object.assign(Object.assign({}, this.cache.value), { forcePasswordResetReason: ForceSetPasswordReason.WeakMasterPassword }));
                }
                else {
                    // Authentication was successful, save the force update password options with the state service
                    yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.WeakMasterPassword, authResult.userId);
                    authResult.forcePasswordReset = ForceSetPasswordReason.WeakMasterPassword;
                }
            }
            return authResult;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : data.captchaBypassToken;
            this.cache.next(data);
            const result = yield _super.logInTwoFactor.call(this, twoFactor);
            // 2FA was successful, save the force update password options with the state service if defined
            const forcePasswordResetReason = this.cache.value.forcePasswordResetReason;
            if (!result.requiresTwoFactor &&
                !result.requiresCaptcha &&
                forcePasswordResetReason != ForceSetPasswordReason.None) {
                yield this.masterPasswordService.setForceSetPasswordReason(forcePasswordResetReason, result.userId);
                result.forcePasswordReset = forcePasswordResetReason;
            }
            return result;
        });
    }
    setMasterKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { masterKey, localMasterKeyHash } = this.cache.value;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(localMasterKeyHash, userId);
        });
    }
    setUserKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // If migration is required, we won't have a user key to set yet.
            if (this.encryptionKeyMigrationRequired(response)) {
                return;
            }
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key, userId);
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey, userId);
            }
        });
    }
    setPrivateKey(response, userId) {
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    encryptionKeyMigrationRequired(response) {
        return !response.key;
    }
    getMasterPasswordPolicyOptionsFromResponse(response) {
        if (response == null) {
            return null;
        }
        return MasterPasswordPolicyOptions.fromResponse(response.masterPasswordPolicy);
    }
    evaluateMasterPassword({ masterPassword, email }, options) {
        var _a;
        const passwordStrength = (_a = this.passwordStrengthService.getPasswordStrength(masterPassword, email)) === null || _a === void 0 ? void 0 : _a.score;
        return this.policyService.evaluateMasterPassword(passwordStrength, masterPassword, options);
    }
    exportCache() {
        return {
            password: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/sso-token.request.ts



class SsoTokenRequest extends TokenRequest {
    constructor(code, codeVerifier, redirectUri, twoFactor, device) {
        super(twoFactor, device);
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUri = redirectUri;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "authorization_code";
        obj.code = this.code;
        obj.code_verifier = this.codeVerifier;
        obj.redirect_uri = this.redirectUri;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(SsoTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/sso-login.strategy.ts
var sso_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class SsoLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new SsoLoginStrategyData(), obj, {
            tokenRequest: SsoTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class SsoLoginStrategy extends LoginStrategy {
    constructor(data, keyConnectorService, deviceTrustService, authRequestService, i18nService, ...sharedDeps) {
        super(...sharedDeps);
        this.keyConnectorService = keyConnectorService;
        this.deviceTrustService = deviceTrustService;
        this.authRequestService = authRequestService;
        this.i18nService = i18nService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.email));
        this.orgId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.orgId));
        this.ssoEmail2FaSessionToken$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.ssoEmail2FaSessionToken));
    }
    logIn(credentials) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new SsoLoginStrategyData();
            data.orgId = credentials.orgId;
            data.userEnteredEmail = credentials.email;
            const deviceRequest = yield this.buildDeviceRequest();
            this.logService.info("Logging in with appId %s.", deviceRequest.identifier);
            data.tokenRequest = new SsoTokenRequest(credentials.code, credentials.codeVerifier, credentials.redirectUrl, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), deviceRequest);
            this.cache.next(data);
            const [ssoAuthResult] = yield this.startLogIn();
            const email = ssoAuthResult.email;
            const ssoEmail2FaSessionToken = ssoAuthResult.ssoEmail2FaSessionToken;
            // Auth guard currently handles redirects for this.
            if (ssoAuthResult.forcePasswordReset == ForceSetPasswordReason.AdminForcePasswordReset) {
                yield this.masterPasswordService.setForceSetPasswordReason(ssoAuthResult.forcePasswordReset, ssoAuthResult.userId);
            }
            this.cache.next(Object.assign(Object.assign({}, this.cache.value), { email,
                ssoEmail2FaSessionToken }));
            return ssoAuthResult;
        });
    }
    setMasterKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // The only way we can be setting a master key at this point is if we are using Key Connector.
            // First, check to make sure that we should do so based on the token response.
            if (this.shouldSetMasterKeyFromKeyConnector(tokenResponse)) {
                // If we're here, we know that the user should use Key Connector (they have a KeyConnectorUrl) and does not have a master password.
                // We can now check the key on the token response to see whether they are a brand new user or an existing user.
                // The presence of a masterKeyEncryptedUserKey indicates that the user has already been provisioned in Key Connector.
                const newSsoUser = tokenResponse.key == null;
                if (newSsoUser) {
                    yield this.keyConnectorService.convertNewSsoUserToKeyConnector(tokenResponse, this.cache.value.orgId, userId);
                }
                else {
                    const keyConnectorUrl = this.getKeyConnectorUrl(tokenResponse);
                    yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl, userId);
                }
            }
        });
    }
    /**
     * Determines if it is possible set the `masterKey` from Key Connector.
     * @param tokenResponse
     * @returns `true` if the master key can be set from Key Connector, `false` otherwise
     */
    shouldSetMasterKeyFromKeyConnector(tokenResponse) {
        var _a;
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        if (userDecryptionOptions != null) {
            const userHasMasterPassword = userDecryptionOptions.hasMasterPassword;
            const userHasKeyConnectorUrl = ((_a = userDecryptionOptions.keyConnectorOption) === null || _a === void 0 ? void 0 : _a.keyConnectorUrl) != null;
            // In order for us to set the master key from Key Connector, we need to have a Key Connector URL
            // and the user must not have a master password.
            return userHasKeyConnectorUrl && !userHasMasterPassword;
        }
        else {
            // In pre-TDE versions of the server, the userDecryptionOptions will not be present.
            // In this case, we can determine if the user has a master password and has a Key Connector URL by
            // just checking the keyConnectorUrl property. This is because the server short-circuits on the response
            // and will not pass back the URL in the response if the user has a master password.
            // TODO: remove compatibility check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            return tokenResponse.keyConnectorUrl != null;
        }
    }
    getKeyConnectorUrl(tokenResponse) {
        var _a, _b;
        // TODO: remove tokenResponse.keyConnectorUrl reference after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        return ((_a = tokenResponse.keyConnectorUrl) !== null && _a !== void 0 ? _a : (_b = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl);
    }
    // TODO: future passkey login strategy will need to support setting user key (decrypting via TDE or admin approval request)
    // so might be worth moving this logic to a common place (base login strategy or a separate service?)
    setUserKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = tokenResponse.key;
            // Note: masterKeyEncryptedUserKey is undefined for SSO JIT provisioned users
            // on account creation and subsequent logins (confirmed or unconfirmed)
            // but that is fine for TDE so we cannot return if it is undefined
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey, userId);
            }
            const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
            // Note: TDE and key connector are mutually exclusive
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.trustedDeviceOption) {
                this.logService.info("Attempting to set user key with approved admin auth request.");
                // Try to use the user key from an approved admin request if it exists.
                // Using it will clear it from state and future requests will use the device key.
                yield this.trySetUserKeyWithApprovedAdminRequestIfExists(userId);
                const hasUserKey = yield this.cryptoService.hasUserKey(userId);
                // Only try to set user key with device key if admin approval request was not successful.
                if (!hasUserKey) {
                    this.logService.info("Attempting to set user key with device key.");
                    yield this.trySetUserKeyWithDeviceKey(tokenResponse, userId);
                }
            }
            else if (masterKeyEncryptedUserKey != null &&
                this.getKeyConnectorUrl(tokenResponse) != null) {
                // Key connector enabled for user
                yield this.trySetUserKeyWithMasterKey(userId);
            }
            // Note: In the traditional SSO flow with MP without key connector, the lock component
            // is responsible for deriving master key from MP entry and then decrypting the user key
        });
    }
    trySetUserKeyWithApprovedAdminRequestIfExists(userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // At this point a user could have an admin auth request that has been approved
            const adminAuthReqStorable = yield this.authRequestService.getAdminAuthRequest(userId);
            if (!adminAuthReqStorable) {
                return;
            }
            // Call server to see if admin auth request has been approved
            let adminAuthReqResponse;
            try {
                adminAuthReqResponse = yield this.apiService.getAuthRequest(adminAuthReqStorable.id);
            }
            catch (error) {
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    // if we get a 404, it means the auth request has been deleted so clear it from storage
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                }
                // Always return on an error here as we don't want to block the user from logging in
                return;
            }
            if (adminAuthReqResponse === null || adminAuthReqResponse === void 0 ? void 0 : adminAuthReqResponse.requestApproved) {
                // if masterPasswordHash has a value, we will always receive authReqResponse.key
                // as authRequestPublicKey(masterKey) + authRequestPublicKey(masterPasswordHash)
                if (adminAuthReqResponse.masterPasswordHash) {
                    yield this.authRequestService.setKeysAfterDecryptingSharedMasterKeyAndHash(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                else {
                    // if masterPasswordHash is null, we will always receive authReqResponse.key
                    // as authRequestPublicKey(userKey)
                    yield this.authRequestService.setUserKeyAfterDecryptingSharedUserKey(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                if (yield this.cryptoService.hasUserKey()) {
                    // Now that we have a decrypted user key in memory, we can check if we
                    // need to establish trust on the current device
                    yield this.deviceTrustService.trustDeviceIfRequired(userId);
                    // if we successfully decrypted the user key, we can delete the admin auth request out of state
                    // TODO: eventually we post and clean up DB as well once consumed on client
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                    this.platformUtilsService.showToast("success", null, this.i18nService.t("loginApproved"));
                }
            }
        });
    }
    trySetUserKeyWithDeviceKey(tokenResponse, userId) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const trustedDeviceOption = (_a = tokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.trustedDeviceOption;
            if (!trustedDeviceOption) {
                this.logService.error("Unable to set user key due to missing trustedDeviceOption.");
                return;
            }
            const deviceKey = yield this.deviceTrustService.getDeviceKey(userId);
            const encDevicePrivateKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedPrivateKey;
            const encUserKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedUserKey;
            if (!deviceKey || !encDevicePrivateKey || !encUserKey) {
                if (!deviceKey) {
                    yield this.logService.warning("Unable to set user key due to missing device key.");
                }
                if (!encDevicePrivateKey) {
                    yield this.logService.warning("Unable to set user key due to missing encrypted device private key.");
                }
                if (!encUserKey) {
                    yield this.logService.warning("Unable to set user key due to missing encrypted user key.");
                }
                return;
            }
            const userKey = yield this.deviceTrustService.decryptUserKeyWithDeviceKey(userId, encDevicePrivateKey, encUserKey, deviceKey);
            if (userKey) {
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    trySetUserKeyWithMasterKey(userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            // There is a scenario in which the master key is not set here. That will occur if the user
            // has a master password and is using Key Connector. In that case, we cannot set the master key
            // because the user hasn't entered their master password yet.
            // Instead, we'll return here and let the migration to Key Connector handle setting the master key.
            if (!masterKey) {
                return;
            }
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setPrivateKey(tokenResponse, userId) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const newSsoUser = tokenResponse.key == null;
            if (!newSsoUser) {
                yield this.cryptoService.setPrivateKey((_a = tokenResponse.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
            }
        });
    }
    exportCache() {
        return {
            sso: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/user-api-token.request.ts



class UserApiTokenRequest extends TokenRequest {
    constructor(clientId, clientSecret, twoFactor, device) {
        super(twoFactor, device);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twoFactor = twoFactor;
    }
    toIdentityToken() {
        const obj = super.toIdentityToken(this.clientId);
        obj.scope = this.clientId.startsWith("organization") ? "api.organization" : "api";
        obj.grant_type = "client_credentials";
        obj.client_secret = this.clientSecret;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(UserApiTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/user-api-login.strategy.ts
var user_api_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class UserApiLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new UserApiLoginStrategyData(), obj, {
            tokenRequest: UserApiTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class UserApiLoginStrategy extends LoginStrategy {
    constructor(data, environmentService, keyConnectorService, ...sharedDeps) {
        super(...sharedDeps);
        this.environmentService = environmentService;
        this.keyConnectorService = keyConnectorService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new UserApiLoginStrategyData();
            data.tokenRequest = new UserApiTokenRequest(credentials.clientId, credentials.clientSecret, yield this.buildTwoFactor(), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    setMasterKey(response, userId) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (response.apiUseKeyConnector) {
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const keyConnectorUrl = env.getKeyConnectorUrl();
                yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl, userId);
            }
        });
    }
    setUserKey(response, userId) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (response.apiUseKeyConnector) {
                const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
                if (masterKey) {
                    const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
                    yield this.cryptoService.setUserKey(userKey, userId);
                }
            }
        });
    }
    setPrivateKey(response, userId) {
        var _a;
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    // Overridden to save client ID and secret to token service
    saveAccountInformation(tokenResponse) {
        const _super = Object.create(null, {
            saveAccountInformation: { get: () => super.saveAccountInformation }
        });
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const userId = yield _super.saveAccountInformation.call(this, tokenResponse);
            const vaultTimeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutActionByUserId$(userId));
            const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutByUserId$(userId));
            const tokenRequest = this.cache.value.tokenRequest;
            yield this.tokenService.setClientId(tokenRequest.clientId, vaultTimeoutAction, vaultTimeout);
            yield this.tokenService.setClientSecret(tokenRequest.clientSecret, vaultTimeoutAction, vaultTimeout);
            return userId;
        });
    }
    exportCache() {
        return {
            userApiKey: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/webauthn-login-token.request.ts




class WebAuthnLoginTokenRequest extends TokenRequest {
    constructor(token, deviceResponse, device) {
        super(undefined, device);
        this.token = token;
        this.deviceResponse = deviceResponse;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "webauthn";
        obj.token = this.token;
        // must be a string b/c sending as form encoded data
        obj.deviceResponse = JSON.stringify(this.deviceResponse);
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginTokenRequest.prototype), json, {
            deviceResponse: WebAuthnLoginAssertionResponseRequest.fromJSON(json.deviceResponse),
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/webauthn-login.strategy.ts
var webauthn_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class WebAuthnLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new WebAuthnLoginStrategyData(), obj, {
            tokenRequest: WebAuthnLoginTokenRequest.fromJSON(obj.tokenRequest),
            credentials: WebAuthnLoginCredentials.fromJSON(obj.credentials),
        });
    }
}
class WebAuthnLoginStrategy extends LoginStrategy {
    constructor(data, ...sharedDeps) {
        super(...sharedDeps);
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new WebAuthnLoginStrategyData();
            data.credentials = credentials;
            data.tokenRequest = new WebAuthnLoginTokenRequest(credentials.token, credentials.deviceResponse, yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            throw new Error("2FA not supported yet for WebAuthn Login.");
        });
    }
    setMasterKey(response, userId) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            return Promise.resolve();
        });
    }
    setUserKey(idTokenResponse, userId) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = idTokenResponse.key;
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey, userId);
            }
            const userDecryptionOptions = idTokenResponse === null || idTokenResponse === void 0 ? void 0 : idTokenResponse.userDecryptionOptions;
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.webAuthnPrfOption) {
                const webAuthnPrfOption = (_a = idTokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.webAuthnPrfOption;
                const credentials = this.cache.value.credentials;
                // confirm we still have the prf key
                if (!credentials.prfKey) {
                    return;
                }
                // decrypt prf encrypted private key
                const privateKey = yield this.cryptoService.decryptToBytes(webAuthnPrfOption.encryptedPrivateKey, credentials.prfKey);
                // decrypt user key with private key
                const userKey = yield this.cryptoService.rsaDecrypt(webAuthnPrfOption.encryptedUserKey.encryptedString, privateKey);
                if (userKey) {
                    yield this.cryptoService.setUserKey(new SymmetricCryptoKey(userKey), userId);
                }
            }
        });
    }
    setPrivateKey(response, userId) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    exportCache() {
        return {
            webAuthn: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-strategies/login-strategy.state.ts






/**
 * The current login strategy in use.
 */
const CURRENT_LOGIN_STRATEGY_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "currentLoginStrategy", {
    deserializer: (data) => data,
});
/**
 * The expiration date for the login strategy cache.
 * Used as a backup to the timer set on the service.
 */
const CACHE_EXPIRATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCacheExpiration", {
    deserializer: (data) => (data ? null : new Date(data)),
});
/**
 * Auth Request notification for all instances of the login strategy service.
 * Note: this isn't an ideal approach, but allows both a background and
 * foreground instance to send out the notification.
 * TODO: Move to Auth Request service.
 */
const AUTH_REQUEST_PUSH_NOTIFICATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "authRequestPushNotification", {
    deserializer: (data) => data,
});
/**
 * A cache for login strategies to use for data persistence through
 * the login process.
 */
const CACHE_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCache", {
    deserializer: (data) => {
        if (data == null) {
            return null;
        }
        return {
            password: data.password ? PasswordLoginStrategyData.fromJSON(data.password) : undefined,
            sso: data.sso ? SsoLoginStrategyData.fromJSON(data.sso) : undefined,
            userApiKey: data.userApiKey
                ? UserApiLoginStrategyData.fromJSON(data.userApiKey)
                : undefined,
            authRequest: data.authRequest
                ? AuthRequestLoginStrategyData.fromJSON(data.authRequest)
                : undefined,
            webAuthn: data.webAuthn ? WebAuthnLoginStrategyData.fromJSON(data.webAuthn) : undefined,
        };
    },
});

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-strategies/login-strategy.service.ts
var login_strategy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













const sessionTimeoutLength = 2 * 60 * 1000; // 2 minutes
class LoginStrategyService {
    constructor(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, keyConnectorService, environmentService, stateService, twoFactorService, i18nService, encryptService, passwordStrengthService, policyService, deviceTrustService, authRequestService, userDecryptionOptionsService, stateProvider, billingAccountProfileStateService, vaultTimeoutSettingsService, kdfConfigService, taskSchedulerService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.deviceTrustService = deviceTrustService;
        this.authRequestService = authRequestService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.stateProvider = stateProvider;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.kdfConfigService = kdfConfigService;
        this.taskSchedulerService = taskSchedulerService;
        this.currentAuthnTypeState = this.stateProvider.get(CURRENT_LOGIN_STRATEGY_KEY);
        this.loginStrategyCacheState = this.stateProvider.get(CACHE_KEY);
        this.loginStrategyCacheExpirationState = this.stateProvider.get(CACHE_EXPIRATION_KEY);
        this.authRequestPushNotificationState = this.stateProvider.get(AUTH_REQUEST_PUSH_NOTIFICATION_KEY);
        this.taskSchedulerService.registerTaskHandler(ScheduledTaskNames.loginStrategySessionTimeout, () => this.clearCache());
        this.currentAuthType$ = this.currentAuthnTypeState.state$;
        this.loginStrategy$ = this.currentAuthnTypeState.state$.pipe((0,external_rxjs_namespaceObject.distinctUntilChanged)(), (0,external_rxjs_namespaceObject.combineLatestWith)(this.loginStrategyCacheState.state$), this.initializeLoginStrategy.bind(this), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
    }
    getEmail() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("email$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.email$);
            }
            return null;
        });
    }
    getMasterPasswordHash() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("serverMasterKeyHash$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.serverMasterKeyHash$);
            }
            return null;
        });
    }
    getSsoEmail2FaSessionToken() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("ssoEmail2FaSessionToken$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.ssoEmail2FaSessionToken$);
            }
            return null;
        });
    }
    getAccessCode() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("accessCode$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.accessCode$);
            }
            return null;
        });
    }
    getAuthRequestId() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("authRequestId$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.authRequestId$);
            }
            return null;
        });
    }
    logIn(credentials) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearCache();
            yield this.currentAuthnTypeState.update((_) => credentials.type);
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            // Note: We aren't passing the credentials directly to the strategy since they are
            // created in the popup and can cause DeadObject references on Firefox.
            // This is a shallow copy, but use deep copy in future if objects are added to credentials
            // that were created in popup.
            // If the popup uses its own instance of this service, this can be removed.
            const ownedCredentials = Object.assign({}, credentials);
            const result = yield strategy.logIn(ownedCredentials);
            if (result != null && !result.requiresTwoFactor) {
                yield this.clearCache();
            }
            else {
                // Cache the strategy data so we can attempt again later with 2fa. Cache supports different contexts
                yield this.loginStrategyCacheState.update((_) => strategy.exportCache());
                yield this.startSessionTimeout();
            }
            return result;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.isSessionValid())) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy == null) {
                throw new Error("No login strategy found.");
            }
            try {
                const result = yield strategy.logInTwoFactor(twoFactor, captchaResponse);
                // Only clear cache if 2FA token has been accepted, otherwise we need to be able to try again
                if (result != null && !result.requiresTwoFactor && !result.requiresCaptcha) {
                    yield this.clearCache();
                }
                return result;
            }
            catch (e) {
                // API exceptions are okay, but if there are any unhandled client-side errors then clear cache to be safe
                if (!(e instanceof ErrorResponse)) {
                    yield this.clearCache();
                }
                throw e;
            }
        });
    }
    makePreloginKey(masterPassword, email) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            email = email.trim().toLowerCase();
            let kdfConfig = null;
            try {
                const preloginResponse = yield this.apiService.postPrelogin(new PreloginRequest(email));
                if (preloginResponse != null) {
                    kdfConfig =
                        preloginResponse.kdf === KdfType.PBKDF2_SHA256
                            ? new PBKDF2KdfConfig(preloginResponse.kdfIterations)
                            : new Argon2KdfConfig(preloginResponse.kdfIterations, preloginResponse.kdfMemory, preloginResponse.kdfParallelism);
                }
            }
            catch (e) {
                if (e == null || e.statusCode !== 404) {
                    throw e;
                }
            }
            return yield this.cryptoService.makeMasterKey(masterPassword, email, kdfConfig);
        });
    }
    clearCache() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.currentAuthnTypeState.update((_) => null);
            yield this.loginStrategyCacheState.update((_) => null);
            yield this.clearSessionTimeout();
        });
    }
    startSessionTimeout() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearSessionTimeout();
            // This Login Strategy Cache Expiration State value set here is used to clear the cache on re-init
            // of the application in the case where the timeout is terminated due to a closure of the application
            // window. The browser extension popup in particular is susceptible to this concern, as the user
            // is almost always likely to close the popup window before the session timeout is reached.
            yield this.loginStrategyCacheExpirationState.update((_) => new Date(Date.now() + sessionTimeoutLength));
            this.sessionTimeoutSubscription = this.taskSchedulerService.setTimeout(ScheduledTaskNames.loginStrategySessionTimeout, sessionTimeoutLength);
        });
    }
    clearSessionTimeout() {
        var _a;
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginStrategyCacheExpirationState.update((_) => null);
            (_a = this.sessionTimeoutSubscription) === null || _a === void 0 ? void 0 : _a.unsubscribe();
        });
    }
    isSessionValid() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const cache = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheState.state$);
            if (cache == null) {
                return false;
            }
            // If the Login Strategy Cache Expiration State value is less than the current
            // datetime stamp, then the cache is invalid and should be cleared.
            const expiration = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheExpirationState.state$);
            if (expiration != null && expiration < new Date()) {
                yield this.clearCache();
                return false;
            }
            return true;
        });
    }
    initializeLoginStrategy(source) {
        const sharedDeps = [
            this.accountService,
            this.masterPasswordService,
            this.cryptoService,
            this.apiService,
            this.tokenService,
            this.appIdService,
            this.platformUtilsService,
            this.messagingService,
            this.logService,
            this.stateService,
            this.twoFactorService,
            this.userDecryptionOptionsService,
            this.billingAccountProfileStateService,
            this.vaultTimeoutSettingsService,
            this.kdfConfigService,
        ];
        return source.pipe((0,external_rxjs_namespaceObject.map)(([strategy, data]) => {
            if (strategy == null) {
                return null;
            }
            switch (strategy) {
                case AuthenticationType.Password:
                    return new PasswordLoginStrategy(data === null || data === void 0 ? void 0 : data.password, this.passwordStrengthService, this.policyService, this, ...sharedDeps);
                case AuthenticationType.Sso:
                    return new SsoLoginStrategy(data === null || data === void 0 ? void 0 : data.sso, this.keyConnectorService, this.deviceTrustService, this.authRequestService, this.i18nService, ...sharedDeps);
                case AuthenticationType.UserApiKey:
                    return new UserApiLoginStrategy(data === null || data === void 0 ? void 0 : data.userApiKey, this.environmentService, this.keyConnectorService, ...sharedDeps);
                case AuthenticationType.AuthRequest:
                    return new AuthRequestLoginStrategy(data === null || data === void 0 ? void 0 : data.authRequest, this.deviceTrustService, ...sharedDeps);
                case AuthenticationType.WebAuthn:
                    return new WebAuthnLoginStrategy(data === null || data === void 0 ? void 0 : data.webAuthn, ...sharedDeps);
            }
        }));
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/user-decryption-options/user-decryption-options.service.ts
var user_decryption_options_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_DECRYPTION_OPTIONS = new UserKeyDefinition(USER_DECRYPTION_OPTIONS_DISK, "decryptionOptions", {
    deserializer: (decryptionOptions) => UserDecryptionOptions.fromJSON(decryptionOptions),
    clearOn: ["logout"],
});
class UserDecryptionOptionsService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.userDecryptionOptionsState = this.stateProvider.getActive(USER_DECRYPTION_OPTIONS);
        this.userDecryptionOptions$ = this.userDecryptionOptionsState.state$;
        this.hasMasterPassword$ = this.userDecryptionOptions$.pipe((0,external_rxjs_namespaceObject.map)((options) => { var _a; return (_a = options === null || options === void 0 ? void 0 : options.hasMasterPassword) !== null && _a !== void 0 ? _a : false; }));
    }
    userDecryptionOptionsById$(userId) {
        return this.stateProvider.getUser(userId, USER_DECRYPTION_OPTIONS).state$;
    }
    setUserDecryptionOptions(userDecryptionOptions) {
        return user_decryption_options_service_awaiter(this, void 0, void 0, function* () {
            yield this.userDecryptionOptionsState.update((_) => userDecryptionOptions);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/admin-auth-req-storable.ts

class AdminAuthRequestStorable {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    toJSON() {
        return {
            id: this.id,
            privateKey: Utils.fromBufferToByteString(this.privateKey),
        };
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        let privateKeyBuffer = null;
        if (obj.privateKey) {
            privateKeyBuffer = Utils.fromByteStringToArray(obj.privateKey);
        }
        return new AdminAuthRequestStorable({
            id: obj.id,
            privateKey: privateKeyBuffer,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/passwordless-auth.request.ts
class PasswordlessAuthRequest {
    constructor(key, masterPasswordHash, deviceIdentifier, requestApproved) {
        this.key = key;
        this.masterPasswordHash = masterPasswordHash;
        this.deviceIdentifier = deviceIdentifier;
        this.requestApproved = requestApproved;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/auth-request/auth-request.service.ts
var auth_request_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/**
 * Disk-local to maintain consistency between tabs. We don't want to
 * clear this on logout since admin auth requests are long-lived.
 */
const ADMIN_AUTH_REQUEST_KEY = new UserKeyDefinition(AUTH_REQUEST_DISK_LOCAL, "adminAuthRequest", {
    deserializer: (value) => value,
    clearOn: [],
});
class AuthRequestService {
    constructor(appIdService, accountService, masterPasswordService, cryptoService, apiService, stateProvider) {
        this.appIdService = appIdService;
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.stateProvider = stateProvider;
        this.authRequestPushNotificationSubject = new external_rxjs_namespaceObject.Subject();
        this.authRequestPushNotification$ = this.authRequestPushNotificationSubject.asObservable();
    }
    getAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            const authRequestSerialized = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, ADMIN_AUTH_REQUEST_KEY).state$);
            const adminAuthRequestStorable = AdminAuthRequestStorable.fromJSON(authRequestSerialized);
            return adminAuthRequestStorable;
        });
    }
    setAdminAuthRequest(authRequest, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            if (authRequest == null) {
                throw new Error("Auth request is required");
            }
            yield this.stateProvider.setUserState(ADMIN_AUTH_REQUEST_KEY, authRequest.toJSON(), userId);
        });
    }
    clearAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            yield this.stateProvider.setUserState(ADMIN_AUTH_REQUEST_KEY, null, userId);
        });
    }
    approveOrDenyAuthRequest(approve, authRequest) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (!authRequest.id) {
                throw new Error("Auth request has no id");
            }
            if (!authRequest.publicKey) {
                throw new Error("Auth request has no public key");
            }
            const pubKey = Utils.fromB64ToArray(authRequest.publicKey);
            const userId = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$)).id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            const masterKeyHash = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));
            let encryptedMasterKeyHash;
            let keyToEncrypt;
            if (masterKey && masterKeyHash) {
                // Only encrypt the master password hash if masterKey exists as
                // we won't have a masterKeyHash without a masterKey
                encryptedMasterKeyHash = yield this.cryptoService.rsaEncrypt(Utils.fromUtf8ToArray(masterKeyHash), pubKey);
                keyToEncrypt = masterKey.encKey;
            }
            else {
                const userKey = yield this.cryptoService.getUserKey();
                keyToEncrypt = userKey.key;
            }
            const encryptedKey = yield this.cryptoService.rsaEncrypt(keyToEncrypt, pubKey);
            const response = new PasswordlessAuthRequest(encryptedKey.encryptedString, encryptedMasterKeyHash === null || encryptedMasterKeyHash === void 0 ? void 0 : encryptedMasterKeyHash.encryptedString, yield this.appIdService.getAppId(), approve);
            return yield this.apiService.putAuthRequest(authRequest.id, response);
        });
    }
    setUserKeyAfterDecryptingSharedUserKey(authReqResponse, authReqPrivateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.decryptPubKeyEncryptedUserKey(authReqResponse.key, authReqPrivateKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setKeysAfterDecryptingSharedMasterKeyAndHash(authReqResponse, authReqPrivateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const { masterKey, masterKeyHash } = yield this.decryptPubKeyEncryptedMasterKeyAndHash(authReqResponse.key, authReqResponse.masterPasswordHash, authReqPrivateKey);
            // Decrypt and set user key in state
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
            // Set masterKey + masterKeyHash in state after decryption (in case decryption fails)
            const userId = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$)).id;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(masterKeyHash, userId);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    // Decryption helpers
    decryptPubKeyEncryptedUserKey(pubKeyEncryptedUserKey, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedUserKeyBytes = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedUserKey, privateKey);
            return new SymmetricCryptoKey(decryptedUserKeyBytes);
        });
    }
    decryptPubKeyEncryptedMasterKeyAndHash(pubKeyEncryptedMasterKey, pubKeyEncryptedMasterKeyHash, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedMasterKeyArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKey, privateKey);
            const decryptedMasterKeyHashArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKeyHash, privateKey);
            const masterKey = new SymmetricCryptoKey(decryptedMasterKeyArrayBuffer);
            const masterKeyHash = Utils.fromBufferToUtf8(decryptedMasterKeyHashArrayBuffer);
            return {
                masterKey,
                masterKeyHash,
            };
        });
    }
    sendAuthRequestPushNotification(notification) {
        if (notification.id != null) {
            this.authRequestPushNotificationSubject.next(notification.id);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/feature-flag.enum.ts
/**
 * Feature flags.
 *
 * Flags MUST be short lived and SHALL be removed once enabled.
 */
var feature_flag_enum_FeatureFlag;
(function (FeatureFlag) {
    FeatureFlag["BrowserFilelessImport"] = "browser-fileless-import";
    FeatureFlag["ItemShare"] = "item-share";
    FeatureFlag["FlexibleCollectionsV1"] = "flexible-collections-v-1";
    FeatureFlag["GeneratorToolsModernization"] = "generator-tools-modernization";
    FeatureFlag["ShowPaymentMethodWarningBanners"] = "show-payment-method-warning-banners";
    FeatureFlag["EnableConsolidatedBilling"] = "enable-consolidated-billing";
    FeatureFlag["AC1795_UpdatedSubscriptionStatusSection"] = "AC-1795_updated-subscription-status-section";
    FeatureFlag["EnableDeleteProvider"] = "AC-1218-delete-provider";
    FeatureFlag["ExtensionRefresh"] = "extension-refresh";
    FeatureFlag["RestrictProviderAccess"] = "restrict-provider-access";
    FeatureFlag["UseTreeWalkerApiForPageDetailsCollection"] = "use-tree-walker-api-for-page-details-collection";
    FeatureFlag["EmailVerification"] = "email-verification";
    FeatureFlag["InlineMenuFieldQualification"] = "inline-menu-field-qualification";
    FeatureFlag["MemberAccessReport"] = "ac-2059-member-access-report";
    FeatureFlag["TwoFactorComponentRefactor"] = "two-factor-component-refactor";
    FeatureFlag["EnableTimeThreshold"] = "PM-5864-dollar-threshold";
    FeatureFlag["InlineMenuPositioningImprovements"] = "inline-menu-positioning-improvements";
    FeatureFlag["GroupsComponentRefactor"] = "groups-component-refactor";
    FeatureFlag["ProviderClientVaultPrivacyBanner"] = "ac-2833-provider-client-vault-privacy-banner";
    FeatureFlag["VaultBulkManagementAction"] = "vault-bulk-management-action";
    FeatureFlag["AC2828_ProviderPortalMembersPage"] = "AC-2828_provider-portal-members-page";
})(feature_flag_enum_FeatureFlag || (feature_flag_enum_FeatureFlag = {}));
// Helper to ensure the value is treated as a boolean.
const FALSE = false;
/**
 * Default value for feature flags.
 *
 * DO NOT enable previously disabled flags, REMOVE them instead.
 * We support true as a value as we prefer flags to "enable" not "disable".
 */
const DefaultFeatureFlagValue = {
    [feature_flag_enum_FeatureFlag.BrowserFilelessImport]: FALSE,
    [feature_flag_enum_FeatureFlag.ItemShare]: FALSE,
    [feature_flag_enum_FeatureFlag.FlexibleCollectionsV1]: FALSE,
    [feature_flag_enum_FeatureFlag.GeneratorToolsModernization]: FALSE,
    [feature_flag_enum_FeatureFlag.ShowPaymentMethodWarningBanners]: FALSE,
    [feature_flag_enum_FeatureFlag.EnableConsolidatedBilling]: FALSE,
    [feature_flag_enum_FeatureFlag.AC1795_UpdatedSubscriptionStatusSection]: FALSE,
    [feature_flag_enum_FeatureFlag.EnableDeleteProvider]: FALSE,
    [feature_flag_enum_FeatureFlag.ExtensionRefresh]: FALSE,
    [feature_flag_enum_FeatureFlag.RestrictProviderAccess]: FALSE,
    [feature_flag_enum_FeatureFlag.UseTreeWalkerApiForPageDetailsCollection]: FALSE,
    [feature_flag_enum_FeatureFlag.EmailVerification]: FALSE,
    [feature_flag_enum_FeatureFlag.InlineMenuFieldQualification]: FALSE,
    [feature_flag_enum_FeatureFlag.MemberAccessReport]: FALSE,
    [feature_flag_enum_FeatureFlag.TwoFactorComponentRefactor]: FALSE,
    [feature_flag_enum_FeatureFlag.EnableTimeThreshold]: FALSE,
    [feature_flag_enum_FeatureFlag.InlineMenuPositioningImprovements]: FALSE,
    [feature_flag_enum_FeatureFlag.GroupsComponentRefactor]: FALSE,
    [feature_flag_enum_FeatureFlag.ProviderClientVaultPrivacyBanner]: FALSE,
    [feature_flag_enum_FeatureFlag.VaultBulkManagementAction]: FALSE,
    [feature_flag_enum_FeatureFlag.AC2828_ProviderPortalMembersPage]: FALSE,
};

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/register-route.service.ts


// This is a temporary service to determine the correct route to use for registration based on the email verification feature flag.
class RegisterRouteService {
    constructor(configService) {
        this.configService = configService;
    }
    registerRoute$() {
        return this.configService.getFeatureFlag$(FeatureFlag.EmailVerification).pipe(map((emailVerificationEnabled) => {
            if (emailVerificationEnabled) {
                return "/signup";
            }
            else {
                return "/register";
            }
        }));
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/index.ts







;// CONCATENATED MODULE: ../../libs/auth/src/common/utilities/decode-jwt-token-to-json.utility.ts

function decodeJwtTokenToJson(jwtToken) {
    if (jwtToken == null) {
        throw new Error("JWT token not found");
    }
    const parts = jwtToken.split(".");
    if (parts.length !== 3) {
        throw new Error("JWT must have 3 parts");
    }
    // JWT has 3 parts: header, payload, signature separated by '.'
    // So, grab the payload to decode
    const encodedPayload = parts[1];
    let decodedPayloadJSON;
    try {
        // Attempt to decode from URL-safe Base64 to UTF-8
        decodedPayloadJSON = Utils.fromUrlB64ToUtf8(encodedPayload);
    }
    catch (decodingError) {
        throw new Error("Cannot decode the token");
    }
    try {
        // Attempt to parse the JSON payload
        const decodedToken = JSON.parse(decodedPayloadJSON);
        return decodedToken;
    }
    catch (jsonError) {
        throw new Error("Cannot parse the token's payload into JSON");
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/utilities/index.ts


;// CONCATENATED MODULE: ../../libs/auth/src/common/index.ts
/**
 * This barrel file should only contain non-Angular exports
 */






;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/secret-verification.request.ts
class SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/password.request.ts

class PasswordRequest extends SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/two-factor-email.request.ts

class TwoFactorEmailRequest extends SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/requests/organization-user-reset-password.request.ts
class OrganizationUserResetPasswordRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/update-temp-password.request.ts

class UpdateTempPasswordRequest extends OrganizationUserResetPasswordRequest {
}

;// CONCATENATED MODULE: external "fs"
const external_fs_namespaceObject = require("fs");
;// CONCATENATED MODULE: external "readline"
const external_readline_namespaceObject = require("readline");
;// CONCATENATED MODULE: ../../libs/node/src/node-utils.ts



class NodeUtils {
    static mkdirpSync(targetDir, mode = "700", relative = false, relativeDir = null) {
        const initialDir = external_path_namespaceObject.isAbsolute(targetDir) ? external_path_namespaceObject.sep : "";
        const baseDir = relative ? (relativeDir != null ? relativeDir : __dirname) : ".";
        targetDir.split(external_path_namespaceObject.sep).reduce((parentDir, childDir) => {
            const dir = external_path_namespaceObject.resolve(baseDir, parentDir, childDir);
            if (!external_fs_namespaceObject.existsSync(dir)) {
                external_fs_namespaceObject.mkdirSync(dir, mode);
            }
            return dir;
        }, initialDir);
    }
    static readFirstLine(fileName) {
        return new Promise((resolve, reject) => {
            const readStream = external_fs_namespaceObject.createReadStream(fileName, { encoding: "utf8" });
            const readInterface = external_readline_namespaceObject.createInterface(readStream);
            readInterface
                .on("line", (line) => {
                readStream.close();
                resolve(line);
            })
                .on("error", (err) => reject(err));
        });
    }
    // https://stackoverflow.com/a/31394257
    static bufferToArrayBuffer(buf) {
        return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength);
    }
}

;// CONCATENATED MODULE: ./src/auth/commands/login.command.ts
var login_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class LoginCommand {
    constructor(loginStrategyService, authService, apiService, cryptoFunctionService, environmentService, passwordGenerationService, passwordStrengthService, platformUtilsService, accountService, cryptoService, policyService, twoFactorService, syncService, keyConnectorService, policyApiService, orgService, logoutCallback, kdfConfigService) {
        this.loginStrategyService = loginStrategyService;
        this.authService = authService;
        this.apiService = apiService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.environmentService = environmentService;
        this.passwordGenerationService = passwordGenerationService;
        this.passwordStrengthService = passwordStrengthService;
        this.platformUtilsService = platformUtilsService;
        this.accountService = accountService;
        this.cryptoService = cryptoService;
        this.policyService = policyService;
        this.twoFactorService = twoFactorService;
        this.syncService = syncService;
        this.keyConnectorService = keyConnectorService;
        this.policyApiService = policyApiService;
        this.orgService = orgService;
        this.logoutCallback = logoutCallback;
        this.kdfConfigService = kdfConfigService;
        this.ssoRedirectUri = null;
    }
    run(email, password, options) {
        var _a;
        return login_command_awaiter(this, void 0, void 0, function* () {
            this.options = options;
            this.email = email;
            this.canInteract = process.env.BW_NOINTERACTION !== "true";
            let ssoCodeVerifier = null;
            let ssoCode = null;
            let orgIdentifier = null;
            let clientId = null;
            let clientSecret = null;
            let selectedProvider = null;
            if (options.apikey != null) {
                const apiIdentifiers = yield this.apiIdentifiers();
                clientId = apiIdentifiers.clientId;
                clientSecret = apiIdentifiers.clientSecret;
                if (clientId == null || clientId.trim() === "") {
                    return Response.badRequest("client_id is required.");
                }
                if (clientSecret == null || clientSecret === "") {
                    return Response.badRequest("client_secret is required.");
                }
            }
            else if (options.sso != null && this.canInteract) {
                const passwordOptions = {
                    type: "password",
                    length: 64,
                    uppercase: true,
                    lowercase: true,
                    numbers: true,
                    special: false,
                };
                const state = yield this.passwordGenerationService.generatePassword(passwordOptions);
                ssoCodeVerifier = yield this.passwordGenerationService.generatePassword(passwordOptions);
                const codeVerifierHash = yield this.cryptoFunctionService.hash(ssoCodeVerifier, "sha256");
                const codeChallenge = Utils.fromBufferToUrlB64(codeVerifierHash);
                try {
                    const ssoParams = yield this.openSsoPrompt(codeChallenge, state);
                    ssoCode = ssoParams.ssoCode;
                    orgIdentifier = ssoParams.orgIdentifier;
                }
                catch (_b) {
                    return Response.badRequest("Something went wrong. Try again.");
                }
            }
            else {
                if ((email == null || email === "") && this.canInteract) {
                    const answer = yield external_inquirer_namespaceObject.createPromptModule({
                        output: process.stderr,
                    })({
                        type: "input",
                        name: "email",
                        message: "Email address:",
                    });
                    email = answer.email;
                }
                if (email == null || email.trim() === "") {
                    return Response.badRequest("Email address is required.");
                }
                if (email.indexOf("@") === -1) {
                    return Response.badRequest("Email address is invalid.");
                }
                this.email = email;
                if (password == null || password === "") {
                    if (options.passwordfile) {
                        password = yield NodeUtils.readFirstLine(options.passwordfile);
                    }
                    else if (options.passwordenv && process.env[options.passwordenv]) {
                        password = process.env[options.passwordenv];
                    }
                    else if (this.canInteract) {
                        const answer = yield external_inquirer_namespaceObject.createPromptModule({
                            output: process.stderr,
                        })({
                            type: "password",
                            name: "password",
                            message: "Master password:",
                        });
                        password = answer.password;
                    }
                }
                if (password == null || password === "") {
                    return Response.badRequest("Master password is required.");
                }
            }
            let twoFactorToken = options.code;
            let twoFactorMethod = null;
            try {
                if (options.method != null) {
                    twoFactorMethod = parseInt(options.method, null);
                }
            }
            catch (e) {
                return Response.error("Invalid two-step login method.");
            }
            const twoFactor = twoFactorToken == null
                ? null
                : new TokenTwoFactorRequest(twoFactorMethod, twoFactorToken, false);
            try {
                yield this.validatedParams();
                let response = null;
                if (clientId != null && clientSecret != null) {
                    if (!clientId.startsWith("user")) {
                        return Response.error("Invalid API Key; Organization API Key currently not supported");
                    }
                    try {
                        response = yield this.loginStrategyService.logIn(new UserApiLoginCredentials(clientId, clientSecret));
                    }
                    catch (e) {
                        // handle API key login failures
                        // Handle invalid client error as server doesn't return a useful message
                        if (((_a = e === null || e === void 0 ? void 0 : e.response) === null || _a === void 0 ? void 0 : _a.error) &&
                            typeof e.response.error === "string" &&
                            e.response.error === "invalid_client") {
                            return Response.badRequest("client_id or client_secret is incorrect. Try again.");
                        }
                        // Pass error up to be handled by the outer catch block below
                        throw e;
                    }
                }
                else if (ssoCode != null && ssoCodeVerifier != null) {
                    response = yield this.loginStrategyService.logIn(new SsoLoginCredentials(ssoCode, ssoCodeVerifier, this.ssoRedirectUri, orgIdentifier, undefined, // email to look up 2FA token not required as CLI can't remember 2FA token
                    twoFactor));
                }
                else {
                    response = yield this.loginStrategyService.logIn(new PasswordLoginCredentials(email, password, null, twoFactor));
                }
                if (response.requiresEncryptionKeyMigration) {
                    return Response.error("Encryption key migration required. Please login through the web vault to update your encryption key.");
                }
                if (response.captchaSiteKey) {
                    const credentials = new PasswordLoginCredentials(email, password);
                    const handledResponse = yield this.handleCaptchaRequired(twoFactor, credentials);
                    // Error Response
                    if (handledResponse instanceof Response) {
                        return handledResponse;
                    }
                    else {
                        response = handledResponse;
                    }
                }
                if (response.requiresTwoFactor) {
                    const twoFactorProviders = yield this.twoFactorService.getSupportedProviders(null);
                    if (twoFactorProviders.length === 0) {
                        return Response.badRequest("No providers available for this client.");
                    }
                    if (twoFactorMethod != null) {
                        try {
                            selectedProvider = twoFactorProviders.filter((p) => p.type === twoFactorMethod)[0];
                        }
                        catch (e) {
                            return Response.error("Invalid two-step login method.");
                        }
                    }
                    if (selectedProvider == null) {
                        if (twoFactorProviders.length === 1) {
                            selectedProvider = twoFactorProviders[0];
                        }
                        else if (this.canInteract) {
                            const twoFactorOptions = twoFactorProviders.map((p) => p.name);
                            twoFactorOptions.push(new external_inquirer_namespaceObject.Separator());
                            twoFactorOptions.push("Cancel");
                            const answer = yield external_inquirer_namespaceObject.createPromptModule({
                                output: process.stderr,
                            })({
                                type: "list",
                                name: "method",
                                message: "Two-step login method:",
                                choices: twoFactorOptions,
                            });
                            const i = twoFactorOptions.indexOf(answer.method);
                            if (i === twoFactorOptions.length - 1) {
                                return Response.error("Login failed.");
                            }
                            selectedProvider = twoFactorProviders[i];
                        }
                        if (selectedProvider == null) {
                            return Response.error("Login failed. No provider selected.");
                        }
                    }
                    if (twoFactorToken == null &&
                        Object.keys(response.twoFactorProviders).length > 1 &&
                        selectedProvider.type === TwoFactorProviderType.Email) {
                        const emailReq = new TwoFactorEmailRequest();
                        emailReq.email = yield this.loginStrategyService.getEmail();
                        emailReq.masterPasswordHash = yield this.loginStrategyService.getMasterPasswordHash();
                        yield this.apiService.postTwoFactorEmail(emailReq);
                    }
                    if (twoFactorToken == null) {
                        if (this.canInteract) {
                            const answer = yield external_inquirer_namespaceObject.createPromptModule({
                                output: process.stderr,
                            })({
                                type: "input",
                                name: "token",
                                message: "Two-step login code:",
                            });
                            twoFactorToken = answer.token;
                        }
                        if (twoFactorToken == null || twoFactorToken === "") {
                            return Response.badRequest("Code is required.");
                        }
                    }
                    response = yield this.loginStrategyService.logInTwoFactor(new TokenTwoFactorRequest(selectedProvider.type, twoFactorToken), null);
                }
                if (response.captchaSiteKey) {
                    const twoFactorRequest = new TokenTwoFactorRequest(selectedProvider.type, twoFactorToken);
                    const handledResponse = yield this.handleCaptchaRequired(twoFactorRequest);
                    // Error Response
                    if (handledResponse instanceof Response) {
                        return handledResponse;
                    }
                    else {
                        response = handledResponse;
                    }
                }
                if (response.requiresTwoFactor) {
                    return Response.error("Login failed.");
                }
                if (response.resetMasterPassword) {
                    return Response.error("In order to log in with SSO from the CLI, you must first log in" +
                        " through the web vault to set your master password.");
                }
                // Run full sync before handling success response or password reset flows (to get Master Password Policies)
                yield this.syncService.fullSync(true);
                // Handle updating passwords if NOT using an API Key for authentication
                if (response.forcePasswordReset != ForceSetPasswordReason.None &&
                    clientId == null &&
                    clientSecret == null) {
                    if (response.forcePasswordReset === ForceSetPasswordReason.AdminForcePasswordReset) {
                        return yield this.updateTempPassword();
                    }
                    else if (response.forcePasswordReset === ForceSetPasswordReason.WeakMasterPassword) {
                        return yield this.updateWeakPassword(password);
                    }
                }
                return yield this.handleSuccessResponse();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    validatedParams() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoFunctionService.randomBytes(64);
            process.env.BW_SESSION = Utils.fromBufferToB64(key);
        });
    }
    handleSuccessResponse() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            const usesKeyConnector = yield this.keyConnectorService.getUsesKeyConnector();
            if ((this.options.sso != null || this.options.apikey != null) &&
                this.canInteract &&
                !usesKeyConnector) {
                const res = new MessageResponse("You are logged in!", "\n" + "To unlock your vault, use the `unlock` command. ex:\n" + "$ bw unlock");
                return Response.success(res);
            }
            const res = new MessageResponse("You are logged in!", "\n" +
                "To unlock your vault, set your session key to the `BW_SESSION` environment variable. ex:\n" +
                '$ export BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n' +
                '> $env:BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n\n' +
                "You can also pass the session key to any command with the `--session` option. ex:\n" +
                "$ bw list items --session " +
                process.env.BW_SESSION);
            res.raw = process.env.BW_SESSION;
            return Response.success(res);
        });
    }
    handleUpdatePasswordSuccessResponse() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            yield this.logoutCallback();
            this.authService.logOut(() => {
                /* Do nothing */
            });
            const res = new MessageResponse("Your master password has been updated!", "\n" + "You have been logged out and must log in again to access the vault.");
            return Response.success(res);
        });
    }
    updateWeakPassword(currentPassword) {
        return login_command_awaiter(this, void 0, void 0, function* () {
            // If no interaction available, alert user to use web vault
            if (!this.canInteract) {
                yield this.logoutCallback();
                this.authService.logOut(() => {
                    /* Do nothing */
                });
                return Response.error(new MessageResponse("Your master password does not meet one or more of your organization policies. In order to access the vault, you must update your master password now via the web vault. You have been logged out.", null));
            }
            try {
                const { newPasswordHash, newUserKey, hint } = yield this.collectNewMasterPasswordDetails("Your master password does not meet one or more of your organization policies. In order to access the vault, you must update your master password now.");
                const request = new PasswordRequest();
                request.masterPasswordHash = yield this.cryptoService.hashMasterKey(currentPassword, null);
                request.masterPasswordHint = hint;
                request.newMasterPasswordHash = newPasswordHash;
                request.key = newUserKey[1].encryptedString;
                yield this.apiService.postPassword(request);
                return yield this.handleUpdatePasswordSuccessResponse();
            }
            catch (e) {
                yield this.logoutCallback();
                this.authService.logOut(() => {
                    /* Do nothing */
                });
                return Response.error(e);
            }
        });
    }
    updateTempPassword() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            // If no interaction available, alert user to use web vault
            if (!this.canInteract) {
                yield this.logoutCallback();
                this.authService.logOut(() => {
                    /* Do nothing */
                });
                return Response.error(new MessageResponse("An organization administrator recently changed your master password. In order to access the vault, you must update your master password now via the web vault. You have been logged out.", null));
            }
            try {
                const { newPasswordHash, newUserKey, hint } = yield this.collectNewMasterPasswordDetails("An organization administrator recently changed your master password. In order to access the vault, you must update your master password now.");
                const request = new UpdateTempPasswordRequest();
                request.key = newUserKey[1].encryptedString;
                request.newMasterPasswordHash = newPasswordHash;
                request.masterPasswordHint = hint;
                yield this.apiService.putUpdateTempPassword(request);
                return yield this.handleUpdatePasswordSuccessResponse();
            }
            catch (e) {
                yield this.logoutCallback();
                this.authService.logOut(() => {
                    /* Do nothing */
                });
                return Response.error(e);
            }
        });
    }
    /**
     * Collect new master password and hint from the CLI. The collected password
     * is validated against any applicable master password policies, a new master
     * key is generated, and we use it to re-encrypt the user key
     * @param prompt - Message that is displayed during the initial prompt
     * @param error
     */
    collectNewMasterPasswordDetails(prompt, error) {
        return login_command_awaiter(this, void 0, void 0, function* () {
            if (this.email == null || this.email === "undefined") {
                this.email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.email)));
            }
            // Get New Master Password
            const baseMessage = `${prompt}\n` + "Master password: ";
            const firstMessage = error != null ? error + baseMessage : baseMessage;
            const mp = yield external_inquirer_namespaceObject.createPromptModule({ output: process.stderr })({
                type: "password",
                name: "password",
                message: firstMessage,
            });
            const masterPassword = mp.password;
            // Master Password Validation
            if (masterPassword == null || masterPassword === "") {
                return this.collectNewMasterPasswordDetails(prompt, "Master password is required.\n");
            }
            if (masterPassword.length < Utils.minimumPasswordLength) {
                return this.collectNewMasterPasswordDetails(prompt, `Master password must be at least ${Utils.minimumPasswordLength} characters long.\n`);
            }
            // Strength & Policy Validation
            const strengthResult = this.passwordStrengthService.getPasswordStrength(masterPassword, this.email);
            const enforcedPolicyOptions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policyService.masterPasswordPolicyOptions$());
            // Verify master password meets policy requirements
            if (enforcedPolicyOptions != null &&
                !this.policyService.evaluateMasterPassword(strengthResult.score, masterPassword, enforcedPolicyOptions)) {
                return this.collectNewMasterPasswordDetails(prompt, "Your new master password does not meet the policy requirements.\n");
            }
            // Get New Master Password Re-type
            const reTypeMessage = "Re-type New Master password (Strength: " + strengthResult.score + ")";
            const retype = yield external_inquirer_namespaceObject.createPromptModule({ output: process.stderr })({
                type: "password",
                name: "password",
                message: reTypeMessage,
            });
            const masterPasswordRetype = retype.password;
            // Re-type Validation
            if (masterPassword !== masterPasswordRetype) {
                return this.collectNewMasterPasswordDetails(prompt, "Master password confirmation does not match.\n");
            }
            // Get Hint (optional)
            const hint = yield external_inquirer_namespaceObject.createPromptModule({ output: process.stderr })({
                type: "input",
                name: "input",
                message: "Master Password Hint (optional):",
            });
            const masterPasswordHint = hint.input;
            const kdfConfig = yield this.kdfConfigService.getKdfConfig();
            // Create new key and hash new password
            const newMasterKey = yield this.cryptoService.makeMasterKey(masterPassword, this.email.trim().toLowerCase(), kdfConfig);
            const newPasswordHash = yield this.cryptoService.hashMasterKey(masterPassword, newMasterKey);
            // Grab user key
            const userKey = yield this.cryptoService.getUserKey();
            if (!userKey) {
                throw new Error("User key not found.");
            }
            // Re-encrypt user key with new master key
            const newUserKey = yield this.cryptoService.encryptUserKeyWithMasterKey(newMasterKey, userKey);
            return { newPasswordHash, newUserKey: newUserKey, hint: masterPasswordHint };
        });
    }
    handleCaptchaRequired(twoFactorRequest, credentials = null) {
        return login_command_awaiter(this, void 0, void 0, function* () {
            const badCaptcha = Response.badRequest("Your authentication request has been flagged and will require user interaction to proceed.\n" +
                "Please use your API key to validate this request and ensure BW_CLIENTSECRET is correct, if set.\n" +
                "(https://bitwarden.com/help/cli-auth-challenges)");
            try {
                const captchaClientSecret = yield this.apiClientSecret(true);
                if (Utils.isNullOrWhitespace(captchaClientSecret)) {
                    return badCaptcha;
                }
                let authResultResponse = null;
                if (credentials != null) {
                    credentials.captchaToken = captchaClientSecret;
                    credentials.twoFactor = twoFactorRequest;
                    authResultResponse = yield this.loginStrategyService.logIn(credentials);
                }
                else {
                    authResultResponse = yield this.loginStrategyService.logInTwoFactor(twoFactorRequest, captchaClientSecret);
                }
                return authResultResponse;
            }
            catch (e) {
                if (e instanceof ErrorResponse ||
                    (e.constructor.name === ErrorResponse.name &&
                        e.message.includes("Captcha is invalid"))) {
                    return badCaptcha;
                }
                else {
                    return Response.error(e);
                }
            }
        });
    }
    apiClientId() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            let clientId = null;
            const storedClientId = process.env.BW_CLIENTID;
            if (storedClientId == null) {
                if (this.canInteract) {
                    const answer = yield external_inquirer_namespaceObject.createPromptModule({
                        output: process.stderr,
                    })({
                        type: "input",
                        name: "clientId",
                        message: "client_id:",
                    });
                    clientId = answer.clientId;
                }
                else {
                    clientId = null;
                }
            }
            else {
                clientId = storedClientId;
            }
            return clientId;
        });
    }
    apiClientSecret(isAdditionalAuthentication = false) {
        return login_command_awaiter(this, void 0, void 0, function* () {
            const additionalAuthenticationMessage = "Additional authentication required.\nAPI key ";
            let clientSecret = null;
            const storedClientSecret = this.clientSecret || process.env.BW_CLIENTSECRET;
            if (storedClientSecret == null) {
                if (this.canInteract) {
                    const answer = yield external_inquirer_namespaceObject.createPromptModule({
                        output: process.stderr,
                    })({
                        type: "input",
                        name: "clientSecret",
                        message: (isAdditionalAuthentication ? additionalAuthenticationMessage : "") + "client_secret:",
                    });
                    clientSecret = answer.clientSecret;
                }
                else {
                    clientSecret = null;
                }
            }
            else {
                clientSecret = storedClientSecret;
            }
            return clientSecret;
        });
    }
    apiIdentifiers() {
        return login_command_awaiter(this, void 0, void 0, function* () {
            return {
                clientId: yield this.apiClientId(),
                clientSecret: yield this.apiClientSecret(),
            };
        });
    }
    openSsoPrompt(codeChallenge, state) {
        return login_command_awaiter(this, void 0, void 0, function* () {
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            return new Promise((resolve, reject) => {
                const callbackServer = external_http_namespaceObject.createServer((req, res) => {
                    const urlString = "http://localhost" + req.url;
                    const url = new URL(urlString);
                    const code = url.searchParams.get("code");
                    const receivedState = url.searchParams.get("state");
                    const orgIdentifier = this.getOrgIdentifierFromState(receivedState);
                    res.setHeader("Content-Type", "text/html");
                    if (code != null && receivedState != null && this.checkState(receivedState, state)) {
                        res.writeHead(200);
                        res.end("<html><head><title>Success | Bitwarden CLI</title></head><body>" +
                            "<h1>Successfully authenticated with the Bitwarden CLI</h1>" +
                            "<p>You may now close this tab and return to the terminal.</p>" +
                            "</body></html>");
                        callbackServer.close(() => resolve({
                            ssoCode: code,
                            orgIdentifier: orgIdentifier,
                        }));
                    }
                    else {
                        res.writeHead(400);
                        res.end("<html><head><title>Failed | Bitwarden CLI</title></head><body>" +
                            "<h1>Something went wrong logging into the Bitwarden CLI</h1>" +
                            "<p>You may now close this tab and return to the terminal.</p>" +
                            "</body></html>");
                        callbackServer.close(() => reject());
                    }
                });
                let foundPort = false;
                const webUrl = env.getWebVaultUrl();
                for (let port = 8065; port <= 8070; port++) {
                    try {
                        this.ssoRedirectUri = "http://localhost:" + port;
                        callbackServer.listen(port, () => {
                            this.platformUtilsService.launchUri(webUrl +
                                "/#/sso?clientId=" +
                                "cli" +
                                "&redirectUri=" +
                                encodeURIComponent(this.ssoRedirectUri) +
                                "&state=" +
                                state +
                                "&codeChallenge=" +
                                codeChallenge);
                        });
                        foundPort = true;
                        break;
                    }
                    catch (_a) {
                        // Ignore error since we run the same command up to 5 times.
                    }
                }
                if (!foundPort) {
                    reject();
                }
            });
        });
    }
    getOrgIdentifierFromState(state) {
        if (state === null || state === undefined) {
            return null;
        }
        const stateSplit = state.split("_identifier=");
        return stateSplit.length > 1 ? stateSplit[1] : null;
    }
    checkState(state, checkState) {
        if (state === null || state === undefined) {
            return false;
        }
        if (checkState === null || checkState === undefined) {
            return false;
        }
        const stateSplit = state.split("_identifier=");
        const checkStateSplit = checkState.split("_identifier=");
        return stateSplit[0] === checkStateSplit[0];
    }
}

;// CONCATENATED MODULE: ./src/auth/commands/logout.command.ts
var logout_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class LogoutCommand {
    constructor(authService, i18nService, logoutCallback) {
        this.authService = authService;
        this.i18nService = i18nService;
        this.logoutCallback = logoutCallback;
    }
    run() {
        return logout_command_awaiter(this, void 0, void 0, function* () {
            yield this.logoutCallback();
            this.authService.logOut(() => {
                /* Do nothing */
            });
            const res = new MessageResponse("You have logged out.", null);
            return Response.success(res);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/verification-type.ts
var VerificationType;
(function (VerificationType) {
    VerificationType[VerificationType["MasterPassword"] = 0] = "MasterPassword";
    VerificationType[VerificationType["OTP"] = 1] = "OTP";
    VerificationType[VerificationType["PIN"] = 2] = "PIN";
    VerificationType[VerificationType["Biometrics"] = 3] = "Biometrics";
})(VerificationType || (VerificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/environment.service.ts
/**
 * A subset of available regions, additional regions can be loaded through configuration.
 */
var Region;
(function (Region) {
    Region["US"] = "US";
    Region["EU"] = "EU";
    Region["SelfHosted"] = "Self-hosted";
})(Region || (Region = {}));
/**
 * The environment service. Provides access to set the current environment urls and region.
 */
class EnvironmentService {
}

;// CONCATENATED MODULE: ./src/commands/convert-to-key-connector.command.ts
var convert_to_key_connector_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class ConvertToKeyConnectorCommand {
    constructor(keyConnectorService, environmentService, syncService, organizationApiService, logout) {
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.syncService = syncService;
        this.organizationApiService = organizationApiService;
        this.logout = logout;
    }
    run() {
        return convert_to_key_connector_command_awaiter(this, void 0, void 0, function* () {
            // If no interaction available, alert user to use web vault
            const canInteract = process.env.BW_NOINTERACTION !== "true";
            if (!canInteract) {
                yield this.logout();
                return Response.error(new MessageResponse("An organization you are a member of is using Key Connector. " +
                    "In order to access the vault, you must opt-in to Key Connector now via the web vault. You have been logged out.", null));
            }
            const organization = yield this.keyConnectorService.getManagingOrganization();
            const answer = yield external_inquirer_namespaceObject.createPromptModule({ output: process.stderr })({
                type: "list",
                name: "convert",
                message: organization.name +
                    " is using a self-hosted key server. A master password is no longer required to log in for members of this organization. ",
                choices: [
                    {
                        name: "Remove master password and unlock",
                        value: "remove",
                    },
                    {
                        name: "Leave organization and unlock",
                        value: "leave",
                    },
                    {
                        name: "Log out",
                        value: "exit",
                    },
                ],
            });
            if (answer.convert === "remove") {
                try {
                    yield this.keyConnectorService.migrateUser();
                }
                catch (e) {
                    yield this.logout();
                    throw e;
                }
                yield this.keyConnectorService.removeConvertAccountRequired();
                yield this.keyConnectorService.setUsesKeyConnector(true);
                // Update environment URL - required for api key login
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const urls = env.getUrls();
                urls.keyConnector = organization.keyConnectorUrl;
                yield this.environmentService.setEnvironment(Region.SelfHosted, urls);
                return Response.success();
            }
            else if (answer.convert === "leave") {
                yield this.organizationApiService.leave(organization.id);
                yield this.keyConnectorService.removeConvertAccountRequired();
                return Response.success();
            }
            else {
                yield this.logout();
                return Response.error("You have been logged out.");
            }
        });
    }
}

;// CONCATENATED MODULE: external "jszip"
const external_jszip_namespaceObject = require("jszip");
;// CONCATENATED MODULE: ./src/utils.ts
var utils_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class CliUtils {
    static writeLn(s, finalLine = false, error = false) {
        const stream = error ? process.stderr : process.stdout;
        if (finalLine && (process.platform === "win32" || !stream.isTTY)) {
            stream.write(s);
        }
        else {
            stream.write(s + "\n");
        }
    }
    static readFile(input) {
        return new Promise((resolve, reject) => {
            let p = null;
            if (input != null && input !== "") {
                const osInput = external_path_namespaceObject.join(input);
                if (osInput.indexOf(external_path_namespaceObject.sep) === -1) {
                    p = external_path_namespaceObject.join(process.cwd(), osInput);
                }
                else {
                    p = osInput;
                }
            }
            else {
                reject("You must specify a file path.");
            }
            external_fs_namespaceObject.readFile(p, "utf8", (err, data) => {
                if (err != null) {
                    reject(err.message);
                }
                resolve(data);
            });
        });
    }
    static extractZipContent(input, filepath) {
        return new Promise((resolve, reject) => {
            let p = null;
            if (input != null && input !== "") {
                const osInput = external_path_namespaceObject.join(input);
                if (osInput.indexOf(external_path_namespaceObject.sep) === -1) {
                    p = external_path_namespaceObject.join(process.cwd(), osInput);
                }
                else {
                    p = osInput;
                }
            }
            else {
                reject("You must specify a file path.");
            }
            external_fs_namespaceObject.readFile(p, function (err, data) {
                if (err) {
                    reject(err);
                }
                external_jszip_namespaceObject.loadAsync(data).then((zip) => {
                    resolve(zip.file(filepath).async("string"));
                }, (reason) => {
                    reject(reason);
                });
            });
        });
    }
    /**
     * Save the given data to a file and determine the target file if necessary.
     * If output is non-empty, it is used as target filename. Otherwise the target filename is
     * built from the current working directory and the given defaultFileName.
     *
     * @param data to be written to the file.
     * @param output file to write to or empty to choose automatically.
     * @param defaultFileName to use when no explicit output filename is given.
     * @return the chosen output file.
     */
    static saveFile(data, output, defaultFileName) {
        let p = null;
        let mkdir = false;
        if (output != null && output !== "") {
            const osOutput = external_path_namespaceObject.join(output);
            if (osOutput.indexOf(external_path_namespaceObject.sep) === -1) {
                p = external_path_namespaceObject.join(process.cwd(), osOutput);
            }
            else {
                mkdir = true;
                if (osOutput.endsWith(external_path_namespaceObject.sep)) {
                    p = external_path_namespaceObject.join(osOutput, defaultFileName);
                }
                else {
                    p = osOutput;
                }
            }
        }
        else {
            p = external_path_namespaceObject.join(process.cwd(), defaultFileName);
        }
        p = external_path_namespaceObject.resolve(p);
        if (mkdir) {
            const dir = p.substring(0, p.lastIndexOf(external_path_namespaceObject.sep));
            if (!external_fs_namespaceObject.existsSync(dir)) {
                NodeUtils.mkdirpSync(dir, "700");
            }
        }
        return new Promise((resolve, reject) => {
            external_fs_namespaceObject.writeFile(p, data, { encoding: "utf8", mode: 0o600 }, (err) => {
                if (err != null) {
                    reject("Cannot save file to " + p);
                }
                resolve(p);
            });
        });
    }
    /**
     * Process the given data and write it to a file if possible. If the user requested RAW output and
     * no output name is given, the file is directly written to stdout. The resulting Response contains
     * an otherwise empty message then to prevent writing other information to stdout.
     *
     * If an output is given or no RAW output is requested, the rules from [saveFile] apply.
     *
     * @param data to be written to the file or stdout.
     * @param output file to write to or empty to choose automatically.
     * @param defaultFileName to use when no explicit output filename is given.
     * @return an empty [Response] if written to stdout or a [Response] with the chosen output file otherwise.
     */
    static saveResultToFile(data, output, defaultFileName) {
        return utils_awaiter(this, void 0, void 0, function* () {
            if ((output == null || output === "") && process.env.BW_RAW === "true") {
                // No output is given and the user expects raw output. Since the command result is about content,
                // we directly return the command result to stdout (and suppress further messages).
                process.stdout.write(data);
                return Response.success();
            }
            const filePath = yield this.saveFile(data, output, defaultFileName);
            const res = new MessageResponse("Saved " + filePath, null);
            res.raw = filePath;
            return Response.success(res);
        });
    }
    static readStdin() {
        return new Promise((resolve, reject) => {
            let input = "";
            if (process.stdin.isTTY) {
                resolve(input);
                return;
            }
            process.stdin.setEncoding("utf8");
            process.stdin.on("readable", () => {
                // eslint-disable-next-line
                while (true) {
                    const chunk = process.stdin.read();
                    if (chunk == null) {
                        break;
                    }
                    input += chunk;
                }
            });
            process.stdin.on("end", () => {
                resolve(input);
            });
        });
    }
    static searchFolders(folders, search) {
        search = search.toLowerCase();
        return folders.filter((f) => {
            if (f.name != null && f.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    static searchCollections(collections, search) {
        search = search.toLowerCase();
        return collections.filter((c) => {
            if (c.name != null && c.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    static searchOrganizations(organizations, search) {
        search = search.toLowerCase();
        return organizations.filter((o) => {
            if (o.name != null && o.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    /**
     * Gets a password from all available sources. In order of priority these are:
     *   * passwordfile
     *   * passwordenv
     *   * user interaction
     *
     * Returns password string if successful, Response if not.
     */
    static getPassword(password, options, logService) {
        return utils_awaiter(this, void 0, void 0, function* () {
            if (Utils.isNullOrEmpty(password)) {
                if (options === null || options === void 0 ? void 0 : options.passwordFile) {
                    password = yield NodeUtils.readFirstLine(options.passwordFile);
                }
                else if (options === null || options === void 0 ? void 0 : options.passwordEnv) {
                    if (process.env[options.passwordEnv]) {
                        password = process.env[options.passwordEnv];
                    }
                    else if (logService) {
                        logService.warning(`Warning: Provided passwordenv ${options.passwordEnv} is not set`);
                    }
                }
            }
            if (Utils.isNullOrEmpty(password)) {
                if (process.env.BW_NOINTERACTION !== "true") {
                    const answer = yield external_inquirer_namespaceObject.createPromptModule({
                        output: process.stderr,
                    })({
                        type: "password",
                        name: "password",
                        message: "Master password:",
                    });
                    password = answer.password;
                }
                else {
                    return Response.badRequest("Master password is required. Try again in interactive mode or provide a password file or environment variable.");
                }
            }
            return password;
        });
    }
    static convertBooleanOption(optionValue) {
        return optionValue || optionValue === "" ? true : false;
    }
    static convertNumberOption(optionValue, defaultValue) {
        try {
            if (optionValue != null) {
                const numVal = parseInt(optionValue);
                return !Number.isNaN(numVal) ? numVal : defaultValue;
            }
            return defaultValue;
        }
        catch (_a) {
            return defaultValue;
        }
    }
    static convertStringOption(optionValue, defaultValue) {
        return optionValue != null ? String(optionValue) : defaultValue;
    }
}

;// CONCATENATED MODULE: ./src/auth/commands/unlock.command.ts
var unlock_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class UnlockCommand {
    constructor(accountService, masterPasswordService, cryptoService, userVerificationService, cryptoFunctionService, logService, keyConnectorService, environmentService, syncService, organizationApiService, logout) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.userVerificationService = userVerificationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.syncService = syncService;
        this.organizationApiService = organizationApiService;
        this.logout = logout;
    }
    run(password, cmdOptions) {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new Options(cmdOptions);
            const passwordResult = yield CliUtils.getPassword(password, normalizedOptions, this.logService);
            if (passwordResult instanceof Response) {
                return passwordResult;
            }
            else {
                password = passwordResult;
            }
            yield this.setNewSessionKey();
            const [userId, email] = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));
            const verification = {
                type: VerificationType.MasterPassword,
                secret: password,
            };
            let masterKey;
            try {
                const response = yield this.userVerificationService.verifyUserByMasterPassword(verification, userId, email);
                masterKey = response.masterKey;
            }
            catch (e) {
                // verification failure throws
                return Response.error(e.message);
            }
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);
            yield this.cryptoService.setUserKey(userKey);
            if (yield this.keyConnectorService.getConvertAccountRequired()) {
                const convertToKeyConnectorCommand = new ConvertToKeyConnectorCommand(this.keyConnectorService, this.environmentService, this.syncService, this.organizationApiService, this.logout);
                const convertResponse = yield convertToKeyConnectorCommand.run();
                if (!convertResponse.success) {
                    return convertResponse;
                }
            }
            return this.successResponse();
        });
    }
    setNewSessionKey() {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoFunctionService.randomBytes(64);
            process.env.BW_SESSION = Utils.fromBufferToB64(key);
        });
    }
    successResponse() {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const res = new MessageResponse("Your vault is now unlocked!", "\n" +
                "To unlock your vault, set your session key to the `BW_SESSION` environment variable. ex:\n" +
                '$ export BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n' +
                '> $env:BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n\n' +
                "You can also pass the session key to any command with the `--session` option. ex:\n" +
                "$ bw list items --session " +
                process.env.BW_SESSION);
            res.raw = process.env.BW_SESSION;
            return Response.success(res);
        });
    }
}
class Options {
    constructor(passedOptions) {
        this.passwordEnv = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordenv) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordEnv);
        this.passwordFile = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordfile) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordFile);
    }
}

;// CONCATENATED MODULE: ./src/base-program.ts
var base_program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






const writeLn = CliUtils.writeLn;
class BaseProgram {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
    }
    processResponse(response, exitImmediately = false) {
        if (!response.success) {
            if (process.env.BW_QUIET !== "true") {
                if (process.env.BW_RESPONSE === "true") {
                    writeLn(this.getJson(response), true, false);
                }
                else {
                    writeLn(external_chalk_namespaceObject.redBright(response.message), true, true);
                }
            }
            const exitCode = process.env.BW_CLEANEXIT ? 0 : 1;
            if (exitImmediately) {
                process.exit(exitCode);
            }
            else {
                process.exitCode = exitCode;
            }
            return;
        }
        if (process.env.BW_RESPONSE === "true") {
            writeLn(this.getJson(response), true, false);
        }
        else if (response.data != null) {
            let out = null;
            if (response.data.object === "template") {
                out = this.getJson(response.data.template);
            }
            if (out == null) {
                if (response.data.object === "string") {
                    const data = response.data.data;
                    if (data != null) {
                        out = data;
                    }
                }
                else if (response.data.object === "list") {
                    out = this.getJson(response.data.data);
                }
                else if (response.data.object === "message") {
                    out = this.getMessage(response);
                }
                else {
                    out = this.getJson(response.data);
                }
            }
            if (out != null && process.env.BW_QUIET !== "true") {
                writeLn(out, true, false);
            }
        }
        if (exitImmediately) {
            process.exit(0);
        }
        else {
            process.exitCode = 0;
        }
    }
    getJson(obj) {
        if (process.env.BW_PRETTY === "true") {
            return JSON.stringify(obj, null, "  ");
        }
        else {
            return JSON.stringify(obj);
        }
    }
    getMessage(response) {
        const message = response.data;
        if (process.env.BW_RAW === "true") {
            return message.raw;
        }
        let out = "";
        if (message.title != null) {
            if (message.noColor) {
                out = message.title;
            }
            else {
                out = external_chalk_namespaceObject.greenBright(message.title);
            }
        }
        if (message.message != null) {
            if (message.title != null) {
                out += "\n";
            }
            out += message.message;
        }
        return out.trim() === "" ? null : out;
    }
    exitIfAuthed() {
        return base_program_awaiter(this, void 0, void 0, function* () {
            const authed = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.serviceContainer.authService.activeAccountStatus$.pipe((0,external_rxjs_namespaceObject.map)((status) => status > authentication_status_AuthenticationStatus.LoggedOut)));
            if (authed) {
                const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.serviceContainer.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.email)));
                this.processResponse(Response.error("You are already logged in as " + email + "."), true);
            }
        });
    }
    exitIfNotAuthed() {
        return base_program_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.serviceContainer.stateService.getIsAuthenticated();
            if (!authed) {
                this.processResponse(Response.error("You are not logged in."), true);
            }
        });
    }
    exitIfLocked() {
        return base_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfNotAuthed();
            if (yield this.serviceContainer.cryptoService.hasUserKey()) {
                return;
            }
            else if (process.env.BW_NOINTERACTION !== "true") {
                // must unlock
                if (yield this.serviceContainer.keyConnectorService.getUsesKeyConnector()) {
                    const response = Response.error("Your vault is locked. You must unlock your vault using your session key.\n" +
                        "If you do not have your session key, you can get a new one by logging out and logging in again.");
                    this.processResponse(response, true);
                }
                else {
                    const command = new UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.userVerificationService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, this.serviceContainer.logout);
                    const response = yield command.run(null, null);
                    if (!response.success) {
                        this.processResponse(response, true);
                    }
                }
            }
            else {
                this.processResponse(Response.error("Vault is locked."), true);
            }
        });
    }
    exitIfFeatureFlagDisabled(featureFlag) {
        return base_program_awaiter(this, void 0, void 0, function* () {
            const enabled = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.serviceContainer.configService.getFeatureFlag$(featureFlag));
            if (!enabled) {
                this.processResponse(Response.error("This command is temporarily unavailable."), true);
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/commands/completion.command.ts
var completion_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const validShells = ["zsh"];
class CompletionCommand {
    run(options) {
        return completion_command_awaiter(this, void 0, void 0, function* () {
            const shell = options.shell;
            if (!shell) {
                return Response.badRequest("`shell` option was not provided.");
            }
            if (!validShells.includes(shell)) {
                return Response.badRequest("Unsupported shell.");
            }
            let content = "";
            if (shell === "zsh") {
                content = this.zshCompletion("bw", external_commander_namespaceObject.program).render();
            }
            const res = new MessageResponse(content, null);
            return Response.success(res);
        });
    }
    zshCompletion(rootName, rootCommand) {
        return {
            render: () => {
                return [
                    `#compdef _${rootName} ${rootName}`,
                    "",
                    this.renderCommandBlock(rootName, rootCommand),
                ].join("\n");
            },
        };
    }
    renderCommandBlock(name, command) {
        const { commands = [], options = [] } = command;
        const hasOptions = options.length > 0;
        const hasCommands = commands.length > 0;
        const args = options
            .map(({ long, short, description }) => {
            const aliases = [short, long].filter(Boolean);
            const opts = aliases.join(",");
            const desc = `[${description.replace(`'`, `'"'"'`)}]`;
            return aliases.length > 1
                ? `'(${aliases.join(" ")})'{${opts}}'${desc}'`
                : `'${opts}${desc}'`;
        })
            .concat(`'(-h --help)'{-h,--help}'[output usage information]'`, hasCommands ? '"1: :->cmnds"' : null, '"*::arg:->args"')
            .filter(Boolean);
        const commandBlockFunctionParts = [];
        if (hasCommands) {
            commandBlockFunctionParts.push("local -a commands");
        }
        if (hasOptions) {
            commandBlockFunctionParts.push(`_arguments -C \\\n    ${args.join(` \\\n    `)}`);
        }
        if (hasCommands) {
            commandBlockFunctionParts.push(`case $state in
    cmnds)
      commands=(
        ${commands
                .map((command) => `"${command.name().split(" ")[0]}:${command.description()}"`)
                .join("\n        ")}
      )
      _describe "command" commands
      ;;\n  esac

  case "$words[1]" in
    ${commands
                .map((command) => {
                const commandName = command.name().split(" ")[0];
                return [`${commandName})`, `_${name}_${commandName}`, ";;"].join("\n      ");
            })
                .join("\n    ")}\n  esac`);
        }
        const commandBlocParts = [
            `function _${name} {\n  ${commandBlockFunctionParts.join("\n\n  ")}\n}`,
        ];
        if (hasCommands) {
            commandBlocParts.push(commands.map((c) => this.renderCommandBlock(`${name}_${c.name()}`, c)).join("\n\n"));
        }
        return commandBlocParts.join("\n\n");
    }
}

;// CONCATENATED MODULE: ./src/models/response/string.response.ts
class StringResponse {
    constructor(data) {
        this.object = "string";
        this.data = data;
    }
}

;// CONCATENATED MODULE: ./src/commands/encode.command.ts
var encode_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class EncodeCommand {
    run() {
        return encode_command_awaiter(this, void 0, void 0, function* () {
            if (process.stdin.isTTY) {
                return Response.badRequest("No stdin was piped in.");
            }
            const input = yield CliUtils.readStdin();
            const b64 = Buffer.from(input, "utf8").toString("base64");
            const res = new StringResponse(b64);
            return Response.success(res);
        });
    }
}

;// CONCATENATED MODULE: ./src/models/response/template.response.ts
class TemplateResponse {
    constructor(template) {
        this.object = "template";
        this.template = template;
    }
}

;// CONCATENATED MODULE: ./src/commands/status.command.ts
var status_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class StatusCommand {
    constructor(envService, syncService, accountService, authService) {
        this.envService = envService;
        this.syncService = syncService;
        this.accountService = accountService;
        this.authService = authService;
    }
    run() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            try {
                const baseUrl = yield this.baseUrl();
                const status = yield this.status();
                const lastSync = yield this.syncService.getLastSync();
                const [userId, email] = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));
                return Response.success(new TemplateResponse({
                    serverUrl: baseUrl,
                    lastSync: lastSync,
                    userEmail: email,
                    userId: userId,
                    status: status,
                }));
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    baseUrl() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.envService.environment$);
            return env.getUrls().base;
        });
    }
    status() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            const authStatus = yield this.authService.getAuthStatus();
            if (authStatus === authentication_status_AuthenticationStatus.Unlocked) {
                return "unlocked";
            }
            else if (authStatus === authentication_status_AuthenticationStatus.Locked) {
                return "locked";
            }
            else {
                return "unauthenticated";
            }
        });
    }
}

;// CONCATENATED MODULE: external "node-fetch"
const external_node_fetch_namespaceObject = require("node-fetch");
var external_node_fetch_default = /*#__PURE__*/__webpack_require__.n(external_node_fetch_namespaceObject);
;// CONCATENATED MODULE: ./src/commands/update.command.ts
var update_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const CLIENTS_RELEASE_LIST_ENDPOINT = "https://api.github.com/repos/bitwarden/clients/releases";
const DEFAULT_DOWNLOAD_URL = "https://github.com/bitwarden/clients/releases";
const UPDATE_COMMAND = "npm install -g @bitwarden/cli";
class UpdateCommand {
    constructor(platformUtilsService) {
        this.platformUtilsService = platformUtilsService;
        this.inPkg = false;
        this.inPkg = !!process.pkg;
    }
    run() {
        return update_command_awaiter(this, void 0, void 0, function* () {
            const response = yield external_node_fetch_default()(CLIENTS_RELEASE_LIST_ENDPOINT);
            if (response.status !== 200) {
                return Response.error("Error contacting update API: " + response.status);
            }
            const responseJson = yield response.json();
            const cliRelease = responseJson.find((r) => r.tag_name.includes("cli"));
            if (cliRelease === undefined || cliRelease === null) {
                return Response.error("Could not find latest CLI version.");
            }
            const currentVersion = yield this.platformUtilsService.getApplicationVersion();
            if (cliRelease.tag_name === "cli-v" + currentVersion) {
                const response = new MessageResponse(null, null);
                response.title = "No update available.";
                response.noColor = true;
                return Response.success(response);
            }
            const res = this.getFoundUpdateResponse(cliRelease);
            return Response.success(res);
        });
    }
    getFoundUpdateResponse(release) {
        const downloadUrl = this.getDownloadUrl(release.assets);
        const response = new MessageResponse(null, null);
        response.title = "A new version is available: " + release.tag_name;
        response.raw = downloadUrl;
        response.message = this.getMessage(release, downloadUrl);
        return response;
    }
    getMessage(release, downloadUrl) {
        let message = "";
        if (release.body != null && release.body !== "") {
            message = release.body + "\n\n";
        }
        message += "You can download this update at " + downloadUrl;
        if (this.inPkg) {
            message +=
                "\n\nIf you installed this CLI through a package manager " +
                    "you should probably update using its update command instead.";
        }
        else {
            message +=
                "\n\nIf you installed this CLI through NPM " +
                    "you should update using `" +
                    UPDATE_COMMAND +
                    "`";
        }
        return message;
    }
    getDownloadUrl(assets) {
        if (assets == null) {
            return DEFAULT_DOWNLOAD_URL;
        }
        let downloadUrl = DEFAULT_DOWNLOAD_URL;
        for (const a of assets) {
            const download = a.browser_download_url;
            if (download == null) {
                continue;
            }
            if (download.indexOf(".zip") === -1) {
                continue;
            }
            if (process.platform === "win32" && download.indexOf("bw-windows") > -1) {
                downloadUrl = download;
                break;
            }
            else if (process.platform === "darwin" && download.indexOf("bw-macos") > -1) {
                downloadUrl = download;
                break;
            }
            else if (process.platform === "linux" && download.indexOf("bw-linux") > -1) {
                downloadUrl = download;
                break;
            }
        }
        return downloadUrl;
    }
}

;// CONCATENATED MODULE: ./src/platform/commands/config.command.ts
var config_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class ConfigCommand {
    constructor(environmentService, accountService) {
        this.environmentService = environmentService;
        this.accountService = accountService;
    }
    run(setting, value, options) {
        return config_command_awaiter(this, void 0, void 0, function* () {
            setting = setting.toLowerCase();
            switch (setting) {
                case "server":
                    return yield this.getOrSetServer(value, options);
                default:
                    return Response.badRequest("Unknown setting.");
            }
        });
    }
    getOrSetServer(url, options) {
        return config_command_awaiter(this, void 0, void 0, function* () {
            if ((url == null || url.trim() === "") &&
                !options.webVault &&
                !options.api &&
                !options.identity &&
                !options.icons &&
                !options.notifications &&
                !options.events) {
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const stringRes = new StringResponse(env.hasBaseUrl() ? env.getUrls().base : "https://bitwarden.com");
                return Response.success(stringRes);
            }
            // The server config cannot be updated while a user is actively logged in to the current server
            const activeAccount = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$);
            if (activeAccount) {
                return Response.error("Logout required before server config update.");
            }
            url = url === "null" || url === "bitwarden.com" || url === "https://bitwarden.com" ? null : url;
            yield this.environmentService.setEnvironment(Region.SelfHosted, {
                base: url,
                webVault: options.webVault || null,
                api: options.api || null,
                identity: options.identity || null,
                icons: options.icons || null,
                notifications: options.notifications || null,
                events: options.events || null,
                keyConnector: options.keyConnector || null,
            });
            const res = new MessageResponse("Saved setting `config`.", null);
            return Response.success(res);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-addy-io-options.ts
const DefaultAddyIoOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.addy.io",
    token: "",
    domain: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-catchall-options.ts
/** The default options for catchall address generation. */
const DefaultCatchallOptions = Object.freeze({
    catchallType: "random",
    catchallDomain: "",
    website: null,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-duck-duck-go-options.ts
const DefaultDuckDuckGoOptions = Object.freeze({
    website: null,
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-fastmail-options.ts
const DefaultFastmailOptions = Object.freeze({
    website: "",
    domain: "",
    prefix: "",
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-forward-email-options.ts
const DefaultForwardEmailOptions = Object.freeze({
    website: null,
    token: "",
    domain: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-passphrase-boundaries.ts
function initializeBoundaries() {
    const numWords = Object.freeze({
        min: 3,
        max: 20,
    });
    return Object.freeze({
        numWords,
    });
}
/** Immutable default boundaries for passphrase generation.
 * These are used when the policy does not override a value.
 */
const DefaultPassphraseBoundaries = initializeBoundaries();

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-password-boundaries.ts
function default_password_boundaries_initializeBoundaries() {
    const length = Object.freeze({
        min: 5,
        max: 128,
    });
    const minDigits = Object.freeze({
        min: 0,
        max: 9,
    });
    const minSpecialCharacters = Object.freeze({
        min: 0,
        max: 9,
    });
    return Object.freeze({
        length,
        minDigits,
        minSpecialCharacters,
    });
}
/** Immutable default boundaries for password generation.
 * These are used when the policy does not override a value.
 */
const DefaultPasswordBoundaries = default_password_boundaries_initializeBoundaries();

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-eff-username-options.ts
/** The default options for EFF long word generation. */
const DefaultEffUsernameOptions = Object.freeze({
    wordCapitalize: false,
    wordIncludeNumber: false,
    website: null,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-firefox-relay-options.ts
const DefaultFirefoxRelayOptions = Object.freeze({
    website: null,
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-passphrase-generation-options.ts
/** The default options for passphrase generation. */
const DefaultPassphraseGenerationOptions = Object.freeze({
    numWords: 3,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-password-generation-options.ts

/** The default options for password generation. */
const DefaultPasswordGenerationOptions = Object.freeze({
    length: 14,
    minLength: DefaultPasswordBoundaries.length.min,
    ambiguous: true,
    uppercase: true,
    lowercase: true,
    number: true,
    minNumber: 1,
    special: false,
    minSpecial: 0,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-subaddress-generator-options.ts
/** The default options for email subaddress generation. */
const DefaultSubaddressOptions = Object.freeze({
    subaddressType: "random",
    subaddressEmail: "",
    website: null,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/default-simple-login-options.ts
const DefaultSimpleLoginOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.simplelogin.io",
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/disabled-passphrase-generator-policy.ts
/** The default options for password generation policy. */
const DisabledPassphraseGeneratorPolicy = Object.freeze({
    minNumberWords: 0,
    capitalize: false,
    includeNumber: false,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/disabled-password-generator-policy.ts
/** The default options for password generation policy. */
const DisabledPasswordGeneratorPolicy = Object.freeze({
    minLength: 0,
    useUppercase: false,
    useLowercase: false,
    useNumbers: false,
    numberCount: 0,
    useSpecial: false,
    specialCount: 0,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/forwarders.ts
/** Metadata about an email forwarding service.
 *  @remarks This is used to populate the forwarder selection list
 *  and to identify forwarding services in error messages.
 */
const forwarders_Forwarders = Object.freeze({
    /** For https://addy.io/ */
    AddyIo: Object.freeze({
        id: "anonaddy",
        name: "Addy.io",
        validForSelfHosted: true,
    }),
    /** For https://duckduckgo.com/email/ */
    DuckDuckGo: Object.freeze({
        id: "duckduckgo",
        name: "DuckDuckGo",
        validForSelfHosted: false,
    }),
    /** For https://www.fastmail.com. */
    Fastmail: Object.freeze({
        id: "fastmail",
        name: "Fastmail",
        validForSelfHosted: true,
    }),
    /** For https://relay.firefox.com/ */
    FirefoxRelay: Object.freeze({
        id: "firefoxrelay",
        name: "Firefox Relay",
        validForSelfHosted: false,
    }),
    /** For https://forwardemail.net/ */
    ForwardEmail: Object.freeze({
        id: "forwardemail",
        name: "Forward Email",
        validForSelfHosted: true,
    }),
    /** For https://simplelogin.io/ */
    SimpleLogin: Object.freeze({
        id: "simplelogin",
        name: "SimpleLogin",
        validForSelfHosted: true,
    }),
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/default-policy-evaluator.ts
/** A policy evaluator that does not apply any policy */
class DefaultPolicyEvaluator {
    /** {@link PolicyEvaluator.policy} */
    get policy() {
        return {};
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        return false;
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        return options;
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        return options;
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/passphrase-generator-options-evaluator.ts

/** Enforces policy for passphrase generation options.
 */
class PassphraseGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.numWords = createBoundary(policy.minNumberWords, DefaultPassphraseBoundaries.numWords);
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.capitalize,
            this.policy.includeNumber,
            this.policy.minNumberWords > DefaultPassphraseBoundaries.numWords.min,
        ];
        return policies.includes(true);
    }
    /** Apply policy to the input options.
     *  @param options The options to build from. These options are not altered.
     *  @returns A new password generation request with policy applied.
     */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value !== null && value !== void 0 ? value : boundaries.min, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const capitalize = this.policy.capitalize || options.capitalize || false;
        const includeNumber = this.policy.includeNumber || options.includeNumber || false;
        // apply boundaries
        const numWords = fitToBounds(options.numWords, this.numWords);
        return Object.assign(Object.assign({}, options), { numWords,
            capitalize,
            includeNumber });
    }
    /** Ensures internal options consistency.
     *  @param options The options to cascade. These options are not altered.
     *  @returns A passphrase generation request with cascade applied.
     */
    sanitize(options) {
        var _a, _b;
        // ensure words are separated by a single character or the empty string
        const wordSeparator = options.wordSeparator === ""
            ? ""
            : (_b = (_a = options.wordSeparator) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : DefaultPassphraseGenerationOptions.wordSeparator;
        return Object.assign(Object.assign({}, options), { wordSeparator });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/password-generator-options-evaluator.ts

/** Enforces policy for password generation.
 */
class PasswordGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.minDigits = createBoundary(policy.numberCount, DefaultPasswordBoundaries.minDigits);
        this.minSpecialCharacters = createBoundary(policy.specialCount, DefaultPasswordBoundaries.minSpecialCharacters);
        // the overall length should be at least as long as the sum of the minimums
        const minConsistentLength = this.minDigits.min + this.minSpecialCharacters.min;
        const minPolicyLength = policy.minLength > 0 ? policy.minLength : DefaultPasswordBoundaries.length.min;
        const minLength = Math.max(minPolicyLength, minConsistentLength, DefaultPasswordBoundaries.length.min);
        this.length = {
            min: minLength,
            max: Math.max(DefaultPasswordBoundaries.length.max, minLength),
        };
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.useUppercase,
            this.policy.useLowercase,
            this.policy.useNumbers,
            this.policy.useSpecial,
            this.policy.minLength > DefaultPasswordBoundaries.length.min,
            this.policy.numberCount > DefaultPasswordBoundaries.minDigits.min,
            this.policy.specialCount > DefaultPasswordBoundaries.minSpecialCharacters.min,
        ];
        return policies.includes(true);
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value || 0, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const uppercase = this.policy.useUppercase || options.uppercase || false;
        const lowercase = this.policy.useLowercase || options.lowercase || false;
        // these overrides can cascade numeric fields to boolean fields
        const number = this.policy.useNumbers || options.number || options.minNumber > 0;
        const special = this.policy.useSpecial || options.special || options.minSpecial > 0;
        // apply boundaries; the boundaries can cascade boolean fields to numeric fields
        const length = fitToBounds(options.length, this.length);
        const minNumber = fitToBounds(options.minNumber, this.minDigits);
        const minSpecial = fitToBounds(options.minSpecial, this.minSpecialCharacters);
        return Object.assign(Object.assign({}, options), { length,
            uppercase,
            lowercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        var _a;
        function cascade(enabled, value) {
            const enabledResult = enabled !== null && enabled !== void 0 ? enabled : value > 0;
            const valueResult = enabledResult ? value || 1 : 0;
            return [enabledResult, valueResult];
        }
        const [lowercase, minLowercase] = cascade(options.lowercase, options.minLowercase);
        const [uppercase, minUppercase] = cascade(options.uppercase, options.minUppercase);
        const [number, minNumber] = cascade(options.number, options.minNumber);
        const [special, minSpecial] = cascade(options.special, options.minSpecial);
        // minimums can only increase the length
        const minConsistentLength = minLowercase + minUppercase + minNumber + minSpecial;
        const minLength = Math.max(minConsistentLength, this.length.min);
        const length = Math.max((_a = options.length) !== null && _a !== void 0 ? _a : minLength, minLength);
        return Object.assign(Object.assign({}, options), { length,
            minLength,
            lowercase,
            minLowercase,
            uppercase,
            minUppercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    // Manager = 3 has been intentionally permanently deleted
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/policy-type.enum.ts
var PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(PolicyType || (PolicyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-type.enum.ts
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(ProviderType || (ProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-status-type.enum.ts
var ProviderStatusType;
(function (ProviderStatusType) {
    ProviderStatusType[ProviderStatusType["Pending"] = 0] = "Pending";
    ProviderStatusType[ProviderStatusType["Created"] = 1] = "Created";
    ProviderStatusType[ProviderStatusType["Billable"] = 2] = "Billable";
})(ProviderStatusType || (ProviderStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/index.ts











;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/passphrase-least-privilege.ts

/** Reduces a policy into an accumulator by accepting the most restrictive
 *  values from each policy.
 *  @param acc the accumulator
 *  @param policy the policy to reduce
 *  @returns the most restrictive values between the policy and accumulator.
 */
function passphraseLeastPrivilege(acc, policy) {
    var _a;
    if (policy.type !== PolicyType.PasswordGenerator) {
        return acc;
    }
    return {
        minNumberWords: Math.max(acc.minNumberWords, (_a = policy.data.minNumberWords) !== null && _a !== void 0 ? _a : acc.minNumberWords),
        capitalize: policy.data.capitalize || acc.capitalize,
        includeNumber: policy.data.includeNumber || acc.includeNumber,
    };
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/password-least-privilege.ts

/** Reduces a policy into an accumulator by accepting the most restrictive
 *  values from each policy.
 *  @param acc the accumulator
 *  @param policy the policy to reduce
 *  @returns the most restrictive values between the policy and accumulator.
 */
function passwordLeastPrivilege(acc, policy) {
    var _a, _b, _c;
    if (policy.type !== PolicyType.PasswordGenerator || !policy.enabled) {
        return acc;
    }
    return {
        minLength: Math.max(acc.minLength, (_a = policy.data.minLength) !== null && _a !== void 0 ? _a : acc.minLength),
        useUppercase: policy.data.useUpper || acc.useUppercase,
        useLowercase: policy.data.useLower || acc.useLowercase,
        useNumbers: policy.data.useNumbers || acc.useNumbers,
        numberCount: Math.max(acc.numberCount, (_b = policy.data.minNumbers) !== null && _b !== void 0 ? _b : acc.numberCount),
        useSpecial: policy.data.useSpecial || acc.useSpecial,
        specialCount: Math.max(acc.specialCount, (_c = policy.data.minSpecial) !== null && _c !== void 0 ? _c : acc.specialCount),
    };
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/policies/index.ts






;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/policies.ts


const PASSPHRASE = Object.freeze({
    disabledValue: DisabledPassphraseGeneratorPolicy,
    combine: passphraseLeastPrivilege,
    createEvaluator: (policy) => new PassphraseGeneratorOptionsEvaluator(policy),
});
const PASSWORD = Object.freeze({
    disabledValue: DisabledPasswordGeneratorPolicy,
    combine: passwordLeastPrivilege,
    createEvaluator: (policy) => new PasswordGeneratorOptionsEvaluator(policy),
});
/** Policy configurations */
const Policies = Object.freeze({
    /** Passphrase policy configuration */
    Passphrase: PASSPHRASE,
    /** Passphrase policy configuration */
    Password: PASSWORD,
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/data/index.ts


















;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/engine/crypto-service-randomizer.ts
var crypto_service_randomizer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/** A randomizer backed by a CryptoService. */
class crypto_service_randomizer_CryptoServiceRandomizer {
    constructor(crypto) {
        this.crypto = crypto;
    }
    pick(list) {
        return crypto_service_randomizer_awaiter(this, void 0, void 0, function* () {
            const index = yield this.uniform(0, list.length - 1);
            return list[index];
        });
    }
    pickWord(list, options) {
        var _a, _b;
        return crypto_service_randomizer_awaiter(this, void 0, void 0, function* () {
            let word = yield this.pick(list);
            if ((_a = options === null || options === void 0 ? void 0 : options.titleCase) !== null && _a !== void 0 ? _a : false) {
                word = word.charAt(0).toUpperCase() + word.slice(1);
            }
            if ((_b = options === null || options === void 0 ? void 0 : options.number) !== null && _b !== void 0 ? _b : false) {
                const num = yield this.crypto.randomNumber(1, 9);
                word = word + num.toString();
            }
            return word;
        });
    }
    // ref: https://stackoverflow.com/a/12646864/1090359
    shuffle(items, options) {
        var _a;
        return crypto_service_randomizer_awaiter(this, void 0, void 0, function* () {
            const shuffled = ((_a = options === null || options === void 0 ? void 0 : options.copy) !== null && _a !== void 0 ? _a : true) ? [...items] : items;
            for (let i = shuffled.length - 1; i > 0; i--) {
                const j = yield this.uniform(0, i);
                [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
            }
            return shuffled;
        });
    }
    chars(length) {
        return crypto_service_randomizer_awaiter(this, void 0, void 0, function* () {
            let str = "";
            const charSet = "abcdefghijklmnopqrstuvwxyz1234567890";
            for (let i = 0; i < length; i++) {
                const randomCharIndex = yield this.uniform(0, charSet.length - 1);
                str += charSet.charAt(randomCharIndex);
            }
            return str;
        });
    }
    uniform(min, max) {
        return crypto_service_randomizer_awaiter(this, void 0, void 0, function* () {
            return this.crypto.randomNumber(min, max);
        });
    }
    // ref: https://stackoverflow.com/a/10073788
    zeroPad(number, width) {
        return number.length >= width
            ? number
            : new Array(width - number.length + 1).join("0") + number;
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/factories.ts
// contains logic that constructs generator services dynamically given
// a generator id.

function createRandomizer(cryptoService) {
    return new CryptoServiceRandomizer(cryptoService);
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/engine/index.ts


;// CONCATENATED MODULE: ../../libs/common/src/tools/rx.ts

/**
 * An observable operator that reduces an emitted collection to a single object,
 * returning a default if all items are ignored.
 * @param reduce The reduce function to apply to the filtered collection. The
 *  first argument is the accumulator, and the second is the current item. The
 *  return value is the new accumulator.
 * @param defaultValue The default value to return if the collection is empty. The
 *   default value is also the initial value of the accumulator.
 */
function reduceCollection(reduce, defaultValue) {
    return (0,external_rxjs_namespaceObject.map)((values) => {
        const reduced = (values !== null && values !== void 0 ? values : []).reduce(reduce, structuredClone(defaultValue));
        return reduced;
    });
}
/**
 * An observable operator that emits distinct values by checking that all
 *   values in the previous entry match the next entry. This method emits
 *   when a key is added and does not when a key is removed.
 * @remarks This method checks objects. It does not check items in arrays.
 */
function distinctIfShallowMatch() {
    return (0,external_rxjs_namespaceObject.distinctUntilChanged)((previous, current) => {
        let isDistinct = true;
        for (const key in current) {
            isDistinct && (isDistinct = previous[key] === current[key]);
        }
        return isDistinct;
    });
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/rx.ts



/** Maps an administrative console policy to a policy evaluator using the provided configuration.
 *  @param configuration the configuration that constructs the evaluator.
 */
function mapPolicyToEvaluator(configuration) {
    return (0,external_rxjs_namespaceObject.pipe)(reduceCollection(configuration.combine, configuration.disabledValue), distinctIfShallowMatch(), (0,external_rxjs_namespaceObject.map)(configuration.createEvaluator));
}
/** Constructs a method that maps a policy to the default (no-op) policy. */
function newDefaultEvaluator() {
    return () => {
        return (0,external_rxjs_namespaceObject.pipe)((0,external_rxjs_namespaceObject.map)((_) => new DefaultPolicyEvaluator()));
    };
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/services/default-generator.service.ts
var default_generator_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** {@link GeneratorServiceAbstraction} */
class DefaultGeneratorService {
    /** Instantiates the generator service
     * @param strategy tailors the service to a specific generator type
     *            (e.g. password, passphrase)
     * @param policy provides the policy to enforce
     */
    constructor(strategy, policy) {
        this.strategy = strategy;
        this.policy = policy;
        this._evaluators$ = new Map();
    }
    /** {@link GeneratorService.options$} */
    options$(userId) {
        return this.strategy.durableState(userId).state$;
    }
    /** {@link GeneratorService.defaults$} */
    defaults$(userId) {
        return this.strategy.defaults$(userId);
    }
    /** {@link GeneratorService.saveOptions} */
    saveOptions(userId, options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            yield this.strategy.durableState(userId).update(() => options);
        });
    }
    /** {@link GeneratorService.evaluator$} */
    evaluator$(userId) {
        let evaluator$ = this._evaluators$.get(userId);
        if (!evaluator$) {
            evaluator$ = this.createEvaluator(userId);
            this._evaluators$.set(userId, evaluator$);
        }
        return evaluator$;
    }
    createEvaluator(userId) {
        const evaluator$ = this.policy.getAll$(this.strategy.policy, userId).pipe(
        // create the evaluator from the policies
        this.strategy.toEvaluator());
        return evaluator$;
    }
    /** {@link GeneratorService.enforcePolicy} */
    enforcePolicy(userId, options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            const policy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.evaluator$(userId));
            const evaluated = policy.applyPolicy(options);
            const sanitized = policy.sanitize(evaluated);
            return sanitized;
        });
    }
    /** {@link GeneratorService.generate} */
    generate(options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            return yield this.strategy.generate(options);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/services/index.ts


;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/util.ts

/** construct a method that outputs a copy of `defaultValue` as an observable. */
function clone$PerUserId(defaultValue) {
    const _subjects = new Map();
    return (key) => {
        let value = _subjects.get(key);
        if (value === undefined) {
            value = new external_rxjs_namespaceObject.BehaviorSubject(Object.assign({}, defaultValue));
            _subjects.set(key, value);
        }
        return value.asObservable();
    };
}
/** construct a method that caches user-specific states by userid. */
function sharedByUserId(create) {
    const _subjects = new Map();
    return (key) => {
        let value = _subjects.get(key);
        if (value === undefined) {
            value = create(key);
            _subjects.set(key, value);
        }
        return value;
    };
}
/** construct a method that loads a user-specific state from the provider. */
function sharedStateByUserId(key, provider) {
    return (id) => provider.getUser(id, key);
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/buffered-key-definition.ts

/** Storage and mapping settings for data stored by a `BufferedState`.
 */
class BufferedKeyDefinition {
    /**
     * Defines a buffered state
     * @param stateDefinition The domain of the buffer
     * @param key Domain key that identifies the buffered value. This key must
     *    not be reused in any capacity.
     * @param options Configures the operation of the buffered state.
     */
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
    }
    /** Converts the buffered key definition to a state provider
     *  key definition
     */
    toKeyDefinition() {
        const bufferedKey = new UserKeyDefinition(this.stateDefinition, this.key, this.options);
        return bufferedKey;
    }
    /** Checks whether the dependency triggers an overwrite. */
    shouldOverwrite(dependency) {
        var _a;
        const shouldOverwrite = (_a = this.options) === null || _a === void 0 ? void 0 : _a.shouldOverwrite;
        if (shouldOverwrite) {
            return shouldOverwrite(dependency);
        }
        return dependency ? true : false;
    }
    /** Converts the input data format to its output format.
     *  @returns the converted value.
     */
    map(input, dependency) {
        var _a;
        const map = (_a = this.options) === null || _a === void 0 ? void 0 : _a.map;
        if (map) {
            return map(input, dependency);
        }
        return Promise.resolve(input);
    }
    /** Checks whether the input type can be converted to the output type.
     *  @returns `true` if the definition is defined and valid, otherwise `false`.
     */
    isValid(input, dependency) {
        var _a;
        if (input === null) {
            return Promise.resolve(false);
        }
        const isValid = (_a = this.options) === null || _a === void 0 ? void 0 : _a.isValid;
        if (isValid) {
            return isValid(input, dependency);
        }
        return Promise.resolve(input ? true : false);
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/storage.ts


/** plaintext password generation options */
const PASSWORD_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passwordGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext passphrase generation options */
const PASSPHRASE_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passphraseGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext username generation options */
const EFF_USERNAME_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "effUsernameGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for a domain catch-all address. */
const CATCHALL_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "catchallGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for an email subaddress. */
const SUBADDRESS_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "subaddressGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.AddyIo} */
const ADDY_IO_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "addyIoForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.DuckDuckGo} */
const DUCK_DUCK_GO_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "duckDuckGoForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.FastMail} */
const FASTMAIL_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "fastmailForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.FireFoxRelay} */
const FIREFOX_RELAY_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "firefoxRelayForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.ForwardEmail} */
const FORWARD_EMAIL_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "forwardEmailForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link forwarders.SimpleLogin} */
const SIMPLE_LOGIN_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "simpleLoginForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.AddyIo} */
const ADDY_IO_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "addyIoBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});
/** backing store configuration for {@link Forwarders.DuckDuckGo} */
const DUCK_DUCK_GO_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "duckDuckGoBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});
/** backing store configuration for {@link Forwarders.FastMail} */
const FASTMAIL_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "fastmailBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});
/** backing store configuration for {@link Forwarders.FireFoxRelay} */
const FIREFOX_RELAY_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "firefoxRelayBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});
/** backing store configuration for {@link Forwarders.ForwardEmail} */
const FORWARD_EMAIL_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "forwardEmailBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});
/** backing store configuration for {@link forwarders.SimpleLogin} */
const SIMPLE_LOGIN_BUFFER = new BufferedKeyDefinition(GENERATOR_DISK, "simpleLoginBuffer", {
    deserializer: (value) => value,
    clearOn: ["logout"],
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/passphrase-generator-strategy.ts
var passphrase_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/** Generates passphrases composed of random words */
class PassphraseGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the passphrase
     *  @param stateProvider provides durable state
     */
    constructor(randomizer, stateProvider) {
        this.randomizer = randomizer;
        this.stateProvider = stateProvider;
        // configuration
        this.durableState = sharedStateByUserId(PASSPHRASE_SETTINGS, this.stateProvider);
        this.defaults$ = clone$PerUserId(DefaultPassphraseGenerationOptions);
        this.policy = PolicyType.PasswordGenerator;
    }
    toEvaluator() {
        return mapPolicyToEvaluator(Policies.Passphrase);
    }
    // algorithm
    generate(options) {
        return passphrase_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const o = Object.assign(Object.assign({}, DefaultPassphraseGenerationOptions), options);
            if (o.numWords == null || o.numWords <= 2) {
                o.numWords = DefaultPassphraseGenerationOptions.numWords;
            }
            if (o.capitalize == null) {
                o.capitalize = false;
            }
            if (o.includeNumber == null) {
                o.includeNumber = false;
            }
            // select which word gets the number, if any
            let luckyNumber = -1;
            if (o.includeNumber) {
                luckyNumber = yield this.randomizer.uniform(0, o.numWords - 1);
            }
            // generate the passphrase
            const wordList = new Array(o.numWords);
            for (let i = 0; i < o.numWords; i++) {
                const word = yield this.randomizer.pickWord(EFFLongWordList, {
                    titleCase: o.capitalize,
                    number: i === luckyNumber,
                });
                wordList[i] = word;
            }
            return wordList.join(o.wordSeparator);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/password-generator-strategy.ts
var password_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Generates passwords composed of random characters */
class PasswordGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the password
     */
    constructor(randomizer, stateProvider) {
        this.randomizer = randomizer;
        this.stateProvider = stateProvider;
        // configuration
        this.durableState = sharedStateByUserId(PASSWORD_SETTINGS, this.stateProvider);
        this.defaults$ = clone$PerUserId(DefaultPasswordGenerationOptions);
        this.policy = PolicyType.PasswordGenerator;
    }
    toEvaluator() {
        return mapPolicyToEvaluator(Policies.Password);
    }
    // algorithm
    generate(options) {
        return password_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const o = Object.assign(Object.assign({}, DefaultPasswordGenerationOptions), options);
            let positions = [];
            if (o.lowercase && o.minLowercase > 0) {
                for (let i = 0; i < o.minLowercase; i++) {
                    positions.push("l");
                }
            }
            if (o.uppercase && o.minUppercase > 0) {
                for (let i = 0; i < o.minUppercase; i++) {
                    positions.push("u");
                }
            }
            if (o.number && o.minNumber > 0) {
                for (let i = 0; i < o.minNumber; i++) {
                    positions.push("n");
                }
            }
            if (o.special && o.minSpecial > 0) {
                for (let i = 0; i < o.minSpecial; i++) {
                    positions.push("s");
                }
            }
            while (positions.length < o.length) {
                positions.push("a");
            }
            // shuffle
            positions = yield this.randomizer.shuffle(positions);
            // build out the char sets
            let allCharSet = "";
            let lowercaseCharSet = "abcdefghijkmnopqrstuvwxyz";
            if (o.ambiguous) {
                lowercaseCharSet += "l";
            }
            if (o.lowercase) {
                allCharSet += lowercaseCharSet;
            }
            let uppercaseCharSet = "ABCDEFGHJKLMNPQRSTUVWXYZ";
            if (o.ambiguous) {
                uppercaseCharSet += "IO";
            }
            if (o.uppercase) {
                allCharSet += uppercaseCharSet;
            }
            let numberCharSet = "23456789";
            if (o.ambiguous) {
                numberCharSet += "01";
            }
            if (o.number) {
                allCharSet += numberCharSet;
            }
            const specialCharSet = "!@#$%^&*";
            if (o.special) {
                allCharSet += specialCharSet;
            }
            let password = "";
            for (let i = 0; i < o.length; i++) {
                let positionChars;
                switch (positions[i]) {
                    case "l":
                        positionChars = lowercaseCharSet;
                        break;
                    case "u":
                        positionChars = uppercaseCharSet;
                        break;
                    case "n":
                        positionChars = numberCharSet;
                        break;
                    case "s":
                        positionChars = specialCharSet;
                        break;
                    case "a":
                        positionChars = allCharSet;
                        break;
                    default:
                        break;
                }
                const randomCharIndex = yield this.randomizer.uniform(0, positionChars.length - 1);
                password += positionChars.charAt(randomCharIndex);
            }
            return password;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/catchall-generator-strategy.ts
var catchall_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Strategy for creating usernames using a catchall email address */
class CatchallGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates a catchall address for a domain
     */
    constructor(random, stateProvider, defaultOptions = DefaultCatchallOptions) {
        this.random = random;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(CATCHALL_SETTINGS, this.stateProvider);
        this.defaults$ = clone$PerUserId(this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        return catchall_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const o = Object.assign({}, DefaultCatchallOptions, options);
            if (o.catchallDomain == null || o.catchallDomain === "") {
                return null;
            }
            if (o.catchallType == null) {
                o.catchallType = "random";
            }
            let startString = "";
            if (o.catchallType === "random") {
                startString = yield this.random.chars(8);
            }
            else if (o.catchallType === "website-name") {
                startString = o.website;
            }
            return startString + "@" + o.catchallDomain;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/subaddress-generator-strategy.ts
var subaddress_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Strategy for creating an email subaddress
 *  @remarks The subaddress is the part following the `+`.
 *  For example, if the email address is `jd+xyz@domain.io`,
 *  the subaddress is `xyz`.
 */
class SubaddressGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates an email subaddress from an email address
     */
    constructor(random, stateProvider, defaultOptions = DefaultSubaddressOptions) {
        this.random = random;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(SUBADDRESS_SETTINGS, this.stateProvider);
        this.defaults$ = clone$PerUserId(this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        return subaddress_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const o = Object.assign({}, DefaultSubaddressOptions, options);
            const subaddressEmail = o.subaddressEmail;
            if (subaddressEmail == null || subaddressEmail.length < 3) {
                return o.subaddressEmail;
            }
            const atIndex = subaddressEmail.indexOf("@");
            if (atIndex < 1 || atIndex >= subaddressEmail.length - 1) {
                return subaddressEmail;
            }
            if (o.subaddressType == null) {
                o.subaddressType = "random";
            }
            const emailBeginning = subaddressEmail.substr(0, atIndex);
            const emailEnding = subaddressEmail.substr(atIndex + 1, subaddressEmail.length);
            let subaddressString = "";
            if (o.subaddressType === "random") {
                subaddressString = yield this.random.chars(8);
            }
            else if (o.subaddressType === "website-name") {
                subaddressString = o.website;
            }
            return emailBeginning + "+" + subaddressString + "@" + emailEnding;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/eff-username-generator-strategy.ts
var eff_username_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/** Strategy for creating usernames from the EFF wordlist */
class EffUsernameGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates a username from EFF word list
     */
    constructor(random, stateProvider, defaultOptions = DefaultEffUsernameOptions) {
        this.random = random;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(EFF_USERNAME_SETTINGS, this.stateProvider);
        this.defaults$ = clone$PerUserId(this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        var _a, _b;
        return eff_username_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const word = yield this.random.pickWord(EFFLongWordList, {
                titleCase: (_a = options.wordCapitalize) !== null && _a !== void 0 ? _a : DefaultEffUsernameOptions.wordCapitalize,
                number: (_b = options.wordIncludeNumber) !== null && _b !== void 0 ? _b : DefaultEffUsernameOptions.wordIncludeNumber,
            });
            return word;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/buffered-state.ts
var buffered_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** Stateful storage that overwrites one state with a buffered state.
 *  When a overwrite occurs, the input state is automatically deleted.
 *  @remarks The buffered state can only overwrite non-nullish values. If the
 *   buffer key contains `null` or `undefined`, it will do nothing.
 */
class BufferedState {
    /**
     * Instantiate a buffered state
     * @param provider constructs the buffer.
     * @param key defines the buffer location.
     * @param output updates when a overwrite occurs
     * @param dependency$ provides data the buffer depends upon to evaluate and
     *   transform its data. If this is omitted, then `true` is injected as
     *   a dependency, which with a default output will trigger a overwrite immediately.
     *
     * @remarks `dependency$` enables overwrite control during dynamic circumstances,
     *   such as when a overwrite should occur only if a user key is available.
     */
    constructor(provider, key, output, dependency$ = null) {
        this.key = key;
        this.output = output;
        this.bufferedState = provider.getUser(output.userId, key.toKeyDefinition());
        // overwrite the output value
        const hasValue$ = (0,external_rxjs_namespaceObject.concat)((0,external_rxjs_namespaceObject.of)(null), this.bufferedState.state$).pipe((0,external_rxjs_namespaceObject.map)((buffer) => (buffer !== null && buffer !== void 0 ? buffer : null) !== null));
        const overwriteDependency$ = (dependency$ !== null && dependency$ !== void 0 ? dependency$ : (0,external_rxjs_namespaceObject.of)(true)).pipe((0,external_rxjs_namespaceObject.map)((dependency) => [key.shouldOverwrite(dependency), dependency]));
        const overwrite$ = (0,external_rxjs_namespaceObject.combineLatest)([hasValue$, overwriteDependency$]).pipe((0,external_rxjs_namespaceObject.concatMap)(([hasValue, [shouldOverwrite, dependency]]) => buffered_state_awaiter(this, void 0, void 0, function* () {
            if (hasValue && shouldOverwrite) {
                yield this.overwriteOutput(dependency);
            }
            return [false, null];
        })));
        // drive overwrites only when there's a subscription;
        // the output state determines when emissions occur
        const output$ = this.output.state$.pipe((0,external_rxjs_namespaceObject.map)((output) => [true, output]));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(overwrite$, output$).pipe((0,external_rxjs_namespaceObject.filter)(([emit]) => emit), (0,external_rxjs_namespaceObject.map)(([, output]) => output));
        this.combinedState$ = this.state$.pipe((0,external_rxjs_namespaceObject.map)((state) => [this.output.userId, state]));
        this.bufferedState$ = this.bufferedState.state$;
    }
    overwriteOutput(dependency) {
        return buffered_state_awaiter(this, void 0, void 0, function* () {
            // take the latest value from the buffer
            let buffered;
            yield this.bufferedState.update((state) => {
                buffered = state !== null && state !== void 0 ? state : null;
                return null;
            });
            // update the output state
            const isValid = yield this.key.isValid(buffered, dependency);
            if (isValid) {
                const output = yield this.key.map(buffered, dependency);
                yield this.output.update(() => output);
            }
        });
    }
    /** {@link SingleUserState.userId} */
    get userId() {
        return this.output.userId;
    }
    /** Buffers a value state. The buffered state overwrites the output
     *  state when a subscription occurs.
     *  @param value the state to roll over. Setting this to `null` or `undefined`
     *  has no effect.
     */
    buffer(value) {
        return buffered_state_awaiter(this, void 0, void 0, function* () {
            const normalized = value !== null && value !== void 0 ? value : null;
            if (normalized !== null) {
                yield this.bufferedState.update(() => normalized);
            }
        });
    }
    /** Updates the output state.
     *  @param configureState a callback that returns an updated output
     *   state. The callback receives the state's present value as its
     *   first argument and the dependencies listed in `options.combinedLatestWith`
     *   as its second argument.
     *  @param options configures how the update is applied. See {@link StateUpdateOptions}.
     */
    update(configureState, options = null) {
        return this.output.update(configureState, options);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/data-packer.abstraction.ts
/** A packing strategy that packs data into a string.
 */
class DataPacker {
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/padded-data-packer.ts


const DATA_PACKING = Object.freeze({
    /** The character to use for padding. */
    padding: "0",
    /** The character dividing packed data. */
    divider: "|",
    /** A regular expression for detecting invalid padding. When the character
     *  changes, this should be updated to include the new padding pattern.
     */
    hasInvalidPadding: /[^0]/,
});
/** A packing strategy that conceals the length of secret data by padding it
 *  to a multiple of the frame size.
 *  @example
 *  // packed === "24|e2Zvbzp0cnVlfQ==|0000"
 *  const packer = new SecretPacker(24);
 *  const packed = packer.pack({ foo: true });
 */
class PaddedDataPacker extends DataPacker {
    /** Instantiates the padded data packer
     *  @param frameSize The size of the dataframe used to pad encrypted values.
     */
    constructor(frameSize) {
        super();
        this.frameSize = frameSize;
    }
    /**
     * Packs value into a string format that conceals the length by obscuring it
     * with the frameSize.
     * @see {@link DataPackerAbstraction.unpack}
     */
    pack(value) {
        // encode the value
        const json = JSON.stringify(value);
        const b64 = Utils.fromUtf8ToB64(json);
        // calculate packing metadata
        const frameSize = JSON.stringify(this.frameSize);
        const separatorLength = 2 * DATA_PACKING.divider.length; // there are 2 separators
        const payloadLength = b64.length + frameSize.length + separatorLength;
        const paddingLength = this.frameSize - (payloadLength % this.frameSize);
        // pack the data, thereby concealing its length
        const padding = DATA_PACKING.padding.repeat(paddingLength);
        const packed = `${frameSize}|${b64}|${padding}`;
        return packed;
    }
    /** {@link DataPackerAbstraction.unpack} */
    unpack(secret) {
        // frame size is stored before the JSON payload in base 10
        const frameEndIndex = secret.indexOf(DATA_PACKING.divider);
        if (frameEndIndex < 1) {
            throw new Error("missing frame size");
        }
        const frameSize = parseInt(secret.slice(0, frameEndIndex), 10);
        const dataStartIndex = frameEndIndex + 1;
        // The decrypted string should be a multiple of the frame length
        if (secret.length % frameSize > 0) {
            throw new Error("invalid length");
        }
        // encoded data terminates with the divider, followed by the padding character
        const dataEndIndex = secret.lastIndexOf(DATA_PACKING.divider);
        if (dataEndIndex == frameEndIndex) {
            throw new Error("missing json object");
        }
        const paddingStartIndex = dataEndIndex + 1;
        // If the padding contains invalid padding characters then the padding could be used
        // as a side channel for arbitrary data.
        if (secret.slice(paddingStartIndex).match(DATA_PACKING.hasInvalidPadding)) {
            throw new Error("invalid padding");
        }
        // remove frame size and padding
        const b64 = secret.slice(dataStartIndex, dataEndIndex);
        // unpack the stored data
        const json = Utils.fromB64ToUtf8(b64);
        const unpacked = JSON.parse(json);
        return unpacked;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/secret-classifier.ts
/** Classifies an object's JSON-serializable data by property into
 *  3 categories:
 *  * Disclosed data MAY be stored in plaintext.
 *  * Excluded data MUST NOT be saved.
 *  * The remaining data is secret and MUST be stored using encryption.
 *
 *  This type should not be used to classify functions.
 *  Data that cannot be serialized by JSON.stringify() should
 *  be excluded.
 */
class SecretClassifier {
    constructor(disclosed, excluded) {
        this.disclosed = disclosed;
        this.excluded = excluded;
    }
    /** Creates a classifier where all properties are secret.
     *  @type {T} The type of secret being classified.
     */
    static allSecret() {
        const disclosed = Object.freeze([]);
        const excluded = Object.freeze([]);
        return new SecretClassifier(disclosed, excluded);
    }
    /** Classify a property as disclosed.
     *  @type {PropertyName} Available secrets to disclose.
     *  @param disclose The property name to disclose.
     *  @returns a new classifier
     */
    disclose(disclose) {
        // update the fluent interface
        const newDisclosed = [...this.disclosed, disclose];
        const classifier = new SecretClassifier(
        // since `NewDisclosed` is opaque to the type checker, it's necessary
        // to assert the type of the array here.
        Object.freeze(newDisclosed), this.excluded);
        return classifier;
    }
    /** Classify a property as excluded.
     *  @type {PropertyName} Available secrets to exclude.
     *  @param exclude The property name to exclude.
     *  @returns a new classifier
     */
    exclude(excludedPropertyName) {
        // update the fluent interface
        const newExcluded = [...this.excluded, excludedPropertyName];
        const classifier = new SecretClassifier(this.disclosed, Object.freeze(newExcluded));
        return classifier;
    }
    /** Partitions `secret` into its disclosed properties and secret properties.
     *  @param value The object to partition
     *  @returns an object that classifies secrets.
     *    The `disclosed` member is new and contains disclosed properties.
     *    The `secret` member is a copy of the secret parameter, including its
     *    prototype, with all disclosed and excluded properties deleted.
     */
    classify(value) {
        // need to JSONify during classification because the prototype is almost guaranteed
        // to be invalid when this  method deletes arbitrary properties.
        const secret = JSON.parse(JSON.stringify(value));
        for (const excludedProp of this.excluded) {
            delete secret[excludedProp];
        }
        const disclosed = {};
        for (const disclosedProp of this.disclosed) {
            // disclosedProp is known to be a subset of the keys of `Plaintext`, so these
            // type assertions are accurate.
            // FIXME: prove it to the compiler
            disclosed[disclosedProp] = secret[disclosedProp];
            delete secret[disclosedProp];
        }
        return {
            disclosed: disclosed,
            secret: secret,
        };
    }
    /** Merges the properties of `secret` and `disclosed`. When `secret` and
     *  `disclosed` contain the same property, the `secret` property overrides
     *  the `disclosed` property.
     *  @param disclosed an object whose disclosed properties are merged into
     *    the output. Unknown properties are ignored.
     *  @param secret an objects whose properties are merged into the output.
     *    Excluded properties are ignored. Unknown properties are retained.
     *  @returns a new object containing the merged data.
     */
    // Declassified data is always jsonified--the purpose of classifying it is to Jsonify it,
    // which causes type conversions.
    declassify(disclosed, secret) {
        // removed unknown keys from `disclosed` to prevent any old edit
        // of plaintext data from being laundered though declassification.
        const cleaned = {};
        for (const disclosedProp of this.disclosed) {
            cleaned[disclosedProp] = disclosed[disclosedProp];
        }
        // merge decrypted into cleaned so that secret data clobbers public data
        const merged = Object.assign(cleaned, secret);
        // delete excluded props
        for (const excludedProp of this.excluded) {
            delete merged[excludedProp];
        }
        return merged;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/secret-key-definition.ts

/** Encryption and storage settings for data stored by a `SecretState`.
 */
class SecretKeyDefinition {
    constructor(stateDefinition, key, classifier, options, 
    // type erasure is necessary here because typescript doesn't support
    // higher kinded types that generalize over collections. The invariants
    // needed to make this typesafe are maintained by the static factories.
    deconstruct, reconstruct) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.classifier = classifier;
        this.options = options;
        this.deconstruct = deconstruct;
        this.reconstruct = reconstruct;
    }
    /** Converts the secret key to the `KeyDefinition` used for secret storage. */
    toEncryptedStateKey() {
        const secretKey = new UserKeyDefinition(this.stateDefinition, this.key, {
            cleanupDelayMs: this.options.cleanupDelayMs,
            deserializer: (jsonValue) => jsonValue,
            // Clear encrypted state on logout
            clearOn: this.options.clearOn,
        });
        return secretKey;
    }
    /**
     * Define a secret state for a single value
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored value. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions the value into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static value(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => [[null, value]], ([[, inner]]) => inner);
    }
    /**
     * Define a secret state for an array of values. Each item is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored items. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each item into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static array(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => value.map((v, id) => [id, v]), (values) => values.map(([, v]) => v));
    }
    /**
     * Define a secret state for a record. Each property is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored properties. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each property into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static record(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => Object.entries(value), (values) => Object.fromEntries(values));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/secret-state.ts
var secret_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const ONE_MINUTE = 1000 * 60;
/** Stores account-specific secrets protected by a UserKeyEncryptor.
 *
 *  @remarks This state store changes the structure of `Plaintext` during
 *  storage, and requires user keys to operate. It is incompatible with sync,
 *  which expects the disk storage format to be identical to the sync format.
 *
 *  DO NOT USE THIS for synchronized data.
 */
class SecretState {
    // The constructor is private to avoid creating a circular dependency when
    // wiring the derived and secret states together.
    constructor(key, encryptor, userId, provider) {
        this.key = key;
        this.encryptor = encryptor;
        // construct the backing store
        this.encryptedState = provider.getUser(userId, key.toEncryptedStateKey());
        // cache plaintext
        this.combinedState$ = this.encryptedState.combinedState$.pipe((0,external_rxjs_namespaceObject.concatMap)(([userId, state]) => secret_state_awaiter(this, void 0, void 0, function* () { return [userId, yield this.declassifyAll(state)]; })), (0,external_rxjs_namespaceObject.share)({
            connector: () => {
                return new external_rxjs_namespaceObject.ReplaySubject(1);
            },
            resetOnRefCountZero: () => { var _a; return (0,external_rxjs_namespaceObject.timer)((_a = key.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : ONE_MINUTE); },
        }));
        this.state$ = this.combinedState$.pipe((0,external_rxjs_namespaceObject.map)(([, state]) => state));
    }
    /** {@link SingleUserState.userId} */
    get userId() {
        return this.encryptedState.userId;
    }
    /** Creates a secret state bound to an account encryptor. The account must be unlocked
     *  when this method is called.
     *  @param userId: the user to which the secret state is bound.
     *  @param key Converts between a declassified secret and its formal type.
     *  @param provider constructs state objects.
     *  @param encryptor protects `Secret` data.
     *  @throws when `key.stateDefinition` is backed by memory storage.
     *  @remarks Secrets are written to a secret store as a named tuple. Data classification is
     *    determined by the encryptor's classifier. Secret-classification data is jsonified,
     *    encrypted, and stored in a `secret` property. Disclosed-classification data is stored
     *    in a `disclosed` property. Omitted-classification data is not stored.
     */
    static from(userId, key, provider, encryptor) {
        const secretState = new SecretState(key, encryptor, userId, provider);
        return secretState;
    }
    declassifyItem({ id, secret, disclosed }) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            const encrypted = EncString.fromJSON(secret);
            const decrypted = yield this.encryptor.decrypt(encrypted, this.encryptedState.userId);
            const declassified = this.key.classifier.declassify(disclosed, decrypted);
            const result = [id, this.key.options.deserializer(declassified)];
            return result;
        });
    }
    declassifyAll(data) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            // fail fast if there's no value
            if (data === null || data === undefined) {
                return null;
            }
            // decrypt each item
            const decryptTasks = data.map((item) => secret_state_awaiter(this, void 0, void 0, function* () { return this.declassifyItem(item); }));
            // reconstruct expected type
            const results = yield Promise.all(decryptTasks);
            const result = this.key.reconstruct(results);
            return result;
        });
    }
    classifyItem([id, item]) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            const classified = this.key.classifier.classify(item);
            const encrypted = yield this.encryptor.encrypt(classified.secret, this.encryptedState.userId);
            // the deserializer in the plaintextState's `derive` configuration always runs, but
            // `encryptedState` is not guaranteed to serialize the data, so it's necessary to
            // round-trip `encrypted` proactively.
            const serialized = {
                id,
                secret: JSON.parse(JSON.stringify(encrypted)),
                disclosed: classified.disclosed,
            };
            return serialized;
        });
    }
    classifyAll(data) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            // fail fast if there's no value
            if (data === null || data === undefined) {
                return null;
            }
            // convert the object to a list format so that all encrypt and decrypt
            // operations are self-similar
            const desconstructed = this.key.deconstruct(data);
            // encrypt each value individually
            const classifyTasks = desconstructed.map((item) => secret_state_awaiter(this, void 0, void 0, function* () { return this.classifyItem(item); }));
            const classified = yield Promise.all(classifyTasks);
            return classified;
        });
    }
    /** Updates the secret stored by this state.
     *  @param configureState a callback that returns an updated decrypted
     *   secret state. The callback receives the state's present value as its
     *   first argument and the dependencies listed in `options.combinedLatestWith`
     *   as its second argument.
     *  @param options configures how the update is applied. See {@link StateUpdateOptions}.
     *  @returns a promise that resolves with the updated value read from the state.
     *   The round-trip encrypts, decrypts, and deserializes the data, producing a new
     *   object.
     *  @remarks `configureState` must return a JSON-serializable object.
     *   If there are properties of your class which are not JSON-serializable,
     *   they can be lost when the secret state updates its backing store.
     */
    update(configureState, options = null) {
        var _a, _b;
        return secret_state_awaiter(this, void 0, void 0, function* () {
            // read the backing store
            let latestClassified;
            let latestCombined;
            yield this.encryptedState.update((c) => c, {
                shouldUpdate: (latest, combined) => {
                    latestClassified = latest;
                    latestCombined = combined;
                    return false;
                },
                combineLatestWith: options === null || options === void 0 ? void 0 : options.combineLatestWith,
            });
            // exit early if there's no update to apply
            const latestDeclassified = yield this.declassifyAll(latestClassified);
            const shouldUpdate = (_b = (_a = options === null || options === void 0 ? void 0 : options.shouldUpdate) === null || _a === void 0 ? void 0 : _a.call(options, latestDeclassified, latestCombined)) !== null && _b !== void 0 ? _b : true;
            if (!shouldUpdate) {
                return latestDeclassified;
            }
            // apply the update
            const updatedDeclassified = configureState(latestDeclassified, latestCombined);
            const updatedClassified = yield this.classifyAll(updatedDeclassified);
            yield this.encryptedState.update(() => updatedClassified);
            return updatedDeclassified;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/user-encryptor.abstraction.ts
/** A classification strategy that protects a type's secrets with
 *  user-specific information. The specific kind of information is
 *  determined by the classification strategy.
 */
class UserEncryptor {
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/state/user-key-encryptor.ts
var user_key_encryptor_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** A classification strategy that protects a type's secrets by encrypting them
 *  with a `UserKey`
 */
class UserKeyEncryptor extends UserEncryptor {
    /** Instantiates the encryptor
     *  @param encryptService protects properties of `Secret`.
     *  @param keyService looks up the user key when protecting data.
     *  @param dataPacker packs and unpacks data classified as secrets.
     */
    constructor(encryptService, keyService, dataPacker) {
        super();
        this.encryptService = encryptService;
        this.keyService = keyService;
        this.dataPacker = dataPacker;
    }
    /** {@link UserEncryptor.encrypt} */
    encrypt(secret, userId) {
        return user_key_encryptor_awaiter(this, void 0, void 0, function* () {
            this.assertHasValue("secret", secret);
            this.assertHasValue("userId", userId);
            let packed = this.dataPacker.pack(secret);
            // encrypt the data and drop the key
            let key = yield this.keyService.getUserKey(userId);
            const encrypted = yield this.encryptService.encrypt(packed, key);
            packed = null;
            key = null;
            return encrypted;
        });
    }
    /** {@link UserEncryptor.decrypt} */
    decrypt(secret, userId) {
        return user_key_encryptor_awaiter(this, void 0, void 0, function* () {
            this.assertHasValue("secret", secret);
            this.assertHasValue("userId", userId);
            // decrypt the data and drop the key
            let key = yield this.keyService.getUserKey(userId);
            let decrypted = yield this.encryptService.decryptToUtf8(secret, key);
            key = null;
            // reconstruct TFrom's data
            const unpacked = this.dataPacker.unpack(decrypted);
            decrypted = null;
            return unpacked;
        });
    }
    assertHasValue(name, value) {
        if (value === undefined || value === null) {
            throw new Error(`${name} cannot be null or undefined`);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/abstractions/generator-strategy.abstraction.ts
/** Tailors the generator service to generate a specific kind of credentials */
class GeneratorStrategy {
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarder-generator-strategy.ts











const OPTIONS_FRAME_SIZE = 512;
/** An email forwarding service configurable through an API. */
class ForwarderGeneratorStrategy extends GeneratorStrategy {
    /** Initializes the generator strategy
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(encryptService, keyService, stateProvider, defaultOptions) {
        super();
        this.encryptService = encryptService;
        this.keyService = keyService;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.policy = PolicyType.PasswordGenerator;
        this.defaults$ = clone$PerUserId(this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.durableState = sharedByUserId((userId) => this.getUserSecrets(userId));
    }
    // per-user encrypted state
    getUserSecrets(userId) {
        // construct the encryptor
        const packer = new PaddedDataPacker(OPTIONS_FRAME_SIZE);
        const encryptor = new UserKeyEncryptor(this.encryptService, this.keyService, packer);
        // always exclude request properties
        const classifier = SecretClassifier.allSecret().exclude("website");
        // Derive the secret key definition
        const key = SecretKeyDefinition.value(this.key.stateDefinition, this.key.key, classifier, {
            deserializer: (d) => this.key.deserializer(d),
            cleanupDelayMs: this.key.cleanupDelayMs,
            clearOn: this.key.clearOn,
        });
        // the type parameter is explicit because type inference fails for `Omit<Options, "website">`
        const secretState = SecretState.from(userId, key, this.stateProvider, encryptor);
        // rollover should occur once the user key is available for decryption
        const canDecrypt$ = this.keyService
            .getInMemoryUserKeyFor$(userId)
            .pipe((0,external_rxjs_namespaceObject.map)((key) => key !== null));
        const rolloverState = new BufferedState(this.stateProvider, this.rolloverKey, secretState, canDecrypt$);
        return rolloverState;
    }
}

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/addy-io.ts
var addy_io_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generates a forwarding address for addy.io (formerly anon addy) */
class AddyIoForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultAddyIoOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = ADDY_IO_FORWARDER;
        this.rolloverKey = ADDY_IO_BUFFER;
        // request
        this.generate = (options) => addy_io_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.AddyIo.name);
                throw error;
            }
            if (!options.domain || options.domain === "") {
                const error = this.i18nService.t("forwarderNoDomain", forwarders_Forwarders.AddyIo.name);
                throw error;
            }
            if (!options.baseUrl || options.baseUrl === "") {
                const error = this.i18nService.t("forwarderNoUrl", forwarders_Forwarders.AddyIo.name);
                throw error;
            }
            let descriptionId = "forwarderGeneratedByWithWebsite";
            if (!options.website || options.website === "") {
                descriptionId = "forwarderGeneratedBy";
            }
            const description = this.i18nService.t(descriptionId, (_a = options.website) !== null && _a !== void 0 ? _a : "");
            const url = options.baseUrl + "/api/v1/aliases";
            const request = new Request(url, {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authorization: "Bearer " + options.token,
                    "Content-Type": "application/json",
                    "X-Requested-With": "XMLHttpRequest",
                }),
                body: JSON.stringify({
                    domain: options.domain,
                    description,
                }),
            });
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 200 || response.status === 201) {
                const json = yield response.json();
                return (_b = json === null || json === void 0 ? void 0 : json.data) === null || _b === void 0 ? void 0 : _b.email;
            }
            else if (response.status === 401) {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.AddyIo.name);
                throw error;
            }
            else if (response === null || response === void 0 ? void 0 : response.statusText) {
                const error = this.i18nService.t("forwarderError", forwarders_Forwarders.AddyIo.name, response.statusText);
                throw error;
            }
            else {
                const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.AddyIo.name);
                throw error;
            }
        });
    }
}
const DefaultOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.addy.io",
    domain: "",
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/duck-duck-go.ts
var duck_duck_go_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generates a forwarding address for DuckDuckGo */
class DuckDuckGoForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultDuckDuckGoOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = DUCK_DUCK_GO_FORWARDER;
        this.rolloverKey = DUCK_DUCK_GO_BUFFER;
        // request
        this.generate = (options) => duck_duck_go_awaiter(this, void 0, void 0, function* () {
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.DuckDuckGo.name);
                throw error;
            }
            const url = "https://quack.duckduckgo.com/api/email/addresses";
            const request = new Request(url, {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authorization: "Bearer " + options.token,
                    "Content-Type": "application/json",
                }),
            });
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 200 || response.status === 201) {
                const json = yield response.json();
                if (json.address) {
                    return `${json.address}@duck.com`;
                }
                else {
                    const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.DuckDuckGo.name);
                    throw error;
                }
            }
            else if (response.status === 401) {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.DuckDuckGo.name);
                throw error;
            }
            else {
                const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.DuckDuckGo.name);
                throw error;
            }
        });
    }
}
const duck_duck_go_DefaultOptions = Object.freeze({
    website: null,
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/fastmail.ts
var fastmail_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generates a forwarding address for Fastmail */
class FastmailForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultFastmailOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = FASTMAIL_FORWARDER;
        this.rolloverKey = FASTMAIL_BUFFER;
        // request
        this.generate = (options) => fastmail_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.Fastmail.name);
                throw error;
            }
            const accountId = yield this.getAccountId(options);
            if (!accountId || accountId === "") {
                const error = this.i18nService.t("forwarderNoAccountId", forwarders_Forwarders.Fastmail.name);
                throw error;
            }
            const body = JSON.stringify({
                using: ["https://www.fastmail.com/dev/maskedemail", "urn:ietf:params:jmap:core"],
                methodCalls: [
                    [
                        "MaskedEmail/set",
                        {
                            accountId: accountId,
                            create: {
                                "new-masked-email": {
                                    state: "enabled",
                                    description: "",
                                    forDomain: (_a = options.website) !== null && _a !== void 0 ? _a : "",
                                    emailPrefix: options.prefix,
                                },
                            },
                        },
                        "0",
                    ],
                ],
            });
            const requestInit = {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authorization: "Bearer " + options.token,
                    "Content-Type": "application/json",
                }),
                body,
            };
            const url = "https://api.fastmail.com/jmap/api/";
            const request = new Request(url, requestInit);
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 200) {
                const json = yield response.json();
                if (json.methodResponses != null &&
                    json.methodResponses.length > 0 &&
                    json.methodResponses[0].length > 0) {
                    if (json.methodResponses[0][0] === "MaskedEmail/set") {
                        if (((_c = (_b = json.methodResponses[0][1]) === null || _b === void 0 ? void 0 : _b.created) === null || _c === void 0 ? void 0 : _c["new-masked-email"]) != null) {
                            return (_f = (_e = (_d = json.methodResponses[0][1]) === null || _d === void 0 ? void 0 : _d.created) === null || _e === void 0 ? void 0 : _e["new-masked-email"]) === null || _f === void 0 ? void 0 : _f.email;
                        }
                        if (((_h = (_g = json.methodResponses[0][1]) === null || _g === void 0 ? void 0 : _g.notCreated) === null || _h === void 0 ? void 0 : _h["new-masked-email"]) != null) {
                            const errorDescription = (_l = (_k = (_j = json.methodResponses[0][1]) === null || _j === void 0 ? void 0 : _j.notCreated) === null || _k === void 0 ? void 0 : _k["new-masked-email"]) === null || _l === void 0 ? void 0 : _l.description;
                            const error = this.i18nService.t("forwarderError", forwarders_Forwarders.Fastmail.name, errorDescription);
                            throw error;
                        }
                    }
                    else if (json.methodResponses[0][0] === "error") {
                        const errorDescription = (_m = json.methodResponses[0][1]) === null || _m === void 0 ? void 0 : _m.description;
                        const error = this.i18nService.t("forwarderError", forwarders_Forwarders.Fastmail.name, errorDescription);
                        throw error;
                    }
                }
            }
            else if (response.status === 401 || response.status === 403) {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.Fastmail.name);
                throw error;
            }
            const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.Fastmail.name);
            throw error;
        });
    }
    getAccountId(options) {
        return fastmail_awaiter(this, void 0, void 0, function* () {
            const requestInit = {
                cache: "no-store",
                method: "GET",
                headers: new Headers({
                    Authorization: "Bearer " + options.token,
                }),
            };
            const url = "https://api.fastmail.com/.well-known/jmap";
            const request = new Request(url, requestInit);
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 200) {
                const json = yield response.json();
                if (json.primaryAccounts != null) {
                    return json.primaryAccounts["https://www.fastmail.com/dev/maskedemail"];
                }
            }
            return null;
        });
    }
}
const fastmail_DefaultOptions = Object.freeze({
    website: null,
    domain: "",
    prefix: "",
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/firefox-relay.ts
var firefox_relay_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generates a forwarding address for Firefox Relay */
class FirefoxRelayForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultFirefoxRelayOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = FIREFOX_RELAY_FORWARDER;
        this.rolloverKey = FIREFOX_RELAY_BUFFER;
        // request
        this.generate = (options) => firefox_relay_awaiter(this, void 0, void 0, function* () {
            var _a;
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.FirefoxRelay.name);
                throw error;
            }
            const url = "https://relay.firefox.com/api/v1/relayaddresses/";
            let descriptionId = "forwarderGeneratedByWithWebsite";
            if (!options.website || options.website === "") {
                descriptionId = "forwarderGeneratedBy";
            }
            const description = this.i18nService.t(descriptionId, (_a = options.website) !== null && _a !== void 0 ? _a : "");
            const request = new Request(url, {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authorization: "Token " + options.token,
                    "Content-Type": "application/json",
                }),
                body: JSON.stringify({
                    enabled: true,
                    generated_for: options.website,
                    description,
                }),
            });
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 401) {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.FirefoxRelay.name);
                throw error;
            }
            else if (response.status === 200 || response.status === 201) {
                const json = yield response.json();
                return json.full_address;
            }
            else {
                const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.FirefoxRelay.name);
                throw error;
            }
        });
    }
}
const firefox_relay_DefaultOptions = Object.freeze({
    website: null,
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/forward-email.ts
var forward_email_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




/** Generates a forwarding address for Forward Email */
class ForwardEmailForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultForwardEmailOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = FORWARD_EMAIL_FORWARDER;
        this.rolloverKey = FORWARD_EMAIL_BUFFER;
        // request
        this.generate = (options) => forward_email_awaiter(this, void 0, void 0, function* () {
            var _a;
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.ForwardEmail.name);
                throw error;
            }
            if (!options.domain || options.domain === "") {
                const error = this.i18nService.t("forwarderNoDomain", forwarders_Forwarders.ForwardEmail.name);
                throw error;
            }
            const url = `https://api.forwardemail.net/v1/domains/${options.domain}/aliases`;
            let descriptionId = "forwarderGeneratedByWithWebsite";
            if (!options.website || options.website === "") {
                descriptionId = "forwarderGeneratedBy";
            }
            const description = this.i18nService.t(descriptionId, (_a = options.website) !== null && _a !== void 0 ? _a : "");
            const request = new Request(url, {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authorization: "Basic " + Utils.fromUtf8ToB64(options.token + ":"),
                    "Content-Type": "application/json",
                }),
                body: JSON.stringify({
                    labels: options.website,
                    description,
                }),
            });
            const response = yield this.apiService.nativeFetch(request);
            const json = yield response.json();
            if (response.status === 401) {
                const messageKey = "message" in json ? "forwaderInvalidTokenWithMessage" : "forwaderInvalidToken";
                const error = this.i18nService.t(messageKey, forwarders_Forwarders.ForwardEmail.name, json.message);
                throw error;
            }
            else if (response.status === 200 || response.status === 201) {
                const { name, domain } = yield response.json();
                const domainPart = (domain === null || domain === void 0 ? void 0 : domain.name) || options.domain;
                return `${name}@${domainPart}`;
            }
            else if (json === null || json === void 0 ? void 0 : json.message) {
                const error = this.i18nService.t("forwarderError", forwarders_Forwarders.ForwardEmail.name, json.message);
                throw error;
            }
            else if (json === null || json === void 0 ? void 0 : json.error) {
                const error = this.i18nService.t("forwarderError", forwarders_Forwarders.ForwardEmail.name, json.error);
                throw error;
            }
            else {
                const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.ForwardEmail.name);
                throw error;
            }
        });
    }
}
const forward_email_DefaultOptions = Object.freeze({
    website: null,
    token: "",
    domain: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/forwarders/simple-login.ts
var simple_login_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generates a forwarding address for Simple Login */
class SimpleLoginForwarder extends ForwarderGeneratorStrategy {
    /** Instantiates the forwarder
     *  @param apiService used for ajax requests to the forwarding service
     *  @param i18nService used to look up error strings
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(apiService, i18nService, encryptService, keyService, stateProvider) {
        super(encryptService, keyService, stateProvider, DefaultSimpleLoginOptions);
        this.apiService = apiService;
        this.i18nService = i18nService;
        // configuration
        this.key = SIMPLE_LOGIN_FORWARDER;
        this.rolloverKey = SIMPLE_LOGIN_BUFFER;
        // request
        this.generate = (options) => simple_login_awaiter(this, void 0, void 0, function* () {
            var _a;
            if (!options.token || options.token === "") {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.SimpleLogin.name);
                throw error;
            }
            if (!options.baseUrl || options.baseUrl === "") {
                const error = this.i18nService.t("forwarderNoUrl", forwarders_Forwarders.SimpleLogin.name);
                throw error;
            }
            let url = options.baseUrl + "/api/alias/random/new";
            let noteId = "forwarderGeneratedBy";
            if (options.website && options.website !== "") {
                url += "?hostname=" + options.website;
                noteId = "forwarderGeneratedByWithWebsite";
            }
            const note = this.i18nService.t(noteId, (_a = options.website) !== null && _a !== void 0 ? _a : "");
            const request = new Request(url, {
                redirect: "manual",
                cache: "no-store",
                method: "POST",
                headers: new Headers({
                    Authentication: options.token,
                    "Content-Type": "application/json",
                }),
                body: JSON.stringify({ note }),
            });
            const response = yield this.apiService.nativeFetch(request);
            if (response.status === 401) {
                const error = this.i18nService.t("forwaderInvalidToken", forwarders_Forwarders.SimpleLogin.name);
                throw error;
            }
            const json = yield response.json();
            if (response.status === 200 || response.status === 201) {
                return json.alias;
            }
            else if (json === null || json === void 0 ? void 0 : json.error) {
                const error = this.i18nService.t("forwarderError", forwarders_Forwarders.SimpleLogin.name, json.error);
                throw error;
            }
            else {
                const error = this.i18nService.t("forwarderUnknownError", forwarders_Forwarders.SimpleLogin.name);
                throw error;
            }
        });
    }
}
const simple_login_DefaultOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.simplelogin.io",
    token: "",
});

;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/strategies/index.ts












;// CONCATENATED MODULE: ../../libs/tools/generator/core/src/index.ts















;// CONCATENATED MODULE: ./src/tools/generate.command.ts
var generate_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class GenerateCommand {
    constructor(passwordGenerationService, stateService) {
        this.passwordGenerationService = passwordGenerationService;
        this.stateService = stateService;
    }
    run(cmdOptions) {
        return generate_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new generate_command_Options(cmdOptions);
            const options = {
                uppercase: normalizedOptions.uppercase,
                lowercase: normalizedOptions.lowercase,
                number: normalizedOptions.number,
                special: normalizedOptions.special,
                length: normalizedOptions.length,
                type: normalizedOptions.type,
                wordSeparator: normalizedOptions.separator,
                numWords: normalizedOptions.words,
                capitalize: normalizedOptions.capitalize,
                includeNumber: normalizedOptions.includeNumber,
                minNumber: normalizedOptions.minNumber,
                minSpecial: normalizedOptions.minSpecial,
                ambiguous: normalizedOptions.ambiguous,
            };
            const enforcedOptions = (yield this.stateService.getIsAuthenticated())
                ? (yield this.passwordGenerationService.enforcePasswordGeneratorPoliciesOnOptions(options))[0]
                : options;
            const password = yield this.passwordGenerationService.generatePassword(enforcedOptions);
            const res = new StringResponse(password);
            return Response.success(res);
        });
    }
}
class generate_command_Options {
    constructor(passedOptions) {
        this.uppercase = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.uppercase);
        this.lowercase = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.lowercase);
        this.number = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.number);
        this.special = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.special);
        this.capitalize = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.capitalize);
        this.includeNumber = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.includeNumber);
        this.ambiguous = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.ambiguous);
        this.length = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.length, DefaultPasswordGenerationOptions.length);
        this.type = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passphrase) ? "passphrase" : "password";
        this.separator = CliUtils.convertStringOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.separator, DefaultPassphraseGenerationOptions.wordSeparator);
        this.words = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.words, DefaultPassphraseGenerationOptions.numWords);
        this.minNumber = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minNumber, DefaultPasswordGenerationOptions.minNumber);
        this.minSpecial = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minSpecial, DefaultPasswordGenerationOptions.minSpecial);
        if (!this.uppercase && !this.lowercase && !this.special && !this.number) {
            this.lowercase = true;
            this.uppercase = true;
            this.number = true;
        }
        if (this.length < 5) {
            this.length = 5;
        }
        if (this.words < 3) {
            this.words = 3;
        }
        if (this.separator === "space") {
            this.separator = " ";
        }
        else if (this.separator === "empty") {
            this.separator = "";
        }
        else if (this.separator != null && this.separator.length > 1) {
            this.separator = this.separator[0];
        }
    }
}

;// CONCATENATED MODULE: ./src/vault/sync.command.ts
var sync_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class SyncCommand {
    constructor(syncService) {
        this.syncService = syncService;
    }
    run(cmdOptions) {
        return sync_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new sync_command_Options(cmdOptions);
            if (normalizedOptions.last) {
                return yield this.getLastSync();
            }
            try {
                yield this.syncService.fullSync(normalizedOptions.force, true);
                const res = new MessageResponse("Syncing complete.", null);
                return Response.success(res);
            }
            catch (e) {
                return Response.error("Syncing failed: " + e.toString());
            }
        });
    }
    getLastSync() {
        return sync_command_awaiter(this, void 0, void 0, function* () {
            const lastSyncDate = yield this.syncService.getLastSync();
            const res = new StringResponse(lastSyncDate == null ? null : lastSyncDate.toISOString());
            return Response.success(res);
        });
    }
}
class sync_command_Options {
    constructor(passedOptions) {
        this.last = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.last);
        this.force = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.force);
    }
}

;// CONCATENATED MODULE: ./src/program.ts
var program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



















const program_writeLn = CliUtils.writeLn;
class Program extends BaseProgram {
    register() {
        return program_awaiter(this, void 0, void 0, function* () {
            external_commander_namespaceObject.program
                .option("--pretty", "Format output. JSON is tabbed with two spaces.")
                .option("--raw", "Return raw output instead of a descriptive message.")
                .option("--response", "Return a JSON formatted version of response output.")
                .option("--cleanexit", "Exit with a success exit code (0) unless an error is thrown.")
                .option("--quiet", "Don't return anything to stdout.")
                .option("--nointeraction", "Do not prompt for interactive user input.")
                .option("--session <session>", "Pass session key instead of reading from env.")
                .version(yield this.serviceContainer.platformUtilsService.getApplicationVersion(), "-v, --version");
            external_commander_namespaceObject.program.on("option:pretty", () => {
                process.env.BW_PRETTY = "true";
            });
            external_commander_namespaceObject.program.on("option:raw", () => {
                process.env.BW_RAW = "true";
            });
            external_commander_namespaceObject.program.on("option:quiet", () => {
                process.env.BW_QUIET = "true";
            });
            external_commander_namespaceObject.program.on("option:response", () => {
                process.env.BW_RESPONSE = "true";
            });
            external_commander_namespaceObject.program.on("option:cleanexit", () => {
                process.env.BW_CLEANEXIT = "true";
            });
            external_commander_namespaceObject.program.on("option:nointeraction", () => {
                process.env.BW_NOINTERACTION = "true";
            });
            external_commander_namespaceObject.program.on("option:session", (key) => program_awaiter(this, void 0, void 0, function* () {
                process.env.BW_SESSION = key;
                // once we have the session key, we can set the user key in memory
                const activeAccount = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.serviceContainer.accountService.activeAccount$);
                if (activeAccount) {
                    yield this.serviceContainer.userAutoUnlockKeyService.setUserKeyInMemoryIfAutoUserKeySet(activeAccount.id);
                }
            }));
            external_commander_namespaceObject.program.on("command:*", () => {
                program_writeLn(external_chalk_namespaceObject.redBright("Invalid command: " + external_commander_namespaceObject.program.args.join(" ")), false, true);
                program_writeLn("See --help for a list of available commands.", true, true);
                process.exitCode = 1;
            });
            external_commander_namespaceObject.program.on("--help", () => {
                program_writeLn(external_chalk_namespaceObject.yellowBright("\n  Tip: Managing and retrieving secrets for dev environments is easier with Bitwarden Secrets Manager. Learn more under https://bitwarden.com/products/secrets-manager/"));
                program_writeLn("\n  Examples:");
                program_writeLn("");
                program_writeLn("    bw login");
                program_writeLn("    bw lock");
                program_writeLn("    bw unlock myPassword321");
                program_writeLn("    bw list --help");
                program_writeLn("    bw list items --search google");
                program_writeLn("    bw get item 99ee88d2-6046-4ea7-92c2-acac464b1412");
                program_writeLn("    bw get password google.com");
                program_writeLn('    echo \'{"name":"My Folder"}\' | bw encode');
                program_writeLn("    bw create folder eyJuYW1lIjoiTXkgRm9sZGVyIn0K");
                program_writeLn("    bw edit folder c7c7b60b-9c61-40f2-8ccd-36c49595ed72 eyJuYW1lIjoiTXkgRm9sZGVyMiJ9Cg==");
                program_writeLn("    bw delete item 99ee88d2-6046-4ea7-92c2-acac464b1412");
                program_writeLn("    bw generate -lusn --length 18");
                program_writeLn("    bw config server https://bitwarden.example.com");
                program_writeLn("    bw send -f ./file.ext");
                program_writeLn('    bw send "text to send"');
                program_writeLn('    echo "text to send" | bw send');
                program_writeLn("    bw receive https://vault.bitwarden.com/#/send/rg3iuoS_Akm2gqy6ADRHmg/Ht7dYjsqjmgqUM3rjzZDSQ");
                program_writeLn("", true);
            });
            external_commander_namespaceObject.program
                .command("login [email] [password]")
                .description("Log into a user account.")
                .option("--method <method>", "Two-step login method.")
                .option("--code <code>", "Two-step login code.")
                .option("--sso", "Log in with Single-Sign On.")
                .option("--apikey", "Log in with an Api Key.")
                .option("--passwordenv <passwordenv>", "Environment variable storing your password")
                .option("--passwordfile <passwordfile>", "Path to a file containing your password as its first line")
                .option("--check", "Check login status.", () => program_awaiter(this, void 0, void 0, function* () {
                const authed = yield this.serviceContainer.stateService.getIsAuthenticated();
                if (authed) {
                    const res = new MessageResponse("You are logged in!", null);
                    this.processResponse(Response.success(res), true);
                }
                this.processResponse(Response.error("You are not logged in."), true);
            }))
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    See docs for valid `method` enum values.");
                program_writeLn("");
                program_writeLn("    Pass `--raw` option to only return the session key.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw login");
                program_writeLn("    bw login john@example.com myPassword321 --raw");
                program_writeLn("    bw login john@example.com myPassword321 --method 1 --code 249213");
                program_writeLn("    bw login --sso");
                program_writeLn("", true);
            })
                .action((email, password, options) => program_awaiter(this, void 0, void 0, function* () {
                if (!options.check) {
                    yield this.exitIfAuthed();
                    const command = new LoginCommand(this.serviceContainer.loginStrategyService, this.serviceContainer.authService, this.serviceContainer.apiService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.environmentService, this.serviceContainer.passwordGenerationService, this.serviceContainer.passwordStrengthService, this.serviceContainer.platformUtilsService, this.serviceContainer.accountService, this.serviceContainer.cryptoService, this.serviceContainer.policyService, this.serviceContainer.twoFactorService, this.serviceContainer.syncService, this.serviceContainer.keyConnectorService, this.serviceContainer.policyApiService, this.serviceContainer.organizationService, () => program_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }), this.serviceContainer.kdfConfigService);
                    const response = yield command.run(email, password, options);
                    this.processResponse(response, true);
                }
            }));
            external_commander_namespaceObject.program
                .command("logout")
                .description("Log out of the current user account.")
                .on("--help", () => {
                program_writeLn("\n  Examples:");
                program_writeLn("");
                program_writeLn("    bw logout");
                program_writeLn("", true);
            })
                .action((cmd) => program_awaiter(this, void 0, void 0, function* () {
                yield this.exitIfNotAuthed();
                const command = new LogoutCommand(this.serviceContainer.authService, this.serviceContainer.i18nService, () => program_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));
                const response = yield command.run();
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("lock")
                .description("Lock the vault and destroy active session keys.")
                .on("--help", () => {
                program_writeLn("\n  Examples:");
                program_writeLn("");
                program_writeLn("    bw lock");
                program_writeLn("", true);
            })
                .action((cmd) => program_awaiter(this, void 0, void 0, function* () {
                yield this.exitIfNotAuthed();
                if (yield this.serviceContainer.keyConnectorService.getUsesKeyConnector()) {
                    const logoutCommand = new LogoutCommand(this.serviceContainer.authService, this.serviceContainer.i18nService, () => program_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));
                    yield logoutCommand.run();
                    this.processResponse(Response.error("You cannot lock your vault because you are using Key Connector. " +
                        "To protect your vault, you have been logged out."), true);
                    return;
                }
                const command = new LockCommand(this.serviceContainer.vaultTimeoutService);
                const response = yield command.run();
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("unlock [password]")
                .description("Unlock the vault and return a new session key.")
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    After unlocking, any previous session keys will no longer be valid.");
                program_writeLn("");
                program_writeLn("    Pass `--raw` option to only return the session key.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw unlock");
                program_writeLn("    bw unlock myPassword321");
                program_writeLn("    bw unlock myPassword321 --raw");
                program_writeLn("", true);
            })
                .option("--check", "Check lock status.", () => program_awaiter(this, void 0, void 0, function* () {
                yield this.exitIfNotAuthed();
                const authStatus = yield this.serviceContainer.authService.getAuthStatus();
                if (authStatus === authentication_status_AuthenticationStatus.Unlocked) {
                    const res = new MessageResponse("Vault is unlocked!", null);
                    this.processResponse(Response.success(res), true);
                }
                else {
                    this.processResponse(Response.error("Vault is locked."), true);
                }
            }))
                .option("--passwordenv <passwordenv>", "Environment variable storing your password")
                .option("--passwordfile <passwordfile>", "Path to a file containing your password as its first line")
                .action((password, cmd) => program_awaiter(this, void 0, void 0, function* () {
                if (!cmd.check) {
                    yield this.exitIfNotAuthed();
                    const command = new UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.userVerificationService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, () => program_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));
                    const response = yield command.run(password, cmd);
                    this.processResponse(response);
                }
            }));
            external_commander_namespaceObject.program
                .command("sync")
                .description("Pull the latest vault data from server.")
                .option("-f, --force", "Force a full sync.")
                .option("--last", "Get the last sync date.")
                .on("--help", () => {
                program_writeLn("\n  Examples:");
                program_writeLn("");
                program_writeLn("    bw sync");
                program_writeLn("    bw sync -f");
                program_writeLn("    bw sync --last");
                program_writeLn("", true);
            })
                .action((cmd) => program_awaiter(this, void 0, void 0, function* () {
                yield this.exitIfNotAuthed();
                const command = new SyncCommand(this.serviceContainer.syncService);
                const response = yield command.run(cmd);
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("generate")
                .description("Generate a password/passphrase.")
                .option("-u, --uppercase", "Include uppercase characters.")
                .option("-l, --lowercase", "Include lowercase characters.")
                .option("-n, --number", "Include numeric characters.")
                .option("-s, --special", "Include special characters.")
                .option("-p, --passphrase", "Generate a passphrase.")
                .option("--length <length>", "Length of the password.")
                .option("--words <words>", "Number of words.")
                .option("--minNumber <count>", "Minimum number of numeric characters.")
                .option("--minSpecial <count>", "Minimum number of special characters.")
                .option("--separator <separator>", "Word separator.")
                .option("-c, --capitalize", "Title case passphrase.")
                .option("--includeNumber", "Passphrase includes number.")
                .option("--ambiguous", "Avoid ambiguous characters.")
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    Default options are `-uln --length 14`.");
                program_writeLn("");
                program_writeLn("    Minimum `length` is 5.");
                program_writeLn("");
                program_writeLn("    Minimum `words` is 3.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw generate");
                program_writeLn("    bw generate -u -l --length 18");
                program_writeLn("    bw generate -ulns --length 25");
                program_writeLn("    bw generate -ul");
                program_writeLn("    bw generate -p --separator _");
                program_writeLn("    bw generate -p --words 5 --separator space");
                program_writeLn("    bw generate -p --words 5 --separator empty");
                program_writeLn("", true);
            })
                .action((options) => program_awaiter(this, void 0, void 0, function* () {
                const command = new GenerateCommand(this.serviceContainer.passwordGenerationService, this.serviceContainer.stateService);
                const response = yield command.run(options);
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("encode")
                .description("Base 64 encode stdin.")
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    Use to create `encodedJson` for `create` and `edit` commands.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn('    echo \'{"name":"My Folder"}\' | bw encode');
                program_writeLn("", true);
            })
                .action(() => program_awaiter(this, void 0, void 0, function* () {
                const command = new EncodeCommand();
                const response = yield command.run();
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("config <setting> [value]")
                .description("Configure CLI settings.")
                .option("--web-vault <url>", "Provides a custom web vault URL that differs from the base URL.")
                .option("--api <url>", "Provides a custom API URL that differs from the base URL.")
                .option("--identity <url>", "Provides a custom identity URL that differs from the base URL.")
                .option("--icons <url>", "Provides a custom icons service URL that differs from the base URL.")
                .option("--notifications <url>", "Provides a custom notifications URL that differs from the base URL.")
                .option("--events <url>", "Provides a custom events URL that differs from the base URL.")
                .option("--key-connector <url>", "Provides the URL for your Key Connector server.")
                .on("--help", () => {
                program_writeLn("\n  Settings:");
                program_writeLn("");
                program_writeLn("    server - On-premises hosted installation URL.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw config server");
                program_writeLn("    bw config server https://bw.company.com");
                program_writeLn("    bw config server bitwarden.com");
                program_writeLn("    bw config server --api http://localhost:4000 --identity http://localhost:33656");
                program_writeLn("", true);
            })
                .action((setting, value, options) => program_awaiter(this, void 0, void 0, function* () {
                const command = new ConfigCommand(this.serviceContainer.environmentService, this.serviceContainer.accountService);
                const response = yield command.run(setting, value, options);
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("update")
                .description("Check for updates.")
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    Returns the URL to download the newest version of this CLI tool.");
                program_writeLn("");
                program_writeLn("    Use the `--raw` option to return only the download URL for the update.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw update");
                program_writeLn("    bw update --raw");
                program_writeLn("", true);
            })
                .action(() => program_awaiter(this, void 0, void 0, function* () {
                const command = new UpdateCommand(this.serviceContainer.platformUtilsService);
                const response = yield command.run();
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("completion")
                .description("Generate shell completions.")
                .option("--shell <shell>", "Shell to generate completions for.")
                .on("--help", () => {
                program_writeLn("\n  Notes:");
                program_writeLn("");
                program_writeLn("    Valid shells are `zsh`.");
                program_writeLn("");
                program_writeLn("  Examples:");
                program_writeLn("");
                program_writeLn("    bw completion --shell zsh");
                program_writeLn("", true);
            })
                .action((options, cmd) => program_awaiter(this, void 0, void 0, function* () {
                const command = new CompletionCommand();
                const response = yield command.run(options);
                this.processResponse(response);
            }));
            external_commander_namespaceObject.program
                .command("status")
                .description("Show server, last sync, user information, and vault status.")
                .on("--help", () => {
                program_writeLn("");
                program_writeLn("");
                program_writeLn("  Example return value:");
                program_writeLn("");
                program_writeLn("    {");
                program_writeLn('      "serverUrl": "https://bitwarden.example.com",');
                program_writeLn('      "lastSync": "2020-06-16T06:33:51.419Z",');
                program_writeLn('      "userEmail": "user@example.com,');
                program_writeLn('      "userId": "00000000-0000-0000-0000-000000000000",');
                program_writeLn('      "status": "locked"');
                program_writeLn("    }");
                program_writeLn("");
                program_writeLn("  Notes:");
                program_writeLn("");
                program_writeLn("  `status` is one of:");
                program_writeLn("    - `unauthenticated` when you are not logged in");
                program_writeLn("    - `locked` when you are logged in and the vault is locked");
                program_writeLn("    - `unlocked` when you are logged in and the vault is unlocked");
                program_writeLn("", true);
            })
                .action(() => program_awaiter(this, void 0, void 0, function* () {
                const command = new StatusCommand(this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.accountService, this.serviceContainer.authService);
                const response = yield command.run();
                this.processResponse(response);
            }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/enums/send-type.ts
var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/card.data.ts
class CardData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.cardholderName = data.cardholderName;
        this.brand = data.brand;
        this.number = data.number;
        this.expMonth = data.expMonth;
        this.expYear = data.expYear;
        this.code = data.code;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-reprompt-type.ts
var CipherRepromptType;
(function (CipherRepromptType) {
    CipherRepromptType[CipherRepromptType["None"] = 0] = "None";
    CipherRepromptType[CipherRepromptType["Password"] = 1] = "Password";
})(CipherRepromptType || (CipherRepromptType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-type.ts
var CipherType;
(function (CipherType) {
    CipherType[CipherType["Login"] = 1] = "Login";
    CipherType[CipherType["SecureNote"] = 2] = "SecureNote";
    CipherType[CipherType["Card"] = 3] = "Card";
    CipherType[CipherType["Identity"] = 4] = "Identity";
})(CipherType || (CipherType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/field-type.enum.ts
var FieldType;
(function (FieldType) {
    FieldType[FieldType["Text"] = 0] = "Text";
    FieldType[FieldType["Hidden"] = 1] = "Hidden";
    FieldType[FieldType["Boolean"] = 2] = "Boolean";
    FieldType[FieldType["Linked"] = 3] = "Linked";
})(FieldType || (FieldType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/linked-id-type.enum.ts
// LoginView
var LoginLinkedId;
(function (LoginLinkedId) {
    LoginLinkedId[LoginLinkedId["Username"] = 100] = "Username";
    LoginLinkedId[LoginLinkedId["Password"] = 101] = "Password";
})(LoginLinkedId || (LoginLinkedId = {}));
// CardView
var CardLinkedId;
(function (CardLinkedId) {
    CardLinkedId[CardLinkedId["CardholderName"] = 300] = "CardholderName";
    CardLinkedId[CardLinkedId["ExpMonth"] = 301] = "ExpMonth";
    CardLinkedId[CardLinkedId["ExpYear"] = 302] = "ExpYear";
    CardLinkedId[CardLinkedId["Code"] = 303] = "Code";
    CardLinkedId[CardLinkedId["Brand"] = 304] = "Brand";
    CardLinkedId[CardLinkedId["Number"] = 305] = "Number";
})(CardLinkedId || (CardLinkedId = {}));
// IdentityView
var IdentityLinkedId;
(function (IdentityLinkedId) {
    IdentityLinkedId[IdentityLinkedId["Title"] = 400] = "Title";
    IdentityLinkedId[IdentityLinkedId["MiddleName"] = 401] = "MiddleName";
    IdentityLinkedId[IdentityLinkedId["Address1"] = 402] = "Address1";
    IdentityLinkedId[IdentityLinkedId["Address2"] = 403] = "Address2";
    IdentityLinkedId[IdentityLinkedId["Address3"] = 404] = "Address3";
    IdentityLinkedId[IdentityLinkedId["City"] = 405] = "City";
    IdentityLinkedId[IdentityLinkedId["State"] = 406] = "State";
    IdentityLinkedId[IdentityLinkedId["PostalCode"] = 407] = "PostalCode";
    IdentityLinkedId[IdentityLinkedId["Country"] = 408] = "Country";
    IdentityLinkedId[IdentityLinkedId["Company"] = 409] = "Company";
    IdentityLinkedId[IdentityLinkedId["Email"] = 410] = "Email";
    IdentityLinkedId[IdentityLinkedId["Phone"] = 411] = "Phone";
    IdentityLinkedId[IdentityLinkedId["Ssn"] = 412] = "Ssn";
    IdentityLinkedId[IdentityLinkedId["Username"] = 413] = "Username";
    IdentityLinkedId[IdentityLinkedId["PassportNumber"] = 414] = "PassportNumber";
    IdentityLinkedId[IdentityLinkedId["LicenseNumber"] = 415] = "LicenseNumber";
    IdentityLinkedId[IdentityLinkedId["FirstName"] = 416] = "FirstName";
    IdentityLinkedId[IdentityLinkedId["LastName"] = 417] = "LastName";
    IdentityLinkedId[IdentityLinkedId["FullName"] = 418] = "FullName";
})(IdentityLinkedId || (IdentityLinkedId = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/secure-note-type.enum.ts
var SecureNoteType;
(function (SecureNoteType) {
    SecureNoteType[SecureNoteType["Generic"] = 0] = "Generic";
})(SecureNoteType || (SecureNoteType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/index.ts






;// CONCATENATED MODULE: ../../libs/common/src/vault/linked-field-option.decorator.ts
class LinkedMetadata {
    constructor(propertyKey, _i18nKey) {
        this.propertyKey = propertyKey;
        this._i18nKey = _i18nKey;
    }
    get i18nKey() {
        var _a;
        return (_a = this._i18nKey) !== null && _a !== void 0 ? _a : this.propertyKey;
    }
}
/**
 * A decorator used to set metadata used by Linked custom fields. Apply it to a class property or getter to make it
 *    available as a Linked custom field option.
 * @param id - A unique value that is saved in the Field model. It is used to look up the decorated class property.
 * @param i18nKey - The i18n key used to describe the decorated class property in the UI. If it is null, then the name
 *    of the class property will be used as the i18n key.
 */
function linkedFieldOption(id, i18nKey) {
    return (prototype, propertyKey) => {
        if (prototype.linkedFieldOptions == null) {
            prototype.linkedFieldOptions = new Map();
        }
        prototype.linkedFieldOptions.set(id, new LinkedMetadata(propertyKey, i18nKey));
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/item.view.ts
class ItemView {
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/card.view.ts
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



class CardView extends ItemView {
    constructor() {
        super(...arguments);
        this.cardholderName = null;
        this.expMonth = null;
        this.expYear = null;
        this.code = null;
        this._brand = null;
        this._number = null;
        this._subTitle = null;
    }
    get maskedCode() {
        return this.code != null ? "•".repeat(this.code.length) : null;
    }
    get maskedNumber() {
        return this.number != null ? "•".repeat(this.number.length) : null;
    }
    get brand() {
        return this._brand;
    }
    set brand(value) {
        this._brand = value;
        this._subTitle = null;
    }
    get number() {
        return this._number;
    }
    set number(value) {
        this._number = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null) {
            this._subTitle = this.brand;
            if (this.number != null && this.number.length >= 4) {
                if (this._subTitle != null && this._subTitle !== "") {
                    this._subTitle += ", ";
                }
                else {
                    this._subTitle = "";
                }
                // Show last 5 on amex, last 4 for all others
                const count = this.number.length >= 5 && this.number.match(new RegExp("^3[47]")) != null ? 5 : 4;
                this._subTitle += "*" + this.number.substr(this.number.length - count);
            }
        }
        return this._subTitle;
    }
    get expiration() {
        if (!this.expMonth && !this.expYear) {
            return null;
        }
        let exp = this.expMonth != null ? ("0" + this.expMonth).slice(-2) : "__";
        exp += " / " + (this.expYear != null ? this.formatYear(this.expYear) : "____");
        return exp;
    }
    formatYear(year) {
        return year.length === 2 ? "20" + year : year;
    }
    static fromJSON(obj) {
        return Object.assign(new CardView(), obj);
    }
    // ref https://stackoverflow.com/a/5911300
    static getCardBrandByPatterns(cardNum) {
        if (cardNum == null || typeof cardNum !== "string" || cardNum.trim() === "") {
            return null;
        }
        // Visa
        let re = new RegExp("^4");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        // Mastercard
        // Updated for Mastercard 2017 BINs expansion
        if (/^(5[1-5][0-9]{14}|2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12}))$/.test(cardNum)) {
            return "Mastercard";
        }
        // AMEX
        re = new RegExp("^3[47]");
        if (cardNum.match(re) != null) {
            return "Amex";
        }
        // Discover
        re = new RegExp("^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)");
        if (cardNum.match(re) != null) {
            return "Discover";
        }
        // Diners
        re = new RegExp("^36");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // Diners - Carte Blanche
        re = new RegExp("^30[0-5]");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // JCB
        re = new RegExp("^35(2[89]|[3-8][0-9])");
        if (cardNum.match(re) != null) {
            return "JCB";
        }
        // Visa Electron
        re = new RegExp("^(4026|417500|4508|4844|491(3|7))");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        return null;
    }
}
__decorate([
    linkedFieldOption(CardLinkedId.CardholderName),
    __metadata("design:type", String)
], CardView.prototype, "cardholderName", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpMonth, "expirationMonth"),
    __metadata("design:type", String)
], CardView.prototype, "expMonth", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpYear, "expirationYear"),
    __metadata("design:type", String)
], CardView.prototype, "expYear", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Code, "securityCode"),
    __metadata("design:type", String)
], CardView.prototype, "code", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Brand),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "brand", null);
__decorate([
    linkedFieldOption(CardLinkedId.Number),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "number", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/card.ts




class Card extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new CardView(), {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, orgId, encKey);
    }
    toCardData() {
        const c = new CardData();
        this.buildDataModel(this, c, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        });
        return c;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const cardholderName = EncString.fromJSON(obj.cardholderName);
        const brand = EncString.fromJSON(obj.brand);
        const number = EncString.fromJSON(obj.number);
        const expMonth = EncString.fromJSON(obj.expMonth);
        const expYear = EncString.fromJSON(obj.expYear);
        const code = EncString.fromJSON(obj.code);
        return Object.assign(new Card(), obj, {
            cardholderName,
            brand,
            number,
            expMonth,
            expYear,
            code,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/utils.ts
function safeGetString(value) {
    if (value == null) {
        return null;
    }
    if (typeof value == "string") {
        return value;
    }
    return value === null || value === void 0 ? void 0 : value.encryptedString;
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/card.export.ts




class CardExport {
    static template() {
        const req = new CardExport();
        req.cardholderName = "John Doe";
        req.brand = "visa";
        req.number = "4242424242424242";
        req.expMonth = "04";
        req.expYear = "2023";
        req.code = "123";
        return req;
    }
    static toView(req, view = new CardView()) {
        view.cardholderName = req.cardholderName;
        view.brand = req.brand;
        view.number = req.number;
        view.expMonth = req.expMonth;
        view.expYear = req.expYear;
        view.code = req.code;
        return view;
    }
    static toDomain(req, domain = new Card()) {
        domain.cardholderName = req.cardholderName != null ? new EncString(req.cardholderName) : null;
        domain.brand = req.brand != null ? new EncString(req.brand) : null;
        domain.number = req.number != null ? new EncString(req.number) : null;
        domain.expMonth = req.expMonth != null ? new EncString(req.expMonth) : null;
        domain.expYear = req.expYear != null ? new EncString(req.expYear) : null;
        domain.code = req.code != null ? new EncString(req.code) : null;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.cardholderName = safeGetString(o.cardholderName);
        this.brand = safeGetString(o.brand);
        this.number = safeGetString(o.number);
        this.expMonth = safeGetString(o.expMonth);
        this.expYear = safeGetString(o.expYear);
        this.code = safeGetString(o.code);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/cryptography/initializer-key.ts
var InitializerKey;
(function (InitializerKey) {
    InitializerKey[InitializerKey["Cipher"] = 0] = "Cipher";
    InitializerKey[InitializerKey["CipherView"] = 1] = "CipherView";
})(InitializerKey || (InitializerKey = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/attachment.data.ts
class AttachmentData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.url = response.url;
        this.fileName = response.fileName;
        this.key = response.key;
        this.size = response.size;
        this.sizeName = response.sizeName;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/field.data.ts
class FieldData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.type = response.type;
        this.name = response.name;
        this.value = response.value;
        this.linkedId = response.linkedId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/identity.data.ts
class IdentityData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.title = data.title;
        this.firstName = data.firstName;
        this.middleName = data.middleName;
        this.lastName = data.lastName;
        this.address1 = data.address1;
        this.address2 = data.address2;
        this.address3 = data.address3;
        this.city = data.city;
        this.state = data.state;
        this.postalCode = data.postalCode;
        this.country = data.country;
        this.company = data.company;
        this.email = data.email;
        this.phone = data.phone;
        this.ssn = data.ssn;
        this.username = data.username;
        this.passportNumber = data.passportNumber;
        this.licenseNumber = data.licenseNumber;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/fido2-credential.data.ts
class Fido2CredentialData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.credentialId = data.credentialId;
        this.keyType = data.keyType;
        this.keyAlgorithm = data.keyAlgorithm;
        this.keyCurve = data.keyCurve;
        this.keyValue = data.keyValue;
        this.rpId = data.rpId;
        this.userHandle = data.userHandle;
        this.userName = data.userName;
        this.counter = data.counter;
        this.rpName = data.rpName;
        this.userDisplayName = data.userDisplayName;
        this.discoverable = data.discoverable;
        this.creationDate = data.creationDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login-uri.data.ts
class LoginUriData {
    constructor(data) {
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = data.uri;
        this.uriChecksum = data.uriChecksum;
        this.match = data.match;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login.data.ts


class LoginData {
    constructor(data) {
        var _a;
        if (data == null) {
            return;
        }
        this.username = data.username;
        this.password = data.password;
        this.passwordRevisionDate = data.passwordRevisionDate;
        this.totp = data.totp;
        this.autofillOnPageLoad = data.autofillOnPageLoad;
        if (data.uris) {
            this.uris = data.uris.map((u) => new LoginUriData(u));
        }
        if (data.fido2Credentials) {
            this.fido2Credentials = (_a = data.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => new Fido2CredentialData(key));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/password-history.data.ts
class PasswordHistoryData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.password = response.password;
        this.lastUsedDate = response.lastUsedDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/secure-note.data.ts
class SecureNoteData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.type = data.type;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/cipher.data.ts








class CipherData {
    constructor(response, collectionIds) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.folderId = response.folderId;
        this.edit = response.edit;
        this.viewPassword = response.viewPassword;
        this.organizationUseTotp = response.organizationUseTotp;
        this.favorite = response.favorite;
        this.revisionDate = response.revisionDate;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.collectionIds = collectionIds != null ? collectionIds : response.collectionIds;
        this.creationDate = response.creationDate;
        this.deletedDate = response.deletedDate;
        this.reprompt = response.reprompt;
        this.key = response.key;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginData(response.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteData(response.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardData(response.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityData(response.identity);
                break;
            default:
                break;
        }
        if (response.fields != null) {
            this.fields = response.fields.map((f) => new FieldData(f));
        }
        if (response.attachments != null) {
            this.attachments = response.attachments.map((a) => new AttachmentData(a));
        }
        if (response.passwordHistory != null) {
            this.passwordHistory = response.passwordHistory.map((ph) => new PasswordHistoryData(ph));
        }
    }
    static fromJSON(obj) {
        return Object.assign(new CipherData(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/attachment.view.ts

class AttachmentView {
    constructor(a) {
        this.id = null;
        this.url = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        this.key = null;
        if (!a) {
            return;
        }
        this.id = a.id;
        this.url = a.url;
        this.size = a.size;
        this.sizeName = a.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(obj) {
        const key = obj.key == null ? null : SymmetricCryptoKey.fromJSON(obj.key);
        return Object.assign(new AttachmentView(), obj, { key: key });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/field.view.ts
class FieldView {
    constructor(f) {
        this.name = null;
        this.value = null;
        this.type = null;
        this.newField = false; // Marks if the field is new and hasn't been saved
        this.showValue = false;
        this.showCount = false;
        this.linkedId = null;
        if (!f) {
            return;
        }
        this.type = f.type;
        this.linkedId = f.linkedId;
    }
    get maskedValue() {
        return this.value != null ? "••••••••" : null;
    }
    static fromJSON(obj) {
        return Object.assign(new FieldView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/identity.view.ts
var identity_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var identity_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




class IdentityView extends ItemView {
    constructor() {
        super();
        this.title = null;
        this.middleName = null;
        this.address1 = null;
        this.address2 = null;
        this.address3 = null;
        this.city = null;
        this.state = null;
        this.postalCode = null;
        this.country = null;
        this.company = null;
        this.email = null;
        this.phone = null;
        this.ssn = null;
        this.username = null;
        this.passportNumber = null;
        this.licenseNumber = null;
        this._firstName = null;
        this._lastName = null;
        this._subTitle = null;
    }
    get firstName() {
        return this._firstName;
    }
    set firstName(value) {
        this._firstName = value;
        this._subTitle = null;
    }
    get lastName() {
        return this._lastName;
    }
    set lastName(value) {
        this._lastName = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null && (this.firstName != null || this.lastName != null)) {
            this._subTitle = "";
            if (this.firstName != null) {
                this._subTitle = this.firstName;
            }
            if (this.lastName != null) {
                if (this._subTitle !== "") {
                    this._subTitle += " ";
                }
                this._subTitle += this.lastName;
            }
        }
        return this._subTitle;
    }
    get fullName() {
        if (this.title != null ||
            this.firstName != null ||
            this.middleName != null ||
            this.lastName != null) {
            let name = "";
            if (this.title != null) {
                name += this.title + " ";
            }
            if (this.firstName != null) {
                name += this.firstName + " ";
            }
            if (this.middleName != null) {
                name += this.middleName + " ";
            }
            if (this.lastName != null) {
                name += this.lastName;
            }
            return name.trim();
        }
        return null;
    }
    get fullAddress() {
        let address = this.address1;
        if (!Utils.isNullOrWhitespace(this.address2)) {
            if (!Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address2;
        }
        if (!Utils.isNullOrWhitespace(this.address3)) {
            if (!Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address3;
        }
        return address;
    }
    get fullAddressPart2() {
        if (this.city == null && this.state == null && this.postalCode == null) {
            return null;
        }
        const city = this.city || "-";
        const state = this.state;
        const postalCode = this.postalCode || "-";
        let addressPart2 = city;
        if (!Utils.isNullOrWhitespace(state)) {
            addressPart2 += ", " + state;
        }
        addressPart2 += ", " + postalCode;
        return addressPart2;
    }
    get fullAddressForCopy() {
        let address = this.fullAddress;
        if (this.city != null || this.state != null || this.postalCode != null) {
            address += "\n" + this.fullAddressPart2;
        }
        if (this.country != null) {
            address += "\n" + this.country;
        }
        return address;
    }
    static fromJSON(obj) {
        return Object.assign(new IdentityView(), obj);
    }
}
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Title),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "title", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.MiddleName),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "middleName", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address1),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address1", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address2),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address2", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address3),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address3", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.City, "cityTown"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "city", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.State, "stateProvince"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "state", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PostalCode, "zipPostalCode"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "postalCode", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Country),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "country", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Company),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "company", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Email),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "email", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Phone),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "phone", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Ssn),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "ssn", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Username),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "username", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PassportNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "passportNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LicenseNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "licenseNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FirstName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "firstName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LastName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "lastName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FullName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [])
], IdentityView.prototype, "fullName", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/fido2-credential.view.ts

class Fido2CredentialView extends ItemView {
    constructor() {
        super(...arguments);
        this.creationDate = null;
    }
    get subTitle() {
        return this.userDisplayName;
    }
    static fromJSON(obj) {
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2CredentialView(), obj, {
            creationDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/domain-service.ts
/*
  See full documentation at:
    https://bitwarden.com/help/uri-match-detection/#match-detection-options

  Domain: "the top-level domain and second-level domain of the URI match the detected resource",
  Host: "the hostname and (if specified) port of the URI matches the detected resource",
  StartsWith: "the detected resource starts with the URI, regardless of what follows it",
  Exact: "the URI matches the detected resource exactly",
  RegularExpression: "the detected resource matches a specified regular expression",
  Never: "never offer auto-fill for the item",
*/
const UriMatchStrategy = {
    Domain: 0,
    Host: 1,
    StartsWith: 2,
    Exact: 3,
    RegularExpression: 4,
    Never: 5,
};

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/safe-urls.ts

const CanLaunchWhitelist = [
    "https://",
    "http://",
    "ssh://",
    "ftp://",
    "sftp://",
    "irc://",
    "vnc://",
    // https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/remote-desktop-uri
    "rdp://",
    "ms-rd:",
    "chrome://",
    "iosapp://",
    "androidapp://",
];
class SafeUrls {
    static canLaunch(uri) {
        if (Utils.isNullOrWhitespace(uri)) {
            return false;
        }
        for (let i = 0; i < CanLaunchWhitelist.length; i++) {
            if (uri.indexOf(CanLaunchWhitelist[i]) === 0) {
                return true;
            }
        }
        return false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login-uri.view.ts



class LoginUriView {
    constructor(u) {
        this.match = null;
        this._uri = null;
        this._domain = null;
        this._hostname = null;
        this._host = null;
        this._canLaunch = null;
        if (!u) {
            return;
        }
        this.match = u.match;
    }
    get uri() {
        return this._uri;
    }
    set uri(value) {
        this._uri = value;
        this._domain = null;
        this._canLaunch = null;
    }
    get domain() {
        if (this._domain == null && this.uri != null) {
            this._domain = Utils.getDomain(this.uri);
            if (this._domain === "") {
                this._domain = null;
            }
        }
        return this._domain;
    }
    get hostname() {
        if (this.match === UriMatchStrategy.RegularExpression) {
            return null;
        }
        if (this._hostname == null && this.uri != null) {
            this._hostname = Utils.getHostname(this.uri);
            if (this._hostname === "") {
                this._hostname = null;
            }
        }
        return this._hostname;
    }
    get host() {
        if (this.match === UriMatchStrategy.RegularExpression) {
            return null;
        }
        if (this._host == null && this.uri != null) {
            this._host = Utils.getHost(this.uri);
            if (this._host === "") {
                this._host = null;
            }
        }
        return this._host;
    }
    get hostnameOrUri() {
        return this.hostname != null ? this.hostname : this.uri;
    }
    get hostOrUri() {
        return this.host != null ? this.host : this.uri;
    }
    get isWebsite() {
        return (this.uri != null &&
            (this.uri.indexOf("http://") === 0 ||
                this.uri.indexOf("https://") === 0 ||
                (this.uri.indexOf("://") < 0 && !Utils.isNullOrWhitespace(Utils.getDomain(this.uri)))));
    }
    get canLaunch() {
        if (this._canLaunch != null) {
            return this._canLaunch;
        }
        if (this.uri != null && this.match !== UriMatchStrategy.RegularExpression) {
            this._canLaunch = SafeUrls.canLaunch(this.launchUri);
        }
        else {
            this._canLaunch = false;
        }
        return this._canLaunch;
    }
    get launchUri() {
        return this.uri.indexOf("://") < 0 && !Utils.isNullOrWhitespace(Utils.getDomain(this.uri))
            ? "http://" + this.uri
            : this.uri;
    }
    static fromJSON(obj) {
        return Object.assign(new LoginUriView(), obj);
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        var _a;
        if (!this.uri || !targetUri) {
            return false;
        }
        let matchType = (_a = this.match) !== null && _a !== void 0 ? _a : defaultUriMatch;
        matchType !== null && matchType !== void 0 ? matchType : (matchType = UriMatchStrategy.Domain);
        const targetDomain = Utils.getDomain(targetUri);
        const matchDomains = equivalentDomains.add(targetDomain);
        switch (matchType) {
            case UriMatchStrategy.Domain:
                return this.matchesDomain(targetUri, matchDomains);
            case UriMatchStrategy.Host: {
                const urlHost = Utils.getHost(targetUri);
                return urlHost != null && urlHost === Utils.getHost(this.uri);
            }
            case UriMatchStrategy.Exact:
                return targetUri === this.uri;
            case UriMatchStrategy.StartsWith:
                return targetUri.startsWith(this.uri);
            case UriMatchStrategy.RegularExpression:
                try {
                    const regex = new RegExp(this.uri, "i");
                    return regex.test(targetUri);
                }
                catch (e) {
                    // Invalid regex
                    return false;
                }
            case UriMatchStrategy.Never:
                return false;
            default:
                break;
        }
        return false;
    }
    matchesDomain(targetUri, matchDomains) {
        if (targetUri == null || this.domain == null || !matchDomains.has(this.domain)) {
            return false;
        }
        if (Utils.DomainMatchBlacklist.has(this.domain)) {
            const domainUrlHost = Utils.getHost(targetUri);
            return !Utils.DomainMatchBlacklist.get(this.domain).has(domainUrlHost);
        }
        return true;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login.view.ts
var login_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var login_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






class LoginView extends ItemView {
    constructor(l) {
        super();
        this.username = null;
        this.password = null;
        this.passwordRevisionDate = null;
        this.totp = null;
        this.uris = [];
        this.autofillOnPageLoad = null;
        this.fido2Credentials = null;
        if (!l) {
            return;
        }
        this.passwordRevisionDate = l.passwordRevisionDate;
        this.autofillOnPageLoad = l.autofillOnPageLoad;
    }
    get uri() {
        return this.hasUris ? this.uris[0].uri : null;
    }
    get maskedPassword() {
        return this.password != null ? "••••••••" : null;
    }
    get subTitle() {
        var _a;
        // if there's a passkey available, use that as a fallback
        if (Utils.isNullOrEmpty(this.username) && ((_a = this.fido2Credentials) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            return this.fido2Credentials[0].userName;
        }
        return this.username;
    }
    get canLaunch() {
        return this.hasUris && this.uris.some((u) => u.canLaunch);
    }
    get hasTotp() {
        return !Utils.isNullOrWhitespace(this.totp);
    }
    get launchUri() {
        if (this.hasUris) {
            const uri = this.uris.find((u) => u.canLaunch);
            if (uri != null) {
                return uri.launchUri;
            }
        }
        return null;
    }
    get hasUris() {
        return this.uris != null && this.uris.length > 0;
    }
    get hasFido2Credentials() {
        return this.fido2Credentials != null && this.fido2Credentials.length > 0;
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        if (this.uris == null) {
            return false;
        }
        return this.uris.some((uri) => uri.matchesUri(targetUri, equivalentDomains, defaultUriMatch));
    }
    static fromJSON(obj) {
        var _a;
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = obj.uris.map((uri) => LoginUriView.fromJSON(uri));
        const fido2Credentials = (_a = obj.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => Fido2CredentialView.fromJSON(key));
        return Object.assign(new LoginView(), obj, {
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
}
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Username),
    login_view_metadata("design:type", String)
], LoginView.prototype, "username", void 0);
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Password),
    login_view_metadata("design:type", String)
], LoginView.prototype, "password", void 0);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/password-history.view.ts
class PasswordHistoryView {
    constructor(ph) {
        this.password = null;
        this.lastUsedDate = null;
        if (!ph) {
            return;
        }
        this.lastUsedDate = ph.lastUsedDate;
    }
    static fromJSON(obj) {
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new PasswordHistoryView(), obj, {
            lastUsedDate: lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/secure-note.view.ts

class SecureNoteView extends ItemView {
    constructor(n) {
        super();
        this.type = null;
        if (!n) {
            return;
        }
        this.type = n.type;
    }
    get subTitle() {
        return null;
    }
    static fromJSON(obj) {
        return Object.assign(new SecureNoteView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/cipher.view.ts










class CipherView {
    constructor(c) {
        var _a;
        this.initializerKey = InitializerKey.CipherView;
        this.id = null;
        this.organizationId = null;
        this.folderId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.favorite = false;
        this.organizationUseTotp = false;
        this.edit = false;
        this.viewPassword = true;
        this.login = new LoginView();
        this.identity = new IdentityView();
        this.card = new CardView();
        this.secureNote = new SecureNoteView();
        this.attachments = null;
        this.fields = null;
        this.passwordHistory = null;
        this.collectionIds = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
        this.reprompt = CipherRepromptType.None;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.folderId = c.folderId;
        this.favorite = c.favorite;
        this.organizationUseTotp = c.organizationUseTotp;
        this.edit = c.edit;
        this.viewPassword = c.viewPassword;
        this.type = c.type;
        this.localData = c.localData;
        this.collectionIds = c.collectionIds;
        this.revisionDate = c.revisionDate;
        this.creationDate = c.creationDate;
        this.deletedDate = c.deletedDate;
        // Old locally stored ciphers might have reprompt == null. If so set it to None.
        this.reprompt = (_a = c.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
    }
    get item() {
        switch (this.type) {
            case CipherType.Login:
                return this.login;
            case CipherType.SecureNote:
                return this.secureNote;
            case CipherType.Card:
                return this.card;
            case CipherType.Identity:
                return this.identity;
            default:
                break;
        }
        return null;
    }
    get subTitle() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.subTitle;
    }
    get hasPasswordHistory() {
        return this.passwordHistory && this.passwordHistory.length > 0;
    }
    get hasAttachments() {
        return this.attachments && this.attachments.length > 0;
    }
    get hasOldAttachments() {
        if (this.hasAttachments) {
            for (let i = 0; i < this.attachments.length; i++) {
                if (this.attachments[i].key == null) {
                    return true;
                }
            }
        }
        return false;
    }
    get hasFields() {
        return this.fields && this.fields.length > 0;
    }
    get passwordRevisionDisplayDate() {
        if (this.type !== CipherType.Login || this.login == null) {
            return null;
        }
        else if (this.login.password == null || this.login.password === "") {
            return null;
        }
        return this.login.passwordRevisionDate;
    }
    get isDeleted() {
        return this.deletedDate != null;
    }
    get linkedFieldOptions() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.linkedFieldOptions;
    }
    get isUnassigned() {
        return (this.organizationId != null && (this.collectionIds == null || this.collectionIds.length === 0));
    }
    linkedFieldValue(id) {
        var _a;
        const linkedFieldOption = (_a = this.linkedFieldOptions) === null || _a === void 0 ? void 0 : _a.get(id);
        if (linkedFieldOption == null) {
            return null;
        }
        const item = this.item;
        return this.item[linkedFieldOption.propertyKey];
    }
    linkedFieldI18nKey(id) {
        var _a;
        return (_a = this.linkedFieldOptions.get(id)) === null || _a === void 0 ? void 0 : _a.i18nKey;
    }
    // This is used as a marker to indicate that the cipher view object still has its prototype
    toJSON() {
        return this;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const view = new CipherView();
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => AttachmentView.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => FieldView.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => PasswordHistoryView.fromJSON(ph));
        Object.assign(view, obj, {
            revisionDate: revisionDate,
            deletedDate: deletedDate,
            attachments: attachments,
            fields: fields,
            passwordHistory: passwordHistory,
        });
        switch (obj.type) {
            case CipherType.Card:
                view.card = CardView.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityView.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                view.login = LoginView.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteView.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return view;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/attachment.ts
var attachment_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Attachment extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
    }
    decrypt(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new AttachmentView(this), {
                fileName: null,
            }, orgId, encKey);
            if (this.key != null) {
                view.key = yield this.decryptAttachmentKey(orgId, encKey);
            }
            return view;
        });
    }
    decryptAttachmentKey(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            try {
                if (encKey == null) {
                    encKey = yield this.getKeyForDecryption(orgId);
                }
                const encryptService = Utils.getContainerService().getEncryptService();
                const decValue = yield encryptService.decryptToBytes(this.key, encKey);
                return new SymmetricCryptoKey(decValue);
            }
            catch (e) {
                // TODO: error?
            }
        });
    }
    getKeyForDecryption(orgId) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const cryptoService = Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getUserKeyWithLegacySupport();
        });
    }
    toAttachmentData() {
        const a = new AttachmentData();
        a.size = this.size;
        this.buildDataModel(this, a, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
        return a;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const key = EncString.fromJSON(obj.key);
        const fileName = EncString.fromJSON(obj.fileName);
        return Object.assign(new Attachment(), obj, {
            key,
            fileName,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/field.ts




class Field extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
        this.linkedId = obj.linkedId;
        this.buildDomainModel(this, obj, {
            name: null,
            value: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new FieldView(this), {
            name: null,
            value: null,
        }, orgId, encKey);
    }
    toFieldData() {
        const f = new FieldData();
        this.buildDataModel(this, f, {
            name: null,
            value: null,
            type: null,
            linkedId: null,
        }, ["type", "linkedId"]);
        return f;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const name = EncString.fromJSON(obj.name);
        const value = EncString.fromJSON(obj.value);
        return Object.assign(new Field(), obj, {
            name,
            value,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/identity.ts




class Identity extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new IdentityView(), {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, orgId, encKey);
    }
    toIdentityData() {
        const i = new IdentityData();
        this.buildDataModel(this, i, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const title = EncString.fromJSON(obj.title);
        const firstName = EncString.fromJSON(obj.firstName);
        const middleName = EncString.fromJSON(obj.middleName);
        const lastName = EncString.fromJSON(obj.lastName);
        const address1 = EncString.fromJSON(obj.address1);
        const address2 = EncString.fromJSON(obj.address2);
        const address3 = EncString.fromJSON(obj.address3);
        const city = EncString.fromJSON(obj.city);
        const state = EncString.fromJSON(obj.state);
        const postalCode = EncString.fromJSON(obj.postalCode);
        const country = EncString.fromJSON(obj.country);
        const company = EncString.fromJSON(obj.company);
        const email = EncString.fromJSON(obj.email);
        const phone = EncString.fromJSON(obj.phone);
        const ssn = EncString.fromJSON(obj.ssn);
        const username = EncString.fromJSON(obj.username);
        const passportNumber = EncString.fromJSON(obj.passportNumber);
        const licenseNumber = EncString.fromJSON(obj.licenseNumber);
        return Object.assign(new Identity(), obj, {
            title,
            firstName,
            middleName,
            lastName,
            address1,
            address2,
            address3,
            city,
            state,
            postalCode,
            country,
            company,
            email,
            phone,
            ssn,
            username,
            passportNumber,
            licenseNumber,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/fido2-credential.ts
var fido2_credential_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class Fido2Credential extends Domain {
    constructor(obj) {
        super();
        this.credentialId = null;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        }, []);
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
    }
    decrypt(orgId, encKey) {
        return fido2_credential_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new Fido2CredentialView(), {
                credentialId: null,
                keyType: null,
                keyAlgorithm: null,
                keyCurve: null,
                keyValue: null,
                rpId: null,
                userHandle: null,
                userName: null,
                rpName: null,
                userDisplayName: null,
                discoverable: null,
            }, orgId, encKey);
            const { counter } = yield this.decryptObj({ counter: "" }, {
                counter: null,
            }, orgId, encKey);
            // Counter will end up as NaN if this fails
            view.counter = parseInt(counter);
            const { discoverable } = yield this.decryptObj({ discoverable: "" }, {
                discoverable: null,
            }, orgId, encKey);
            view.discoverable = discoverable === "true";
            view.creationDate = this.creationDate;
            return view;
        });
    }
    toFido2CredentialData() {
        const i = new Fido2CredentialData();
        i.creationDate = this.creationDate.toISOString();
        this.buildDataModel(this, i, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const credentialId = EncString.fromJSON(obj.credentialId);
        const keyType = EncString.fromJSON(obj.keyType);
        const keyAlgorithm = EncString.fromJSON(obj.keyAlgorithm);
        const keyCurve = EncString.fromJSON(obj.keyCurve);
        const keyValue = EncString.fromJSON(obj.keyValue);
        const rpId = EncString.fromJSON(obj.rpId);
        const userHandle = EncString.fromJSON(obj.userHandle);
        const userName = EncString.fromJSON(obj.userName);
        const counter = EncString.fromJSON(obj.counter);
        const rpName = EncString.fromJSON(obj.rpName);
        const userDisplayName = EncString.fromJSON(obj.userDisplayName);
        const discoverable = EncString.fromJSON(obj.discoverable);
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2Credential(), obj, {
            credentialId,
            keyType,
            keyAlgorithm,
            keyCurve,
            keyValue,
            rpId,
            userHandle,
            userName,
            counter,
            rpName,
            userDisplayName,
            discoverable,
            creationDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login-uri.ts
var login_uri_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class LoginUri extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.match = obj.match;
        this.buildDomainModel(this, obj, {
            uri: null,
            uriChecksum: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new LoginUriView(this), {
            uri: null,
        }, orgId, encKey);
    }
    validateChecksum(clearTextUri, orgId, encKey) {
        return login_uri_awaiter(this, void 0, void 0, function* () {
            if (this.uriChecksum == null) {
                return false;
            }
            const cryptoService = Utils.getContainerService().getEncryptService();
            const localChecksum = yield cryptoService.hash(clearTextUri, "sha256");
            const remoteChecksum = yield this.uriChecksum.decrypt(orgId, encKey);
            return remoteChecksum === localChecksum;
        });
    }
    toLoginUriData() {
        const u = new LoginUriData();
        this.buildDataModel(this, u, {
            uri: null,
            uriChecksum: null,
            match: null,
        }, ["match"]);
        return u;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const uri = EncString.fromJSON(obj.uri);
        const uriChecksum = EncString.fromJSON(obj.uriChecksum);
        return Object.assign(new LoginUri(), obj, {
            uri,
            uriChecksum,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login.ts
var login_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Login extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.passwordRevisionDate =
            obj.passwordRevisionDate != null ? new Date(obj.passwordRevisionDate) : null;
        this.autofillOnPageLoad = obj.autofillOnPageLoad;
        this.buildDomainModel(this, obj, {
            username: null,
            password: null,
            totp: null,
        }, []);
        if (obj.uris) {
            this.uris = [];
            obj.uris.forEach((u) => {
                this.uris.push(new LoginUri(u));
            });
        }
        if (obj.fido2Credentials) {
            this.fido2Credentials = obj.fido2Credentials.map((key) => new Fido2Credential(key));
        }
    }
    decrypt(orgId, bypassValidation, encKey) {
        return login_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new LoginView(this), {
                username: null,
                password: null,
                totp: null,
            }, orgId, encKey);
            if (this.uris != null) {
                view.uris = [];
                for (let i = 0; i < this.uris.length; i++) {
                    // If the uri is null, there is nothing to decrypt or validate
                    if (this.uris[i].uri == null) {
                        continue;
                    }
                    const uri = yield this.uris[i].decrypt(orgId, encKey);
                    // URIs are shared remotely after decryption
                    // we need to validate that the string hasn't been changed by a compromised server
                    // This validation is tied to the existence of cypher.key for backwards compatibility
                    // So we bypass the validation if there's no cipher.key or procceed with the validation and
                    // Skip the value if it's been tampered with.
                    if (bypassValidation || (yield this.uris[i].validateChecksum(uri.uri, orgId, encKey))) {
                        view.uris.push(uri);
                    }
                }
            }
            if (this.fido2Credentials != null) {
                view.fido2Credentials = yield Promise.all(this.fido2Credentials.map((key) => key.decrypt(orgId, encKey)));
            }
            return view;
        });
    }
    toLoginData() {
        const l = new LoginData();
        l.passwordRevisionDate =
            this.passwordRevisionDate != null ? this.passwordRevisionDate.toISOString() : null;
        l.autofillOnPageLoad = this.autofillOnPageLoad;
        this.buildDataModel(this, l, {
            username: null,
            password: null,
            totp: null,
        });
        if (this.uris != null && this.uris.length > 0) {
            l.uris = [];
            this.uris.forEach((u) => {
                l.uris.push(u.toLoginUriData());
            });
        }
        if (this.fido2Credentials != null && this.fido2Credentials.length > 0) {
            l.fido2Credentials = this.fido2Credentials.map((key) => key.toFido2CredentialData());
        }
        return l;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const username = EncString.fromJSON(obj.username);
        const password = EncString.fromJSON(obj.password);
        const totp = EncString.fromJSON(obj.totp);
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUri.fromJSON(uri));
        const fido2Credentials = (_c = (_b = obj.fido2Credentials) === null || _b === void 0 ? void 0 : _b.map((key) => Fido2Credential.fromJSON(key))) !== null && _c !== void 0 ? _c : [];
        return Object.assign(new Login(), obj, {
            username,
            password,
            totp,
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/password.ts




class Password extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            password: null,
        });
        this.lastUsedDate = new Date(obj.lastUsedDate);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new PasswordHistoryView(this), {
            password: null,
        }, orgId, encKey);
    }
    toPasswordHistoryData() {
        const ph = new PasswordHistoryData();
        ph.lastUsedDate = this.lastUsedDate.toISOString();
        this.buildDataModel(this, ph, {
            password: null,
        });
        return ph;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const password = EncString.fromJSON(obj.password);
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new Password(), obj, {
            password,
            lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/secure-note.ts



class SecureNote extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
    }
    decrypt(orgId, encKey) {
        return Promise.resolve(new SecureNoteView(this));
    }
    toSecureNoteData() {
        const n = new SecureNoteData();
        n.type = this.type;
        return n;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SecureNote(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/cipher.ts
var cipher_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class Cipher extends Domain {
    constructor(obj, localData = null) {
        super();
        this.initializerKey = InitializerKey.Cipher;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            folderId: null,
            name: null,
            notes: null,
            key: null,
        }, ["id", "organizationId", "folderId"]);
        this.type = obj.type;
        this.favorite = obj.favorite;
        this.organizationUseTotp = obj.organizationUseTotp;
        this.edit = obj.edit;
        if (obj.viewPassword != null) {
            this.viewPassword = obj.viewPassword;
        }
        else {
            this.viewPassword = true; // Default for already synced Ciphers without viewPassword
        }
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.collectionIds = obj.collectionIds;
        this.localData = localData;
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        this.deletedDate = obj.deletedDate != null ? new Date(obj.deletedDate) : null;
        this.reprompt = obj.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new Login(obj.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNote(obj.secureNote);
                break;
            case CipherType.Card:
                this.card = new Card(obj.card);
                break;
            case CipherType.Identity:
                this.identity = new Identity(obj.identity);
                break;
            default:
                break;
        }
        if (obj.attachments != null) {
            this.attachments = obj.attachments.map((a) => new Attachment(a));
        }
        else {
            this.attachments = null;
        }
        if (obj.fields != null) {
            this.fields = obj.fields.map((f) => new Field(f));
        }
        else {
            this.fields = null;
        }
        if (obj.passwordHistory != null) {
            this.passwordHistory = obj.passwordHistory.map((ph) => new Password(ph));
        }
        else {
            this.passwordHistory = null;
        }
    }
    // We are passing the organizationId into the EncString.decrypt() method here, but because the encKey will always be
    // present and so the organizationId will not be used.
    // We will refactor the EncString.decrypt() in https://bitwarden.atlassian.net/browse/PM-3762 to remove the dependency on the organizationId.
    decrypt(encKey) {
        return cipher_awaiter(this, void 0, void 0, function* () {
            const model = new CipherView(this);
            let bypassValidation = true;
            if (this.key != null) {
                const encryptService = Utils.getContainerService().getEncryptService();
                encKey = new SymmetricCryptoKey(yield encryptService.decryptToBytes(this.key, encKey));
                bypassValidation = false;
            }
            yield this.decryptObj(model, {
                name: null,
                notes: null,
            }, this.organizationId, encKey);
            switch (this.type) {
                case CipherType.Login:
                    model.login = yield this.login.decrypt(this.organizationId, bypassValidation, encKey);
                    break;
                case CipherType.SecureNote:
                    model.secureNote = yield this.secureNote.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Card:
                    model.card = yield this.card.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Identity:
                    model.identity = yield this.identity.decrypt(this.organizationId, encKey);
                    break;
                default:
                    break;
            }
            if (this.attachments != null && this.attachments.length > 0) {
                const attachments = [];
                yield this.attachments.reduce((promise, attachment) => {
                    return promise
                        .then(() => {
                        return attachment.decrypt(this.organizationId, encKey);
                    })
                        .then((decAttachment) => {
                        attachments.push(decAttachment);
                    });
                }, Promise.resolve());
                model.attachments = attachments;
            }
            if (this.fields != null && this.fields.length > 0) {
                const fields = [];
                yield this.fields.reduce((promise, field) => {
                    return promise
                        .then(() => {
                        return field.decrypt(this.organizationId, encKey);
                    })
                        .then((decField) => {
                        fields.push(decField);
                    });
                }, Promise.resolve());
                model.fields = fields;
            }
            if (this.passwordHistory != null && this.passwordHistory.length > 0) {
                const passwordHistory = [];
                yield this.passwordHistory.reduce((promise, ph) => {
                    return promise
                        .then(() => {
                        return ph.decrypt(this.organizationId, encKey);
                    })
                        .then((decPh) => {
                        passwordHistory.push(decPh);
                    });
                }, Promise.resolve());
                model.passwordHistory = passwordHistory;
            }
            return model;
        });
    }
    toCipherData() {
        var _a;
        const c = new CipherData();
        c.id = this.id;
        c.organizationId = this.organizationId;
        c.folderId = this.folderId;
        c.edit = this.edit;
        c.viewPassword = this.viewPassword;
        c.organizationUseTotp = this.organizationUseTotp;
        c.favorite = this.favorite;
        c.revisionDate = this.revisionDate != null ? this.revisionDate.toISOString() : null;
        c.type = this.type;
        c.collectionIds = this.collectionIds;
        c.creationDate = this.creationDate != null ? this.creationDate.toISOString() : null;
        c.deletedDate = this.deletedDate != null ? this.deletedDate.toISOString() : null;
        c.reprompt = this.reprompt;
        c.key = (_a = this.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        this.buildDataModel(this, c, {
            name: null,
            notes: null,
        });
        switch (c.type) {
            case CipherType.Login:
                c.login = this.login.toLoginData();
                break;
            case CipherType.SecureNote:
                c.secureNote = this.secureNote.toSecureNoteData();
                break;
            case CipherType.Card:
                c.card = this.card.toCardData();
                break;
            case CipherType.Identity:
                c.identity = this.identity.toIdentityData();
                break;
            default:
                break;
        }
        if (this.fields != null) {
            c.fields = this.fields.map((f) => f.toFieldData());
        }
        if (this.attachments != null) {
            c.attachments = this.attachments.map((a) => a.toAttachmentData());
        }
        if (this.passwordHistory != null) {
            c.passwordHistory = this.passwordHistory.map((ph) => ph.toPasswordHistoryData());
        }
        return c;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const domain = new Cipher();
        const name = EncString.fromJSON(obj.name);
        const notes = EncString.fromJSON(obj.notes);
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => Attachment.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => Field.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => Password.fromJSON(ph));
        const key = EncString.fromJSON(obj.key);
        Object.assign(domain, obj, {
            name,
            notes,
            revisionDate,
            deletedDate,
            attachments,
            fields,
            passwordHistory,
            key,
        });
        switch (obj.type) {
            case CipherType.Card:
                domain.card = Card.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                domain.identity = Identity.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                domain.login = Login.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNote.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return domain;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/field.export.ts





class FieldExport {
    static template() {
        const req = new FieldExport();
        req.name = "Field name";
        req.value = "Some value";
        req.type = FieldType.Text;
        return req;
    }
    static toView(req, view = new FieldView()) {
        view.type = req.type;
        view.value = req.value;
        view.name = req.name;
        view.linkedId = req.linkedId;
        return view;
    }
    static toDomain(req, domain = new Field()) {
        domain.type = req.type;
        domain.value = req.value != null ? new EncString(req.value) : null;
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.linkedId = req.linkedId;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.name = safeGetString(o.name);
        this.value = safeGetString(o.value);
        this.type = o.type;
        this.linkedId = o.linkedId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/identity.export.ts




class IdentityExport {
    static template() {
        const req = new IdentityExport();
        req.title = "Mr";
        req.firstName = "John";
        req.middleName = "William";
        req.lastName = "Doe";
        req.address1 = "123 Any St";
        req.address2 = "Apt #123";
        req.address3 = null;
        req.city = "New York";
        req.state = "NY";
        req.postalCode = "10001";
        req.country = "US";
        req.company = "Acme Inc.";
        req.email = "john@company.com";
        req.phone = "5555551234";
        req.ssn = "000-123-4567";
        req.username = "jdoe";
        req.passportNumber = "US-123456789";
        req.licenseNumber = "D123-12-123-12333";
        return req;
    }
    static toView(req, view = new IdentityView()) {
        view.title = req.title;
        view.firstName = req.firstName;
        view.middleName = req.middleName;
        view.lastName = req.lastName;
        view.address1 = req.address1;
        view.address2 = req.address2;
        view.address3 = req.address3;
        view.city = req.city;
        view.state = req.state;
        view.postalCode = req.postalCode;
        view.country = req.country;
        view.company = req.company;
        view.email = req.email;
        view.phone = req.phone;
        view.ssn = req.ssn;
        view.username = req.username;
        view.passportNumber = req.passportNumber;
        view.licenseNumber = req.licenseNumber;
        return view;
    }
    static toDomain(req, domain = new Identity()) {
        domain.title = req.title != null ? new EncString(req.title) : null;
        domain.firstName = req.firstName != null ? new EncString(req.firstName) : null;
        domain.middleName = req.middleName != null ? new EncString(req.middleName) : null;
        domain.lastName = req.lastName != null ? new EncString(req.lastName) : null;
        domain.address1 = req.address1 != null ? new EncString(req.address1) : null;
        domain.address2 = req.address2 != null ? new EncString(req.address2) : null;
        domain.address3 = req.address3 != null ? new EncString(req.address3) : null;
        domain.city = req.city != null ? new EncString(req.city) : null;
        domain.state = req.state != null ? new EncString(req.state) : null;
        domain.postalCode = req.postalCode != null ? new EncString(req.postalCode) : null;
        domain.country = req.country != null ? new EncString(req.country) : null;
        domain.company = req.company != null ? new EncString(req.company) : null;
        domain.email = req.email != null ? new EncString(req.email) : null;
        domain.phone = req.phone != null ? new EncString(req.phone) : null;
        domain.ssn = req.ssn != null ? new EncString(req.ssn) : null;
        domain.username = req.username != null ? new EncString(req.username) : null;
        domain.passportNumber = req.passportNumber != null ? new EncString(req.passportNumber) : null;
        domain.licenseNumber = req.licenseNumber != null ? new EncString(req.licenseNumber) : null;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.title = safeGetString(o.title);
        this.firstName = safeGetString(o.firstName);
        this.middleName = safeGetString(o.middleName);
        this.lastName = safeGetString(o.lastName);
        this.address1 = safeGetString(o.address1);
        this.address2 = safeGetString(o.address2);
        this.address3 = safeGetString(o.address3);
        this.city = safeGetString(o.city);
        this.state = safeGetString(o.state);
        this.postalCode = safeGetString(o.postalCode);
        this.country = safeGetString(o.country);
        this.company = safeGetString(o.company);
        this.email = safeGetString(o.email);
        this.phone = safeGetString(o.phone);
        this.ssn = safeGetString(o.ssn);
        this.username = safeGetString(o.username);
        this.passportNumber = safeGetString(o.passportNumber);
        this.licenseNumber = safeGetString(o.licenseNumber);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/fido2-credential.export.ts




/**
 * Represents format of Fido2 Credentials in JSON exports.
 */
class Fido2CredentialExport {
    /**
     * Generates a template for Fido2CredentialExport
     * @returns Instance of Fido2CredentialExport with predefined values.
     */
    static template() {
        const req = new Fido2CredentialExport();
        req.credentialId = "keyId";
        req.keyType = "keyType";
        req.keyAlgorithm = "keyAlgorithm";
        req.keyCurve = "keyCurve";
        req.keyValue = "keyValue";
        req.rpId = "rpId";
        req.userHandle = "userHandle";
        req.userName = "userName";
        req.counter = "counter";
        req.rpName = "rpName";
        req.userDisplayName = "userDisplayName";
        req.discoverable = "false";
        req.creationDate = null;
        return req;
    }
    /**
     * Converts a Fido2CredentialExport object to its view representation.
     * @param req - The Fido2CredentialExport object to be converted.
     * @param view - (Optional) The Fido2CredentialView object to popualte with Fido2CredentialExport data
     * @returns Fido2CredentialView - The populated view, or a new instance if none was provided.
     */
    static toView(req, view = new Fido2CredentialView()) {
        view.credentialId = req.credentialId;
        view.keyType = req.keyType;
        view.keyAlgorithm = req.keyAlgorithm;
        view.keyCurve = req.keyCurve;
        view.keyValue = req.keyValue;
        view.rpId = req.rpId;
        view.userHandle = req.userHandle;
        view.userName = req.userName;
        view.counter = parseInt(req.counter);
        view.rpName = req.rpName;
        view.userDisplayName = req.userDisplayName;
        view.discoverable = req.discoverable === "true";
        view.creationDate = new Date(req.creationDate);
        return view;
    }
    /**
     * Converts a Fido2CredentialExport object to its domain representation.
     * @param req - The Fido2CredentialExport object to be converted.
     * @param domain - (Optional) The Fido2Credential object to popualte with Fido2CredentialExport data
     * @returns Fido2Credential - The populated domain, or a new instance if none was provided.
     */
    static toDomain(req, domain = new Fido2Credential()) {
        domain.credentialId = req.credentialId != null ? new EncString(req.credentialId) : null;
        domain.keyType = req.keyType != null ? new EncString(req.keyType) : null;
        domain.keyAlgorithm = req.keyAlgorithm != null ? new EncString(req.keyAlgorithm) : null;
        domain.keyCurve = req.keyCurve != null ? new EncString(req.keyCurve) : null;
        domain.keyValue = req.keyValue != null ? new EncString(req.keyValue) : null;
        domain.rpId = req.rpId != null ? new EncString(req.rpId) : null;
        domain.userHandle = req.userHandle != null ? new EncString(req.userHandle) : null;
        domain.userName = req.userName != null ? new EncString(req.userName) : null;
        domain.counter = req.counter != null ? new EncString(req.counter) : null;
        domain.rpName = req.rpName != null ? new EncString(req.rpName) : null;
        domain.userDisplayName =
            req.userDisplayName != null ? new EncString(req.userDisplayName) : null;
        domain.discoverable = req.discoverable != null ? new EncString(req.discoverable) : null;
        domain.creationDate = req.creationDate;
        return domain;
    }
    /**
     * Constructs a new Fid2CredentialExport instance.
     *
     * @param o - The credential storing the data being exported. When not provided, an empty export is created instead.
     */
    constructor(o) {
        if (o == null) {
            return;
        }
        this.credentialId = safeGetString(o.credentialId);
        this.keyType = safeGetString(o.keyType);
        this.keyAlgorithm = safeGetString(o.keyAlgorithm);
        this.keyCurve = safeGetString(o.keyCurve);
        this.keyValue = safeGetString(o.keyValue);
        this.rpId = safeGetString(o.rpId);
        this.userHandle = safeGetString(o.userHandle);
        this.userName = safeGetString(o.userName);
        this.counter = safeGetString(String(o.counter));
        this.rpName = safeGetString(o.rpName);
        this.userDisplayName = safeGetString(o.userDisplayName);
        this.discoverable = safeGetString(String(o.discoverable));
        this.creationDate = o.creationDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/login-uri.export.ts




class LoginUriExport {
    static template() {
        const req = new LoginUriExport();
        req.uri = "https://google.com";
        req.match = null;
        return req;
    }
    static toView(req, view = new LoginUriView()) {
        view.uri = req.uri;
        view.match = req.match;
        return view;
    }
    static toDomain(req, domain = new LoginUri()) {
        domain.uri = req.uri != null ? new EncString(req.uri) : null;
        domain.uriChecksum = req.uriChecksum != null ? new EncString(req.uriChecksum) : null;
        domain.match = req.match;
        return domain;
    }
    constructor(o) {
        var _a;
        this.match = null;
        if (o == null) {
            return;
        }
        this.uri = safeGetString(o.uri);
        if ("uriChecksum" in o) {
            this.uriChecksum = (_a = o.uriChecksum) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.match = o.match;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/login.export.ts






class LoginExport {
    static template() {
        const req = new LoginExport();
        req.uris = [];
        req.username = "jdoe";
        req.password = "myp@ssword123";
        req.totp = "JBSWY3DPEHPK3PXP";
        req.fido2Credentials = [Fido2CredentialExport.template()];
        return req;
    }
    static toView(req, view = new LoginView()) {
        if (req.uris != null) {
            view.uris = req.uris.map((u) => LoginUriExport.toView(u));
        }
        view.username = req.username;
        view.password = req.password;
        view.totp = req.totp;
        if (req.fido2Credentials != null) {
            view.fido2Credentials = req.fido2Credentials.map((key) => Fido2CredentialExport.toView(key));
        }
        return view;
    }
    static toDomain(req, domain = new Login()) {
        if (req.uris != null) {
            domain.uris = req.uris.map((u) => LoginUriExport.toDomain(u));
        }
        domain.username = req.username != null ? new EncString(req.username) : null;
        domain.password = req.password != null ? new EncString(req.password) : null;
        domain.totp = req.totp != null ? new EncString(req.totp) : null;
        // Fido2credentials are currently not supported for exports.
        return domain;
    }
    constructor(o) {
        this.fido2Credentials = [];
        if (o == null) {
            return;
        }
        if (o.uris != null) {
            this.uris = o.uris.map((u) => new LoginUriExport(u));
        }
        if (o.fido2Credentials != null) {
            this.fido2Credentials = o.fido2Credentials.map((key) => new Fido2CredentialExport(key));
        }
        this.username = safeGetString(o.username);
        this.password = safeGetString(o.password);
        this.totp = safeGetString(o.totp);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/password-history.export.ts




class PasswordHistoryExport {
    static template() {
        const req = new PasswordHistoryExport();
        req.password = null;
        req.lastUsedDate = null;
        return req;
    }
    static toView(req, view = new PasswordHistoryView()) {
        view.password = req.password;
        view.lastUsedDate = req.lastUsedDate;
        return view;
    }
    static toDomain(req, domain = new Password()) {
        domain.password = req.password != null ? new EncString(req.password) : null;
        domain.lastUsedDate = req.lastUsedDate;
        return domain;
    }
    constructor(o) {
        this.lastUsedDate = null;
        if (o == null) {
            return;
        }
        this.password = safeGetString(o.password);
        this.lastUsedDate = o.lastUsedDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/secure-note.export.ts



class SecureNoteExport {
    static template() {
        const req = new SecureNoteExport();
        req.type = SecureNoteType.Generic;
        return req;
    }
    static toView(req, view = new SecureNoteView()) {
        view.type = req.type;
        return view;
    }
    static toDomain(req, view = new SecureNote()) {
        view.type = req.type;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.type = o.type;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/cipher.export.ts












class CipherExport {
    constructor() {
        this.passwordHistory = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
    }
    static template() {
        const req = new CipherExport();
        req.organizationId = null;
        req.collectionIds = null;
        req.folderId = null;
        req.type = CipherType.Login;
        req.name = "Item name";
        req.notes = "Some notes about this item.";
        req.favorite = false;
        req.fields = [];
        req.login = null;
        req.secureNote = null;
        req.card = null;
        req.identity = null;
        req.reprompt = CipherRepromptType.None;
        req.passwordHistory = [];
        req.creationDate = null;
        req.revisionDate = null;
        req.deletedDate = null;
        return req;
    }
    static toView(req, view = new CipherView()) {
        var _a, _b, _c;
        view.type = req.type;
        view.folderId = req.folderId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        if (view.collectionIds || req.collectionIds) {
            const set = new Set(((_a = view.collectionIds) !== null && _a !== void 0 ? _a : []).concat((_b = req.collectionIds) !== null && _b !== void 0 ? _b : []));
            view.collectionIds = Array.from(set.values());
        }
        view.name = req.name;
        view.notes = req.notes;
        view.favorite = req.favorite;
        view.reprompt = (_c = req.reprompt) !== null && _c !== void 0 ? _c : CipherRepromptType.None;
        if (req.fields != null) {
            view.fields = req.fields.map((f) => FieldExport.toView(f));
        }
        switch (req.type) {
            case CipherType.Login:
                view.login = LoginExport.toView(req.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteExport.toView(req.secureNote);
                break;
            case CipherType.Card:
                view.card = CardExport.toView(req.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityExport.toView(req.identity);
                break;
        }
        if (req.passwordHistory != null) {
            view.passwordHistory = req.passwordHistory.map((ph) => PasswordHistoryExport.toView(ph));
        }
        view.creationDate = req.creationDate;
        view.revisionDate = req.revisionDate;
        view.deletedDate = req.deletedDate;
        return view;
    }
    static toDomain(req, domain = new Cipher()) {
        var _a;
        domain.type = req.type;
        domain.folderId = req.folderId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.notes = req.notes != null ? new EncString(req.notes) : null;
        domain.favorite = req.favorite;
        domain.reprompt = (_a = req.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
        domain.key = req.key != null ? new EncString(req.key) : null;
        if (req.fields != null) {
            domain.fields = req.fields.map((f) => FieldExport.toDomain(f));
        }
        switch (req.type) {
            case CipherType.Login:
                domain.login = LoginExport.toDomain(req.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNoteExport.toDomain(req.secureNote);
                break;
            case CipherType.Card:
                domain.card = CardExport.toDomain(req.card);
                break;
            case CipherType.Identity:
                domain.identity = IdentityExport.toDomain(req.identity);
                break;
        }
        if (req.passwordHistory != null) {
            domain.passwordHistory = req.passwordHistory.map((ph) => PasswordHistoryExport.toDomain(ph));
        }
        domain.creationDate = req.creationDate;
        domain.revisionDate = req.revisionDate;
        domain.deletedDate = req.deletedDate;
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        var _a;
        this.organizationId = o.organizationId;
        this.folderId = o.folderId;
        this.type = o.type;
        this.reprompt = o.reprompt;
        this.name = safeGetString(o.name);
        this.notes = safeGetString(o.notes);
        if ("key" in o) {
            this.key = (_a = o.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.favorite = o.favorite;
        if (o.fields != null) {
            this.fields = o.fields.map((f) => new FieldExport(f));
        }
        switch (o.type) {
            case CipherType.Login:
                this.login = new LoginExport(o.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteExport(o.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardExport(o.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityExport(o.identity);
                break;
        }
        if (o.passwordHistory != null) {
            this.passwordHistory = o.passwordHistory.map((ph) => new PasswordHistoryExport(ph));
        }
        this.creationDate = o.creationDate;
        this.revisionDate = o.revisionDate;
        this.deletedDate = o.deletedDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
        this.manage = this.getResponseProperty("Manage");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/response/collection.response.ts


class CollectionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.name = this.getResponseProperty("Name");
        this.externalId = this.getResponseProperty("ExternalId");
    }
}
class CollectionDetailsResponse extends CollectionResponse {
    constructor(response) {
        super(response);
        this.readOnly = this.getResponseProperty("ReadOnly") || false;
        this.manage = this.getResponseProperty("Manage") || false;
        this.hidePasswords = this.getResponseProperty("HidePasswords") || false;
        // Temporary until the API is updated to return this property in AC-2084
        // For now, we can assume that if the object is 'collectionDetails' then the user is assigned
        this.assigned = this.getResponseProperty("object") == "collectionDetails";
    }
}
class CollectionAccessDetailsResponse extends CollectionDetailsResponse {
    constructor(response) {
        super(response);
        this.groups = [];
        this.users = [];
        this.assigned = this.getResponseProperty("Assigned") || false;
        this.unmanaged = this.getResponseProperty("Unmanaged") || false;
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups.map((g) => new SelectionReadOnlyResponse(g));
        }
        const users = this.getResponseProperty("Users");
        if (users != null) {
            this.users = users.map((g) => new SelectionReadOnlyResponse(g));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/collection.view.ts


const NestingDelimiter = "/";
class CollectionView {
    constructor(c) {
        this.id = null;
        this.organizationId = null;
        this.name = null;
        this.externalId = null;
        // readOnly applies to the items within a collection
        this.readOnly = null;
        this.hidePasswords = null;
        this.manage = null;
        this.assigned = null;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.externalId = c.externalId;
        if (c instanceof Collection) {
            this.readOnly = c.readOnly;
            this.hidePasswords = c.hidePasswords;
            this.manage = c.manage;
            this.assigned = true;
        }
        if (c instanceof CollectionAccessDetailsResponse) {
            this.assigned = c.assigned;
        }
    }
    canEditItems(org, v1FlexibleCollections, restrictProviderAccess) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        return ((org === null || org === void 0 ? void 0 : org.canEditAllCiphers(v1FlexibleCollections, restrictProviderAccess)) ||
            this.manage ||
            (this.assigned && !this.readOnly));
    }
    /**
     * Returns true if the user can edit a collection (including user and group access) from the individual vault.
     * After FCv1, does not include admin permissions - see {@link CollectionAdminView.canEdit}.
     */
    canEdit(org, flexibleCollectionsV1Enabled) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        if (flexibleCollectionsV1Enabled) {
            // Only use individual permissions, not admin permissions
            return this.manage;
        }
        return (org === null || org === void 0 ? void 0 : org.canEditAnyCollection(flexibleCollectionsV1Enabled)) || this.manage;
    }
    /**
     * Returns true if the user can delete a collection from the individual vault.
     * After FCv1, does not include admin permissions - see {@link CollectionAdminView.canDelete}.
     */
    canDelete(org, flexibleCollectionsV1Enabled) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        const canDeleteManagedCollections = !(org === null || org === void 0 ? void 0 : org.limitCollectionCreationDeletion) || org.isAdmin;
        if (flexibleCollectionsV1Enabled) {
            // Only use individual permissions, not admin permissions
            return canDeleteManagedCollections && this.manage;
        }
        return ((org === null || org === void 0 ? void 0 : org.canDeleteAnyCollection(flexibleCollectionsV1Enabled)) ||
            (canDeleteManagedCollections && this.manage));
    }
    /**
     * Returns true if the user can view collection info and access in a read-only state from the individual vault
     */
    canViewCollectionInfo(org, flexibleCollectionsV1Enabled) {
        return false;
    }
    static fromJSON(obj) {
        return Object.assign(new CollectionView(new Collection()), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/collection.ts


class Collection extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            name: null,
            externalId: null,
            readOnly: null,
            hidePasswords: null,
            manage: null,
        }, ["id", "organizationId", "externalId", "readOnly", "hidePasswords", "manage"]);
    }
    decrypt(orgKey) {
        return this.decryptObj(new CollectionView(this), {
            name: null,
        }, this.organizationId, orgKey);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/collection.export.ts




class CollectionExport {
    static template() {
        const req = new CollectionExport();
        req.organizationId = "00000000-0000-0000-0000-000000000000";
        req.name = "Collection name";
        req.externalId = null;
        return req;
    }
    static toView(req, view = new CollectionView()) {
        view.name = req.name;
        view.externalId = req.externalId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        return view;
    }
    static toDomain(req, domain = new Collection()) {
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.externalId = req.externalId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.organizationId = o.organizationId;
        this.name = safeGetString(o.name);
        this.externalId = o.externalId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/folder.view.ts
class FolderView {
    constructor(f) {
        this.id = null;
        this.name = null;
        this.revisionDate = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.revisionDate = f.revisionDate;
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new FolderView(), obj, { revisionDate });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/folder.ts



class Folder extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            name: null,
        }, ["id"]);
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
    }
    decrypt() {
        return this.decryptObj(new FolderView(this), {
            name: null,
        }, null);
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new Folder(), obj, { name: EncString.fromJSON(obj.name), revisionDate });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/folder.export.ts




class FolderExport {
    static template() {
        const req = new FolderExport();
        req.name = "Folder name";
        return req;
    }
    static toView(req, view = new FolderView()) {
        view.name = req.name;
        return view;
    }
    static toDomain(req, domain = new Folder()) {
        domain.name = req.name != null ? new EncString(req.name) : null;
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.name = safeGetString(o.name);
    }
}

;// CONCATENATED MODULE: ./src/admin-console/models/selection-read-only.ts
class SelectionReadOnly {
    static template() {
        return new SelectionReadOnly("00000000-0000-0000-0000-000000000000", false, false, false);
    }
    constructor(id, readOnly, hidePasswords, manage) {
        this.id = id;
        this.readOnly = readOnly;
        this.hidePasswords = hidePasswords || false;
        this.manage = manage;
    }
}

;// CONCATENATED MODULE: ./src/admin-console/models/request/organization-collection.request.ts


class OrganizationCollectionRequest extends CollectionExport {
    static template() {
        const req = new OrganizationCollectionRequest();
        req.organizationId = "00000000-0000-0000-0000-000000000000";
        req.name = "Collection name";
        req.externalId = null;
        req.groups = [SelectionReadOnly.template(), SelectionReadOnly.template()];
        req.users = [SelectionReadOnly.template(), SelectionReadOnly.template()];
        return req;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/collection-with-id.export.ts



class CollectionWithIdExport extends CollectionExport {
    static toView(req, view = new CollectionView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Collection()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// CONCATENATED MODULE: ./src/vault/models/collection.response.ts

class collection_response_CollectionResponse extends CollectionWithIdExport {
    constructor(o) {
        super();
        this.object = "collection";
        this.build(o);
    }
}

;// CONCATENATED MODULE: ./src/admin-console/models/response/organization-collection.response.ts

class OrganizationCollectionResponse extends collection_response_CollectionResponse {
    constructor(o, groups) {
        super(o);
        this.object = "org-collection";
        this.groups = groups;
    }
}

;// CONCATENATED MODULE: ./src/admin-console/models/response/organization.response.ts
class OrganizationResponse {
    constructor(o) {
        this.object = "organization";
        this.id = o.id;
        this.name = o.name;
        this.status = o.status;
        this.type = o.type;
        this.enabled = o.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-file.view.ts
class SendFileView {
    constructor(f) {
        this.id = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.size = f.size;
        this.sizeName = f.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendFileView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-text.view.ts
class SendTextView {
    constructor(t) {
        this.text = null;
        if (!t) {
            return;
        }
        this.hidden = t.hidden;
    }
    get maskedText() {
        return this.text != null ? "••••••••" : null;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendTextView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send.view.ts




class SendView {
    constructor(s) {
        this.id = null;
        this.accessId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.maxAccessCount = null;
        this.accessCount = 0;
        this.revisionDate = null;
        this.deletionDate = null;
        this.expirationDate = null;
        this.password = null;
        this.disabled = false;
        this.hideEmail = false;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.accessId = s.accessId;
        this.type = s.type;
        this.maxAccessCount = s.maxAccessCount;
        this.accessCount = s.accessCount;
        this.revisionDate = s.revisionDate;
        this.deletionDate = s.deletionDate;
        this.expirationDate = s.expirationDate;
        this.disabled = s.disabled;
        this.password = s.password;
        this.hideEmail = s.hideEmail;
    }
    get urlB64Key() {
        return Utils.fromBufferToUrlB64(this.key);
    }
    get maxAccessCountReached() {
        if (this.maxAccessCount == null) {
            return false;
        }
        return this.accessCount >= this.maxAccessCount;
    }
    get expired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate <= new Date();
    }
    get pendingDelete() {
        return this.deletionDate <= new Date();
    }
    toJSON() {
        return Utils.merge(Object.assign({}, this), {
            key: Utils.fromBufferToB64(this.key),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendView(), json, {
            key: Utils.fromB64ToArray(json.key),
            cryptoKey: SymmetricCryptoKey.fromJSON(json.cryptoKey),
            text: SendTextView.fromJSON(json.text),
            file: SendFileView.fromJSON(json.file),
            revisionDate: json.revisionDate == null ? null : new Date(json.revisionDate),
            deletionDate: json.deletionDate == null ? null : new Date(json.deletionDate),
            expirationDate: json.expirationDate == null ? null : new Date(json.expirationDate),
        });
    }
}

;// CONCATENATED MODULE: ./src/tools/send/models/send-file.response.ts

class SendFileResponse {
    static template(fileName = "file attachment location") {
        const req = new SendFileResponse();
        req.fileName = fileName;
        return req;
    }
    static toView(file, view = new SendFileView()) {
        if (file == null) {
            return null;
        }
        view.id = file.id;
        view.size = file.size;
        view.sizeName = file.sizeName;
        view.fileName = file.fileName;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.size = o.size;
        this.sizeName = o.sizeName;
        this.fileName = o.fileName;
    }
}

;// CONCATENATED MODULE: ./src/tools/send/models/send-text.response.ts

class SendTextResponse {
    static template(text = "Text contained in the send.", hidden = false) {
        const req = new SendTextResponse();
        req.text = text;
        req.hidden = hidden;
        return req;
    }
    static toView(text, view = new SendTextView()) {
        if (text == null) {
            return null;
        }
        view.text = text.text;
        view.hidden = text.hidden;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.text = o.text;
        this.hidden = o.hidden;
    }
}

;// CONCATENATED MODULE: ./src/tools/send/models/send.response.ts





const dateProperties = [
    Utils.nameOf("deletionDate"),
    Utils.nameOf("expirationDate"),
];
class SendResponse {
    static template(sendType, deleteInDays = 7) {
        const req = new SendResponse();
        req.name = "Send name";
        req.notes = "Some notes about this send.";
        req.type = sendType === SendType.File ? SendType.File : SendType.Text;
        req.text = sendType === SendType.Text ? SendTextResponse.template() : null;
        req.file = sendType === SendType.File ? SendFileResponse.template() : null;
        req.maxAccessCount = null;
        req.deletionDate = this.getStandardDeletionDate(deleteInDays);
        req.expirationDate = null;
        req.password = null;
        req.disabled = false;
        req.hideEmail = false;
        return req;
    }
    static toView(send, view = new SendView()) {
        if (send == null) {
            return null;
        }
        view.id = send.id;
        view.accessId = send.accessId;
        view.name = send.name;
        view.notes = send.notes;
        view.key = send.key == null ? null : Utils.fromB64ToArray(send.key);
        view.type = send.type;
        view.file = SendFileResponse.toView(send.file);
        view.text = SendTextResponse.toView(send.text);
        view.maxAccessCount = send.maxAccessCount;
        view.accessCount = send.accessCount;
        view.revisionDate = send.revisionDate;
        view.deletionDate = send.deletionDate;
        view.expirationDate = send.expirationDate;
        view.password = send.password;
        view.disabled = send.disabled;
        view.hideEmail = send.hideEmail;
        return view;
    }
    static fromJson(json) {
        return JSON.parse(json, (key, value) => {
            if (dateProperties.includes(key)) {
                return value == null ? null : new Date(value);
            }
            return value;
        });
    }
    static getStandardDeletionDate(days) {
        const d = new Date();
        d.setTime(d.getTime() + days * 86400000); // ms per day
        return d;
    }
    constructor(o, webVaultUrl) {
        this.object = "send";
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.accessId = o.accessId;
        let sendLinkBaseUrl = webVaultUrl;
        if (sendLinkBaseUrl == null) {
            sendLinkBaseUrl = "https://send.bitwarden.com/#";
        }
        else {
            sendLinkBaseUrl += "/#/send/";
        }
        this.accessUrl = sendLinkBaseUrl + this.accessId + "/" + o.urlB64Key;
        this.name = o.name;
        this.notes = o.notes;
        this.key = Utils.fromBufferToB64(o.key);
        this.type = o.type;
        this.maxAccessCount = o.maxAccessCount;
        this.accessCount = o.accessCount;
        this.revisionDate = o.revisionDate;
        this.deletionDate = o.deletionDate;
        this.expirationDate = o.expirationDate;
        this.passwordSet = o.password != null;
        this.disabled = o.disabled;
        this.hideEmail = o.hideEmail;
        if (o.type === SendType.Text && o.text != null) {
            this.text = new SendTextResponse(o.text);
        }
        if (o.type === SendType.File && o.file != null) {
            this.file = new SendFileResponse(o.file);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/cipher-with-ids.export.ts

class CipherWithIdExport extends CipherExport {
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
        this.collectionIds = o.collectionIds;
    }
}

;// CONCATENATED MODULE: ./src/models/response/login.response.ts

class LoginResponse extends LoginExport {
    constructor(o) {
        super(o);
        this.passwordRevisionDate = o.passwordRevisionDate != null ? o.passwordRevisionDate : null;
    }
}

;// CONCATENATED MODULE: ./src/vault/models/attachment.response.ts
class AttachmentResponse {
    constructor(o) {
        this.id = o.id;
        this.fileName = o.fileName;
        this.size = o.size;
        this.sizeName = o.sizeName;
        this.url = o.url;
    }
}

;// CONCATENATED MODULE: ./src/vault/models/password-history.response.ts
class PasswordHistoryResponse {
    constructor(o) {
        this.lastUsedDate = o.lastUsedDate;
        this.password = o.password;
    }
}

;// CONCATENATED MODULE: ./src/vault/models/cipher.response.ts





class CipherResponse extends CipherWithIdExport {
    constructor(o) {
        super();
        this.object = "item";
        this.build(o);
        if (o.attachments != null) {
            this.attachments = o.attachments.map((a) => new AttachmentResponse(a));
        }
        this.revisionDate = o.revisionDate;
        if (o.creationDate != null) {
            this.creationDate = o.creationDate;
        }
        this.deletedDate = o.deletedDate;
        if (o.passwordHistory != null) {
            this.passwordHistory = o.passwordHistory.map((h) => new PasswordHistoryResponse(h));
        }
        if (o.type === CipherType.Login && o.login != null) {
            this.login = new LoginResponse(o.login);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/folder-with-id.export.ts



class FolderWithIdExport extends FolderExport {
    static toView(req, view = new FolderView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Folder()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/index.ts













;// CONCATENATED MODULE: ./src/vault/models/folder.response.ts

class FolderResponse extends FolderWithIdExport {
    constructor(o) {
        super();
        this.object = "folder";
        this.build(o);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-array-buffer.ts
var enc_array_buffer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const ENC_TYPE_LENGTH = 1;
const IV_LENGTH = 16;
const MAC_LENGTH = 32;
const MIN_DATA_LENGTH = 1;
class EncArrayBuffer {
    constructor(buffer) {
        this.buffer = buffer;
        this.encryptionType = null;
        this.dataBytes = null;
        this.ivBytes = null;
        this.macBytes = null;
        const encBytes = buffer;
        const encType = encBytes[0];
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.macBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                break;
            }
            case EncryptionType.AesCbc256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH);
                break;
            }
            default:
                this.throwDecryptionError();
        }
        this.encryptionType = encType;
    }
    throwDecryptionError() {
        throw new Error("Error parsing encrypted ArrayBuffer: data is corrupted or has an invalid format.");
    }
    static fromResponse(response) {
        return enc_array_buffer_awaiter(this, void 0, void 0, function* () {
            const buffer = yield response.arrayBuffer();
            if (buffer == null) {
                throw new Error("Cannot create EncArrayBuffer from Response - Response is empty");
            }
            return new EncArrayBuffer(new Uint8Array(buffer));
        });
    }
    static fromB64(b64) {
        const buffer = Utils.fromB64ToArray(b64);
        return new EncArrayBuffer(buffer);
    }
}

;// CONCATENATED MODULE: ./src/models/response/file.response.ts
class FileResponse {
    constructor(data, fileName) {
        this.object = "file";
        this.data = data;
        this.fileName = fileName;
    }
}

;// CONCATENATED MODULE: ./src/commands/download.command.ts
var download_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class DownloadCommand {
    constructor(cryptoService) {
        this.cryptoService = cryptoService;
    }
    saveAttachmentToFile(url, key, fileName, output) {
        return download_command_awaiter(this, void 0, void 0, function* () {
            const response = yield external_node_fetch_default()(new external_node_fetch_namespaceObject.Request(url, { headers: { cache: "no-cache" } }));
            if (response.status !== 200) {
                return Response.error("A " + response.status + " error occurred while downloading the attachment.");
            }
            try {
                const encBuf = yield EncArrayBuffer.fromResponse(response);
                const decBuf = yield this.cryptoService.decryptFromBytes(encBuf, key);
                if (process.env.BW_SERVE === "true") {
                    const res = new FileResponse(Buffer.from(decBuf), fileName);
                    return Response.success(res);
                }
                else {
                    return yield CliUtils.saveResultToFile(Buffer.from(decBuf), output, fileName);
                }
            }
            catch (e) {
                if (typeof e === "string") {
                    return Response.error(e);
                }
                else {
                    return Response.error("An error occurred while saving the attachment.");
                }
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/commands/get.command.ts
var get_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






























class GetCommand extends DownloadCommand {
    constructor(cipherService, folderService, collectionService, totpService, auditService, cryptoService, stateService, searchService, apiService, organizationService, eventCollectionService, accountProfileService) {
        super(cryptoService);
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.totpService = totpService;
        this.auditService = auditService;
        this.stateService = stateService;
        this.searchService = searchService;
        this.apiService = apiService;
        this.organizationService = organizationService;
        this.eventCollectionService = eventCollectionService;
        this.accountProfileService = accountProfileService;
    }
    run(object, id, cmdOptions) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new get_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.getCipher(id);
                case "username":
                    return yield this.getUsername(id);
                case "password":
                    return yield this.getPassword(id);
                case "uri":
                    return yield this.getUri(id);
                case "totp":
                    return yield this.getTotp(id);
                case "notes":
                    return yield this.getNotes(id);
                case "exposed":
                    return yield this.getExposed(id);
                case "attachment":
                    return yield this.getAttachment(id, normalizedOptions);
                case "folder":
                    return yield this.getFolder(id);
                case "collection":
                    return yield this.getCollection(id);
                case "org-collection":
                    return yield this.getOrganizationCollection(id, normalizedOptions);
                case "organization":
                    return yield this.getOrganization(id);
                case "template":
                    return yield this.getTemplate(id);
                case "fingerprint":
                    return yield this.getFingerprint(id);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    getCipherView(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCipher = null;
            if (Utils.isGuid(id)) {
                const cipher = yield this.cipherService.get(id);
                if (cipher != null) {
                    decCipher = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));
                }
            }
            else if (id.trim() !== "") {
                let ciphers = yield this.cipherService.getAllDecrypted();
                ciphers = this.searchService.searchCiphersBasic(ciphers, id);
                if (ciphers.length > 1) {
                    return ciphers;
                }
                if (ciphers.length > 0) {
                    decCipher = ciphers[0];
                }
            }
            return decCipher;
        });
    }
    getCipher(id, filter) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCipher = yield this.getCipherView(id);
            if (decCipher == null) {
                return Response.notFound();
            }
            if (Array.isArray(decCipher)) {
                if (filter != null) {
                    decCipher = decCipher.filter(filter);
                    if (decCipher.length === 1) {
                        decCipher = decCipher[0];
                    }
                }
                if (Array.isArray(decCipher)) {
                    return Response.multipleResults(decCipher.map((c) => c.id));
                }
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this.eventCollectionService.collect(EventType.Cipher_ClientViewed, id, true, decCipher.organizationId);
            const res = new CipherResponse(decCipher);
            return Response.success(res);
        });
    }
    getUsername(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !Utils.isNullOrWhitespace(c.login.username));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return Response.badRequest("Not a login.");
            }
            if (Utils.isNullOrWhitespace(cipher.login.username)) {
                return Response.error("No username available for this login.");
            }
            const res = new StringResponse(cipher.login.username);
            return Response.success(res);
        });
    }
    getPassword(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !Utils.isNullOrWhitespace(c.login.password));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return Response.badRequest("Not a login.");
            }
            if (Utils.isNullOrWhitespace(cipher.login.password)) {
                return Response.error("No password available for this login.");
            }
            const res = new StringResponse(cipher.login.password);
            return Response.success(res);
        });
    }
    getUri(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login &&
                c.login.uris != null &&
                c.login.uris.length > 0 &&
                c.login.uris[0].uri !== "");
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return Response.badRequest("Not a login.");
            }
            if (cipher.login.uris == null ||
                cipher.login.uris.length === 0 ||
                cipher.login.uris[0].uri === "") {
                return Response.error("No uri available for this login.");
            }
            const res = new StringResponse(cipher.login.uris[0].uri);
            return Response.success(res);
        });
    }
    getTotp(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !Utils.isNullOrWhitespace(c.login.totp));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return Response.badRequest("Not a login.");
            }
            if (Utils.isNullOrWhitespace(cipher.login.totp)) {
                return Response.error("No TOTP available for this login.");
            }
            const totp = yield this.totpService.getCode(cipher.login.totp);
            if (totp == null) {
                return Response.error("Couldn't generate TOTP code.");
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);
            if (!canAccessPremium) {
                const originalCipher = yield this.cipherService.get(cipher.id);
                if (originalCipher == null ||
                    originalCipher.organizationId == null ||
                    !originalCipher.organizationUseTotp) {
                    return Response.error("Premium status is required to use this feature.");
                }
            }
            const res = new StringResponse(totp);
            return Response.success(res);
        });
    }
    getNotes(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => !Utils.isNullOrWhitespace(c.notes));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (Utils.isNullOrWhitespace(cipher.notes)) {
                return Response.error("No notes available for this item.");
            }
            const res = new StringResponse(cipher.notes);
            return Response.success(res);
        });
    }
    getExposed(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const passwordResponse = yield this.getPassword(id);
            if (!passwordResponse.success) {
                return passwordResponse;
            }
            const exposedNumber = yield this.auditService.passwordLeaked(passwordResponse.data.data);
            const res = new StringResponse(exposedNumber.toString());
            return Response.success(res);
        });
    }
    getAttachment(id, options) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return Response.badRequest("--itemid <itemid> required.");
            }
            const itemId = options.itemId.toLowerCase();
            const cipherResponse = yield this.getCipher(itemId);
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = yield this.getCipherView(itemId);
            if (cipher == null ||
                Array.isArray(cipher) ||
                cipher.attachments == null ||
                cipher.attachments.length === 0) {
                return Response.error("No attachments available for this item.");
            }
            let attachments = cipher.attachments.filter((a) => a.id.toLowerCase() === id ||
                (a.fileName != null && a.fileName.toLowerCase().indexOf(id) > -1));
            if (attachments.length === 0) {
                return Response.error("Attachment `" + id + "` was not found.");
            }
            const exactMatches = attachments.filter((a) => a.fileName.toLowerCase() === id);
            if (exactMatches.length === 1) {
                attachments = exactMatches;
            }
            if (attachments.length > 1) {
                return Response.multipleResults(attachments.map((a) => a.id));
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);
            if (!canAccessPremium) {
                const originalCipher = yield this.cipherService.get(cipher.id);
                if (originalCipher == null || originalCipher.organizationId == null) {
                    return Response.error("Premium status is required to use this feature.");
                }
            }
            let url;
            try {
                const attachmentDownloadResponse = yield this.apiService.getAttachmentData(cipher.id, attachments[0].id);
                url = attachmentDownloadResponse.url;
            }
            catch (e) {
                if (e instanceof ErrorResponse && e.statusCode === 404) {
                    url = attachments[0].url;
                }
                else if (e instanceof ErrorResponse) {
                    throw new Error(e.getSingleMessage());
                }
                else {
                    throw e;
                }
            }
            const key = attachments[0].key != null
                ? attachments[0].key
                : yield this.cryptoService.getOrgKey(cipher.organizationId);
            return yield this.saveAttachmentToFile(url, key, attachments[0].fileName, options.output);
        });
    }
    getFolder(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decFolder = null;
            if (Utils.isGuid(id)) {
                const folder = yield this.folderService.getFromState(id);
                if (folder != null) {
                    decFolder = yield folder.decrypt();
                }
            }
            else if (id.trim() !== "") {
                let folders = yield this.folderService.getAllDecryptedFromState();
                folders = CliUtils.searchFolders(folders, id);
                if (folders.length > 1) {
                    return Response.multipleResults(folders.map((f) => f.id));
                }
                if (folders.length > 0) {
                    decFolder = folders[0];
                }
            }
            if (decFolder == null) {
                return Response.notFound();
            }
            const res = new FolderResponse(decFolder);
            return Response.success(res);
        });
    }
    getCollection(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCollection = null;
            if (Utils.isGuid(id)) {
                const collection = yield this.collectionService.get(id);
                if (collection != null) {
                    const orgKeys = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.cryptoService.activeUserOrgKeys$);
                    decCollection = yield collection.decrypt(orgKeys[collection.organizationId]);
                }
            }
            else if (id.trim() !== "") {
                let collections = yield this.collectionService.getAllDecrypted();
                collections = CliUtils.searchCollections(collections, id);
                if (collections.length > 1) {
                    return Response.multipleResults(collections.map((c) => c.id));
                }
                if (collections.length > 0) {
                    decCollection = collections[0];
                }
            }
            if (decCollection == null) {
                return Response.notFound();
            }
            const res = new collection_response_CollectionResponse(decCollection);
            return Response.success(res);
        });
    }
    getOrganizationCollection(id, options) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` option is required.");
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                const orgKey = yield this.cryptoService.getOrgKey(options.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const response = yield this.apiService.getCollectionAccessDetails(options.organizationId, id);
                const decCollection = new CollectionView(response);
                decCollection.name = yield this.cryptoService.decryptToUtf8(new EncString(response.name), orgKey);
                const groups = response.groups == null
                    ? null
                    : response.groups.map((g) => new SelectionReadOnly(g.id, g.readOnly, g.hidePasswords, g.manage));
                const res = new OrganizationCollectionResponse(decCollection, groups);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    getOrganization(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let org = null;
            if (Utils.isGuid(id)) {
                org = yield this.organizationService.getFromState(id);
            }
            else if (id.trim() !== "") {
                let orgs = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.organizations$);
                orgs = CliUtils.searchOrganizations(orgs, id);
                if (orgs.length > 1) {
                    return Response.multipleResults(orgs.map((c) => c.id));
                }
                if (orgs.length > 0) {
                    org = orgs[0];
                }
            }
            if (org == null) {
                return Response.notFound();
            }
            const res = new OrganizationResponse(org);
            return Response.success(res);
        });
    }
    getTemplate(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let template = null;
            switch (id.toLowerCase()) {
                case "item":
                    template = CipherExport.template();
                    break;
                case "item.field":
                    template = FieldExport.template();
                    break;
                case "item.login":
                    template = LoginExport.template();
                    break;
                case "item.login.uri":
                    template = LoginUriExport.template();
                    break;
                case "item.card":
                    template = CardExport.template();
                    break;
                case "item.identity":
                    template = IdentityExport.template();
                    break;
                case "item.securenote":
                    template = SecureNoteExport.template();
                    break;
                case "folder":
                    template = FolderExport.template();
                    break;
                case "collection":
                    template = CollectionExport.template();
                    break;
                case "item-collections":
                    template = ["collection-id1", "collection-id2"];
                    break;
                case "org-collection":
                    template = OrganizationCollectionRequest.template();
                    break;
                case "send.text":
                    template = SendResponse.template(SendType.Text);
                    break;
                case "send.file":
                    template = SendResponse.template(SendType.File);
                    break;
                default:
                    return Response.badRequest("Unknown template object.");
            }
            const res = new TemplateResponse(template);
            return Response.success(res);
        });
    }
    getFingerprint(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let fingerprint = null;
            if (id === "me") {
                fingerprint = yield this.cryptoService.getFingerprint(yield this.stateService.getUserId());
            }
            else if (Utils.isGuid(id)) {
                try {
                    const response = yield this.apiService.getUserPublicKey(id);
                    const pubKey = Utils.fromB64ToArray(response.publicKey);
                    fingerprint = yield this.cryptoService.getFingerprint(id, pubKey);
                }
                catch (_a) {
                    // eslint-disable-next-line
                }
            }
            if (fingerprint == null) {
                return Response.notFound();
            }
            const res = new StringResponse(fingerprint.join("-"));
            return Response.success(res);
        });
    }
}
class get_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.output = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.output;
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/create.command.ts
var create_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









class SendCreateCommand {
    constructor(sendService, environmentService, sendApiService, accountProfileService) {
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.sendApiService = sendApiService;
        this.accountProfileService = accountProfileService;
    }
    run(requestJson, cmdOptions) {
        return create_command_awaiter(this, void 0, void 0, function* () {
            let req = null;
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return Response.badRequest("`requestJson` was not provided.");
            }
            if (typeof requestJson !== "string") {
                req = requestJson;
                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);
                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = SendResponse.fromJson(reqJson);
                    if (req == null) {
                        throw new Error("Null request");
                    }
                }
                catch (e) {
                    return Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (req.deletionDate == null ||
                isNaN(new Date(req.deletionDate).getTime()) ||
                new Date(req.deletionDate) <= new Date()) {
                return Response.badRequest("Must specify a valid deletion date after the current time");
            }
            if (req.expirationDate != null && isNaN(new Date(req.expirationDate).getTime())) {
                return Response.badRequest("Unable to parse expirationDate: " + req.expirationDate);
            }
            const normalizedOptions = new create_command_Options(cmdOptions);
            return this.createSend(req, normalizedOptions);
        });
    }
    createSend(req, options) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        return create_command_awaiter(this, void 0, void 0, function* () {
            const filePath = (_b = (_a = req.file) === null || _a === void 0 ? void 0 : _a.fileName) !== null && _b !== void 0 ? _b : options.file;
            const text = (_d = (_c = req.text) === null || _c === void 0 ? void 0 : _c.text) !== null && _d !== void 0 ? _d : options.text;
            const hidden = (_f = (_e = req.text) === null || _e === void 0 ? void 0 : _e.hidden) !== null && _f !== void 0 ? _f : options.hidden;
            const password = (_g = req.password) !== null && _g !== void 0 ? _g : options.password;
            const maxAccessCount = (_h = req.maxAccessCount) !== null && _h !== void 0 ? _h : options.maxAccessCount;
            req.key = null;
            req.maxAccessCount = maxAccessCount;
            switch (req.type) {
                case SendType.File:
                    if (process.env.BW_SERVE === "true") {
                        return Response.error("Creating a file-based Send is unsupported through the `serve` command at this time.");
                    }
                    if (!(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$))) {
                        return Response.error("Premium status is required to use this feature.");
                    }
                    if (filePath == null) {
                        return Response.badRequest("Must specify a file to Send either with the --file option or in the request JSON.");
                    }
                    req.file.fileName = external_path_namespaceObject.basename(filePath);
                    break;
                case SendType.Text:
                    if (text == null) {
                        return Response.badRequest("Must specify text content to Send either with the --text option or in the request JSON.");
                    }
                    req.text = new SendTextResponse();
                    req.text.text = text;
                    req.text.hidden = hidden;
                    break;
                default:
                    return Response.badRequest("Unknown Send type " + SendType[req.type] + ". Valid types are: file, text");
            }
            try {
                let fileBuffer = null;
                if (req.type === SendType.File) {
                    fileBuffer = NodeUtils.bufferToArrayBuffer(external_fs_namespaceObject.readFileSync(filePath));
                }
                const sendView = SendResponse.toView(req);
                const [encSend, fileData] = yield this.sendService.encrypt(sendView, fileBuffer, password);
                // Add dates from template
                encSend.deletionDate = sendView.deletionDate;
                encSend.expirationDate = sendView.expirationDate;
                yield this.sendApiService.save([encSend, fileData]);
                const newSend = yield this.sendService.getFromState(encSend.id);
                const decSend = yield newSend.decrypt();
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const res = new SendResponse(decSend, env.getWebVaultUrl());
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}
class create_command_Options {
    constructor(passedOptions) {
        this.file = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.file;
        this.text = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.text;
        this.password = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.password;
        this.hidden = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.hidden);
        this.maxAccessCount =
            (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.maxAccessCount) != null ? parseInt(passedOptions.maxAccessCount, null) : null;
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/delete.command.ts
var delete_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class SendDeleteCommand {
    constructor(sendService, sendApiService) {
        this.sendService = sendService;
        this.sendApiService = sendApiService;
    }
    run(id) {
        return delete_command_awaiter(this, void 0, void 0, function* () {
            const send = yield this.sendService.getFromState(id);
            if (send == null) {
                return Response.notFound();
            }
            try {
                yield this.sendApiService.delete(id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/edit.command.ts
var edit_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class SendEditCommand {
    constructor(sendService, getCommand, sendApiService, accountProfileService) {
        this.sendService = sendService;
        this.getCommand = getCommand;
        this.sendApiService = sendApiService;
        this.accountProfileService = accountProfileService;
    }
    run(requestJson, cmdOptions) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return Response.badRequest("`requestJson` was not provided.");
            }
            let req = null;
            if (typeof requestJson !== "string") {
                req = requestJson;
                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);
                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = SendResponse.fromJson(reqJson);
                }
                catch (e) {
                    return Response.badRequest("Error parsing the encoded request data.");
                }
            }
            const normalizedOptions = new edit_command_Options(cmdOptions);
            req.id = normalizedOptions.itemId || req.id;
            if (req.id != null) {
                req.id = req.id.toLowerCase();
            }
            const send = yield this.sendService.getFromState(req.id);
            if (send == null) {
                return Response.notFound();
            }
            if (send.type !== req.type) {
                return Response.badRequest("Cannot change a Send's type");
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);
            if (send.type === SendType.File && !canAccessPremium) {
                return Response.error("Premium status is required to use this feature.");
            }
            let sendView = yield send.decrypt();
            sendView = SendResponse.toView(req, sendView);
            if (typeof req.password !== "string" || req.password === "") {
                req.password = null;
            }
            try {
                const [encSend, encFileData] = yield this.sendService.encrypt(sendView, null, req.password);
                // Add dates from template
                encSend.deletionDate = sendView.deletionDate;
                encSend.expirationDate = sendView.expirationDate;
                yield this.sendApiService.save([encSend, encFileData]);
            }
            catch (e) {
                return Response.error(e);
            }
            return yield this.getCommand.run(send.id, {});
        });
    }
}
class edit_command_Options {
    constructor(passedOptions) {
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid);
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/get.command.ts
var commands_get_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class SendGetCommand extends DownloadCommand {
    constructor(sendService, environmentService, searchService, cryptoService) {
        super(cryptoService);
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.searchService = searchService;
    }
    run(id, options) {
        return commands_get_command_awaiter(this, void 0, void 0, function* () {
            const serveCommand = process.env.BW_SERVE === "true";
            if (serveCommand && !Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            let sends = yield this.getSendView(id);
            if (sends == null) {
                return Response.notFound();
            }
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const webVaultUrl = env.getWebVaultUrl();
            let filter = (s) => true;
            let selector = (s) => commands_get_command_awaiter(this, void 0, void 0, function* () { return Response.success(new SendResponse(s, webVaultUrl)); });
            if (!serveCommand && (options === null || options === void 0 ? void 0 : options.text) != null) {
                filter = (s) => {
                    return filter(s) && s.text != null;
                };
                selector = (s) => commands_get_command_awaiter(this, void 0, void 0, function* () {
                    // Write to stdout and response success so we get the text string only to stdout
                    process.stdout.write(s.text.text);
                    return Response.success();
                });
            }
            if (Array.isArray(sends)) {
                if (filter != null) {
                    sends = sends.filter(filter);
                }
                if (sends.length > 1) {
                    return Response.multipleResults(sends.map((s) => s.id));
                }
                if (sends.length > 0) {
                    return selector(sends[0]);
                }
                else {
                    return Response.notFound();
                }
            }
            return selector(sends);
        });
    }
    getSendView(id) {
        return commands_get_command_awaiter(this, void 0, void 0, function* () {
            if (Utils.isGuid(id)) {
                const send = yield this.sendService.getFromState(id);
                if (send != null) {
                    return yield send.decrypt();
                }
            }
            else if (id.trim() !== "") {
                let sends = yield this.sendService.getAllDecryptedFromState();
                sends = this.searchService.searchSends(sends, id);
                if (sends.length > 1) {
                    return sends;
                }
                else if (sends.length > 0) {
                    return sends[0];
                }
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/models/response/list.response.ts
class ListResponse {
    constructor(data) {
        this.object = "list";
        this.data = data;
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/list.command.ts
var list_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class SendListCommand {
    constructor(sendService, environmentService, searchService) {
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.searchService = searchService;
    }
    run(cmdOptions) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            let sends = yield this.sendService.getAllDecryptedFromState();
            const normalizedOptions = new list_command_Options(cmdOptions);
            if (normalizedOptions.search != null && normalizedOptions.search.trim() !== "") {
                sends = this.searchService.searchSends(sends, normalizedOptions.search);
            }
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const webVaultUrl = env.getWebVaultUrl();
            const res = new ListResponse(sends.map((s) => new SendResponse(s, webVaultUrl)));
            return Response.success(res);
        });
    }
}
class list_command_Options {
    constructor(passedOptions) {
        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-access.view.ts


class SendAccessView {
    constructor(s) {
        this.id = null;
        this.name = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.expirationDate = null;
        this.creatorIdentifier = null;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.type = s.type;
        this.expirationDate = s.expirationDate;
        this.creatorIdentifier = s.creatorIdentifier;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-file.ts
var send_file_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SendFile extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            sizeName: null,
            fileName: null,
        }, ["id", "sizeName"]);
    }
    decrypt(key) {
        return send_file_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new SendFileView(this), {
                fileName: null,
            }, null, key);
            return view;
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendFile(), obj, {
            fileName: EncString.fromJSON(obj.fileName),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-text.ts



class SendText extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.hidden = obj.hidden;
        this.buildDomainModel(this, obj, {
            text: null,
        }, []);
    }
    decrypt(key) {
        return this.decryptObj(new SendTextView(this), {
            text: null,
        }, null, key);
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendText(), obj, {
            text: EncString.fromJSON(obj.text),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-access.ts
var send_access_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class SendAccess extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            name: null,
            expirationDate: null,
            creatorIdentifier: null,
        }, ["id", "expirationDate", "creatorIdentifier"]);
        this.type = obj.type;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendText(obj.text);
                break;
            case SendType.File:
                this.file = new SendFile(obj.file);
                break;
            default:
                break;
        }
    }
    decrypt(key) {
        return send_access_awaiter(this, void 0, void 0, function* () {
            const model = new SendAccessView(this);
            yield this.decryptObj(model, {
                name: null,
            }, null, key);
            switch (this.type) {
                case SendType.File:
                    model.file = yield this.file.decrypt(key);
                    break;
                case SendType.Text:
                    model.text = yield this.text.decrypt(key);
                    break;
                default:
                    break;
            }
            return model;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/request/send-access.request.ts
class SendAccessRequest {
}

;// CONCATENATED MODULE: ./src/tools/send/models/send-access.response.ts



class SendAccessResponse {
    static template() {
        const req = new SendAccessResponse();
        req.name = "Send name";
        req.type = SendType.Text;
        req.text = null;
        req.file = null;
        return req;
    }
    constructor(o) {
        this.object = "send-access";
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.name = o.name;
        this.type = o.type;
        if (o.type === SendType.Text && o.text != null) {
            this.text = new SendTextResponse(o.text);
        }
        if (o.type === SendType.File && o.file != null) {
            this.file = new SendFileResponse(o.file);
        }
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/receive.command.ts
var receive_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class SendReceiveCommand extends DownloadCommand {
    constructor(apiService, cryptoService, cryptoFunctionService, platformUtilsService, environmentService, sendApiService) {
        super(cryptoService);
        this.apiService = apiService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.platformUtilsService = platformUtilsService;
        this.environmentService = environmentService;
        this.sendApiService = sendApiService;
    }
    run(url, options) {
        var _a, _b;
        return receive_command_awaiter(this, void 0, void 0, function* () {
            this.canInteract = process.env.BW_NOINTERACTION !== "true";
            let urlObject;
            try {
                urlObject = new URL(url);
            }
            catch (e) {
                return Response.badRequest("Failed to parse the provided Send url");
            }
            const apiUrl = yield this.getApiUrl(urlObject);
            const [id, key] = this.getIdAndKey(urlObject);
            if (Utils.isNullOrWhitespace(id) || Utils.isNullOrWhitespace(key)) {
                return Response.badRequest("Failed to parse url, the url provided is not a valid Send url");
            }
            const keyArray = Utils.fromUrlB64ToArray(key);
            this.sendAccessRequest = new SendAccessRequest();
            let password = options.password;
            if (password == null || password === "") {
                if (options.passwordfile) {
                    password = yield NodeUtils.readFirstLine(options.passwordfile);
                }
                else if (options.passwordenv && process.env[options.passwordenv]) {
                    password = process.env[options.passwordenv];
                }
            }
            if (password != null && password !== "") {
                this.sendAccessRequest.password = yield this.getUnlockedPassword(password, keyArray);
            }
            const response = yield this.sendRequest(apiUrl, id, keyArray);
            if (response instanceof Response) {
                // Error scenario
                return response;
            }
            if (options.obj != null) {
                return Response.success(new SendAccessResponse(response));
            }
            switch (response.type) {
                case SendType.Text:
                    // Write to stdout and response success so we get the text string only to stdout
                    process.stdout.write((_a = response === null || response === void 0 ? void 0 : response.text) === null || _a === void 0 ? void 0 : _a.text);
                    return Response.success();
                case SendType.File: {
                    const downloadData = yield this.sendApiService.getSendFileDownloadData(response, this.sendAccessRequest, apiUrl);
                    return yield this.saveAttachmentToFile(downloadData.url, this.decKey, (_b = response === null || response === void 0 ? void 0 : response.file) === null || _b === void 0 ? void 0 : _b.fileName, options.output);
                }
                default:
                    return Response.success(new SendAccessResponse(response));
            }
        });
    }
    getIdAndKey(url) {
        const result = url.hash.slice(1).split("/").slice(-2);
        return [result[0], result[1]];
    }
    getApiUrl(url) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const urls = env.getUrls();
            if (url.origin === "https://send.bitwarden.com") {
                return "https://api.bitwarden.com";
            }
            else if (url.origin === urls.api) {
                return url.origin;
            }
            else if (this.platformUtilsService.isDev() && url.origin === urls.webVault) {
                return urls.api;
            }
            else {
                return url.origin + "/api";
            }
        });
    }
    getUnlockedPassword(password, keyArray) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            const passwordHash = yield this.cryptoFunctionService.pbkdf2(password, keyArray, "sha256", 100000);
            return Utils.fromBufferToB64(passwordHash);
        });
    }
    sendRequest(url, id, key) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            try {
                const sendResponse = yield this.sendApiService.postSendAccess(id, this.sendAccessRequest, url);
                const sendAccess = new SendAccess(sendResponse);
                this.decKey = yield this.cryptoService.makeSendKey(key);
                return yield sendAccess.decrypt(this.decKey);
            }
            catch (e) {
                if (e instanceof ErrorResponse) {
                    if (e.statusCode === 401) {
                        if (this.canInteract) {
                            const answer = yield external_inquirer_namespaceObject.createPromptModule({
                                output: process.stderr,
                            })({
                                type: "password",
                                name: "password",
                                message: "Send password:",
                            });
                            // reattempt with new password
                            this.sendAccessRequest.password = yield this.getUnlockedPassword(answer.password, key);
                            return yield this.sendRequest(url, id, key);
                        }
                        return Response.badRequest("Incorrect or missing password");
                    }
                    else if (e.statusCode === 405) {
                        return Response.badRequest("Bad Request");
                    }
                    else if (e.statusCode === 404) {
                        return Response.notFound();
                    }
                }
                return Response.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/remove-password.command.ts
var remove_password_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SendRemovePasswordCommand {
    constructor(sendService, sendApiService, environmentService) {
        this.sendService = sendService;
        this.sendApiService = sendApiService;
        this.environmentService = environmentService;
    }
    run(id) {
        return remove_password_command_awaiter(this, void 0, void 0, function* () {
            try {
                yield this.sendApiService.removePassword(id);
                const updatedSend = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.sendService.get$(id));
                const decSend = yield updatedSend.decrypt();
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const webVaultUrl = env.getWebVaultUrl();
                const res = new SendResponse(decSend, webVaultUrl);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ./src/tools/send/commands/index.ts








;// CONCATENATED MODULE: ./src/tools/send/send.program.ts
var send_program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














const send_program_writeLn = CliUtils.writeLn;
class SendProgram extends BaseProgram {
    register() {
        external_commander_namespaceObject.program.addCommand(this.sendCommand());
        // receive is accessible both at `bw receive` and `bw send receive`
        external_commander_namespaceObject.program.addCommand(this.receiveCommand());
    }
    sendCommand() {
        return new external_commander_namespaceObject.Command("send")
            .argument("<data>", "The data to Send. Specify as a filepath with the --file option")
            .description("Work with Bitwarden sends. A Send can be quickly created using this command or subcommands can be used to fine-tune the Send")
            .option("-f, --file", "Specifies that <data> is a filepath")
            .option("-d, --deleteInDays <days>", "The number of days in the future to set deletion date, defaults to 7", "7")
            .option("-a, --maxAccessCount <amount>", "The amount of max possible accesses.")
            .option("--hidden", "Hide <data> in web by default. Valid only if --file is not set.")
            .option("-n, --name <name>", "The name of the Send. Defaults to a guid for text Sends and the filename for files.")
            .option("--notes <notes>", "Notes to add to the Send.")
            .option("--fullObject", "Specifies that the full Send object should be returned rather than just the access url.")
            .addCommand(this.listCommand())
            .addCommand(this.templateCommand())
            .addCommand(this.getCommand())
            .addCommand(this.receiveCommand())
            .addCommand(this.createCommand())
            .addCommand(this.editCommand())
            .addCommand(this.removePasswordCommand())
            .addCommand(this.deleteCommand())
            .action((data, options) => send_program_awaiter(this, void 0, void 0, function* () {
            const encodedJson = this.makeSendJson(data, options);
            let response;
            if (encodedJson instanceof Response) {
                response = encodedJson;
            }
            else {
                response = yield this.runCreate(encodedJson, options);
            }
            this.processResponse(response);
        }));
    }
    receiveCommand() {
        return new external_commander_namespaceObject.Command("receive")
            .arguments("<url>")
            .description("Access a Bitwarden Send from a url")
            .option("--password <password>", "Password needed to access the Send.")
            .option("--passwordenv <passwordenv>", "Environment variable storing the Send's password")
            .option("--passwordfile <passwordfile>", "Path to a file containing the Sends password as its first line")
            .option("--obj", "Return the Send's json object rather than the Send's content")
            .option("--output <location>", "Specify a file path to save a File-type Send to")
            .on("--help", () => {
            send_program_writeLn("");
            send_program_writeLn("If a password is required, the provided password is used or the user is prompted.");
            send_program_writeLn("", true);
        })
            .action((url, options) => send_program_awaiter(this, void 0, void 0, function* () {
            const cmd = new SendReceiveCommand(this.serviceContainer.apiService, this.serviceContainer.cryptoService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.platformUtilsService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService);
            const response = yield cmd.run(url, options);
            this.processResponse(response);
        }));
    }
    listCommand() {
        return new external_commander_namespaceObject.Command("list")
            .description("List all the Sends owned by you")
            .on("--help", () => {
            send_program_writeLn(external_chalk_namespaceObject("This is in the list command"));
        })
            .action((options) => send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = new SendListCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService);
            const response = yield cmd.run(options);
            this.processResponse(response);
        }));
    }
    templateCommand() {
        return new external_commander_namespaceObject.Command("template")
            .argument("<object>", "Valid objects are: send.text, send.file")
            .description("Get json templates for send objects")
            .action((object) => send_program_awaiter(this, void 0, void 0, function* () {
            const cmd = new GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService);
            const response = yield cmd.run("template", object, null);
            this.processResponse(response);
        }));
    }
    getCommand() {
        return new external_commander_namespaceObject.Command("get")
            .arguments("<id>")
            .description("Get Sends owned by you.")
            .option("--output <output>", "Output directory or filename for attachment.")
            .option("--text", "Specifies to return the text content of a Send")
            .on("--help", () => {
            send_program_writeLn("");
            send_program_writeLn("  Id:");
            send_program_writeLn("");
            send_program_writeLn("    Search term or Send's globally unique `id`.");
            send_program_writeLn("");
            send_program_writeLn("    If raw output is specified and no output filename or directory is given for");
            send_program_writeLn("    an attachment query, the attachment content is written to stdout.");
            send_program_writeLn("");
            send_program_writeLn("  Examples:");
            send_program_writeLn("");
            send_program_writeLn("    bw send get searchText");
            send_program_writeLn("    bw send get id");
            send_program_writeLn("    bw send get searchText --text");
            send_program_writeLn("    bw send get searchText --file");
            send_program_writeLn("    bw send get searchText --file --output ../Photos/photo.jpg");
            send_program_writeLn("    bw send get searchText --file --raw");
            send_program_writeLn("", true);
        })
            .action((id, options) => send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = new SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);
            const response = yield cmd.run(id, options);
            this.processResponse(response);
        }));
    }
    createCommand() {
        return new external_commander_namespaceObject.Command("create")
            .argument("[encodedJson]", "JSON object to upload. Can also be piped in through stdin.")
            .description("create a Send")
            .option("--file <path>", "file to Send. Can also be specified in parent's JSON.")
            .option("--text <text>", "text to Send. Can also be specified in parent's JSON.")
            .option("--hidden", "text hidden flag. Valid only with the --text option.")
            .option("--password <password>", "optional password to access this Send. Can also be specified in JSON")
            .on("--help", () => {
            send_program_writeLn("");
            send_program_writeLn("Note:");
            send_program_writeLn("  Options specified in JSON take precedence over command options");
            send_program_writeLn("", true);
        })
            .action((encodedJson, options, args) => send_program_awaiter(this, void 0, void 0, function* () {
            // Work-around to support `--fullObject` option for `send create --fullObject`
            // Calling `option('--fullObject', ...)` above won't work due to Commander doesn't like same option
            // to be defind on both parent-command and sub-command
            const { fullObject = false } = args.parent.opts();
            const mergedOptions = Object.assign(Object.assign({}, options), { fullObject: fullObject });
            const response = yield this.runCreate(encodedJson, mergedOptions);
            this.processResponse(response);
        }));
    }
    editCommand() {
        return new external_commander_namespaceObject.Command("edit")
            .argument("[encodedJson]", "Updated JSON object to save. If not provided, encodedJson is read from stdin.")
            .description("edit a Send")
            .option("--itemid <itemid>", "Overrides the itemId provided in [encodedJson]")
            .on("--help", () => {
            send_program_writeLn("");
            send_program_writeLn("Note:");
            send_program_writeLn("  You cannot update a File-type Send's file. Just delete and remake it");
            send_program_writeLn("", true);
        })
            .action((encodedJson, options) => send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const getCmd = new SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);
            const cmd = new SendEditCommand(this.serviceContainer.sendService, getCmd, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);
            const response = yield cmd.run(encodedJson, options);
            this.processResponse(response);
        }));
    }
    deleteCommand() {
        return new external_commander_namespaceObject.Command("delete")
            .argument("<id>", "The id of the Send to delete.")
            .description("delete a Send")
            .action((id) => send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = new SendDeleteCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService);
            const response = yield cmd.run(id);
            this.processResponse(response);
        }));
    }
    removePasswordCommand() {
        return new external_commander_namespaceObject.Command("remove-password")
            .argument("<id>", "The id of the Send to alter.")
            .description("removes the saved password from a Send.")
            .action((id) => send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = new SendRemovePasswordCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService, this.serviceContainer.environmentService);
            const response = yield cmd.run(id);
            this.processResponse(response);
        }));
    }
    makeSendJson(data, options) {
        var _a;
        let sendFile = null;
        let sendText = null;
        let name = Utils.newGuid();
        let type = SendType.Text;
        if (options.file != null) {
            data = external_path_namespaceObject.resolve(data);
            if (!external_fs_namespaceObject.existsSync(data)) {
                return Response.badRequest("data path does not exist");
            }
            sendFile = SendFileResponse.template(data);
            name = external_path_namespaceObject.basename(data);
            type = SendType.File;
        }
        else {
            sendText = SendTextResponse.template(data, options.hidden);
        }
        const template = Utils.assign(SendResponse.template(null, options.deleteInDays), {
            name: (_a = options.name) !== null && _a !== void 0 ? _a : name,
            notes: options.notes,
            file: sendFile,
            text: sendText,
            type: type,
        });
        return Buffer.from(JSON.stringify(template), "utf8").toString("base64");
    }
    runCreate(encodedJson, options) {
        return send_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = new SendCreateCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);
            return yield cmd.run(encodedJson, options);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/requests/organization-user-confirm.request.ts
class OrganizationUserConfirmRequest {
}

;// CONCATENATED MODULE: ./src/admin-console/commands/confirm.command.ts
var confirm_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class ConfirmCommand {
    constructor(apiService, cryptoService, organizationUserService) {
        this.apiService = apiService;
        this.cryptoService = cryptoService;
        this.organizationUserService = organizationUserService;
    }
    run(object, id, cmdOptions) {
        return confirm_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new confirm_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "org-member":
                    return yield this.confirmOrganizationMember(id, normalizedOptions);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    confirmOrganizationMember(id, options) {
        return confirm_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("--organizationid <organizationid> required.");
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                const orgKey = yield this.cryptoService.getOrgKey(options.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const orgUser = yield this.organizationUserService.getOrganizationUser(options.organizationId, id);
                if (orgUser == null) {
                    throw new Error("Member id does not exist for this organization.");
                }
                const publicKeyResponse = yield this.apiService.getUserPublicKey(orgUser.userId);
                const publicKey = Utils.fromB64ToArray(publicKeyResponse.publicKey);
                const key = yield this.cryptoService.rsaEncrypt(orgKey.key, publicKey);
                const req = new OrganizationUserConfirmRequest();
                req.key = key.encryptedString;
                yield this.organizationUserService.postOrganizationUserConfirm(options.organizationId, id, req);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}
class confirm_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
    }
}

;// CONCATENATED MODULE: ./src/admin-console/commands/share.command.ts
var share_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class ShareCommand {
    constructor(cipherService) {
        this.cipherService = cipherService;
    }
    run(id, organizationId, requestJson) {
        return share_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return Response.badRequest("`requestJson` was not provided.");
            }
            let req = [];
            if (typeof requestJson !== "string") {
                req = requestJson;
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = JSON.parse(reqJson);
                    if (req == null || req.length === 0) {
                        return Response.badRequest("You must provide at least one collection id for this item.");
                    }
                }
                catch (e) {
                    return Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            const cipher = yield this.cipherService.get(id);
            if (cipher == null) {
                return Response.notFound();
            }
            if (cipher.organizationId != null) {
                return Response.badRequest("This item already belongs to an organization.");
            }
            const cipherView = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));
            try {
                yield this.cipherService.shareWithServer(cipherView, organizationId, req);
                const updatedCipher = yield this.cipherService.get(cipher.id);
                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));
                const res = new CipherResponse(decCipher);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/request/selection-read-only.request.ts
class SelectionReadOnlyRequest {
    constructor(id, readOnly, hidePasswords, manage) {
        this.id = id;
        this.readOnly = readOnly;
        this.hidePasswords = hidePasswords;
        this.manage = manage;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/collection.request.ts
class CollectionRequest {
    constructor(collection) {
        this.groups = [];
        this.users = [];
        if (collection == null) {
            return;
        }
        this.name = collection.name ? collection.name.encryptedString : null;
        this.externalId = collection.externalId;
    }
}

;// CONCATENATED MODULE: ./src/commands/edit.command.ts
var commands_edit_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class EditCommand {
    constructor(cipherService, folderService, cryptoService, apiService, folderApiService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
    }
    run(object, id, requestJson, cmdOptions) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return Response.badRequest("`requestJson` was not provided.");
            }
            let req = null;
            if (typeof requestJson !== "string") {
                req = requestJson;
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = JSON.parse(reqJson);
                }
                catch (e) {
                    return Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new commands_edit_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.editCipher(id, req);
                case "item-collections":
                    return yield this.editCipherCollections(id, req);
                case "folder":
                    return yield this.editFolder(id, req);
                case "org-collection":
                    return yield this.editOrganizationCollection(id, req, normalizedOptions);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    editCipher(id, req) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            const cipher = yield this.cipherService.get(id);
            if (cipher == null) {
                return Response.notFound();
            }
            let cipherView = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));
            if (cipherView.isDeleted) {
                return Response.badRequest("You may not edit a deleted item. Use the restore command first.");
            }
            cipherView = CipherExport.toView(req, cipherView);
            const encCipher = yield this.cipherService.encrypt(cipherView);
            try {
                const updatedCipher = yield this.cipherService.updateWithServer(encCipher);
                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));
                const res = new CipherResponse(decCipher);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    editCipherCollections(id, req) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            const cipher = yield this.cipherService.get(id);
            if (cipher == null) {
                return Response.notFound();
            }
            if (cipher.organizationId == null) {
                return Response.badRequest("Item does not belong to an organization. Consider moving it first.");
            }
            cipher.collectionIds = req;
            try {
                const updatedCipher = yield this.cipherService.saveCollectionsWithServer(cipher);
                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));
                const res = new CipherResponse(decCipher);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    editFolder(id, req) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            const folder = yield this.folderService.getFromState(id);
            if (folder == null) {
                return Response.notFound();
            }
            let folderView = yield folder.decrypt();
            folderView = FolderExport.toView(req, folderView);
            const encFolder = yield this.folderService.encrypt(folderView);
            try {
                yield this.folderApiService.save(encFolder);
                const updatedFolder = yield this.folderService.get(folder.id);
                const decFolder = yield updatedFolder.decrypt();
                const res = new FolderResponse(decFolder);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    editOrganizationCollection(id, req, options) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` option is required.");
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            if (options.organizationId !== req.organizationId) {
                return Response.badRequest("`organizationid` option does not match request object.");
            }
            try {
                const orgKey = yield this.cryptoService.getOrgKey(req.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const groups = req.groups == null
                    ? null
                    : req.groups.map((g) => new SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));
                const users = req.users == null
                    ? null
                    : req.users.map((u) => new SelectionReadOnlyRequest(u.id, u.readOnly, u.hidePasswords, u.manage));
                const request = new CollectionRequest();
                request.name = (yield this.cryptoService.encrypt(req.name, orgKey)).encryptedString;
                request.externalId = req.externalId;
                request.groups = groups;
                request.users = users;
                const response = yield this.apiService.putCollection(req.organizationId, id, request);
                const view = CollectionExport.toView(req);
                view.id = response.id;
                const res = new OrganizationCollectionResponse(view, groups);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}
class commands_edit_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/collection.data.ts

class CollectionData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.name = response.name;
        this.externalId = response.externalId;
        this.readOnly = response.readOnly;
        this.manage = response.manage;
        this.hidePasswords = response.hidePasswords;
    }
    static fromJSON(obj) {
        return Object.assign(new CollectionData(new CollectionDetailsResponse({})), obj);
    }
}

;// CONCATENATED MODULE: ./src/admin-console/models/response/organization-user.response.ts
class OrganizationUserResponse {
    constructor() {
        this.object = "org-member";
    }
}

;// CONCATENATED MODULE: ./src/commands/list.command.ts
var commands_list_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













class ListCommand {
    constructor(cipherService, folderService, collectionService, organizationService, searchService, organizationUserService, apiService, eventCollectionService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.organizationService = organizationService;
        this.searchService = searchService;
        this.organizationUserService = organizationUserService;
        this.apiService = apiService;
        this.eventCollectionService = eventCollectionService;
    }
    run(object, cmdOptions) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new commands_list_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "items":
                    return yield this.listCiphers(normalizedOptions);
                case "folders":
                    return yield this.listFolders(normalizedOptions);
                case "collections":
                    return yield this.listCollections(normalizedOptions);
                case "org-collections":
                    return yield this.listOrganizationCollections(normalizedOptions);
                case "org-members":
                    return yield this.listOrganizationMembers(normalizedOptions);
                case "organizations":
                    return yield this.listOrganizations(normalizedOptions);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    listCiphers(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            let ciphers;
            options.trash = options.trash || false;
            if (options.url != null && options.url.trim() !== "") {
                ciphers = yield this.cipherService.getAllDecryptedForUrl(options.url);
            }
            else {
                ciphers = yield this.cipherService.getAllDecrypted();
            }
            if (options.folderId != null ||
                options.collectionId != null ||
                options.organizationId != null) {
                ciphers = ciphers.filter((c) => {
                    if (options.trash !== c.isDeleted) {
                        return false;
                    }
                    if (options.folderId != null) {
                        if (options.folderId === "notnull" && c.folderId != null) {
                            return true;
                        }
                        const folderId = options.folderId === "null" ? null : options.folderId;
                        if (folderId === c.folderId) {
                            return true;
                        }
                    }
                    if (options.organizationId != null) {
                        if (options.organizationId === "notnull" && c.organizationId != null) {
                            return true;
                        }
                        const organizationId = options.organizationId === "null" ? null : options.organizationId;
                        if (organizationId === c.organizationId) {
                            return true;
                        }
                    }
                    if (options.collectionId != null) {
                        if (options.collectionId === "notnull" &&
                            c.collectionIds != null &&
                            c.collectionIds.length > 0) {
                            return true;
                        }
                        const collectionId = options.collectionId === "null" ? null : options.collectionId;
                        if (collectionId == null && (c.collectionIds == null || c.collectionIds.length === 0)) {
                            return true;
                        }
                        if (collectionId != null &&
                            c.collectionIds != null &&
                            c.collectionIds.indexOf(collectionId) > -1) {
                            return true;
                        }
                    }
                    return false;
                });
            }
            else if (options.search == null || options.search.trim() === "") {
                ciphers = ciphers.filter((c) => options.trash === c.isDeleted);
            }
            if (options.search != null && options.search.trim() !== "") {
                ciphers = this.searchService.searchCiphersBasic(ciphers, options.search, options.trash);
            }
            yield this.eventCollectionService.collectMany(EventType.Cipher_ClientViewed, ciphers, true);
            const res = new ListResponse(ciphers.map((o) => new CipherResponse(o)));
            return Response.success(res);
        });
    }
    listFolders(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            let folders = yield this.folderService.getAllDecryptedFromState();
            if (options.search != null && options.search.trim() !== "") {
                folders = CliUtils.searchFolders(folders, options.search);
            }
            const res = new ListResponse(folders.map((o) => new FolderResponse(o)));
            return Response.success(res);
        });
    }
    listCollections(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            let collections = yield this.collectionService.getAllDecrypted();
            if (options.organizationId != null) {
                collections = collections.filter((c) => {
                    if (options.organizationId === c.organizationId) {
                        return true;
                    }
                    return false;
                });
            }
            if (options.search != null && options.search.trim() !== "") {
                collections = CliUtils.searchCollections(collections, options.search);
            }
            const res = new ListResponse(collections.map((o) => new collection_response_CollectionResponse(o)));
            return Response.success(res);
        });
    }
    listOrganizationCollections(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` option is required.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            const organization = yield this.organizationService.getFromState(options.organizationId);
            if (organization == null) {
                return Response.error("Organization not found.");
            }
            try {
                let response;
                if (organization.canViewAllCollections) {
                    response = yield this.apiService.getCollections(options.organizationId);
                }
                else {
                    response = yield this.apiService.getUserCollections();
                }
                const collections = response.data
                    .filter((c) => c.organizationId === options.organizationId)
                    .map((r) => new Collection(new CollectionData(r)));
                let decCollections = yield this.collectionService.decryptMany(collections);
                if (options.search != null && options.search.trim() !== "") {
                    decCollections = CliUtils.searchCollections(decCollections, options.search);
                }
                const res = new ListResponse(decCollections.map((o) => new collection_response_CollectionResponse(o)));
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    listOrganizationMembers(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` option is required.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            const organization = yield this.organizationService.getFromState(options.organizationId);
            if (organization == null) {
                return Response.error("Organization not found.");
            }
            try {
                const response = yield this.organizationUserService.getAllUsers(options.organizationId);
                const res = new ListResponse(response.data.map((r) => {
                    const u = new OrganizationUserResponse();
                    u.email = r.email;
                    u.name = r.name;
                    u.id = r.id;
                    u.status = r.status;
                    u.type = r.type;
                    u.twoFactorEnabled = r.twoFactorEnabled;
                    return u;
                }));
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    listOrganizations(options) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            let organizations = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.memberOrganizations$);
            if (options.search != null && options.search.trim() !== "") {
                organizations = CliUtils.searchOrganizations(organizations, options.search);
            }
            const res = new ListResponse(organizations.map((o) => new OrganizationResponse(o)));
            return Response.success(res);
        });
    }
}
class commands_list_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.collectionId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionId);
        this.folderId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderId);
        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;
        this.url = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.url;
        this.trash = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.trash);
    }
}

;// CONCATENATED MODULE: ./src/commands/restore.command.ts
var restore_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RestoreCommand {
    constructor(cipherService) {
        this.cipherService = cipherService;
    }
    run(object, id) {
        return restore_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.restoreCipher(id);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    restoreCipher(id) {
        return restore_command_awaiter(this, void 0, void 0, function* () {
            const cipher = yield this.cipherService.get(id);
            if (cipher == null) {
                return Response.notFound();
            }
            if (cipher.deletedDate == null) {
                return Response.badRequest("Cipher is not in trash.");
            }
            try {
                yield this.cipherService.restoreWithServer(id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/vault-export.service.abstraction.ts
const EXPORT_FORMATS = ["csv", "json", "encrypted_json"];
class VaultExportServiceAbstraction {
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/export-helper.ts
class ExportHelper {
    static getFileName(prefix = null, extension = "csv") {
        const now = new Date();
        const dateString = now.getFullYear() +
            "" +
            this.padNumber(now.getMonth() + 1, 2) +
            "" +
            this.padNumber(now.getDate(), 2) +
            this.padNumber(now.getHours(), 2) +
            "" +
            this.padNumber(now.getMinutes(), 2) +
            this.padNumber(now.getSeconds(), 2);
        return "bitwarden" + (prefix ? "_" + prefix : "") + "_export_" + dateString + "." + extension;
    }
    static padNumber(num, width, padCharacter = "0") {
        const numString = num.toString();
        return numString.length >= width
            ? numString
            : new Array(width - numString.length + 1).join(padCharacter) + numString;
    }
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/vault-export.service.ts
var vault_export_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class VaultExportService {
    constructor(individualVaultExportService, organizationVaultExportService) {
        this.individualVaultExportService = individualVaultExportService;
        this.organizationVaultExportService = organizationVaultExportService;
    }
    getExport(format = "csv", password) {
        return vault_export_service_awaiter(this, void 0, void 0, function* () {
            if (!Utils.isNullOrWhitespace(password)) {
                if (format == "csv") {
                    throw new Error("CSV does not support password protected export");
                }
                return this.individualVaultExportService.getPasswordProtectedExport(password);
            }
            return this.individualVaultExportService.getExport(format);
        });
    }
    getOrganizationExport(organizationId, format, password, onlyManagedCollections = false) {
        return vault_export_service_awaiter(this, void 0, void 0, function* () {
            if (!Utils.isNullOrWhitespace(password)) {
                if (format == "csv") {
                    throw new Error("CSV does not support password protected export");
                }
                return this.organizationVaultExportService.getPasswordProtectedExport(organizationId, password, onlyManagedCollections);
            }
            return this.organizationVaultExportService.getOrganizationExport(organizationId, format, onlyManagedCollections);
        });
    }
    getFileName(prefix = null, extension = "csv") {
        return ExportHelper.getFileName(prefix, extension);
    }
}

;// CONCATENATED MODULE: external "papaparse"
const external_papaparse_namespaceObject = require("papaparse");
;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/base-vault-export.service.ts
var base_vault_export_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class BaseVaultExportService {
    constructor(pinService, cryptoService, cryptoFunctionService, kdfConfigService) {
        this.pinService = pinService;
        this.cryptoService = cryptoService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.kdfConfigService = kdfConfigService;
    }
    buildPasswordExport(clearText, password) {
        return base_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const kdfConfig = yield this.kdfConfigService.getKdfConfig();
            const salt = Utils.fromBufferToB64(yield this.cryptoFunctionService.randomBytes(16));
            const key = yield this.pinService.makePinKey(password, salt, kdfConfig);
            const encKeyValidation = yield this.cryptoService.encrypt(Utils.newGuid(), key);
            const encText = yield this.cryptoService.encrypt(clearText, key);
            const jsonDoc = {
                encrypted: true,
                passwordProtected: true,
                salt: salt,
                kdfType: kdfConfig.kdfType,
                kdfIterations: kdfConfig.iterations,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                data: encText.encryptedString,
            };
            if (kdfConfig.kdfType === KdfType.Argon2id) {
                jsonDoc.kdfMemory = kdfConfig.memory;
                jsonDoc.kdfParallelism = kdfConfig.parallelism;
            }
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    buildCommonCipher(cipher, c) {
        cipher.type = null;
        cipher.name = c.name;
        cipher.notes = c.notes;
        cipher.fields = null;
        cipher.reprompt = c.reprompt;
        // Login props
        cipher.login_uri = null;
        cipher.login_username = null;
        cipher.login_password = null;
        cipher.login_totp = null;
        if (c.fields) {
            c.fields.forEach((f) => {
                if (!cipher.fields) {
                    cipher.fields = "";
                }
                else {
                    cipher.fields += "\n";
                }
                cipher.fields += (f.name || "") + ": " + f.value;
            });
        }
        switch (c.type) {
            case CipherType.Login:
                cipher.type = "login";
                cipher.login_username = c.login.username;
                cipher.login_password = c.login.password;
                cipher.login_totp = c.login.totp;
                if (c.login.uris) {
                    cipher.login_uri = [];
                    c.login.uris.forEach((u) => {
                        cipher.login_uri.push(u.uri);
                    });
                }
                break;
            case CipherType.SecureNote:
                cipher.type = "note";
                break;
            default:
                return;
        }
        return cipher;
    }
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/org-vault-export.service.ts
var org_vault_export_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










class OrganizationVaultExportService extends BaseVaultExportService {
    constructor(cipherService, apiService, pinService, cryptoService, cryptoFunctionService, collectionService, kdfConfigService) {
        super(pinService, cryptoService, cryptoFunctionService, kdfConfigService);
        this.cipherService = cipherService;
        this.apiService = apiService;
        this.collectionService = collectionService;
    }
    getPasswordProtectedExport(organizationId, password, onlyManagedCollections) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const clearText = yield this.getOrganizationExport(organizationId, "json", onlyManagedCollections);
            return this.buildPasswordExport(clearText, password);
        });
    }
    getOrganizationExport(organizationId, format = "csv", onlyManagedCollections) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            if (Utils.isNullOrWhitespace(organizationId)) {
                throw new Error("OrganizationId must be set");
            }
            if (format === "encrypted_json") {
                return onlyManagedCollections
                    ? this.getEncryptedManagedExport(organizationId)
                    : this.getOrganizationEncryptedExport(organizationId);
            }
            return onlyManagedCollections
                ? this.getDecryptedManagedExport(organizationId, format)
                : this.getOrganizationDecryptedExport(organizationId, format);
        });
    }
    getOrganizationDecryptedExport(organizationId, format) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const decCollections = [];
            const decCiphers = [];
            const promises = [];
            promises.push(this.apiService.getOrganizationExport(organizationId).then((exportData) => {
                const exportPromises = [];
                if (exportData != null) {
                    if (exportData.collections != null && exportData.collections.length > 0) {
                        exportData.collections.forEach((c) => {
                            const collection = new Collection(new CollectionData(c));
                            exportPromises.push((0,external_rxjs_namespaceObject.firstValueFrom)(this.cryptoService.activeUserOrgKeys$)
                                .then((keys) => collection.decrypt(keys[organizationId]))
                                .then((decCol) => {
                                decCollections.push(decCol);
                            }));
                        });
                    }
                    if (exportData.ciphers != null && exportData.ciphers.length > 0) {
                        exportData.ciphers
                            .filter((c) => c.deletedDate === null)
                            .forEach((c) => org_vault_export_service_awaiter(this, void 0, void 0, function* () {
                            const cipher = new Cipher(new CipherData(c));
                            exportPromises.push(this.cipherService
                                .getKeyForCipherKeyDecryption(cipher)
                                .then((key) => cipher.decrypt(key))
                                .then((decCipher) => {
                                decCiphers.push(decCipher);
                            }));
                        }));
                    }
                }
                return Promise.all(exportPromises);
            }));
            yield Promise.all(promises);
            if (format === "csv") {
                return this.buildCsvExport(decCollections, decCiphers);
            }
            return this.buildJsonExport(decCollections, decCiphers);
        });
    }
    getOrganizationEncryptedExport(organizationId) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const collections = [];
            const ciphers = [];
            const promises = [];
            promises.push(this.apiService.getCollections(organizationId).then((c) => {
                if (c != null && c.data != null && c.data.length > 0) {
                    c.data.forEach((r) => {
                        const collection = new Collection(new CollectionData(r));
                        collections.push(collection);
                    });
                }
            }));
            promises.push(this.apiService.getCiphersOrganization(organizationId).then((c) => {
                if (c != null && c.data != null && c.data.length > 0) {
                    c.data
                        .filter((item) => item.deletedDate === null)
                        .forEach((item) => {
                        const cipher = new Cipher(new CipherData(item));
                        ciphers.push(cipher);
                    });
                }
            }));
            yield Promise.all(promises);
            return this.BuildEncryptedExport(organizationId, collections, ciphers);
        });
    }
    getDecryptedManagedExport(organizationId, format) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            let decCiphers = [];
            let allDecCiphers = [];
            let decCollections = [];
            const promises = [];
            promises.push(this.collectionService.getAllDecrypted().then((collections) => org_vault_export_service_awaiter(this, void 0, void 0, function* () {
                decCollections = collections.filter((c) => c.organizationId == organizationId && c.manage);
            })));
            promises.push(this.cipherService.getAllDecrypted().then((ciphers) => {
                allDecCiphers = ciphers;
            }));
            yield Promise.all(promises);
            decCiphers = allDecCiphers.filter((f) => f.deletedDate == null &&
                f.organizationId == organizationId &&
                decCollections.some((dC) => f.collectionIds.some((cId) => dC.id === cId)));
            if (format === "csv") {
                return this.buildCsvExport(decCollections, decCiphers);
            }
            return this.buildJsonExport(decCollections, decCiphers);
        });
    }
    getEncryptedManagedExport(organizationId) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            let encCiphers = [];
            let allCiphers = [];
            let encCollections = [];
            const promises = [];
            promises.push(this.collectionService.getAll().then((collections) => {
                encCollections = collections.filter((c) => c.organizationId == organizationId && c.manage);
            }));
            promises.push(this.cipherService.getAll().then((ciphers) => {
                allCiphers = ciphers;
            }));
            yield Promise.all(promises);
            encCiphers = allCiphers.filter((f) => f.deletedDate == null &&
                f.organizationId == organizationId &&
                encCollections.some((eC) => f.collectionIds.some((cId) => eC.id === cId)));
            return this.BuildEncryptedExport(organizationId, encCollections, encCiphers);
        });
    }
    BuildEncryptedExport(organizationId, collections, ciphers) {
        return org_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const orgKey = yield this.cryptoService.getOrgKey(organizationId);
            const encKeyValidation = yield this.cryptoService.encrypt(Utils.newGuid(), orgKey);
            const jsonDoc = {
                encrypted: true,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                collections: [],
                items: [],
            };
            collections.forEach((c) => {
                const collection = new CollectionWithIdExport();
                collection.build(c);
                jsonDoc.collections.push(collection);
            });
            ciphers.forEach((c) => {
                const cipher = new CipherWithIdExport();
                cipher.build(c);
                jsonDoc.items.push(cipher);
            });
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    buildCsvExport(decCollections, decCiphers) {
        const collectionsMap = new Map();
        decCollections.forEach((c) => {
            collectionsMap.set(c.id, c);
        });
        const exportCiphers = [];
        decCiphers.forEach((c) => {
            // only export logins and secure notes
            if (c.type !== CipherType.Login && c.type !== CipherType.SecureNote) {
                return;
            }
            const cipher = {};
            cipher.collections = [];
            if (c.collectionIds != null) {
                cipher.collections = c.collectionIds
                    .filter((id) => collectionsMap.has(id))
                    .map((id) => collectionsMap.get(id).name);
            }
            this.buildCommonCipher(cipher, c);
            exportCiphers.push(cipher);
        });
        return external_papaparse_namespaceObject.unparse(exportCiphers);
    }
    buildJsonExport(decCollections, decCiphers) {
        const jsonDoc = {
            encrypted: false,
            collections: [],
            items: [],
        };
        decCollections.forEach((c) => {
            const collection = new CollectionWithIdExport();
            collection.build(c);
            jsonDoc.collections.push(collection);
        });
        decCiphers.forEach((c) => {
            const cipher = new CipherWithIdExport();
            cipher.build(c);
            jsonDoc.items.push(cipher);
        });
        return JSON.stringify(jsonDoc, null, "  ");
    }
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/services/individual-vault-export.service.ts
var individual_vault_export_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class IndividualVaultExportService extends BaseVaultExportService {
    constructor(folderService, cipherService, pinService, cryptoService, cryptoFunctionService, kdfConfigService) {
        super(pinService, cryptoService, cryptoFunctionService, kdfConfigService);
        this.folderService = folderService;
        this.cipherService = cipherService;
    }
    getExport(format = "csv") {
        return individual_vault_export_service_awaiter(this, void 0, void 0, function* () {
            if (format === "encrypted_json") {
                return this.getEncryptedExport();
            }
            return this.getDecryptedExport(format);
        });
    }
    getPasswordProtectedExport(password) {
        return individual_vault_export_service_awaiter(this, void 0, void 0, function* () {
            const clearText = yield this.getExport("json");
            return this.buildPasswordExport(clearText, password);
        });
    }
    getDecryptedExport(format) {
        return individual_vault_export_service_awaiter(this, void 0, void 0, function* () {
            let decFolders = [];
            let decCiphers = [];
            const promises = [];
            promises.push(this.folderService.getAllDecryptedFromState().then((folders) => {
                decFolders = folders;
            }));
            promises.push(this.cipherService.getAllDecrypted().then((ciphers) => {
                decCiphers = ciphers.filter((f) => f.deletedDate == null);
            }));
            yield Promise.all(promises);
            if (format === "csv") {
                return this.buildCsvExport(decFolders, decCiphers);
            }
            return this.buildJsonExport(decFolders, decCiphers);
        });
    }
    getEncryptedExport() {
        return individual_vault_export_service_awaiter(this, void 0, void 0, function* () {
            let folders = [];
            let ciphers = [];
            const promises = [];
            promises.push(this.folderService.getAllFromState().then((f) => {
                folders = f;
            }));
            promises.push(this.cipherService.getAll().then((c) => {
                ciphers = c.filter((f) => f.deletedDate == null);
            }));
            yield Promise.all(promises);
            const encKeyValidation = yield this.cryptoService.encrypt(Utils.newGuid());
            const jsonDoc = {
                encrypted: true,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                folders: [],
                items: [],
            };
            folders.forEach((f) => {
                if (f.id == null) {
                    return;
                }
                const folder = new FolderWithIdExport();
                folder.build(f);
                jsonDoc.folders.push(folder);
            });
            ciphers.forEach((c) => {
                if (c.organizationId != null) {
                    return;
                }
                const cipher = new CipherWithIdExport();
                cipher.build(c);
                cipher.collectionIds = null;
                jsonDoc.items.push(cipher);
            });
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    buildCsvExport(decFolders, decCiphers) {
        const foldersMap = new Map();
        decFolders.forEach((f) => {
            if (f.id != null) {
                foldersMap.set(f.id, f);
            }
        });
        const exportCiphers = [];
        decCiphers.forEach((c) => {
            // only export logins and secure notes
            if (c.type !== CipherType.Login && c.type !== CipherType.SecureNote) {
                return;
            }
            if (c.organizationId != null) {
                return;
            }
            const cipher = {};
            cipher.folder =
                c.folderId != null && foldersMap.has(c.folderId) ? foldersMap.get(c.folderId).name : null;
            cipher.favorite = c.favorite ? 1 : null;
            this.buildCommonCipher(cipher, c);
            exportCiphers.push(cipher);
        });
        return external_papaparse_namespaceObject.unparse(exportCiphers);
    }
    buildJsonExport(decFolders, decCiphers) {
        const jsonDoc = {
            encrypted: false,
            folders: [],
            items: [],
        };
        decFolders.forEach((f) => {
            if (f.id == null) {
                return;
            }
            const folder = new FolderWithIdExport();
            folder.build(f);
            jsonDoc.folders.push(folder);
        });
        decCiphers.forEach((c) => {
            if (c.organizationId != null) {
                return;
            }
            const cipher = new CipherWithIdExport();
            cipher.build(c);
            cipher.collectionIds = null;
            jsonDoc.items.push(cipher);
        });
        return JSON.stringify(jsonDoc, null, "  ");
    }
}

;// CONCATENATED MODULE: ../../libs/tools/export/vault-export/vault-export-core/src/index.ts









;// CONCATENATED MODULE: ./src/tools/export.command.ts
var export_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class ExportCommand {
    constructor(exportService, policyService, eventCollectionService) {
        this.exportService = exportService;
        this.policyService = policyService;
        this.eventCollectionService = eventCollectionService;
    }
    run(options) {
        var _a;
        return export_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationid == null &&
                (yield this.policyService.policyAppliesToUser(PolicyType.DisablePersonalVaultExport))) {
                return Response.badRequest("One or more organization policies prevents you from exporting your personal vault.");
            }
            let password = options.password;
            // has password and format is 'json' => should have the same behaviour as 'encrypted_json'
            // format is 'undefined' => Defaults to 'csv'
            // Any other case => returns the options.format
            const format = password && options.format == "json" ? "encrypted_json" : (_a = options.format) !== null && _a !== void 0 ? _a : "csv";
            if (!this.isSupportedExportFormat(format)) {
                return Response.badRequest(`'${format}' is not a supported export format. Supported formats: ${EXPORT_FORMATS.join(", ")}.`);
            }
            if (options.organizationid != null && !Utils.isGuid(options.organizationid)) {
                return Response.error("`" + options.organizationid + "` is not a GUID.");
            }
            let exportContent = null;
            try {
                if (format === "encrypted_json") {
                    password = yield this.promptPassword(password);
                }
                exportContent =
                    options.organizationid == null
                        ? yield this.exportService.getExport(format, password)
                        : yield this.exportService.getOrganizationExport(options.organizationid, format, password);
                const eventType = options.organizationid
                    ? EventType.Organization_ClientExportedVault
                    : EventType.User_ClientExportedVault;
                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.eventCollectionService.collect(eventType, null, true, options.organizationid);
            }
            catch (e) {
                return Response.error(e);
            }
            return yield this.saveFile(exportContent, options, format);
        });
    }
    saveFile(exportContent, options, format) {
        return export_command_awaiter(this, void 0, void 0, function* () {
            try {
                const fileName = this.getFileName(format, options.organizationid != null ? "org" : null);
                return yield CliUtils.saveResultToFile(exportContent, options.output, fileName);
            }
            catch (e) {
                return Response.error(e.toString());
            }
        });
    }
    getFileName(format, prefix) {
        if (format === "encrypted_json") {
            if (prefix == null) {
                prefix = "encrypted";
            }
            else {
                prefix = "encrypted_" + prefix;
            }
            format = "json";
        }
        return this.exportService.getFileName(prefix, format);
    }
    promptPassword(password) {
        return export_command_awaiter(this, void 0, void 0, function* () {
            // boolean => flag set with no value, we need to prompt for password
            // string => flag set with value, use this value for password
            // undefined/null/false => account protect, not password, no password needed
            if (typeof password === "string") {
                return password;
            }
            else if (password) {
                const answer = yield external_inquirer_namespaceObject.createPromptModule({
                    output: process.stderr,
                })({
                    type: "password",
                    name: "password",
                    message: "Export file password:",
                });
                return answer.password;
            }
            return null;
        });
    }
    isSupportedExportFormat(format) {
        return EXPORT_FORMATS.includes(format);
    }
}

;// CONCATENATED MODULE: ./src/tools/import.command.ts
var import_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class ImportCommand {
    constructor(importService, organizationService, syncService) {
        this.importService = importService;
        this.organizationService = organizationService;
        this.syncService = syncService;
    }
    run(format, filepath, options) {
        return import_command_awaiter(this, void 0, void 0, function* () {
            const organizationId = options.organizationid;
            if (organizationId != null) {
                const organization = yield this.organizationService.getFromState(organizationId);
                if (organization == null) {
                    return Response.badRequest(`You do not belong to an organization with the ID of ${organizationId}. Check the organization ID and sync your vault.`);
                }
                if (!organization.canAccessImportExport) {
                    return Response.badRequest("You are not authorized to import into the provided organization.");
                }
            }
            if (options.formats || false) {
                return yield this.list();
            }
            else {
                return yield this.import(format, filepath, organizationId);
            }
        });
    }
    import(format, filepath, organizationId) {
        return import_command_awaiter(this, void 0, void 0, function* () {
            if (format == null) {
                return Response.badRequest("`format` was not provided.");
            }
            if (filepath == null || filepath === "") {
                return Response.badRequest("`filepath` was not provided.");
            }
            const promptForPassword_callback = () => import_command_awaiter(this, void 0, void 0, function* () {
                return yield this.promptPassword();
            });
            const importer = yield this.importService.getImporter(format, promptForPassword_callback, organizationId);
            if (importer === null) {
                return Response.badRequest("Proper importer type required.");
            }
            try {
                let contents;
                if (format === "1password1pux" && filepath.endsWith(".1pux")) {
                    contents = yield CliUtils.extractZipContent(filepath, "export.data");
                }
                else if (format === "protonpass" && filepath.endsWith(".zip")) {
                    contents = yield CliUtils.extractZipContent(filepath, "Proton Pass/data.json");
                }
                else {
                    contents = yield CliUtils.readFile(filepath);
                }
                if (contents === null || contents === "") {
                    return Response.badRequest("Import file was empty.");
                }
                const response = yield this.importService.import(importer, contents, organizationId);
                if (response.success) {
                    // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                    // eslint-disable-next-line @typescript-eslint/no-floating-promises
                    this.syncService.fullSync(true);
                    return Response.success(new MessageResponse("Imported " + filepath, null));
                }
            }
            catch (err) {
                if (err.message) {
                    return Response.badRequest(err.message);
                }
                return Response.badRequest(err);
            }
        });
    }
    list() {
        return import_command_awaiter(this, void 0, void 0, function* () {
            const options = this.importService
                .getImportOptions()
                .sort((a, b) => {
                return a.id < b.id ? -1 : a.id > b.id ? 1 : 0;
            })
                .map((option) => option.id)
                .join("\n");
            const res = new MessageResponse("Supported input formats:", options);
            res.raw = options;
            return Response.success(res);
        });
    }
    promptPassword() {
        return import_command_awaiter(this, void 0, void 0, function* () {
            const answer = yield external_inquirer_namespaceObject.createPromptModule({
                output: process.stderr,
            })({
                type: "password",
                name: "password",
                message: "Import file password:",
            });
            return answer.password;
        });
    }
}

;// CONCATENATED MODULE: ./src/vault/create.command.ts
var vault_create_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














class CreateCommand {
    constructor(cipherService, folderService, cryptoService, apiService, folderApiService, accountProfileService, organizationService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
        this.accountProfileService = accountProfileService;
        this.organizationService = organizationService;
    }
    run(object, requestJson, cmdOptions, additionalData = null) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            let req = null;
            if (object !== "attachment") {
                if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                    requestJson = yield CliUtils.readStdin();
                }
                if (requestJson == null || requestJson === "") {
                    return Response.badRequest("`requestJson` was not provided.");
                }
                if (typeof requestJson !== "string") {
                    req = requestJson;
                }
                else {
                    try {
                        const reqJson = Buffer.from(requestJson, "base64").toString();
                        req = JSON.parse(reqJson);
                    }
                    catch (e) {
                        return Response.badRequest("Error parsing the encoded request data.");
                    }
                }
            }
            const normalizedOptions = new vault_create_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.createCipher(req);
                case "attachment":
                    return yield this.createAttachment(normalizedOptions, additionalData);
                case "folder":
                    return yield this.createFolder(req);
                case "org-collection":
                    return yield this.createOrganizationCollection(req, normalizedOptions);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    createCipher(req) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            const cipher = yield this.cipherService.encrypt(CipherExport.toView(req));
            try {
                const newCipher = yield this.cipherService.createWithServer(cipher);
                const decCipher = yield newCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(newCipher));
                const res = new CipherResponse(decCipher);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    createAttachment(options, additionalData) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return Response.badRequest("`itemid` option is required.");
            }
            let fileBuf = null;
            let fileName = null;
            if (process.env.BW_SERVE === "true") {
                fileBuf = additionalData.fileBuffer;
                fileName = additionalData.fileName;
            }
            else {
                if (options.file == null || options.file === "") {
                    return Response.badRequest("`file` option is required.");
                }
                const filePath = external_path_namespaceObject.resolve(options.file);
                if (!external_fs_namespaceObject.existsSync(options.file)) {
                    return Response.badRequest("Cannot find file at " + filePath);
                }
                fileBuf = external_fs_namespaceObject.readFileSync(filePath);
                fileName = external_path_namespaceObject.basename(filePath);
            }
            if (fileBuf == null) {
                return Response.badRequest("File not provided.");
            }
            if (fileName == null || fileName.trim() === "") {
                return Response.badRequest("File name not provided.");
            }
            const itemId = options.itemId.toLowerCase();
            const cipher = yield this.cipherService.get(itemId);
            if (cipher == null) {
                return Response.notFound();
            }
            if (cipher.organizationId == null &&
                !(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$))) {
                return Response.error("Premium status is required to use this feature.");
            }
            const userKey = yield this.cryptoService.getUserKey();
            if (userKey == null) {
                return Response.error("You must update your encryption key before you can use this feature. " +
                    "See https://help.bitwarden.com/article/update-encryption-key/");
            }
            try {
                const updatedCipher = yield this.cipherService.saveAttachmentRawWithServer(cipher, fileName, new Uint8Array(fileBuf).buffer);
                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));
                return Response.success(new CipherResponse(decCipher));
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    createFolder(req) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            const folder = yield this.folderService.encrypt(FolderExport.toView(req));
            try {
                yield this.folderApiService.save(folder);
                const newFolder = yield this.folderService.get(folder.id);
                const decFolder = yield newFolder.decrypt();
                const res = new FolderResponse(decFolder);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    createOrganizationCollection(req, options) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` option is required.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            if (options.organizationId !== req.organizationId) {
                return Response.badRequest("`organizationid` option does not match request object.");
            }
            try {
                const orgKey = yield this.cryptoService.getOrgKey(req.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const organization = yield this.organizationService.get(req.organizationId);
                const currentOrgUserId = organization.organizationUserId;
                const groups = req.groups == null
                    ? null
                    : req.groups.map((g) => new SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));
                const users = req.users == null
                    ? [new SelectionReadOnlyRequest(currentOrgUserId, false, false, true)]
                    : req.users.map((u) => new SelectionReadOnlyRequest(u.id, u.readOnly, u.hidePasswords, u.manage));
                const request = new CollectionRequest();
                request.name = (yield this.cryptoService.encrypt(req.name, orgKey)).encryptedString;
                request.externalId = req.externalId;
                request.groups = groups;
                request.users = users;
                const response = yield this.apiService.postCollection(req.organizationId, request);
                const view = CollectionExport.toView(req);
                view.id = response.id;
                const res = new OrganizationCollectionResponse(view, groups);
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}
class vault_create_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.file = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.file;
    }
}

;// CONCATENATED MODULE: ./src/vault/delete.command.ts
var vault_delete_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class DeleteCommand {
    constructor(cipherService, folderService, apiService, folderApiService, accountProfileService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
        this.accountProfileService = accountProfileService;
    }
    run(object, id, cmdOptions) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new delete_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.deleteCipher(id, normalizedOptions);
                case "attachment":
                    return yield this.deleteAttachment(id, normalizedOptions);
                case "folder":
                    return yield this.deleteFolder(id);
                case "org-collection":
                    return yield this.deleteOrganizationCollection(id, normalizedOptions);
                default:
                    return Response.badRequest("Unknown object.");
            }
        });
    }
    deleteCipher(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            const cipher = yield this.cipherService.get(id);
            if (cipher == null) {
                return Response.notFound();
            }
            try {
                if (options.permanent) {
                    yield this.cipherService.deleteWithServer(id);
                }
                else {
                    yield this.cipherService.softDeleteWithServer(id);
                }
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    deleteAttachment(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return Response.badRequest("`itemid` option is required.");
            }
            const itemId = options.itemId.toLowerCase();
            const cipher = yield this.cipherService.get(itemId);
            if (cipher == null) {
                return Response.notFound();
            }
            if (cipher.attachments == null || cipher.attachments.length === 0) {
                return Response.error("No attachments available for this item.");
            }
            const attachments = cipher.attachments.filter((a) => a.id.toLowerCase() === id);
            if (attachments.length === 0) {
                return Response.error("Attachment `" + id + "` was not found.");
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);
            if (cipher.organizationId == null && !canAccessPremium) {
                return Response.error("Premium status is required to use this feature.");
            }
            try {
                yield this.cipherService.deleteAttachmentWithServer(cipher.id, attachments[0].id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    deleteFolder(id) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            const folder = yield this.folderService.getFromState(id);
            if (folder == null) {
                return Response.notFound();
            }
            try {
                yield this.folderApiService.delete(id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    deleteOrganizationCollection(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return Response.badRequest("`organizationid` options is required.");
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!Utils.isGuid(options.organizationId)) {
                return Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                yield this.apiService.deleteCollection(options.organizationId, id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
}
class delete_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.permanent = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.permanent);
    }
}

;// CONCATENATED MODULE: ./src/vault.program.ts
var vault_program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














const vault_program_writeLn = CliUtils.writeLn;
class VaultProgram extends BaseProgram {
    register() {
        external_commander_namespaceObject.program
            .addCommand(this.listCommand())
            .addCommand(this.getCommand())
            .addCommand(this.createCommand())
            .addCommand(this.editCommand())
            .addCommand(this.deleteCommand())
            .addCommand(this.restoreCommand())
            .addCommand(this.shareCommand("move", false))
            .addCommand(this.confirmCommand())
            .addCommand(this.importCommand())
            .addCommand(this.exportCommand())
            .addCommand(this.shareCommand("share", true));
    }
    validateObject(requestedObject, validObjects) {
        let success = true;
        if (!validObjects.includes(requestedObject)) {
            success = false;
            this.processResponse(Response.badRequest('Unknown object "' +
                requestedObject +
                '". Allowed objects are ' +
                validObjects.join(", ") +
                "."));
        }
        return success;
    }
    listCommand() {
        const listObjects = [
            "items",
            "folders",
            "collections",
            "org-collections",
            "org-members",
            "organizations",
        ];
        return new external_commander_namespaceObject.Command("list")
            .argument("<object>", "Valid objects are: " + listObjects.join(", "))
            .description("List an array of objects from the vault.")
            .option("--search <search>", "Perform a search on the listed objects.")
            .option("--url <url>", "Filter items of type login with a url-match search.")
            .option("--folderid <folderid>", "Filter items by folder id.")
            .option("--collectionid <collectionid>", "Filter items by collection id.")
            .option("--organizationid <organizationid>", "Filter items or collections by organization id.")
            .option("--trash", "Filter items that are deleted and in the trash.")
            .on("--help", () => {
            vault_program_writeLn("\n  Notes:");
            vault_program_writeLn("");
            vault_program_writeLn("    Combining search with a filter performs a logical AND operation.");
            vault_program_writeLn("");
            vault_program_writeLn("    Combining multiple filters performs a logical OR operation.");
            vault_program_writeLn("");
            vault_program_writeLn("  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw list items");
            vault_program_writeLn("    bw list items --folderid 60556c31-e649-4b5d-8daf-fc1c391a1bf2");
            vault_program_writeLn("    bw list items --search google --folderid 60556c31-e649-4b5d-8daf-fc1c391a1bf2");
            vault_program_writeLn("    bw list items --url https://google.com");
            vault_program_writeLn("    bw list items --folderid null");
            vault_program_writeLn("    bw list items --organizationid notnull");
            vault_program_writeLn("    bw list items --folderid 60556c31-e649-4b5d-8daf-fc1c391a1bf2 --organizationid notnull");
            vault_program_writeLn("    bw list items --trash");
            vault_program_writeLn("    bw list folders --search email");
            vault_program_writeLn("    bw list org-members --organizationid 60556c31-e649-4b5d-8daf-fc1c391a1bf2");
            vault_program_writeLn("", true);
        })
            .action((object, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, listObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new ListCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.organizationService, this.serviceContainer.searchService, this.serviceContainer.organizationUserService, this.serviceContainer.apiService, this.serviceContainer.eventCollectionService);
            const response = yield command.run(object, cmd);
            this.processResponse(response);
        }));
    }
    getCommand() {
        const getObjects = [
            "item",
            "username",
            "password",
            "uri",
            "totp",
            "notes",
            "exposed",
            "attachment",
            "folder",
            "collection",
            "org-collection",
            "organization",
            "template",
            "fingerprint",
            "send",
        ];
        return new external_commander_namespaceObject.Command("get")
            .argument("<object>", "Valid objects are: " + getObjects.join(", "))
            .argument("<id>", "Search term or object's globally unique `id`.")
            .description("Get an object from the vault.")
            .option("--itemid <itemid>", "Attachment's item id.")
            .option("--output <output>", "Output directory or filename for attachment.")
            .option("--organizationid <organizationid>", "Organization id for an organization object.")
            .on("--help", () => {
            vault_program_writeLn("\n  If raw output is specified and no output filename or directory is given for");
            vault_program_writeLn("  an attachment query, the attachment content is written to stdout.");
            vault_program_writeLn("");
            vault_program_writeLn("  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw get item 99ee88d2-6046-4ea7-92c2-acac464b1412");
            vault_program_writeLn("    bw get password https://google.com");
            vault_program_writeLn("    bw get totp google.com");
            vault_program_writeLn("    bw get notes google.com");
            vault_program_writeLn("    bw get exposed yahoo.com");
            vault_program_writeLn("    bw get attachment b857igwl1dzrs2 --itemid 99ee88d2-6046-4ea7-92c2-acac464b1412 " +
                "--output ./photo.jpg");
            vault_program_writeLn("    bw get attachment photo.jpg --itemid 99ee88d2-6046-4ea7-92c2-acac464b1412 --raw");
            vault_program_writeLn("    bw get folder email");
            vault_program_writeLn("    bw get template folder");
            vault_program_writeLn("", true);
        })
            .action((object, id, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, getObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService);
            const response = yield command.run(object, id, cmd);
            this.processResponse(response);
        }));
    }
    createCommand() {
        const createObjects = ["item", "attachment", "folder", "org-collection"];
        return new external_commander_namespaceObject.Command("create")
            .argument("<object>", "Valid objects are: " + createObjects.join(", "))
            .argument("[encodedJson]", "Encoded json of the object to create. Can also be piped into stdin.")
            .description("Create an object in the vault.")
            .option("--file <file>", "Path to file for attachment.")
            .option("--itemid <itemid>", "Attachment's item id.")
            .option("--organizationid <organizationid>", "Organization id for an organization object.")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw create folder eyJuYW1lIjoiTXkgRm9sZGVyIn0K");
            vault_program_writeLn("    echo 'eyJuYW1lIjoiTXkgRm9sZGVyIn0K' | bw create folder");
            vault_program_writeLn("    bw create attachment --file ./myfile.csv " +
                "--itemid 16b15b89-65b3-4639-ad2a-95052a6d8f66");
            vault_program_writeLn("", true);
        })
            .action((object, encodedJson, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, createObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new CreateCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.organizationService);
            const response = yield command.run(object, encodedJson, cmd);
            this.processResponse(response);
        }));
    }
    editCommand() {
        const editObjects = ["item", "item-collections", "folder", "org-collection"];
        return new external_commander_namespaceObject.Command("edit")
            .argument("<object>", "Valid objects are: " + editObjects.join(", "))
            .argument("<id>", "Object's globally unique `id`.")
            .argument("[encodedJson]", "Encoded json of the object to create. Can also be piped into stdin.")
            .description("Edit an object from the vault.")
            .option("--organizationid <organizationid>", "Organization id for an organization object.")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw edit folder 5cdfbd80-d99f-409b-915b-f4c5d0241b02 eyJuYW1lIjoiTXkgRm9sZGVyMiJ9Cg==");
            vault_program_writeLn("    echo 'eyJuYW1lIjoiTXkgRm9sZGVyMiJ9Cg==' | " +
                "bw edit folder 5cdfbd80-d99f-409b-915b-f4c5d0241b02");
            vault_program_writeLn("    bw edit item-collections 78307355-fd25-416b-88b8-b33fd0e88c82 " +
                "WyI5NzQwNTNkMC0zYjMzLTRiOTgtODg2ZS1mZWNmNWM4ZGJhOTYiXQ==");
            vault_program_writeLn("", true);
        })
            .action((object, id, encodedJson, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, editObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new EditCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService);
            const response = yield command.run(object, id, encodedJson, cmd);
            this.processResponse(response);
        }));
    }
    deleteCommand() {
        const deleteObjects = ["item", "attachment", "folder", "org-collection"];
        return new external_commander_namespaceObject.Command("delete")
            .argument("<object>", "Valid objects are: " + deleteObjects.join(", "))
            .argument("<id>", "Object's globally unique `id`.")
            .description("Delete an object from the vault.")
            .option("--itemid <itemid>", "Attachment's item id.")
            .option("--organizationid <organizationid>", "Organization id for an organization object.")
            .option("-p, --permanent", "Permanently deletes the item instead of soft-deleting it (item only).")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw delete item 7063feab-4b10-472e-b64c-785e2b870b92");
            vault_program_writeLn("    bw delete item 89c21cd2-fab0-4f69-8c6e-ab8a0168f69a --permanent");
            vault_program_writeLn("    bw delete folder 5cdfbd80-d99f-409b-915b-f4c5d0241b02");
            vault_program_writeLn("    bw delete attachment b857igwl1dzrs2 --itemid 310d5ffd-e9a2-4451-af87-ea054dce0f78");
            vault_program_writeLn("", true);
        })
            .action((object, id, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, deleteObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new DeleteCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService);
            const response = yield command.run(object, id, cmd);
            this.processResponse(response);
        }));
    }
    restoreCommand() {
        const restoreObjects = ["item"];
        return new external_commander_namespaceObject.Command("restore")
            .argument("<object>", "Valid objects are: " + restoreObjects.join(", "))
            .argument("<id>", "Object's globally unique `id`.")
            .description("Restores an object from the trash.")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw restore item 7063feab-4b10-472e-b64c-785e2b870b92");
            vault_program_writeLn("", true);
        })
            .action((object, id, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, restoreObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new RestoreCommand(this.serviceContainer.cipherService);
            const response = yield command.run(object, id);
            this.processResponse(response);
        }));
    }
    shareCommand(commandName, deprecated) {
        return new external_commander_namespaceObject.Command(commandName)
            .argument("<id>", "Object's globally unique `id`.")
            .argument("<organizationId>", "Organization's globally unique `id`.")
            .argument("[encodedJson]", "Encoded json of an array of collection ids. Can also be piped into stdin.")
            .description((deprecated ? "--DEPRECATED-- " : "") + "Move an item to an organization.")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw " +
                commandName +
                " 4af958ce-96a7-45d9-beed-1e70fabaa27a " +
                "6d82949b-b44d-468a-adae-3f3bacb0ea32 WyI5NzQwNTNkMC0zYjMzLTRiOTgtODg2ZS1mZWNmNWM4ZGJhOTYiXQ==");
            vault_program_writeLn("    echo '[\"974053d0-3b33-4b98-886e-fecf5c8dba96\"]' | bw encode | " +
                "bw " +
                commandName +
                " 4af958ce-96a7-45d9-beed-1e70fabaa27a 6d82949b-b44d-468a-adae-3f3bacb0ea32");
            if (deprecated) {
                vault_program_writeLn("");
                vault_program_writeLn('--DEPRECATED See "bw move" for the current implementation--');
            }
            vault_program_writeLn("", true);
        })
            .action((id, organizationId, encodedJson, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const command = new ShareCommand(this.serviceContainer.cipherService);
            const response = yield command.run(id, organizationId, encodedJson);
            this.processResponse(response);
        }));
    }
    confirmCommand() {
        const confirmObjects = ["org-member"];
        return new external_commander_namespaceObject.Command("confirm")
            .argument("<object>", "Valid objects are: " + confirmObjects.join(", "))
            .argument("<id>", "Object's globally unique `id`.")
            .description("Confirm an object to the organization.")
            .option("--organizationid <organizationid>", "Organization id for an organization object.")
            .on("--help", () => {
            vault_program_writeLn("\n  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw confirm org-member 7063feab-4b10-472e-b64c-785e2b870b92 " +
                "--organizationid 310d5ffd-e9a2-4451-af87-ea054dce0f78");
            vault_program_writeLn("", true);
        })
            .action((object, id, cmd) => vault_program_awaiter(this, void 0, void 0, function* () {
            if (!this.validateObject(object, confirmObjects)) {
                return;
            }
            yield this.exitIfLocked();
            const command = new ConfirmCommand(this.serviceContainer.apiService, this.serviceContainer.cryptoService, this.serviceContainer.organizationUserService);
            const response = yield command.run(object, id, cmd);
            this.processResponse(response);
        }));
    }
    importCommand() {
        return new external_commander_namespaceObject.Command("import")
            .argument("[format]", "The format of [input]")
            .argument("[input]", "Filepath to data to import")
            .description("Import vault data from a file.")
            .option("--formats", "List formats")
            .option("--organizationid <organizationid>", "ID of the organization to import to.")
            .on("--help", () => {
            vault_program_writeLn("\n Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw import --formats");
            vault_program_writeLn("    bw import bitwardencsv ./from/source.csv");
            vault_program_writeLn("    bw import keepass2xml keepass_backup.xml");
            vault_program_writeLn("    bw import --organizationid cf14adc3-aca5-4573-890a-f6fa231436d9 keepass2xml keepass_backup.xml");
        })
            .action((format, filepath, options) => vault_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const command = new ImportCommand(this.serviceContainer.importService, this.serviceContainer.organizationService, this.serviceContainer.syncService);
            const response = yield command.run(format, filepath, options);
            this.processResponse(response);
        }));
    }
    exportCommand() {
        return new external_commander_namespaceObject.Command("export")
            .description("Export vault data to a CSV or JSON file.")
            .option("--output <output>", "Output directory or filename.")
            .option("--format <format>", "Export file format.")
            .option("--password [password]", "Use password to encrypt instead of your Bitwarden account encryption key. Only applies to the encrypted_json format.")
            .option("--organizationid <organizationid>", "Organization id for an organization.")
            .on("--help", () => {
            vault_program_writeLn("\n  Notes:");
            vault_program_writeLn("");
            vault_program_writeLn("    Valid formats are `csv`, `json`, and `encrypted_json`. Default format is `csv`.");
            vault_program_writeLn("");
            vault_program_writeLn("    If --raw option is specified and no output filename or directory is given, the");
            vault_program_writeLn("    result is written to stdout.");
            vault_program_writeLn("");
            vault_program_writeLn("  Examples:");
            vault_program_writeLn("");
            vault_program_writeLn("    bw export");
            vault_program_writeLn("    bw --raw export");
            vault_program_writeLn("    bw export myPassword321");
            vault_program_writeLn("    bw export myPassword321 --format json");
            vault_program_writeLn("    bw export --output ./exp/bw.csv");
            vault_program_writeLn("    bw export myPassword321 --output bw.json --format json");
            vault_program_writeLn("    bw export myPassword321 --organizationid 7063feab-4b10-472e-b64c-785e2b870b92");
            vault_program_writeLn("", true);
        })
            .action((options) => vault_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const command = new ExportCommand(this.serviceContainer.exportService, this.serviceContainer.policyService, this.serviceContainer.eventCollectionService);
            const response = yield command.run(options);
            this.processResponse(response);
        }));
    }
}

;// CONCATENATED MODULE: ./src/register-oss-programs.ts
var register_oss_programs_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/**
 * All OSS licensed programs should be registered here.
 * @example
 * const myProgram = new myProgram(serviceContainer);
 * myProgram.register();
 * @param serviceContainer A class that instantiates services and makes them available for dependency injection
 */
function registerOssPrograms(serviceContainer) {
    return register_oss_programs_awaiter(this, void 0, void 0, function* () {
        const program = new Program(serviceContainer);
        yield program.register();
        const vaultProgram = new VaultProgram(serviceContainer);
        vaultProgram.register();
        const sendProgram = new SendProgram(serviceContainer);
        sendProgram.register();
    });
}

;// CONCATENATED MODULE: external "@koa/router"
const router_namespaceObject = require("@koa/router");
;// CONCATENATED MODULE: external "koa"
const external_koa_namespaceObject = require("koa");
;// CONCATENATED MODULE: external "koa-bodyparser"
const external_koa_bodyparser_namespaceObject = require("koa-bodyparser");
;// CONCATENATED MODULE: external "koa-json"
const external_koa_json_namespaceObject = require("koa-json");
;// CONCATENATED MODULE: ./src/commands/serve.command.ts
var serve_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class ServeCommand {
    constructor(serviceContainer, serveConfigurator) {
        this.serviceContainer = serviceContainer;
        this.serveConfigurator = serveConfigurator;
    }
    run(options) {
        return serve_command_awaiter(this, void 0, void 0, function* () {
            const protectOrigin = !options.disableOriginProtection;
            const port = options.port || 8087;
            const hostname = options.hostname || "localhost";
            this.serviceContainer.logService.info(`Starting server on ${hostname}:${port} with ${protectOrigin ? "origin protection" : "no origin protection"}`);
            const server = new external_koa_namespaceObject();
            const router = new router_namespaceObject();
            process.env.BW_SERVE = "true";
            process.env.BW_NOINTERACTION = "true";
            server
                .use((ctx, next) => serve_command_awaiter(this, void 0, void 0, function* () {
                if (protectOrigin && ctx.headers.origin != undefined) {
                    ctx.status = 403;
                    this.serviceContainer.logService.warning(`Blocking request from "${Utils.isNullOrEmpty(ctx.headers.origin)
                        ? "(Origin header value missing)"
                        : ctx.headers.origin}"`);
                    return;
                }
                yield next();
            }))
                .use(external_koa_bodyparser_namespaceObject())
                .use(external_koa_json_namespaceObject({ pretty: false, param: "pretty" }));
            this.serveConfigurator.configureRouter(router);
            server
                .use(router.routes())
                .use(router.allowedMethods())
                .listen(port, hostname === "all" ? null : hostname, () => {
                this.serviceContainer.logService.info("Listening on " + hostname + ":" + port);
            });
        });
    }
}

;// CONCATENATED MODULE: ./src/serve.program.ts
var serve_program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const serve_program_writeLn = CliUtils.writeLn;
class ServeProgram extends BaseProgram {
    constructor(serviceContainer, configurator) {
        super(serviceContainer);
        this.configurator = configurator;
    }
    register() {
        external_commander_namespaceObject.program
            .command("serve")
            .description("Start a RESTful API webserver.")
            .option("--hostname <hostname>", "The hostname to bind your API webserver to.")
            .option("--port <port>", "The port to run your API webserver on.")
            .option("--disable-origin-protection", "If set, allows requests with origin header. Warning, this option exists for backwards compatibility reasons and exposes your environment to known CSRF attacks.")
            .on("--help", () => {
            serve_program_writeLn("\n  Notes:");
            serve_program_writeLn("");
            serve_program_writeLn("    Default hostname is `localhost`.");
            serve_program_writeLn("    Use hostname `all` for no hostname binding.");
            serve_program_writeLn("    Default port is `8087`.");
            serve_program_writeLn("");
            serve_program_writeLn("  Examples:");
            serve_program_writeLn("");
            serve_program_writeLn("    bw serve");
            serve_program_writeLn("    bw serve --port 8080");
            serve_program_writeLn("    bw serve --hostname bwapi.mydomain.com --port 80");
            serve_program_writeLn("", true);
        })
            .action((cmd) => serve_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfNotAuthed();
            const command = new ServeCommand(this.serviceContainer, this.configurator);
            yield command.run(cmd);
        }));
    }
}

;// CONCATENATED MODULE: external "@koa/multer"
const multer_namespaceObject = require("@koa/multer");
;// CONCATENATED MODULE: ./src/tools/send/index.ts


;// CONCATENATED MODULE: ./src/oss-serve-configurator.ts
var oss_serve_configurator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

















class OssServeConfigurator {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
        this.getCommand = new GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService);
        this.listCommand = new ListCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.organizationService, this.serviceContainer.searchService, this.serviceContainer.organizationUserService, this.serviceContainer.apiService, this.serviceContainer.eventCollectionService);
        this.createCommand = new CreateCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.organizationService);
        this.editCommand = new EditCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService);
        this.generateCommand = new GenerateCommand(this.serviceContainer.passwordGenerationService, this.serviceContainer.stateService);
        this.syncCommand = new SyncCommand(this.serviceContainer.syncService);
        this.statusCommand = new StatusCommand(this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.accountService, this.serviceContainer.authService);
        this.deleteCommand = new DeleteCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService);
        this.confirmCommand = new ConfirmCommand(this.serviceContainer.apiService, this.serviceContainer.cryptoService, this.serviceContainer.organizationUserService);
        this.restoreCommand = new RestoreCommand(this.serviceContainer.cipherService);
        this.shareCommand = new ShareCommand(this.serviceContainer.cipherService);
        this.lockCommand = new LockCommand(this.serviceContainer.vaultTimeoutService);
        this.unlockCommand = new UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.userVerificationService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, () => oss_serve_configurator_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));
        this.sendCreateCommand = new SendCreateCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);
        this.sendDeleteCommand = new SendDeleteCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService);
        this.sendGetCommand = new SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);
        this.sendEditCommand = new SendEditCommand(this.serviceContainer.sendService, this.sendGetCommand, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);
        this.sendListCommand = new SendListCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService);
        this.sendRemovePasswordCommand = new SendRemovePasswordCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService, this.serviceContainer.environmentService);
    }
    configureRouter(router) {
        router.get("/generate", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.generateCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/status", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.statusCommand.run();
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/list/object/:object", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendListCommand.run(ctx.request.query);
            }
            else {
                response = yield this.listCommand.run(ctx.params.object, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/send/list", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.sendListCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/sync", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.syncCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/lock", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.lockCommand.run();
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/unlock", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            // Do not allow guessing password location through serve command
            delete ctx.request.query.passwordFile;
            delete ctx.request.query.passwordEnv;
            const response = yield this.unlockCommand.run(ctx.request.body.password == null ? null : ctx.request.body.password, ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/confirm/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.confirmCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/restore/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.restoreCommand.run(ctx.params.object, ctx.params.id);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/move/:id/:organizationId", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.shareCommand.run(ctx.params.id, ctx.params.organizationId, ctx.request.body);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/attachment", multer_namespaceObject().single("file"), (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.createCommand.run("attachment", ctx.request.body, ctx.request.query, {
                fileBuffer: ctx.request.file.buffer,
                fileName: ctx.request.file.originalname,
            });
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/send/:id/remove-password", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.sendRemovePasswordCommand.run(ctx.params.id);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/object/:object", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendCreateCommand.run(ctx.request.body, ctx.request.query);
            }
            else {
                response = yield this.createCommand.run(ctx.params.object, ctx.request.body, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.put("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                ctx.request.body.id = ctx.params.id;
                response = yield this.sendEditCommand.run(ctx.request.body, ctx.request.query);
            }
            else {
                response = yield this.editCommand.run(ctx.params.object, ctx.params.id, ctx.request.body, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendGetCommand.run(ctx.params.id, null);
            }
            else {
                response = yield this.getCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.delete("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendDeleteCommand.run(ctx.params.id);
            }
            else {
                response = yield this.deleteCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
    }
    processResponse(res, commandResponse) {
        if (!commandResponse.success) {
            res.status = 400;
        }
        if (commandResponse.data instanceof FileResponse) {
            res.body = commandResponse.data.data;
            res.attachment(commandResponse.data.fileName);
            res.set("Content-Type", "application/octet-stream");
            res.set("Content-Length", commandResponse.data.data.length.toString());
        }
        else {
            res.body = commandResponse;
        }
    }
    errorIfLocked(res) {
        return oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.serviceContainer.stateService.getIsAuthenticated();
            if (!authed) {
                this.processResponse(res, Response.error("You are not logged in."));
                return true;
            }
            if (yield this.serviceContainer.cryptoService.hasUserKey()) {
                return false;
            }
            this.processResponse(res, Response.error("Vault is locked."));
            return true;
        });
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/approve-all.command.ts
var approve_all_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class ApproveAllCommand {
    constructor(organizationAuthRequestService, organizationService) {
        this.organizationAuthRequestService = organizationAuthRequestService;
        this.organizationService = organizationService;
    }
    run(organizationId) {
        return approve_all_command_awaiter(this, void 0, void 0, function* () {
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            if (!Utils.isGuid(organizationId)) {
                return Response.badRequest("`" + organizationId + "` is not a GUID.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.get$(organizationId));
            if (!(organization === null || organization === void 0 ? void 0 : organization.canManageUsersPassword)) {
                return Response.error("You do not have permission to approve pending device authorization requests.");
            }
            try {
                const pendingApprovals = yield this.organizationAuthRequestService.listPendingRequests(organizationId);
                if (pendingApprovals.length == 0) {
                    const res = new MessageResponse("No pending device authorization requests to approve.", null);
                    return Response.success(res);
                }
                yield this.organizationAuthRequestService.approvePendingRequests(organizationId, pendingApprovals);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    static create(serviceContainer) {
        return new ApproveAllCommand(serviceContainer.organizationAuthRequestService, serviceContainer.organizationService);
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/approve.command.ts
var approve_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class ApproveCommand {
    constructor(organizationService, organizationAuthRequestService) {
        this.organizationService = organizationService;
        this.organizationAuthRequestService = organizationAuthRequestService;
    }
    run(organizationId, id) {
        return approve_command_awaiter(this, void 0, void 0, function* () {
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            if (!Utils.isGuid(organizationId)) {
                return Response.badRequest("`" + organizationId + "` is not a GUID.");
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.get$(organizationId));
            if (!(organization === null || organization === void 0 ? void 0 : organization.canManageUsersPassword)) {
                return Response.error("You do not have permission to approve pending device authorization requests.");
            }
            try {
                const pendingRequests = yield this.organizationAuthRequestService.listPendingRequests(organizationId);
                const request = pendingRequests.find((r) => r.id == id);
                if (request == null) {
                    return Response.error("The request id is invalid.");
                }
                yield this.organizationAuthRequestService.approvePendingRequest(organizationId, request);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    static create(serviceContainer) {
        return new ApproveCommand(serviceContainer.organizationService, serviceContainer.organizationAuthRequestService);
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/deny-all.command.ts
var deny_all_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class DenyAllCommand {
    constructor(organizationService, organizationAuthRequestService) {
        this.organizationService = organizationService;
        this.organizationAuthRequestService = organizationAuthRequestService;
    }
    run(organizationId) {
        return deny_all_command_awaiter(this, void 0, void 0, function* () {
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            if (!Utils.isGuid(organizationId)) {
                return Response.badRequest("`" + organizationId + "` is not a GUID.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.get$(organizationId));
            if (!(organization === null || organization === void 0 ? void 0 : organization.canManageUsersPassword)) {
                return Response.error("You do not have permission to approve pending device authorization requests.");
            }
            try {
                const pendingRequests = yield this.organizationAuthRequestService.listPendingRequests(organizationId);
                if (pendingRequests.length == 0) {
                    const res = new MessageResponse("No pending device authorization requests to deny.", null);
                    return Response.success(res);
                }
                yield this.organizationAuthRequestService.denyPendingRequests(organizationId, ...pendingRequests.map((r) => r.id));
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    static create(serviceContainer) {
        return new DenyAllCommand(serviceContainer.organizationService, serviceContainer.organizationAuthRequestService);
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/deny.command.ts
var deny_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DenyCommand {
    constructor(organizationService, organizationAuthRequestService) {
        this.organizationService = organizationService;
        this.organizationAuthRequestService = organizationAuthRequestService;
    }
    run(organizationId, id) {
        return deny_command_awaiter(this, void 0, void 0, function* () {
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            if (!Utils.isGuid(organizationId)) {
                return Response.badRequest("`" + organizationId + "` is not a GUID.");
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            if (!Utils.isGuid(id)) {
                return Response.badRequest("`" + id + "` is not a GUID.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.get$(organizationId));
            if (!(organization === null || organization === void 0 ? void 0 : organization.canManageUsersPassword)) {
                return Response.error("You do not have permission to approve pending device authorization requests.");
            }
            try {
                const pendingRequests = yield this.organizationAuthRequestService.listPendingRequests(organizationId);
                const request = pendingRequests.find((r) => r.id == id);
                if (request == null) {
                    return Response.error("The request id is invalid.");
                }
                yield this.organizationAuthRequestService.denyPendingRequest(organizationId, id);
                return Response.success();
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    static create(serviceContainer) {
        return new DenyCommand(serviceContainer.organizationService, serviceContainer.organizationAuthRequestService);
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/pending-auth-request.response.ts
class PendingAuthRequestResponse {
    constructor(authRequest) {
        this.object = "auth-request";
        this.id = authRequest.id;
        this.userId = authRequest.userId;
        this.organizationUserId = authRequest.organizationUserId;
        this.email = authRequest.email;
        this.requestDeviceIdentifier = authRequest.requestDeviceIdentifier;
        this.requestDeviceType = authRequest.requestDeviceType;
        this.requestIpAddress = authRequest.requestIpAddress;
        this.creationDate = authRequest.creationDate;
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/list.command.ts
var device_approval_list_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class list_command_ListCommand {
    constructor(organizationAuthRequestService, organizationService) {
        this.organizationAuthRequestService = organizationAuthRequestService;
        this.organizationService = organizationService;
    }
    run(organizationId) {
        return device_approval_list_command_awaiter(this, void 0, void 0, function* () {
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            if (!Utils.isGuid(organizationId)) {
                return Response.badRequest("`" + organizationId + "` is not a GUID.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.get$(organizationId));
            if (!(organization === null || organization === void 0 ? void 0 : organization.canManageUsersPassword)) {
                return Response.error("You do not have permission to approve pending device authorization requests.");
            }
            try {
                const requests = yield this.organizationAuthRequestService.listPendingRequests(organizationId);
                const res = new ListResponse(requests.map((r) => new PendingAuthRequestResponse(r)));
                return Response.success(res);
            }
            catch (e) {
                return Response.error(e);
            }
        });
    }
    static create(serviceContainer) {
        return new list_command_ListCommand(serviceContainer.organizationAuthRequestService, serviceContainer.organizationService);
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/device-approval.program.ts
var device_approval_program_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class DeviceApprovalProgram extends BaseProgram {
    constructor(serviceContainer) {
        super(serviceContainer);
        this.serviceContainer = serviceContainer;
    }
    register() {
        external_commander_namespaceObject.program.addCommand(this.deviceApprovalCommand());
    }
    deviceApprovalCommand() {
        return new external_commander_namespaceObject.Command("device-approval")
            .description("Manage device approval requests sent to organizations that use SSO with trusted devices.")
            .addCommand(this.listCommand())
            .addCommand(this.approveCommand())
            .addCommand(this.approveAllCommand())
            .addCommand(this.denyCommand())
            .addCommand(this.denyAllCommand());
    }
    listCommand() {
        return new external_commander_namespaceObject.Command("list")
            .description("List all pending requests for an organization")
            .requiredOption("--organizationid <organizationid>", "The organization id (required)")
            .action((options) => device_approval_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = list_command_ListCommand.create(this.serviceContainer);
            const response = yield cmd.run(options.organizationid);
            this.processResponse(response);
        }));
    }
    approveCommand() {
        return new external_commander_namespaceObject.Command("approve")
            .argument("<requestId>", "The id of the request to approve")
            .requiredOption("--organizationid <organizationid>", "The organization id (required)")
            .description("Approve a pending request")
            .action((id, options) => device_approval_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = ApproveCommand.create(this.serviceContainer);
            const response = yield cmd.run(options.organizationid, id);
            this.processResponse(response);
        }));
    }
    approveAllCommand() {
        return new external_commander_namespaceObject.Command("approve-all")
            .description("Approve all pending requests for an organization")
            .requiredOption("--organizationid <organizationid>", "The organization id (required)")
            .action((options) => device_approval_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = ApproveAllCommand.create(this.serviceContainer);
            const response = yield cmd.run(options.organizationid);
            this.processResponse(response);
        }));
    }
    denyCommand() {
        return new external_commander_namespaceObject.Command("deny")
            .argument("<requestId>", "The id of the request to deny")
            .requiredOption("--organizationid <organizationid>", "The organization id (required)")
            .description("Deny a pending request")
            .action((id, options) => device_approval_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = DenyCommand.create(this.serviceContainer);
            const response = yield cmd.run(options.organizationid, id);
            this.processResponse(response);
        }));
    }
    denyAllCommand() {
        return new external_commander_namespaceObject.Command("deny-all")
            .description("Deny all pending requests for an organization")
            .requiredOption("--organizationid <organizationid>", "The organization id (required)")
            .action((options) => device_approval_program_awaiter(this, void 0, void 0, function* () {
            yield this.exitIfLocked();
            const cmd = DenyAllCommand.create(this.serviceContainer);
            const response = yield cmd.run(options.organizationid);
            this.processResponse(response);
        }));
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/admin-console/device-approval/index.ts







;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/bit-serve-configurator.ts
var bit_serve_configurator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class BitServeConfigurator extends OssServeConfigurator {
    constructor(serviceContainer) {
        super(serviceContainer);
        this.serviceContainer = serviceContainer;
    }
    configureRouter(router) {
        // Register OSS endpoints
        super.configureRouter(router);
        // Register bit endpoints
        this.serveDeviceApprovals(router);
    }
    serveDeviceApprovals(router) {
        router.get("/device-approval/:organizationId", (ctx, next) => bit_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield list_command_ListCommand.create(this.serviceContainer).run(ctx.params.organizationId);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/device-approval/:organizationId/approve-all", (ctx, next) => bit_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield ApproveAllCommand.create(this.serviceContainer).run(ctx.params.organizationId);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/device-approval/:organizationId/approve/:requestId", (ctx, next) => bit_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield ApproveCommand.create(this.serviceContainer).run(ctx.params.organizationId, ctx.params.requestId);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/device-approval/:organizationId/deny-all", (ctx, next) => bit_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield DenyAllCommand.create(this.serviceContainer).run(ctx.params.organizationId);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/device-approval/:organizationId/deny/:requestId", (ctx, next) => bit_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield DenyCommand.create(this.serviceContainer).run(ctx.params.organizationId, ctx.params.requestId);
            this.processResponse(ctx.response, response);
            yield next();
        }));
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-cli/src/register-bit-programs.ts
var register_bit_programs_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/**
 * All Bitwarden-licensed programs should be registered here.
 * @example
 * const myProgram = new myProgram(serviceContainer);
 * myProgram.register();
 * @param serviceContainer A class that instantiates services and makes them available for dependency injection
 */
function registerBitPrograms(serviceContainer) {
    return register_bit_programs_awaiter(this, void 0, void 0, function* () {
        new DeviceApprovalProgram(serviceContainer).register();
    });
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/pending-organization-auth-request.response.ts

class PendingOrganizationAuthRequestResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.organizationUserId = this.getResponseProperty("OrganizationUserId");
        this.email = this.getResponseProperty("Email");
        this.publicKey = this.getResponseProperty("PublicKey");
        this.requestDeviceIdentifier = this.getResponseProperty("RequestDeviceIdentifier");
        this.requestDeviceType = this.getResponseProperty("RequestDeviceType");
        this.requestIpAddress = this.getResponseProperty("RequestIpAddress");
        this.creationDate = this.getResponseProperty("CreationDate");
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/organization-auth-request-update.request.ts
class OrganizationAuthRequestUpdateRequest {
    constructor(id, approved, key) {
        this.id = id;
        this.approved = approved;
        this.key = key;
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/organization-auth-request.service.ts
var organization_auth_request_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class OrganizationAuthRequestService {
    constructor(organizationAuthRequestApiService, cryptoService, organizationUserService) {
        this.organizationAuthRequestApiService = organizationAuthRequestApiService;
        this.cryptoService = cryptoService;
        this.organizationUserService = organizationUserService;
    }
    listPendingRequests(organizationId) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            return yield this.organizationAuthRequestApiService.listPendingRequests(organizationId);
        });
    }
    denyPendingRequests(organizationId, ...requestIds) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            yield this.organizationAuthRequestApiService.denyPendingRequests(organizationId, ...requestIds);
        });
    }
    approvePendingRequests(organizationId, authRequests) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            const organizationUserIds = authRequests.map((r) => r.organizationUserId);
            const details = yield this.organizationUserService.getManyOrganizationUserAccountRecoveryDetails(organizationId, organizationUserIds);
            if (details == null ||
                details.data.length == 0 ||
                details.data.some((d) => d.resetPasswordKey == null)) {
                throw new Error("All users must be enrolled in account recovery (password reset) in order for the requests to be approved.");
            }
            const requestsToApprove = yield Promise.all(authRequests.map((r) => organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
                const detail = details.data.find((d) => d.organizationUserId === r.organizationUserId);
                const encryptedKey = yield this.getEncryptedUserKey(organizationId, r.publicKey, detail);
                return new OrganizationAuthRequestUpdateRequest(r.id, true, encryptedKey.encryptedString);
            })));
            yield this.organizationAuthRequestApiService.bulkUpdatePendingRequests(organizationId, requestsToApprove);
        });
    }
    approvePendingRequest(organizationId, authRequest) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            const details = yield this.organizationUserService.getOrganizationUserResetPasswordDetails(organizationId, authRequest.organizationUserId);
            if (details == null || details.resetPasswordKey == null) {
                throw new Error("The user must be enrolled in account recovery (password reset) in order for the request to be approved.");
            }
            const encryptedKey = yield this.getEncryptedUserKey(organizationId, authRequest.publicKey, details);
            yield this.organizationAuthRequestApiService.approvePendingRequest(organizationId, authRequest.id, encryptedKey);
        });
    }
    denyPendingRequest(organizationId, requestId) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            yield this.organizationAuthRequestApiService.denyPendingRequest(organizationId, requestId);
        });
    }
    /**
     * Creates a copy of the user key that has been encrypted with the provided device's public key.
     * @param organizationId
     * @param devicePublicKey
     * @param resetPasswordDetails
     * @private
     */
    getEncryptedUserKey(organizationId, devicePublicKey, resetPasswordDetails) {
        return organization_auth_request_service_awaiter(this, void 0, void 0, function* () {
            const encryptedUserKey = resetPasswordDetails.resetPasswordKey;
            const encryptedOrgPrivateKey = resetPasswordDetails.encryptedPrivateKey;
            const devicePubKey = Utils.fromB64ToArray(devicePublicKey);
            // Decrypt Organization's encrypted Private Key with org key
            const orgSymKey = yield this.cryptoService.getOrgKey(organizationId);
            const decOrgPrivateKey = yield this.cryptoService.decryptToBytes(new EncString(encryptedOrgPrivateKey), orgSymKey);
            // Decrypt user key with decrypted org private key
            const decValue = yield this.cryptoService.rsaDecrypt(encryptedUserKey, decOrgPrivateKey);
            const userKey = new SymmetricCryptoKey(decValue);
            // Re-encrypt user Key with the Device Public Key
            return yield this.cryptoService.rsaEncrypt(userKey.key, devicePubKey);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/list.response.ts

class list_response_ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/admin-auth-request-update.request.ts
class AdminAuthRequestUpdateRequest {
    /**
     *
     * @param requestApproved - Whether the request was approved/denied. If true, the key must be provided.
     * @param encryptedUserKey The user key that has been encrypted with a device public key if the request was approved.
     */
    constructor(requestApproved, encryptedUserKey) {
        this.requestApproved = requestApproved;
        this.encryptedUserKey = encryptedUserKey;
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/bulk-deny-auth-requests.request.ts
class BulkDenyAuthRequestsRequest {
    constructor(authRequestIds) {
        this.ids = authRequestIds;
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/pending-auth-request.view.ts
class PendingAuthRequestView {
    static fromResponse(response) {
        const view = Object.assign(new PendingAuthRequestView(), response);
        view.creationDate = new Date(response.creationDate);
        return view;
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/organization-auth-request-api.service.ts
var organization_auth_request_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class OrganizationAuthRequestApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    listPendingRequests(organizationId) {
        return organization_auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/auth-requests`, null, true, true);
            const listResponse = new list_response_ListResponse(r, PendingOrganizationAuthRequestResponse);
            return listResponse.data.map((ar) => PendingAuthRequestView.fromResponse(ar));
        });
    }
    denyPendingRequests(organizationId, ...requestIds) {
        return organization_auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", `/organizations/${organizationId}/auth-requests/deny`, new BulkDenyAuthRequestsRequest(requestIds), true, false);
        });
    }
    bulkUpdatePendingRequests(organizationId, items) {
        return organization_auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", `/organizations/${organizationId}/auth-requests`, items, true, false);
        });
    }
    approvePendingRequest(organizationId, requestId, encryptedKey) {
        return organization_auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", `/organizations/${organizationId}/auth-requests/${requestId}`, new AdminAuthRequestUpdateRequest(true, encryptedKey.encryptedString), true, false);
        });
    }
    denyPendingRequest(organizationId, requestId) {
        return organization_auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", `/organizations/${organizationId}/auth-requests/${requestId}`, new AdminAuthRequestUpdateRequest(false), true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../bitwarden_license/bit-common/src/admin-console/auth-requests/index.ts





;// CONCATENATED MODULE: external "jsdom"
const external_jsdom_namespaceObject = require("jsdom");
;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/billing.response.ts

class BillingResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.balance = this.getResponseProperty("Balance");
        const paymentSource = this.getResponseProperty("PaymentSource");
        this.paymentSource = paymentSource == null ? null : new BillingSourceResponse(paymentSource);
    }
}
class BillingSourceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.cardBrand = this.getResponseProperty("CardBrand");
        this.description = this.getResponseProperty("Description");
        this.needsVerification = this.getResponseProperty("NeedsVerification");
    }
}
class BillingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = this.getResponseProperty("Url");
        this.pdfUrl = this.getResponseProperty("PdfUrl");
        this.number = this.getResponseProperty("Number");
        this.paid = this.getResponseProperty("Paid");
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}
class BillingTransactionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.createdDate = this.getResponseProperty("CreatedDate");
        this.amount = this.getResponseProperty("Amount");
        this.refunded = this.getResponseProperty("Refunded");
        this.partiallyRefunded = this.getResponseProperty("PartiallyRefunded");
        this.refundedAmount = this.getResponseProperty("RefundedAmount");
        this.type = this.getResponseProperty("Type");
        this.paymentMethodType = this.getResponseProperty("PaymentMethodType");
        this.details = this.getResponseProperty("Details");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/billing-history.response.ts


class BillingHistoryResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.invoices = [];
        this.transactions = [];
        const transactions = this.getResponseProperty("Transactions");
        const invoices = this.getResponseProperty("Invoices");
        if (transactions != null) {
            this.transactions = transactions.map((t) => new BillingTransactionResponse(t));
        }
        if (invoices != null) {
            this.invoices = invoices.map((i) => new BillingInvoiceResponse(i));
        }
    }
    get hasNoHistory() {
        return this.invoices.length == 0 && this.transactions.length == 0;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/api-key.response.ts

class ApiKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.apiKey = this.getResponseProperty("ApiKey");
        this.revisionDate = new Date(this.getResponseProperty("RevisionDate"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/sso.ts
var SsoType;
(function (SsoType) {
    SsoType[SsoType["None"] = 0] = "None";
    SsoType[SsoType["OpenIdConnect"] = 1] = "OpenIdConnect";
    SsoType[SsoType["Saml2"] = 2] = "Saml2";
})(SsoType || (SsoType = {}));
var MemberDecryptionType;
(function (MemberDecryptionType) {
    MemberDecryptionType[MemberDecryptionType["MasterPassword"] = 0] = "MasterPassword";
    MemberDecryptionType[MemberDecryptionType["KeyConnector"] = 1] = "KeyConnector";
    MemberDecryptionType[MemberDecryptionType["TrustedDeviceEncryption"] = 2] = "TrustedDeviceEncryption";
})(MemberDecryptionType || (MemberDecryptionType = {}));
var OpenIdConnectRedirectBehavior;
(function (OpenIdConnectRedirectBehavior) {
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["RedirectGet"] = 0] = "RedirectGet";
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["FormPost"] = 1] = "FormPost";
})(OpenIdConnectRedirectBehavior || (OpenIdConnectRedirectBehavior = {}));
var Saml2BindingType;
(function (Saml2BindingType) {
    Saml2BindingType[Saml2BindingType["HttpRedirect"] = 1] = "HttpRedirect";
    Saml2BindingType[Saml2BindingType["HttpPost"] = 2] = "HttpPost";
})(Saml2BindingType || (Saml2BindingType = {}));
var Saml2NameIdFormat;
(function (Saml2NameIdFormat) {
    Saml2NameIdFormat[Saml2NameIdFormat["NotConfigured"] = 0] = "NotConfigured";
    Saml2NameIdFormat[Saml2NameIdFormat["Unspecified"] = 1] = "Unspecified";
    Saml2NameIdFormat[Saml2NameIdFormat["EmailAddress"] = 2] = "EmailAddress";
    Saml2NameIdFormat[Saml2NameIdFormat["X509SubjectName"] = 3] = "X509SubjectName";
    Saml2NameIdFormat[Saml2NameIdFormat["WindowsDomainQualifiedName"] = 4] = "WindowsDomainQualifiedName";
    Saml2NameIdFormat[Saml2NameIdFormat["KerberosPrincipalName"] = 5] = "KerberosPrincipalName";
    Saml2NameIdFormat[Saml2NameIdFormat["EntityIdentifier"] = 6] = "EntityIdentifier";
    Saml2NameIdFormat[Saml2NameIdFormat["Persistent"] = 7] = "Persistent";
    Saml2NameIdFormat[Saml2NameIdFormat["Transient"] = 8] = "Transient";
})(Saml2NameIdFormat || (Saml2NameIdFormat = {}));
var Saml2SigningBehavior;
(function (Saml2SigningBehavior) {
    Saml2SigningBehavior[Saml2SigningBehavior["IfIdpWantAuthnRequestsSigned"] = 0] = "IfIdpWantAuthnRequestsSigned";
    Saml2SigningBehavior[Saml2SigningBehavior["Always"] = 1] = "Always";
    Saml2SigningBehavior[Saml2SigningBehavior["Never"] = 3] = "Never";
})(Saml2SigningBehavior || (Saml2SigningBehavior = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/api/sso-config.api.ts


class SsoConfigApi extends BaseResponse {
    static fromView(view, api = new SsoConfigApi()) {
        api.configType = view.configType;
        api.memberDecryptionType = view.memberDecryptionType;
        api.keyConnectorUrl = view.keyConnectorUrl;
        if (api.configType === SsoType.OpenIdConnect) {
            api.authority = view.openId.authority;
            api.clientId = view.openId.clientId;
            api.clientSecret = view.openId.clientSecret;
            api.metadataAddress = view.openId.metadataAddress;
            api.redirectBehavior = view.openId.redirectBehavior;
            api.getClaimsFromUserInfoEndpoint = view.openId.getClaimsFromUserInfoEndpoint;
            api.additionalScopes = view.openId.additionalScopes;
            api.additionalUserIdClaimTypes = view.openId.additionalUserIdClaimTypes;
            api.additionalEmailClaimTypes = view.openId.additionalEmailClaimTypes;
            api.additionalNameClaimTypes = view.openId.additionalNameClaimTypes;
            api.acrValues = view.openId.acrValues;
            api.expectedReturnAcrValue = view.openId.expectedReturnAcrValue;
        }
        else if (api.configType === SsoType.Saml2) {
            api.spUniqueEntityId = view.saml.spUniqueEntityId;
            api.spNameIdFormat = view.saml.spNameIdFormat;
            api.spOutboundSigningAlgorithm = view.saml.spOutboundSigningAlgorithm;
            api.spSigningBehavior = view.saml.spSigningBehavior;
            api.spMinIncomingSigningAlgorithm = view.saml.spMinIncomingSigningAlgorithm;
            api.spWantAssertionsSigned = view.saml.spWantAssertionsSigned;
            api.spValidateCertificates = view.saml.spValidateCertificates;
            api.idpEntityId = view.saml.idpEntityId;
            api.idpBindingType = view.saml.idpBindingType;
            api.idpSingleSignOnServiceUrl = view.saml.idpSingleSignOnServiceUrl;
            api.idpSingleLogoutServiceUrl = view.saml.idpSingleLogoutServiceUrl;
            api.idpX509PublicCert = view.saml.idpX509PublicCert;
            api.idpOutboundSigningAlgorithm = view.saml.idpOutboundSigningAlgorithm;
            api.idpAllowUnsolicitedAuthnResponse = view.saml.idpAllowUnsolicitedAuthnResponse;
            api.idpWantAuthnRequestsSigned = view.saml.idpWantAuthnRequestsSigned;
            // Value is inverted in the api model (disable instead of allow)
            api.idpDisableOutboundLogoutRequests = !view.saml.idpAllowOutboundLogoutRequests;
        }
        return api;
    }
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.configType = this.getResponseProperty("ConfigType");
        this.memberDecryptionType = this.getResponseProperty("MemberDecryptionType");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.authority = this.getResponseProperty("Authority");
        this.clientId = this.getResponseProperty("ClientId");
        this.clientSecret = this.getResponseProperty("ClientSecret");
        this.metadataAddress = this.getResponseProperty("MetadataAddress");
        this.redirectBehavior = this.getResponseProperty("RedirectBehavior");
        this.getClaimsFromUserInfoEndpoint = this.getResponseProperty("GetClaimsFromUserInfoEndpoint");
        this.additionalScopes = this.getResponseProperty("AdditionalScopes");
        this.additionalUserIdClaimTypes = this.getResponseProperty("AdditionalUserIdClaimTypes");
        this.additionalEmailClaimTypes = this.getResponseProperty("AdditionalEmailClaimTypes");
        this.additionalNameClaimTypes = this.getResponseProperty("AdditionalNameClaimTypes");
        this.acrValues = this.getResponseProperty("AcrValues");
        this.expectedReturnAcrValue = this.getResponseProperty("ExpectedReturnAcrValue");
        this.spUniqueEntityId = this.getResponseProperty("SpUniqueEntityId");
        this.spNameIdFormat = this.getResponseProperty("SpNameIdFormat");
        this.spOutboundSigningAlgorithm = this.getResponseProperty("SpOutboundSigningAlgorithm");
        this.spSigningBehavior = this.getResponseProperty("SpSigningBehavior");
        this.spMinIncomingSigningAlgorithm = this.getResponseProperty("SpMinIncomingSigningAlgorithm");
        this.spWantAssertionsSigned = this.getResponseProperty("SpWantAssertionsSigned");
        this.spValidateCertificates = this.getResponseProperty("SpValidateCertificates");
        this.idpEntityId = this.getResponseProperty("IdpEntityId");
        this.idpBindingType = this.getResponseProperty("IdpBindingType");
        this.idpSingleSignOnServiceUrl = this.getResponseProperty("IdpSingleSignOnServiceUrl");
        this.idpSingleLogoutServiceUrl = this.getResponseProperty("IdpSingleLogoutServiceUrl");
        this.idpX509PublicCert = this.getResponseProperty("IdpX509PublicCert");
        this.idpOutboundSigningAlgorithm = this.getResponseProperty("IdpOutboundSigningAlgorithm");
        this.idpAllowUnsolicitedAuthnResponse = this.getResponseProperty("IdpAllowUnsolicitedAuthnResponse");
        this.idpDisableOutboundLogoutRequests = this.getResponseProperty("IdpDisableOutboundLogoutRequests");
        this.idpWantAuthnRequestsSigned = this.getResponseProperty("IdpWantAuthnRequestsSigned");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/organization-sso.response.ts


class OrganizationSsoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.enabled = this.getResponseProperty("Enabled");
        this.identifier = this.getResponseProperty("Identifier");
        this.data =
            this.getResponseProperty("Data") != null
                ? new SsoConfigApi(this.getResponseProperty("Data"))
                : null;
        this.urls = new SsoUrls(this.getResponseProperty("Urls"));
    }
}
class SsoUrls extends BaseResponse {
    constructor(response) {
        super(response);
        this.callbackPath = this.getResponseProperty("CallbackPath");
        this.signedOutCallbackPath = this.getResponseProperty("SignedOutCallbackPath");
        this.spEntityId = this.getResponseProperty("SpEntityId");
        this.spEntityIdStatic = this.getResponseProperty("SpEntityIdStatic");
        this.spMetadataUrl = this.getResponseProperty("SpMetadataUrl");
        this.spAcsUrl = this.getResponseProperty("SpAcsUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/plan.response.ts

class PlanResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.productTier = this.getResponseProperty("ProductTier");
        this.name = this.getResponseProperty("Name");
        this.isAnnual = this.getResponseProperty("IsAnnual");
        this.nameLocalizationKey = this.getResponseProperty("NameLocalizationKey");
        this.descriptionLocalizationKey = this.getResponseProperty("DescriptionLocalizationKey");
        this.canBeUsedByBusiness = this.getResponseProperty("CanBeUsedByBusiness");
        this.trialPeriodDays = this.getResponseProperty("TrialPeriodDays");
        this.hasSelfHost = this.getResponseProperty("HasSelfHost");
        this.hasPolicies = this.getResponseProperty("HasPolicies");
        this.hasGroups = this.getResponseProperty("HasGroups");
        this.hasDirectory = this.getResponseProperty("HasDirectory");
        this.hasEvents = this.getResponseProperty("HasEvents");
        this.hasTotp = this.getResponseProperty("HasTotp");
        this.has2fa = this.getResponseProperty("Has2fa");
        this.hasApi = this.getResponseProperty("HasApi");
        this.hasSso = this.getResponseProperty("HasSso");
        this.hasResetPassword = this.getResponseProperty("HasResetPassword");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.upgradeSortOrder = this.getResponseProperty("UpgradeSortOrder");
        this.displaySortOrder = this.getResponseProperty("DisplaySortOrder");
        this.legacyYear = this.getResponseProperty("LegacyYear");
        this.disabled = this.getResponseProperty("Disabled");
        const passwordManager = this.getResponseProperty("PasswordManager");
        const secretsManager = this.getResponseProperty("SecretsManager");
        this.PasswordManager =
            passwordManager == null ? null : new PasswordManagerPlanFeaturesResponse(passwordManager);
        this.SecretsManager =
            secretsManager == null ? null : new SecretsManagerPlanFeaturesResponse(secretsManager);
    }
}
class SecretsManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.stripeServiceAccountPlanId = this.getResponseProperty("StripeServiceAccountPlanId");
        this.additionalPricePerServiceAccount = this.getResponseProperty("AdditionalPricePerServiceAccount");
        this.baseServiceAccount = this.getResponseProperty("BaseServiceAccount");
        this.maxServiceAccount = this.getResponseProperty("MaxServiceAccount");
        this.hasAdditionalServiceAccountOption = this.getResponseProperty("HasAdditionalServiceAccountOption");
        this.maxAdditionalServiceAccounts = this.getResponseProperty("MaxAdditionalServiceAccounts");
        this.maxProjects = this.getResponseProperty("MaxProjects");
    }
}
class PasswordManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripePlanId = this.getResponseProperty("StripePlanId");
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.stripeProviderPortalSeatPlanId = this.getResponseProperty("StripeProviderPortalSeatPlanId");
        this.stripeStoragePlanId = this.getResponseProperty("StripeStoragePlanId");
        this.stripePremiumAccessPlanId = this.getResponseProperty("StripePremiumAccessPlanId");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.providerPortalSeatPrice = this.getResponseProperty("ProviderPortalSeatPrice");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.premiumAccessOptionPrice = this.getResponseProperty("PremiumAccessOptionPrice");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.additionalStoragePricePerGb = this.getResponseProperty("AdditionalStoragePricePerGb");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.baseStorageGb = this.getResponseProperty("BaseStorageGb");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.hasAdditionalStorageOption = this.getResponseProperty("HasAdditionalStorageOption");
        this.maxAdditionalStorage = this.getResponseProperty("MaxAdditionalStorage");
        this.hasPremiumAccessOption = this.getResponseProperty("HasPremiumAccessOption");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization.response.ts


class organization_response_OrganizationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.businessName = this.getResponseProperty("BusinessName");
        this.businessAddress1 = this.getResponseProperty("BusinessAddress1");
        this.businessAddress2 = this.getResponseProperty("BusinessAddress2");
        this.businessAddress3 = this.getResponseProperty("BusinessAddress3");
        this.businessCountry = this.getResponseProperty("BusinessCountry");
        this.businessTaxNumber = this.getResponseProperty("BusinessTaxNumber");
        this.billingEmail = this.getResponseProperty("BillingEmail");
        const plan = this.getResponseProperty("Plan");
        this.plan = plan == null ? null : new PlanResponse(plan);
        this.planType = this.getResponseProperty("PlanType");
        this.seats = this.getResponseProperty("Seats");
        this.maxAutoscaleSeats = this.getResponseProperty("MaxAutoscaleSeats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.smSeats = this.getResponseProperty("SmSeats");
        this.smServiceAccounts = this.getResponseProperty("SmServiceAccounts");
        this.maxAutoscaleSmSeats = this.getResponseProperty("MaxAutoscaleSmSeats");
        this.maxAutoscaleSmServiceAccounts = this.getResponseProperty("MaxAutoscaleSmServiceAccounts");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/subscription.response.ts

class SubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.license = this.getResponseProperty("License");
        this.expiration = this.getResponseProperty("Expiration");
        const subscription = this.getResponseProperty("Subscription");
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
    }
}
class BillingSubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.items = [];
        this.trialStartDate = this.getResponseProperty("TrialStartDate");
        this.trialEndDate = this.getResponseProperty("TrialEndDate");
        this.periodStartDate = this.getResponseProperty("PeriodStartDate");
        this.periodEndDate = this.getResponseProperty("PeriodEndDate");
        this.cancelledDate = this.getResponseProperty("CancelledDate");
        this.cancelAtEndDate = this.getResponseProperty("CancelAtEndDate");
        this.status = this.getResponseProperty("Status");
        this.cancelled = this.getResponseProperty("Cancelled");
        const items = this.getResponseProperty("Items");
        if (items != null) {
            this.items = items.map((i) => new BillingSubscriptionItemResponse(i));
        }
        this.collectionMethod = this.getResponseProperty("CollectionMethod");
        this.suspensionDate = this.getResponseProperty("SuspensionDate");
        this.unpaidPeriodEndDate = this.getResponseProperty("unpaidPeriodEndDate");
        this.gracePeriod = this.getResponseProperty("GracePeriod");
    }
}
class BillingSubscriptionItemResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.productId = this.getResponseProperty("ProductId");
        this.name = this.getResponseProperty("Name");
        this.amount = this.getResponseProperty("Amount");
        this.quantity = this.getResponseProperty("Quantity");
        this.interval = this.getResponseProperty("Interval");
        this.sponsoredSubscriptionItem = this.getResponseProperty("SponsoredSubscriptionItem");
        this.addonSubscriptionItem = this.getResponseProperty("AddonSubscriptionItem");
    }
}
class BillingSubscriptionUpcomingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/organization-subscription.response.ts



class OrganizationSubscriptionResponse extends organization_response_OrganizationResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        const subscription = this.getResponseProperty("Subscription");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
        const customerDiscount = this.getResponseProperty("CustomerDiscount");
        this.customerDiscount =
            customerDiscount == null ? null : new BillingCustomerDiscount(customerDiscount);
        this.expiration = this.getResponseProperty("Expiration");
        this.expirationWithoutGracePeriod = this.getResponseProperty("ExpirationWithoutGracePeriod");
    }
}
class BillingCustomerDiscount extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.active = this.getResponseProperty("Active");
        this.percentOff = this.getResponseProperty("PercentOff");
        this.appliesTo = this.getResponseProperty("AppliesTo");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/api/permissions.api.ts

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.editAssignedCollections = this.getResponseProperty("EditAssignedCollections");
        this.deleteAssignedCollections = this.getResponseProperty("DeleteAssignedCollections");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-organization.response.ts


class ProfileOrganizationResponse extends BaseResponse {
    constructor(response) {
        var _a, _b, _c, _d;
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.usePolicies = this.getResponseProperty("UsePolicies");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useSso = this.getResponseProperty("UseSso");
        this.useKeyConnector = (_a = this.getResponseProperty("UseKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.useScim = (_b = this.getResponseProperty("UseScim")) !== null && _b !== void 0 ? _b : false;
        this.useCustomPermissions = (_c = this.getResponseProperty("UseCustomPermissions")) !== null && _c !== void 0 ? _c : false;
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.useActivateAutofillPolicy = this.getResponseProperty("UseActivateAutofillPolicy");
        this.selfHost = this.getResponseProperty("SelfHost");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.seats = this.getResponseProperty("Seats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.key = this.getResponseProperty("Key");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.ssoBound = this.getResponseProperty("SsoBound");
        this.identifier = this.getResponseProperty("Identifier");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.userId = this.getResponseProperty("UserId");
        this.organizationUserId = this.getResponseProperty("OrganizationUserId");
        this.providerId = this.getResponseProperty("ProviderId");
        this.providerName = this.getResponseProperty("ProviderName");
        this.providerType = this.getResponseProperty("ProviderType");
        this.familySponsorshipFriendlyName = this.getResponseProperty("FamilySponsorshipFriendlyName");
        this.familySponsorshipAvailable = this.getResponseProperty("FamilySponsorshipAvailable");
        this.productTierType = this.getResponseProperty("ProductTierType");
        this.keyConnectorEnabled = (_d = this.getResponseProperty("KeyConnectorEnabled")) !== null && _d !== void 0 ? _d : false;
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        const familySponsorshipLastSyncDateString = this.getResponseProperty("FamilySponsorshipLastSyncDate");
        if (familySponsorshipLastSyncDateString) {
            this.familySponsorshipLastSyncDate = new Date(familySponsorshipLastSyncDateString);
        }
        const familySponsorshipValidUntilString = this.getResponseProperty("FamilySponsorshipValidUntil");
        if (familySponsorshipValidUntilString) {
            this.familySponsorshipValidUntil = new Date(familySponsorshipValidUntilString);
        }
        this.familySponsorshipToDelete = this.getResponseProperty("FamilySponsorshipToDelete");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider-organization.response.ts

class ProfileProviderOrganizationResponse extends ProfileOrganizationResponse {
    constructor(response) {
        super(response);
        this.keyConnectorEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider.response.ts


class ProfileProviderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.key = this.getResponseProperty("Key");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.userId = this.getResponseProperty("UserId");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.providerStatus = this.getResponseProperty("ProviderStatus");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/profile.response.ts




class ProfileResponse extends BaseResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.organizations = [];
        this.providers = [];
        this.providerOrganizations = [];
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.emailVerified = this.getResponseProperty("EmailVerified");
        this.masterPasswordHint = this.getResponseProperty("MasterPasswordHint");
        this.premiumPersonally = this.getResponseProperty("Premium");
        this.premiumFromOrganization = this.getResponseProperty("PremiumFromOrganization");
        this.culture = this.getResponseProperty("Culture");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.key = this.getResponseProperty("Key");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.creationDate = this.getResponseProperty("CreationDate");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.securityStamp = this.getResponseProperty("SecurityStamp");
        this.forcePasswordReset = (_a = this.getResponseProperty("ForcePasswordReset")) !== null && _a !== void 0 ? _a : false;
        this.usesKeyConnector = (_b = this.getResponseProperty("UsesKeyConnector")) !== null && _b !== void 0 ? _b : false;
        const organizations = this.getResponseProperty("Organizations");
        if (organizations != null) {
            this.organizations = organizations.map((o) => new ProfileOrganizationResponse(o));
        }
        const providers = this.getResponseProperty("Providers");
        if (providers != null) {
            this.providers = providers.map((o) => new ProfileProviderResponse(o));
        }
        const providerOrganizations = this.getResponseProperty("ProviderOrganizations");
        if (providerOrganizations != null) {
            this.providerOrganizations = providerOrganizations.map((o) => new ProfileProviderOrganizationResponse(o));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/payment.response.ts


class PaymentResponse extends BaseResponse {
    constructor(response) {
        super(response);
        const userProfile = this.getResponseProperty("UserProfile");
        if (userProfile != null) {
            this.userProfile = new ProfileResponse(userProfile);
        }
        this.paymentIntentClientSecret = this.getResponseProperty("PaymentIntentClientSecret");
        this.success = this.getResponseProperty("Success");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/tax-info.response.ts

class TaxInfoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.taxId = this.getResponseProperty("TaxIdNumber");
        if (!this.taxId) {
            this.taxId = this.getResponseProperty("TaxId");
        }
        this.taxIdType = this.getResponseProperty("TaxIdType");
        this.line1 = this.getResponseProperty("Line1");
        this.line2 = this.getResponseProperty("Line2");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-api-key-information.response.ts

class OrganizationApiKeyInformationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyType = this.getResponseProperty("KeyType");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-auto-enroll-status.response.ts

class OrganizationAutoEnrollStatusResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.resetPasswordEnabled = this.getResponseProperty("ResetPasswordEnabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/keys.response.ts

class KeysResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.publicKey = this.getResponseProperty("PublicKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-keys.response.ts

class OrganizationKeysResponse extends KeysResponse {
    constructor(response) {
        super(response);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization-api.service.ts
var organization_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













class OrganizationApiService {
    constructor(apiService, syncService) {
        this.apiService = apiService;
        this.syncService = syncService;
    }
    get(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id, null, true, true);
            return new organization_response_OrganizationResponse(r);
        });
    }
    getBilling(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/billing", null, true, true);
            return new BillingResponse(r);
        });
    }
    getBillingHistory(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/billing/history", null, true, true);
            return new BillingHistoryResponse(r);
        });
    }
    getSubscription(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/subscription", null, true, true);
            return new OrganizationSubscriptionResponse(r);
        });
    }
    getLicense(id, installationId) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("GET", "/organizations/" + id + "/license?installationId=" + installationId, null, true, true);
        });
    }
    getAutoEnrollStatus(identifier) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + identifier + "/auto-enroll-status", null, true, true);
            return new OrganizationAutoEnrollStatusResponse(r);
        });
    }
    create(request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations", request, true, true);
            // Forcing a sync will notify organization service that they need to repull
            yield this.syncService.fullSync(true);
            return new organization_response_OrganizationResponse(r);
        });
    }
    createLicense(data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/licenses/self-hosted", data, true, true);
            return new organization_response_OrganizationResponse(r);
        });
    }
    save(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id, request, true, true);
            const data = new organization_response_OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    updatePayment(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/payment", request, true, false);
        });
    }
    upgrade(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/upgrade", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updatePasswordManagerSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/subscription", request, true, false);
        });
    }
    updateSecretsManagerSubscription(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/sm-subscription", request, true, false);
        });
    }
    updateSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/seat", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updateStorage(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/storage", request, true, true);
            return new PaymentResponse(r);
        });
    }
    verifyBank(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/verify-bank", request, true, false);
        });
    }
    reinstate(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/reinstate", null, true, false);
        });
    }
    leave(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/leave", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    delete(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("DELETE", "/organizations/" + id, request, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    deleteUsingToken(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/delete-recover-token", request, false, false);
    }
    updateLicense(id, data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id, data, true, false);
        });
    }
    importDirectory(organizationId, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + organizationId + "/import", request, true, false);
        });
    }
    getOrCreateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getApiKeyInformation(id, organizationApiKeyType = null) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const uri = organizationApiKeyType === null
                ? "/organizations/" + id + "/api-key-information"
                : "/organizations/" + id + "/api-key-information/" + organizationApiKeyType;
            const r = yield this.apiService.send("GET", uri, null, true, true);
            return new list_response_ListResponse(r, OrganizationApiKeyInformationResponse);
        });
    }
    rotateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/rotate-api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getTaxInfo(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/tax", null, true, true);
            return new TaxInfoResponse(r);
        });
    }
    updateTaxInfo(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            // Can't broadcast anything because the response doesn't have content
            return this.apiService.send("PUT", "/organizations/" + id + "/tax", request, true, false);
        });
    }
    getKeys(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/keys", null, true, true);
            return new OrganizationKeysResponse(r);
        });
    }
    updateKeys(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/keys", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationKeysResponse(r);
        });
    }
    getSso(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/sso", null, true, true);
            return new OrganizationSsoResponse(r);
        });
    }
    updateSso(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/sso", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationSsoResponse(r);
        });
    }
    selfHostedSyncLicense(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id + "/sync/", null, true, false);
        });
    }
    subscribeToSecretsManager(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/subscribe-secrets-manager", request, true, true);
            return new ProfileOrganizationResponse(r);
        });
    }
    updateCollectionManagement(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id + "/collection-management", request, true, true);
            const data = new organization_response_OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/organization.data.ts
class OrganizationData {
    constructor(response, options) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.name = response.name;
        this.status = response.status;
        this.type = response.type;
        this.enabled = response.enabled;
        this.usePolicies = response.usePolicies;
        this.useGroups = response.useGroups;
        this.useDirectory = response.useDirectory;
        this.useEvents = response.useEvents;
        this.useTotp = response.useTotp;
        this.use2fa = response.use2fa;
        this.useApi = response.useApi;
        this.useSso = response.useSso;
        this.useKeyConnector = response.useKeyConnector;
        this.useScim = response.useScim;
        this.useCustomPermissions = response.useCustomPermissions;
        this.useResetPassword = response.useResetPassword;
        this.useSecretsManager = response.useSecretsManager;
        this.usePasswordManager = response.usePasswordManager;
        this.useActivateAutofillPolicy = response.useActivateAutofillPolicy;
        this.selfHost = response.selfHost;
        this.usersGetPremium = response.usersGetPremium;
        this.seats = response.seats;
        this.maxCollections = response.maxCollections;
        this.maxStorageGb = response.maxStorageGb;
        this.ssoBound = response.ssoBound;
        this.identifier = response.identifier;
        this.permissions = response.permissions;
        this.resetPasswordEnrolled = response.resetPasswordEnrolled;
        this.userId = response.userId;
        this.organizationUserId = response.organizationUserId;
        this.hasPublicAndPrivateKeys = response.hasPublicAndPrivateKeys;
        this.providerId = response.providerId;
        this.providerName = response.providerName;
        this.providerType = response.providerType;
        this.familySponsorshipFriendlyName = response.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = response.familySponsorshipAvailable;
        this.productTierType = response.productTierType;
        this.keyConnectorEnabled = response.keyConnectorEnabled;
        this.keyConnectorUrl = response.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = response.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = response.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = response.familySponsorshipToDelete;
        this.accessSecretsManager = response.accessSecretsManager;
        this.limitCollectionCreationDeletion = response.limitCollectionCreationDeletion;
        this.allowAdminAccessToAllCollectionItems = response.allowAdminAccessToAllCollectionItems;
        this.flexibleCollections = response.flexibleCollections;
        this.isMember = options.isMember;
        this.isProviderUser = options.isProviderUser;
    }
    static fromJSON(obj) {
        return Object.assign(new OrganizationData(), obj, {
            familySponsorshipLastSyncDate: obj.familySponsorshipLastSyncDate != null
                ? new Date(obj.familySponsorshipLastSyncDate)
                : obj.familySponsorshipLastSyncDate,
            familySponsorshipValidUntil: obj.familySponsorshipValidUntil != null
                ? new Date(obj.familySponsorshipValidUntil)
                : obj.familySponsorshipValidUntil,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/organization.ts

class Organization {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj