#!/usr/bin/python
import version
import time;

VERSION = version.VERSION

def write_config (prefix):
	print ("Writing Config.vala")

	vars = (('VERSION', VERSION),
		('BUILD_TIMESTAMP', time.asctime( time.localtime(time.time()))),
		('PREFIX', prefix),
		)

	f = open('./libbirdfont/Config.vala', 'w+')
	f.write("// Don't edit this file -- it is generated by the build script\n")
	f.write("namespace BirdFont {\n")

	var_line = '	internal static const string %s = "%s";\n'
	for name, value in vars:
		f.write(var_line % (name, value))

	f.write("}")
