;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --randomize-branch-hints -S -o - | filecheck %s

(module
  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (type $1 (func (result f64)))

  ;; CHECK:      (func $if
  ;; CHECK-NEXT:  (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 42)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 1337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 99)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (@metadata.code.branch_hint "\00")
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 142)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 11337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 199)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 242)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 21337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 299)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 342)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 31337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 399)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if
    ;; We should see various branch hints appear, both true and false, and also
    ;; some instructions with no hint.
    (if
      (i32.const 42)
      (then
        (drop (i32.const 1337))
      )
      (else
        (drop (i32.const 99))
      )
    )
    (if
      (i32.const 142)
      (then
        (drop (i32.const 11337))
      )
      (else
        (drop (i32.const 199))
      )
    )
    (if
      (i32.const 242)
      (then
        (drop (i32.const 21337))
      )
      (else
        (drop (i32.const 299))
      )
    )
    (if
      (i32.const 342)
      (then
        (drop (i32.const 31337))
      )
      (else
        (drop (i32.const 399))
      )
    )
  )

  ;; CHECK:      (func $if-existing
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 42)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 1337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 99)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 142)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 11337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 199)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 242)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 21337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 299)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 342)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 31337)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 399)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-existing
    ;; We do not error on existing hints, and trample/remove them.
    (@metadata.code.branch_hint "\01")
    (if
      (i32.const 42)
      (then
        (drop (i32.const 1337))
      )
      (else
        (drop (i32.const 99))
      )
    )
      (@metadata.code.branch_hint "\00")
    (if
      (i32.const 142)
      (then
        (drop (i32.const 11337))
      )
      (else
        (drop (i32.const 199))
      )
    )
    (@metadata.code.branch_hint "\01")
    (if
      (i32.const 242)
      (then
        (drop (i32.const 21337))
      )
      (else
        (drop (i32.const 299))
      )
    )
    (@metadata.code.branch_hint "\00")
    (if
      (i32.const 342)
      (then
        (drop (i32.const 31337))
      )
      (else
        (drop (i32.const 399))
      )
    )
  )

  ;; CHECK:      (func $br_if
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\00")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 1337)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $out1
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\00")
  ;; CHECK-NEXT:   (br_if $out1
  ;; CHECK-NEXT:    (i32.const 142)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 11337)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $out2
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out2
  ;; CHECK-NEXT:    (i32.const 242)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 21337)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $br_if
    ;; As above, with br_if.
    (block $out
      (br_if $out
        (i32.const 42)
      )
      (drop (i32.const 1337))
    )
    (block $out1
      (br_if $out1
        (i32.const 142)
      )
      (drop (i32.const 11337))
    )
    (block $out2
      ;; Existing hint.
      (@metadata.code.branch_hint "\01")
      (br_if $out2
        (i32.const 242)
      )
      (drop (i32.const 21337))
    )
  )

  ;; CHECK:      (func $br_value (result f64)
  ;; CHECK-NEXT:  (local $scratch f64)
  ;; CHECK-NEXT:  (block $out (result f64)
  ;; CHECK-NEXT:   (local.set $scratch
  ;; CHECK-NEXT:    (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:    (br_if $out
  ;; CHECK-NEXT:     (f64.const 3.14159)
  ;; CHECK-NEXT:     (i32.const 42)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 1337)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.get $scratch)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $br_value (result f64)
    ;; As above, but now with a value. We should not error.
    (block $out (result f64)
      (br_if $out
        (f64.const 3.14159)
        (i32.const 42)
      )
      (drop (i32.const 1337))
    )
  )

  ;; CHECK:      (func $br
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 1337)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $br
    ;; As above, but now without a condition. We should not error.
    (block $out
      (br $out
        (i32.const 42)
      )
      (drop (i32.const 1337))
    )
  )
)
