;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: foreach %s %t wasm-opt --optimize-instructions --ignore-implicit-traps --enable-reference-types --enable-gc -S -o - \
;; RUN:   | filecheck %s
;; RUN: foreach %s %t wasm-opt --optimize-instructions --ignore-implicit-traps --enable-reference-types --enable-gc --nominal -S -o - \
;; RUN:   | filecheck %s --check-prefix NOMNL
;; Also test trapsNeverHappen (with nominal; no need for both type system modes).
;; RUN: foreach %s %t wasm-opt --optimize-instructions --traps-never-happen --enable-reference-types --enable-gc --nominal -S -o - \
;; RUN:   | filecheck %s --check-prefix NOMNL-TNH

(module
  ;; CHECK:      (type $parent (struct (field i32)))
  ;; NOMNL:      (type $parent (struct_subtype (field i32) data))
  ;; NOMNL-TNH:      (type $parent (struct_subtype (field i32) data))
  (type $parent (struct (field i32)))
  ;; CHECK:      (type $child (struct (field i32) (field f64)))
  ;; NOMNL:      (type $child (struct_subtype (field i32) (field f64) $parent))
  ;; NOMNL-TNH:      (type $child (struct_subtype (field i32) (field f64) $parent))
  (type $child (struct_subtype (field i32) (field f64) $parent))
  ;; CHECK:      (type $other (struct (field i64) (field f32)))
  ;; NOMNL:      (type $other (struct_subtype (field i64) (field f32) data))
  ;; NOMNL-TNH:      (type $other (struct_subtype (field i64) (field f32) data))
  (type $other  (struct (field i64) (field f32)))

  ;; CHECK:      (func $foo
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $foo (type $none_=>_none)
  ;; NOMNL-NEXT:  (nop)
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $foo (type $none_=>_none)
  ;; NOMNL-TNH-NEXT:  (nop)
  ;; NOMNL-TNH-NEXT: )
  (func $foo)


  ;; CHECK:      (func $ref-cast-iit (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $parent)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $child)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast_static $child
  ;; CHECK-NEXT:    (local.get $parent)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $child)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-cast-iit (type $ref|$parent|_ref|$child|_ref|$other|_=>_none) (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other))
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (local.get $parent)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (local.get $child)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast_static $child
  ;; NOMNL-NEXT:    (local.get $parent)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (local.get $child)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (unreachable)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-cast-iit (type $ref|$parent|_ref|$child|_ref|$other|_=>_none) (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other))
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (local.get $parent)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (local.get $child)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (ref.cast_static $child
  ;; NOMNL-TNH-NEXT:    (local.get $parent)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (local.get $child)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (unreachable)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-cast-iit
    (param $parent (ref $parent))
    (param $child (ref $child))
    (param $other (ref $other))

    ;; a cast of parent to parent. We can optimize this as the new type will be
    ;; valid.
    (drop
      (ref.cast_static $parent
        (local.get $parent)
      )
    )
    ;; a cast of child to a supertype: again, we replace with a valid type.
    (drop
      (ref.cast_static $parent
        (local.get $child)
      )
    )
    ;; a cast of parent to a subtype: we cannot replace the original heap type
    ;; $child with one that is not equal or more specific, like $parent, so we
    ;; cannot optimize here.
    (drop
      (ref.cast_static $child
        (local.get $parent)
      )
    )
    ;; a cast of child to an unrelated type: it will trap anyhow
    (drop
      (ref.cast_static $other
        (local.get $child)
      )
    )
  )

  ;; CHECK:      (func $ref-cast-iit-bad (param $parent (ref $parent))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $parent))
  ;; CHECK-NEXT:    (call $foo)
  ;; CHECK-NEXT:    (local.get $parent)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast_static $parent
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-cast-iit-bad (type $ref|$parent|_=>_none) (param $parent (ref $parent))
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block (result (ref $parent))
  ;; NOMNL-NEXT:    (call $foo)
  ;; NOMNL-NEXT:    (local.get $parent)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast_static $parent
  ;; NOMNL-NEXT:    (unreachable)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-cast-iit-bad (type $ref|$parent|_=>_none) (param $parent (ref $parent))
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block (result (ref $parent))
  ;; NOMNL-TNH-NEXT:    (call $foo)
  ;; NOMNL-TNH-NEXT:    (local.get $parent)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (ref.cast_static $parent
  ;; NOMNL-TNH-NEXT:    (unreachable)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-cast-iit-bad
    (param $parent (ref $parent))

    ;; optimizing this cast away requires reordering.
    (drop
      (ref.cast_static $parent
        (block (result (ref $parent))
          (call $foo)
          (local.get $parent)
        )
      )
    )

    ;; ignore unreachability
    (drop
      (ref.cast_static $parent
        (unreachable)
      )
    )
  )

  ;; CHECK:      (func $ref-eq-ref-cast (param $x eqref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-eq-ref-cast (type $eqref_=>_none) (param $x eqref)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (i32.const 1)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-eq-ref-cast (type $eqref_=>_none) (param $x eqref)
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (i32.const 1)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-eq-ref-cast (param $x eqref)
    ;; we can look through a ref.cast if we ignore traps
    (drop
      (ref.eq
        (local.get $x)
        (ref.cast_static $parent
          (local.get $x)
        )
      )
    )
  )

  ;; CHECK:      (func $set-of-as-non-null (param $x anyref)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $set-of-as-non-null (type $anyref_=>_none) (param $x anyref)
  ;; NOMNL-NEXT:  (local.set $x
  ;; NOMNL-NEXT:   (local.get $x)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $set-of-as-non-null (type $anyref_=>_none) (param $x anyref)
  ;; NOMNL-TNH-NEXT:  (local.set $x
  ;; NOMNL-TNH-NEXT:   (local.get $x)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $set-of-as-non-null (param $x anyref)
    ;; As we ignore such traps, we can remove the ref.as here.
    (local.set $x
      (ref.as_non_null
        (local.get $x)
      )
    )
  )
)

(module
  ;; CHECK:      (type $B (struct (field (ref null $A))))

  ;; CHECK:      (type $A (struct ))
  ;; NOMNL:      (type $A (struct_subtype  data))
  ;; NOMNL-TNH:      (type $A (struct_subtype  data))
  (type $A (struct_subtype  data))
  ;; NOMNL:      (type $B (struct_subtype (field (ref null $A)) $A))
  ;; NOMNL-TNH:      (type $B (struct_subtype (field (ref null $A)) $A))
  (type $B (struct_subtype (field (ref null $A)) $A))
  ;; NOMNL:      (type $C (struct_subtype (field (ref null $D)) $B))
  ;; NOMNL-TNH:      (type $C (struct_subtype (field (ref null $D)) $B))
  (type $C (struct_subtype (field (ref null $D)) $B))
  ;; NOMNL:      (type $D (struct_subtype  $A))
  ;; NOMNL-TNH:      (type $D (struct_subtype  $A))
  (type $D (struct_subtype  $A))

  ;; CHECK:      (func $test (param $C (ref $B)) (result anyref)
  ;; CHECK-NEXT:  (struct.get $B 0
  ;; CHECK-NEXT:   (local.get $C)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $ref|$C|_=>_anyref) (param $C (ref $C)) (result anyref)
  ;; NOMNL-NEXT:  (struct.get $C 0
  ;; NOMNL-NEXT:   (local.get $C)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $test (type $ref|$C|_=>_anyref) (param $C (ref $C)) (result anyref)
  ;; NOMNL-TNH-NEXT:  (struct.get $C 0
  ;; NOMNL-TNH-NEXT:   (local.get $C)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $test (param $C (ref $C)) (result anyref)
    (struct.get $B 0
      (ref.cast_static $B ;; Try to cast a $C to its parent, $B. That always
                          ;; works, so the cast can be removed.
                          ;; Then once the cast is removed, the outer struct.get
                          ;; will have a reference with a different type,
                          ;; making it a (struct.get $C ..) instead of $B.
                          ;; But $B and $C have different types on field 0, and
                          ;; so the struct.get must be refinalized so the node
                          ;; has the expected type.
        (local.get $C)
      )
    )
  )
)
