#!/usr/bin/env python

# This script will automatically create the dependency graph for this directory
# and write the Makefile dependency into make_deps.mk
#
# Felipe H. da Jornada (2015)


from glob import glob
from subprocess import call, check_output
from time import strftime

def main():
    fnames = sorted(glob('*.[fF]90'))
    print('Found {} files'.format(len(fnames)))
    fname_deps = 'make_deps.mk'
    print('Writing dependencies to ' + fname_deps)
    fout = open(fname_deps, 'w')
    fout.write('# This file was generated by make_deps.py at {}\n\n'.format(
        strftime("%a, %d %b %Y %H:%M:%S")))

    for fname in fnames:
        print(fname)
        is_prog = call(['grep', '-q', '^ *program', fname])==0
        out = check_output(['sed', '-ne', r's/^ *use *\([^ ,]\{1,\}\).*$/\1/p', fname])
        deps_ = out.split('\n')
        deps = []
        for dep in deps_:
            if dep.endswith('_m'):
                # All BGW modules finish with _m. We can`t make system modules!
                if not ((dep[:-2]+'.f90' in fnames) or (dep[:-2]+'.F90' in fnames)):
                    # Original module file is not here. It must be in Common then.
                    dep = '$(COMMON)/' + dep
                dep += '.mod'
                if not dep in deps:
                    deps.append(dep)
                print('  {}'.format(dep))
        print('')

        fname_o = fname.replace('.f90','.o').replace('.F90','.o')
        if is_prog:
            fname_mod = ''
        else:
            fname_mod = fname.replace('.f90','_m.mod').replace('.F90','_m.mod')
        fout.write('{} {}: {}\n'.format(fname_o, fname_mod, ' '.join(deps)))

    print('File {} writen'.format(fname_deps))


if __name__=='__main__':
    main()

