# arch.mk for BerkeleyGW codes
#
# Suitable for serial Linux with Absoft compiler
# Required packages: liblapack-dev, fftw-dev, gfortran, g++, ia32-libs
# Status: all tests passed, 19 Oct 2011, r3449
#
# D. Strubbe
# Sept 2011 UCB

COMPFLAG  = -DABSOFT
MATHFLAG  = 
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DVERBOSE
# NOTE: long lines generated by SAFE_ALLOCATE are not accepted

# use of the cpp line numbers gives incorrect reference for error messages, so we need -P
FCPP    = cpp -P -ansi
F90free = af90 -f free
LINK    = af90 -L/opt/absoft11.1/lib -laU77
FOPTS   = -O3
#FOPTS   = -g -Rb -Rs  # debug flags
FNOOPTS = $(FOPTS)
MOD_OPT = -YMOD_OUT_DIR=
INCFLAG = -p

CC_COMP = g++
C_COMP  = gcc
C_LINK  = g++
C_OPTS  = -O3
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/lib/ -lfftw
FFTWINCLUDE  = /usr/share/doc/fftw-dev/fortran
LAPACKLIB    = -L/usr/lib/ -llapack
