# arch.mk for BerkeleyGW codes
#
# suitable for Hopper at NERSC with Cray compiler
# module swap PrgEnv-pgi PrgEnv-cray
# module load cray-hdf5-parallel
# Status: all tests passed r5435, 23 June 2013
#
# http://docs.cray.com/books/S-3695-35/html-S-3695-35/pdollsmg.html
# Unit numbers 100, 101, and 102 are permanently associated with the standard input, standard output, and standard error files, respectively.
#
# D. Strubbe
# Sept 2011, UC Berkeley
#
# This .mk file is non-ideal. You are encouraged to use hopper.nersc.gov.mk
#
# Passed testsuite 10/04/2014

COMPFLAG  = -DCRAY
PARAFLAG  = -DMPI -DOMP
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DHDF5
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

# use of the cpp line numbers gives incorrect reference for error messages, so we need -P
FCPP    = /usr/bin/cpp -P -ansi
F90free = ftn -em -f free
LINK    = ftn
# debugging flags: -R bscpd
# default is like -fast, according to Cray recommendations
FOPTS   =
FNOOPTS =
MOD_OPT = -J 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP  = CC
C_COMP  = cc
C_LINK  = CC
# default is like -fast, according to Cray recommendations
C_OPTS  = 
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /opt/fftw/2.1.5.4
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
HDF5LIB      = -lhdf5hl_fortran -lhdf5_hl -lhdf5_fortran -lhdf5 -lz
HDF5INCLUDE  = $(HDF5_INCLUDE_OPTS)

#PERFORMANCE  = -L/usr/common/usg/ipm/0.921/lib -lipm
PERFORMANCE  = 

TESTSCRIPT = qsub hopper.scr
