# arch.mk for BerkeleyGW codes
#
# suitable for Edison at NERSC
#
# JRD
# 2013, NERSC
#
# This version currently does not pass testsuite due to issue with MKL ScaLAPACK and Cray MPICH
# We recommend you use edison.nersc.gov_gnu_libsci.mk or edison.nersc.gov_gnu_libsci_hdf5.mk


# Precompiler options
#
COMPFLAG  = -DINTEL
PARAFLAG  = -DMPI -DOMP
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DUSEFFTW3
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -free -openmp
LINK    = ftn
FOPTS   = -fast -no-ipo -openmp
FNOOPTS = $(FOPTS)
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
C_OPTS  = -fast -no-ipo
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
#FFTWPATH     = 
MKLROOT            = /opt/intel/composer_xe_2013.1.117/mkl
FFTWLIB      = $(MKLROOT)/lib/intel64/libmkl_scalapack_lp64.a -Wl,--start-group  $(MKLROOT)/lib/intel64/libmkl_intel_lp64.a \
               $(MKLROOT)/lib/intel64/libmkl_intel_thread.a $(MKLROOT)/lib/intel64/libmkl_core.a $(MKLROOT)/lib/intel64/libmkl_blacs_intelmpi_lp64.a \
               -Wl,--end-group -lpthread -lm
FFTWINCLUDE  = /opt/intel/composer_xe_2013.1.117/mkl/include/fftw/
#PERFORMANCE  = -L/usr/common/usg/ipm/2.00/lib -lipm 
PERFORMANCE  = 

#LAPACKLIB = -mkl=cluster
LAPACKLIB = 

TESTSCRIPT = qsub edison.scr
