# arch.mk for BerkeleyGW codes
#
# suitable for Carver at NERSC
# module load mkl/10.2
#
# JRD
#
# Testsuite Passed 10/20/2014

COMPFLAG  = -DPGI
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DUSEFFTW3
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = mpif90 -Mfree
LINK    = mpif90
FOPTS   = -fast
FNOOPTS = $(FOPTS)
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG  = -DPARA
CC_COMP = mpiCC
C_COMP  = mpicc
C_LINK  = mpiCC
C_OPTS  = -fast
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /usr/common/usg/fftw/3.3.2/
FFTWLIB      = -L$(FFTWPATH)/lib -lfftw3
FFTWINCLUDE  = $(FFTWPATH)/include

LAPACKLIB = -L/usr/common/usg/mkl/10.2.2.025/lib/em64t -Wl,--start-group -lmkl_intel_lp64 -lmkl_sequential -lmkl_core -lmkl_blacs_openmpi_lp64 -Wl,--end-group -lm
SCALAPACKLIB = -lmkl_scalapack_lp64

PERFORMANCE  = 

TESTSCRIPT = qsub hopper.scr
