# arch.mk for BerkeleyGW codes
#
# suitable for BigRed at IU, in 32-bit
# ESSL is used where possible, but LAPACK is the only option in EPM
# LAPACK is also required for linking of ScaLAPACK
# in .soft, replace @teragrid-dev with +mpich-mx-ibm-32
# and run resoft.
# testsuite passes, 2/2/2011 r2224 (RC4)
# 3.0.x has unexplained problems after new WFN format in Graphene test
# also, dependencies for make are not handled correctly, causing unnecessary recompilation
# BigRed has cut off TeraGrid users running jobs, no more tests possible
#
# J. Deslippe
# Feb, 2008, UCB

COMPFLAG  = -DXLF
PARAFLAG  = -DMPI
MATHFLAG  = -DUSEESSL -DUSESCALAPACK
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -P -ansi
F90free = mpif90 -free
LINK    = mpif90
FOPTS   = -q32 -O3 -qarch=auto -qhot -qalias=noaryovrlp -Q -lessl
FNOOPTS = $(FOPTS)
MOD_OPT = -qmoddir=
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = mpicxx
C_COMP  = mpicc
C_LINK  = mpicxx
C_OPTS  = -q32 -O3
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
SOFTPATH     = /N/soft/linux-sles9-ppc64
FFTWLIB      = -L$(SOFTPATH)/fftw2.1.5-32-double/lib -lfftw
FFTWINCLUDE  = $(SOFTPATH)/fftw2.1.5-32-double/include
LAPACKLIB    = $(SOFTPATH)/lapack/lib32/lapack.a $(SOFTPATH)/blas/lib32/libblas.a
SCALAPACKLIB = $(SOFTPATH)/scalapack/lib32/libscalapack.a $(SOFTPATH)/BLACS/lib32/libblacs.a \
               $(SOFTPATH)/BLACS/lib32/libblacsF77init.a $(SOFTPATH)/BLACS/lib32/libblacs.a

TESTSCRIPT = llsubmit bigred.scr
