!>=========================================================================
!!
!! Module:
!!
!! (1) wfn_io_hdf5_m     Originally by JIM     Last Modified 4/25/2012 (JIM)
!!
!!     Routines to read and write wavefunctions in HDF5 format.
!!     The code is generated through repeated inclusion of a file with
!!     different preprocessor definitions each time. You are not expected to
!!     understand this. Consult the resulting .p.f file for clarity.
!!
!!=========================================================================

#include "f_defs.h"

module hdf5_io_m
  use global_m
#ifdef HDF5
  use h5lt
  use hdf5
  
  implicit none
  
  private
  
  public :: &
    hdf5_read_int           , &
    hdf5_write_int          , &
    hdf5_read_int_array     , &
    hdf5_write_int_array    , &
    hdf5_read_double        , &
    hdf5_write_double       , &
    hdf5_read_double_array  , &
    hdf5_write_double_array

contains
  
!===============================================================================
#define TYPE_INT
#define READ
#include "hdf5_io_inc.f90"
#undef READ
#include "hdf5_io_inc.f90"
#undef TYPE_INT

#define TYPE_DOUBLE
#define READ
#include "hdf5_io_inc.f90"
#undef READ
#include "hdf5_io_inc.f90"
#undef TYPE_DOUBLE
!===============================================================================

#endif

end module hdf5_io_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
