!===============================================================================
!
! Routines:
!
! (1) absorption         Originally by JRD       Last Edited: 9/12/2011 (JRD)
!
!     This routine calls either diag or haydock.
!
!     For more details the README_absorption file:
!
!     Please report bugs to: jdeslip@civet.berkeley.edu
!     
!================================================================================

#include "f_defs.h"

program absorption

#ifdef HDF5
  use hdf5
#endif

  use global_m
  use inread_m
  use bse_init_m
  implicit none

  type (eqpinfo) :: eqp
  type (xctinfo) :: xct
  type (flags) :: flag

  integer :: nmax,neig,error
  logical :: diagonalization

  call peinfo_init()

!---------------------------
! Write header

  call write_program_header('BSE/Absorption', .false.)

!---------------------------
! Read absorption.inp

  call logit('Calling inread')
  call open_file(8,file='absorption.inp',form='formatted',status='old')
  call inread(eqp,xct,flag,nmax,neig,diagonalization)
  call close_file(8)

! FHJ: Initialize xct%nkpt_co and dimensionality of the problem
  call bse_init(xct,flag)

!----------------------
! Initialize HDF5

#ifdef HDF5
  if(xct%use_hdf5) call h5open_f(error)
#endif

!----------------------
! Initialize random numbers

  peinf%jobtypeeval = 1

!----------------------
! Initialize wcoul0

  xct%wcoul0 = 0d0

!----------------------
! Initialize timer

  call timacc(0,0)
  call timacc(1,1)

!---------------------------
! Initialize files

  if (xct%iwritecoul .eq. 1 .and. peinf%inode .eq. 0) then
    call open_file(19,file='vcoul',form='formatted',status='replace')
  endif

  if (diagonalization) then
    call diag(eqp,xct,flag,neig)
  else 
    call haydock(eqp,xct,flag,nmax)
  endif

  call write_memory_usage()

#ifdef MPI
  call MPI_FINALIZE(mpierr)
#endif

end program absorption
