/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.util.ArrayUtil;

public class MultiInstructionVisitor
implements InstructionVisitor {
    private InstructionVisitor[] instructionVisitors;
    private int instructionVisitorCount;

    public MultiInstructionVisitor() {
        this.instructionVisitors = new InstructionVisitor[16];
    }

    public MultiInstructionVisitor(InstructionVisitor ... instructionVisitors) {
        this.instructionVisitors = instructionVisitors;
        this.instructionVisitorCount = instructionVisitors.length;
    }

    public void addInstructionVisitor(InstructionVisitor instructionVisitor) {
        this.instructionVisitors = ArrayUtil.add(this.instructionVisitors, this.instructionVisitorCount++, instructionVisitor);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitSimpleInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitVariableInstruction(clazz, method, codeAttribute, offset, variableInstruction);
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
        }
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitTableSwitchInstruction(clazz, method, codeAttribute, offset, tableSwitchInstruction);
        }
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        for (int index = 0; index < this.instructionVisitorCount; ++index) {
            this.instructionVisitors[index].visitLookUpSwitchInstruction(clazz, method, codeAttribute, offset, lookUpSwitchInstruction);
        }
    }
}

