/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;

public class VdIcon
implements Icon,
Comparable<VdIcon> {
    private VdTree mVdTree;
    private final String mName;
    private final URL mUrl;
    private boolean mDrawCheckerBoardBackground;
    private Rectangle myRectangle = new Rectangle();
    private static final Color CHECKER_COLOR = new Color(238, 238, 238);

    public VdIcon(URL url) {
        this.mVdTree = this.parseVdTree(url);
        this.mUrl = url;
        String fileName = url.getFile();
        this.mName = fileName.substring(fileName.lastIndexOf("/") + 1);
    }

    public String getName() {
        return this.mName;
    }

    public URL getURL() {
        return this.mUrl;
    }

    private VdTree parseVdTree(URL url) {
        VdParser p = new VdParser();
        VdTree result = null;
        try {
            result = p.parse(url.openStream(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void paintCheckeredBackground(Graphics g, Color backgroundColor, Color checkeredColor, Shape clip, int cellSize) {
        Shape savedClip = g.getClip();
        ((Graphics2D)g).clip(clip);
        Rectangle rect = clip.getBounds();
        g.setColor(backgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(checkeredColor);
        int dy = 0;
        while (dy * cellSize < rect.height) {
            int dx = dy % 2;
            while (dx * cellSize < rect.width) {
                g.fillRect(rect.x + dx * cellSize, rect.y + dy * cellSize, cellSize, cellSize);
                dx += 2;
            }
            ++dy;
        }
        g.setClip(savedClip);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.myRectangle.setBounds(0, 0, c.getWidth(), c.getHeight());
        if (this.mDrawCheckerBoardBackground) {
            VdIcon.paintCheckeredBackground(g, Color.LIGHT_GRAY, CHECKER_COLOR, this.myRectangle, 8);
        }
        if (this.mVdTree == null) {
            return;
        }
        int minSize = Math.min(c.getWidth(), c.getHeight());
        BufferedImage image = AssetUtil.newArgbBufferedImage(minSize, minSize);
        this.mVdTree.drawIntoImage(image);
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        AssetUtil.drawCenterInside((Graphics2D)g, image, rect);
    }

    @Override
    public int getIconWidth() {
        return (int)(this.mVdTree != null ? this.mVdTree.getPortWidth() : 0.0f);
    }

    @Override
    public int getIconHeight() {
        return (int)(this.mVdTree != null ? this.mVdTree.getPortHeight() : 0.0f);
    }

    @Override
    public int compareTo(VdIcon other) {
        return this.mName.compareTo(other.mName);
    }

    public void enableCheckerBoardBackground(boolean enable) {
        this.mDrawCheckerBoardBackground = enable;
    }
}

