/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.VariableDefinitionEntry;

public abstract class PermissionRequirement {
    public static final String ATTR_PROTECTION_LEVEL = "protectionLevel";
    public static final String VALUE_DANGEROUS = "dangerous";
    protected final JavaParser.ResolvedAnnotation annotation;
    private int firstApi;
    private int lastApi;
    public static final PermissionRequirement NONE = new PermissionRequirement(null){

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return true;
        }

        @Override
        public boolean appliesTo(PermissionHolder available) {
            return false;
        }

        @Override
        public boolean isConditional() {
            return false;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return false;
        }

        public String toString() {
            return "None";
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> result) {
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
        }

        @Override
        public BinaryOperator getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }
    };
    static final String[] REVOCABLE_PERMISSION_NAMES = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS", "android.permission.CALL_PHONE", "android.permission.CAMERA", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CELL_BROADCASTS", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE", "android.permission.READ_PROFILE", "android.permission.READ_SMS", "android.permission.READ_SOCIAL_STREAM", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.SEND_SMS", "android.permission.USE_FINGERPRINT", "android.permission.USE_SIP", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WRITE_SETTINGS", "android.permission.WRITE_PROFILE", "android.permission.WRITE_SOCIAL_STREAM", "com.android.voicemail.permission.ADD_VOICEMAIL"};

    private PermissionRequirement(JavaParser.ResolvedAnnotation annotation) {
        this.annotation = annotation;
    }

    public static PermissionRequirement create(Context context, JavaParser.ResolvedAnnotation annotation) {
        String[] allOf;
        String value = (String)annotation.getValue("value");
        if (value != null && !value.isEmpty()) {
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char c = value.charAt(i);
                if (c != '&' && c != '|' && c != '^') continue;
                return Complex.parse(annotation, context, value);
            }
            return new Single(annotation, value);
        }
        Object v = annotation.getValue("anyOf");
        String[] anyOf = PermissionRequirement.getAnnotationStrings(v);
        if (anyOf != null) {
            if (anyOf.length > 1) {
                return new Many(annotation, BinaryOperator.LOGICAL_OR, anyOf);
            }
            if (anyOf.length == 1) {
                return new Single(annotation, anyOf[0]);
            }
        }
        if ((allOf = PermissionRequirement.getAnnotationStrings(v = annotation.getValue("allOf"))) != null) {
            if (allOf.length > 1) {
                return new Many(annotation, BinaryOperator.LOGICAL_AND, allOf);
            }
            if (allOf.length == 1) {
                return new Single(annotation, allOf[0]);
            }
        }
        return NONE;
    }

    private static String[] getAnnotationStrings(Object v) {
        if (v != null) {
            if (v instanceof String[]) {
                return (String[])v;
            }
            if (v instanceof String) {
                return new String[]{(String)v};
            }
            if (v instanceof Object[]) {
                ArrayList strings = Lists.newArrayList();
                for (Object o : (Object[])v) {
                    if (o instanceof JavaParser.ResolvedField) {
                        Object vs = ((JavaParser.ResolvedField)o).getValue();
                        if (!(vs instanceof String)) continue;
                        strings.add((String)vs);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    strings.add((String)o);
                }
                return strings.toArray(new String[strings.size()]);
            }
        }
        return null;
    }

    protected boolean appliesTo(PermissionHolder available) {
        if (this.firstApi == 0) {
            String range;
            int index;
            this.firstApi = -1;
            Object o = this.annotation.getValue("apis");
            if (o instanceof String && (index = (range = (String)o).indexOf("..")) != -1) {
                try {
                    this.firstApi = index > 0 ? Integer.parseInt(range.substring(0, index)) : 1;
                    this.lastApi = index + 2 < range.length() ? Integer.parseInt(range.substring(index + 2)) : Integer.MAX_VALUE;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        if (this.firstApi != -1) {
            AndroidVersion minSdkVersion = available.getMinSdkVersion();
            if (minSdkVersion.getFeatureLevel() > this.lastApi) {
                return false;
            }
            AndroidVersion targetSdkVersion = available.getTargetSdkVersion();
            if (targetSdkVersion.getFeatureLevel() < this.firstApi) {
                return false;
            }
        }
        return true;
    }

    public boolean isConditional() {
        Object o = this.annotation.getValue("conditional");
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof JavaParser.ResolvedField && (o = ((JavaParser.ResolvedField)o).getValue()) instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public boolean isSingle() {
        return true;
    }

    public abstract boolean isSatisfied(PermissionHolder var1);

    public String describeMissingPermissions(PermissionHolder available) {
        return "";
    }

    public Set<String> getMissingPermissions(PermissionHolder available) {
        HashSet result = Sets.newHashSet();
        this.addMissingPermissions(available, result);
        return result;
    }

    protected abstract void addMissingPermissions(PermissionHolder var1, Set<String> var2);

    public Set<String> getRevocablePermissions(PermissionHolder revocable) {
        HashSet result = Sets.newHashSet();
        this.addRevocablePermissions(result, revocable);
        return result;
    }

    protected abstract void addRevocablePermissions(Set<String> var1, PermissionHolder var2);

    public abstract boolean isRevocable(PermissionHolder var1);

    public abstract BinaryOperator getOperator();

    public abstract Iterable<PermissionRequirement> getChildren();

    protected static void appendOperator(StringBuilder sb, BinaryOperator operator) {
        sb.append(' ');
        if (operator == BinaryOperator.LOGICAL_AND) {
            sb.append("and");
        } else if (operator == BinaryOperator.LOGICAL_OR) {
            sb.append("or");
        } else {
            assert (operator == BinaryOperator.BITWISE_XOR) : operator;
            sb.append("xor");
        }
        sb.append(' ');
    }

    public static boolean isRevocableSystemPermission(String name) {
        return Arrays.binarySearch(REVOCABLE_PERMISSION_NAMES, name) >= 0;
    }

    private static class Complex
    extends PermissionRequirement {
        public final BinaryOperator operator;
        public final PermissionRequirement left;
        public final PermissionRequirement right;

        public Complex(JavaParser.ResolvedAnnotation annotation, BinaryOperator operator, PermissionRequirement left, PermissionRequirement right) {
            super(annotation);
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            boolean needsParentheses;
            StringBuilder sb = new StringBuilder();
            boolean bl = needsParentheses = this.left instanceof Complex && ((Complex)this.left).operator != BinaryOperator.LOGICAL_AND;
            if (needsParentheses) {
                sb.append('(');
            }
            sb.append(this.left.toString());
            if (needsParentheses) {
                sb.append(')');
            }
            Complex.appendOperator(sb, this.operator);
            boolean bl2 = needsParentheses = this.right instanceof Complex && ((Complex)this.right).operator != BinaryOperator.LOGICAL_AND;
            if (needsParentheses) {
                sb.append('(');
            }
            sb.append(this.right.toString());
            if (needsParentheses) {
                sb.append(')');
            }
            return sb.toString();
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            boolean satisfiedRight;
            boolean satisfiedLeft = this.left.isSatisfied(available) || !this.left.appliesTo(available);
            boolean bl = satisfiedRight = this.right.isSatisfied(available) || !this.right.appliesTo(available);
            if (this.operator == BinaryOperator.LOGICAL_AND) {
                return satisfiedLeft && satisfiedRight;
            }
            if (this.operator == BinaryOperator.LOGICAL_OR) {
                return satisfiedLeft || satisfiedRight;
            }
            assert (this.operator == BinaryOperator.BITWISE_XOR) : this.operator;
            return satisfiedLeft ^ satisfiedRight;
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            boolean satisfiedLeft = this.left.isSatisfied(available);
            boolean satisfiedRight = this.right.isSatisfied(available);
            if (this.operator == BinaryOperator.LOGICAL_AND || this.operator == BinaryOperator.LOGICAL_OR) {
                if (satisfiedLeft) {
                    if (satisfiedRight) {
                        return "";
                    }
                    return this.right.describeMissingPermissions(available);
                }
                if (satisfiedRight) {
                    return this.left.describeMissingPermissions(available);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.left.describeMissingPermissions(available));
                Complex.appendOperator(sb, this.operator);
                sb.append(this.right.describeMissingPermissions(available));
                return sb.toString();
            }
            assert (this.operator == BinaryOperator.BITWISE_XOR) : this.operator;
            return this.toString();
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            boolean satisfiedLeft = this.left.isSatisfied(available);
            boolean satisfiedRight = this.right.isSatisfied(available);
            if (this.operator == BinaryOperator.LOGICAL_AND || this.operator == BinaryOperator.LOGICAL_OR) {
                if (satisfiedLeft) {
                    if (satisfiedRight) {
                        return;
                    }
                    this.right.addMissingPermissions(available, missing);
                } else if (satisfiedRight) {
                    this.left.addMissingPermissions(available, missing);
                } else {
                    this.left.addMissingPermissions(available, missing);
                    this.right.addMissingPermissions(available, missing);
                }
            } else {
                assert (this.operator == BinaryOperator.BITWISE_XOR) : this.operator;
                this.left.addMissingPermissions(available, missing);
                this.right.addMissingPermissions(available, missing);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
            this.left.addRevocablePermissions(result, revocable);
            this.right.addRevocablePermissions(result, revocable);
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return this.left.isRevocable(revocable) || this.right.isRevocable(revocable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PermissionRequirement parse(JavaParser.ResolvedAnnotation annotation, Context context, final String value) {
            if (context == null) {
                return NONE;
            }
            JavaParser javaParser = context.getClient().getJavaParser(null);
            if (javaParser == null) {
                return NONE;
            }
            try {
                JavaContext javaContext = new JavaContext(context.getDriver(), context.getProject(), context.getMainProject(), context.file, javaParser){

                    public String getContents() {
                        return "class Test { void test() {\nboolean result=" + value + ";\n}\n}";
                    }
                };
                Node node = javaParser.parseJava(javaContext);
                if (node != null) {
                    final AtomicReference reference = new AtomicReference();
                    node.accept((AstVisitor)new ForwardingAstVisitor(){

                        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
                            reference.set(node.astInitializer());
                            return true;
                        }
                    });
                    Expression expression = (Expression)reference.get();
                    if (expression != null) {
                        PermissionRequirement permissionRequirement = Complex.parse(annotation, expression);
                        return permissionRequirement;
                    }
                }
                PermissionRequirement permissionRequirement = NONE;
                return permissionRequirement;
            }
            finally {
                javaParser.dispose();
            }
        }

        private static PermissionRequirement parse(JavaParser.ResolvedAnnotation annotation, Expression expression) {
            BinaryExpression binaryExpression;
            BinaryOperator operator;
            if (expression instanceof Select) {
                return new Single(annotation, expression.toString());
            }
            if (expression instanceof BinaryExpression && ((operator = (binaryExpression = (BinaryExpression)expression).astOperator()) == BinaryOperator.LOGICAL_AND || operator == BinaryOperator.LOGICAL_OR || operator == BinaryOperator.BITWISE_XOR)) {
                PermissionRequirement left = Complex.parse(annotation, binaryExpression.astLeft());
                PermissionRequirement right = Complex.parse(annotation, binaryExpression.astRight());
                return new Complex(annotation, operator, left, right);
            }
            return NONE;
        }

        @Override
        public BinaryOperator getOperator() {
            return this.operator;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Arrays.asList(this.left, this.right);
        }
    }

    private static class Many
    extends PermissionRequirement {
        public final BinaryOperator operator;
        public final List<PermissionRequirement> permissions;

        public Many(JavaParser.ResolvedAnnotation annotation, BinaryOperator operator, String[] names) {
            super(annotation);
            assert (operator == BinaryOperator.LOGICAL_OR || operator == BinaryOperator.LOGICAL_AND) : operator;
            assert (names.length >= 2);
            this.operator = operator;
            this.permissions = Lists.newArrayListWithExpectedSize((int)names.length);
            for (String name : names) {
                this.permissions.add(new Single(annotation, name));
            }
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.permissions.get(0));
            for (int i = 1; i < this.permissions.size(); ++i) {
                Many.appendOperator(sb, this.operator);
                sb.append(this.permissions.get(i));
            }
            return sb.toString();
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            if (this.operator == BinaryOperator.LOGICAL_AND) {
                for (PermissionRequirement requirement : this.permissions) {
                    if (requirement.isSatisfied(available) || !requirement.appliesTo(available)) continue;
                    return false;
                }
                return true;
            }
            assert (this.operator == BinaryOperator.LOGICAL_OR) : this.operator;
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isSatisfied(available) && requirement.appliesTo(available)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                if (first) {
                    first = false;
                } else {
                    Many.appendOperator(sb, this.operator);
                }
                sb.append(requirement.describeMissingPermissions(available));
            }
            return sb.toString();
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                requirement.addMissingPermissions(available, missing);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                requirement.addRevocablePermissions(result, revocable);
            }
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isRevocable(revocable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public BinaryOperator getOperator() {
            return this.operator;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return this.permissions;
        }
    }

    private static class Single
    extends PermissionRequirement {
        public final String name;

        public Single(JavaParser.ResolvedAnnotation annotation, String name) {
            super(annotation);
            this.name = name;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return revocable.isRevocable(this.name) || Single.isRevocableSystemPermission(this.name);
        }

        @Override
        public BinaryOperator getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return available.hasPermission(this.name) || !this.appliesTo(available);
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            return this.isSatisfied(available) ? "" : this.name;
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            if (!this.isSatisfied(available)) {
                missing.add(this.name);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
            if (this.isRevocable(revocable)) {
                result.add(this.name);
            }
        }
    }
}

