/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import java.util.ArrayDeque;
import org.jspecify.nullness.Nullable;

public class HierarchyBinder {
    private final TurbineLog.TurbineLogWithSource log;
    private final ClassSymbol origin;
    private final PackageSourceBoundClass base;
    private final Env<ClassSymbol, ? extends HeaderBoundClass> env;

    public static SourceHeaderBoundClass bind(TurbineLog.TurbineLogWithSource log, ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        return new HierarchyBinder(log, origin, base, env).bind();
    }

    private HierarchyBinder(TurbineLog.TurbineLogWithSource log, ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        this.log = log;
        this.origin = origin;
        this.base = base;
        this.env = env;
    }

    private SourceHeaderBoundClass bind() {
        ClassSymbol superclass;
        Tree.TyDecl decl = this.base.decl();
        if (decl.xtnds().isPresent()) {
            superclass = this.resolveClass(decl.xtnds().get());
            if (this.origin.equals(superclass)) {
                this.log.error(decl.xtnds().get().position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, this.origin);
            }
        } else {
            switch (decl.tykind()) {
                case ENUM: {
                    superclass = ClassSymbol.ENUM;
                    break;
                }
                case INTERFACE: 
                case ANNOTATION: 
                case CLASS: {
                    superclass = !this.origin.equals(ClassSymbol.OBJECT) ? ClassSymbol.OBJECT : null;
                    break;
                }
                case RECORD: {
                    superclass = ClassSymbol.RECORD;
                    break;
                }
                default: {
                    throw new AssertionError((Object)decl.tykind());
                }
            }
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (!decl.impls().isEmpty()) {
            for (Tree.ClassTy i : decl.impls()) {
                ClassSymbol result = this.resolveClass(i);
                if (result == null) continue;
                if (this.origin.equals(result)) {
                    this.log.error(i.position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, this.origin);
                }
                interfaces.add((Object)result);
            }
        } else if (decl.tykind() == TurbineTyKind.ANNOTATION) {
            interfaces.add((Object)ClassSymbol.ANNOTATION);
        }
        ImmutableMap.Builder typeParameters = ImmutableMap.builder();
        for (Tree.TyParam p : decl.typarams()) {
            typeParameters.put((Object)p.name().value(), (Object)new TyVarSymbol(this.origin, p.name().value()));
        }
        return new SourceHeaderBoundClass(this.base, superclass, (ImmutableList<ClassSymbol>)interfaces.build(), (ImmutableMap<String, TyVarSymbol>)typeParameters.buildOrThrow());
    }

    private @Nullable ClassSymbol resolveClass(Tree.ClassTy ty) {
        Tree.Ident bit;
        ArrayDeque<Tree.Ident> flat = new ArrayDeque<Tree.Ident>();
        Tree.ClassTy curr = ty;
        while (curr != null) {
            flat.addFirst(curr.name());
            curr = curr.base().orElse(null);
        }
        LookupResult result = this.lookup(ty, new LookupKey((ImmutableList<Tree.Ident>)ImmutableList.copyOf(flat)));
        if (result == null) {
            this.log.error(ty.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, Joiner.on((char)'.').join(flat));
            return null;
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        UnmodifiableIterator unmodifiableIterator = result.remaining().iterator();
        while (unmodifiableIterator.hasNext() && (sym = this.resolveNext(ty, sym, bit = (Tree.Ident)unmodifiableIterator.next())) != null) {
        }
        return sym;
    }

    private @Nullable ClassSymbol resolveNext(Tree.ClassTy ty, ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next;
        try {
            next = Resolve.resolve(this.env, this.origin, sym, bit);
        }
        catch (LazyEnv.LazyBindingError e) {
            this.log.error(ty.position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, e.getMessage());
            return null;
        }
        if (next == null) {
            this.log.error(bit.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + '$' + bit));
        }
        return next;
    }

    private @Nullable LookupResult lookup(Tree tree, LookupKey lookup) {
        ClassSymbol curr = this.base.owner();
        while (curr != null) {
            ClassSymbol result;
            try {
                result = Resolve.resolve(this.env, this.origin, curr, lookup.first());
            }
            catch (LazyEnv.LazyBindingError e) {
                this.log.error(tree.position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, e.getMessage());
                result = null;
            }
            if (result != null) {
                return new LookupResult(result, lookup);
            }
            curr = this.env.getNonNull(curr).owner();
        }
        return this.base.scope().lookup(lookup, Resolve.resolveFunction(this.env, this.origin));
    }
}

