/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.type.Type;
import com.google.turbine.types.Canonicalize;
import java.util.Map;
import java.util.Objects;

public final class CanonicalTypeBinder {
    static SourceTypeBoundClass bind(ClassSymbol sym, SourceTypeBoundClass base, Env<ClassSymbol, TypeBoundClass> env) {
        Type superClassType = base.superClassType();
        int pos = base.decl().position();
        if (superClassType != null && superClassType.tyKind() == Type.TyKind.CLASS_TY) {
            superClassType = Canonicalize.canonicalizeClassTy(base.source(), pos, env, base.owner(), (Type.ClassTy)superClassType);
        }
        ImmutableList.Builder interfaceTypes = ImmutableList.builder();
        for (Type i : base.interfaceTypes()) {
            if (i.tyKind() == Type.TyKind.CLASS_TY) {
                i = Canonicalize.canonicalizeClassTy(base.source(), pos, env, base.owner(), (Type.ClassTy)i);
            }
            interfaceTypes.add((Object)i);
        }
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typParamTypes = CanonicalTypeBinder.typeParameters(base.source(), pos, env, sym, base.typeParameterTypes());
        ImmutableList<TypeBoundClass.RecordComponentInfo> components = CanonicalTypeBinder.components(base.source(), env, sym, pos, base.components());
        ImmutableList<TypeBoundClass.MethodInfo> methods = CanonicalTypeBinder.methods(base.source(), pos, env, sym, base.methods());
        ImmutableList<TypeBoundClass.FieldInfo> fields = CanonicalTypeBinder.fields(base.source(), env, sym, base.fields());
        return new SourceTypeBoundClass((ImmutableList<Type>)interfaceTypes.build(), base.permits(), superClassType, typParamTypes, base.access(), components, methods, fields, base.owner(), base.kind(), base.children(), base.typeParameters(), base.enclosingScope(), base.scope(), base.memberImports(), base.annotationMetadata(), base.annotations(), base.source(), base.decl());
    }

    private static ImmutableList<TypeBoundClass.FieldInfo> fields(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.FieldInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo base : fields) {
            result.add((Object)new TypeBoundClass.FieldInfo(base.sym(), Canonicalize.canonicalize(source, Objects.requireNonNull(base.decl()).position(), env, sym, base.type()), base.access(), base.annotations(), base.decl(), base.value()));
        }
        return result.build();
    }

    private static ImmutableList<TypeBoundClass.MethodInfo> methods(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.MethodInfo> methods) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.MethodInfo base : methods) {
            int pos = base.decl() != null ? base.decl().position() : position;
            ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tps = CanonicalTypeBinder.typeParameters(source, pos, env, sym, base.tyParams());
            Type ret = Canonicalize.canonicalize(source, pos, env, sym, base.returnType());
            ImmutableList<TypeBoundClass.ParamInfo> parameters = CanonicalTypeBinder.parameters(source, env, sym, pos, base.parameters());
            ImmutableList<Type> exceptions = CanonicalTypeBinder.canonicalizeList(source, pos, env, sym, base.exceptions());
            result.add((Object)new TypeBoundClass.MethodInfo(base.sym(), tps, ret, parameters, exceptions, base.access(), base.defaultValue(), base.decl(), base.annotations(), base.receiver() != null ? CanonicalTypeBinder.param(source, pos, env, sym, base.receiver()) : null));
        }
        return result.build();
    }

    private static ImmutableList<TypeBoundClass.ParamInfo> parameters(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, int pos, ImmutableList<TypeBoundClass.ParamInfo> parameters) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo parameter : parameters) {
            result.add((Object)CanonicalTypeBinder.param(source, pos, env, sym, parameter));
        }
        return result.build();
    }

    private static TypeBoundClass.ParamInfo param(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, TypeBoundClass.ParamInfo base) {
        return new TypeBoundClass.ParamInfo(base.sym(), Canonicalize.canonicalize(source, position, env, sym, base.type()), base.annotations(), base.access());
    }

    private static ImmutableList<TypeBoundClass.RecordComponentInfo> components(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, int pos, ImmutableList<TypeBoundClass.RecordComponentInfo> components) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.RecordComponentInfo component : components) {
            result.add((Object)new TypeBoundClass.RecordComponentInfo(component.sym(), Canonicalize.canonicalize(source, pos, env, sym, component.type()), component.annotations(), component.access()));
        }
        return result.build();
    }

    private static ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameters(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tps) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<TyVarSymbol, TypeBoundClass.TyVarInfo> e : tps.entrySet()) {
            TypeBoundClass.TyVarInfo info = e.getValue();
            Type.IntersectionTy upperBound = (Type.IntersectionTy)Canonicalize.canonicalize(source, position, env, sym, info.upperBound());
            result.put((Object)e.getKey(), (Object)new TypeBoundClass.TyVarInfo(upperBound, null, info.annotations()));
        }
        return result.buildOrThrow();
    }

    private static ImmutableList<Type> canonicalizeList(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)Canonicalize.canonicalize(source, position, env, sym, type));
        }
        return result.build();
    }

    private CanonicalTypeBinder() {
    }
}

