/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster.annotation;

import com.google.auto.common.AnnotationMirrors;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.refaster.annotation.RequiredAnnotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
public final class RequiredAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        this.validateElements(roundEnv.getRootElements());
        return false;
    }

    private AnnotationMirror getAnnotationMirror(Element element, TypeMirror annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue getAnnotationValue(AnnotationMirror mirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void validateElements(Iterable<? extends Element> elements) {
        for (Element element : elements) {
            this.validateElement(element);
        }
    }

    private void validateElement(final Element element) {
        TypeMirror requiredAnnotationTypeMirror = this.processingEnv.getElementUtils().getTypeElement(RequiredAnnotation.class.getName()).asType();
        for (final AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(element)) {
            AnnotationValue value;
            AnnotationMirror requiredAnnotationMirror = this.getAnnotationMirror(annotationMirror.getAnnotationType().asElement(), requiredAnnotationTypeMirror);
            if (requiredAnnotationMirror == null || (value = this.getAnnotationValue(requiredAnnotationMirror, "value")) == null) continue;
            new SimpleAnnotationValueVisitor7<Void, Void>(){

                @Override
                public Void visitType(TypeMirror t, Void p) {
                    if (RequiredAnnotationProcessor.this.getAnnotationMirror(element, t) == null) {
                        RequiredAnnotationProcessor.this.printError(element, annotationMirror, "Annotation %s on %s also requires %s", AnnotationMirrors.toString((AnnotationMirror)annotationMirror), element, t);
                    }
                    return null;
                }

                @Override
                public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                    for (AnnotationValue annotationValue : vals) {
                        this.visit(annotationValue);
                    }
                    return null;
                }
            }.visit(value);
        }
        this.validateElements(element.getEnclosedElements());
    }

    @FormatMethod
    private void printError(Element element, AnnotationMirror annotation, @FormatString String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element, annotation);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

