/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import java.util.List;

@BugPattern(name="EmptyBlockTag", summary="A block tag (@param, @return, @throws, @deprecated) has an empty description. Block tags without descriptions don't add much value for future readers of the code; consider removing the tag entirely or adding a description.", severity=BugPattern.SeverityLevel.WARNING, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s7.1.3-javadoc-block-tags", documentSuppression=false)
public final class EmptyBlockTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        this.checkForEmptyBlockTags(state);
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        this.checkForEmptyBlockTags(state);
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        this.checkForEmptyBlockTags(state);
        return Description.NO_MATCH;
    }

    private void checkForEmptyBlockTags(VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new EmptyBlockTagChecker(state).scan(path, null);
        }
    }

    private final class EmptyBlockTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private EmptyBlockTagChecker(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitParam(ParamTree paramTree, Void unused) {
            this.reportMatchIfEmpty(paramTree, paramTree.getDescription());
            return (Void)super.visitParam(paramTree, null);
        }

        @Override
        public Void visitReturn(ReturnTree returnTree, Void unused) {
            this.reportMatchIfEmpty(returnTree, returnTree.getDescription());
            return (Void)super.visitReturn(returnTree, null);
        }

        @Override
        public Void visitThrows(ThrowsTree throwsTree, Void unused) {
            this.reportMatchIfEmpty(throwsTree, throwsTree.getDescription());
            return (Void)super.visitThrows(throwsTree, null);
        }

        @Override
        public Void visitDeprecated(DeprecatedTree deprecatedTree, Void unused) {
            this.reportMatchIfEmpty(deprecatedTree, deprecatedTree.getBody());
            return (Void)super.visitDeprecated(deprecatedTree, null);
        }

        private void reportMatchIfEmpty(BlockTagTree blockTagTree, List<? extends DocTree> description) {
            if (description.isEmpty()) {
                this.state.reportMatch(EmptyBlockTag.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)(blockTagTree.getTagName().equals("deprecated") ? SuggestedFix.emptyFix() : Utils.replace(blockTagTree, "", this.state))));
            }
        }
    }
}

