/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="UnsafeLocaleUsage", summary="Possible unsafe operation related to the java.util.Locale library.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnsafeLocaleUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> LOCALE_TO_STRING = Matchers.instanceMethod().onExactClass("java.util.Locale").named("toString");
    private static final Matcher<ExpressionTree> LOCALE_CONSTRUCTOR = Matchers.constructor().forClass("java.util.Locale");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (LOCALE_TO_STRING.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Avoid using Locale.toString() since it produces a value that misleadingly looks like a locale identifier. Prefer using Locale.toLanguageTag() since it produces an IETF BCP 47-formatted string that can be deserialized back into a Locale.").addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toLanguageTag", (VisitorState)state)).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (LOCALE_CONSTRUCTOR.matches((Tree)tree, state)) {
            Description.Builder descriptionBuilder = this.buildDescription(tree).setMessage("Avoid using Locale constructors, and prefer using Locale.forLanguageTag(String) which takes in an IETF BCP 47-formatted string or a Locale Builder.");
            ImmutableList constructorArguments = ImmutableList.copyOf(tree.getArguments());
            if (constructorArguments.size() == 1) {
                ExpressionTree arg = (ExpressionTree)constructorArguments.get(0);
                String replacementArg = arg instanceof JCTree.JCLiteral ? String.format("\"%s\"", ((String)ASTHelpers.constValue((Tree)arg, String.class)).replace("_", "-")) : String.format("%s.replace(\"_\", \"-\")", state.getSourceForNode((Tree)constructorArguments.get(0)));
                descriptionBuilder.addFix((Fix)SuggestedFix.replace((Tree)tree, (String)String.format("Locale.forLanguageTag(%s)", replacementArg)));
            } else if (constructorArguments.size() == 2) {
                descriptionBuilder.addFix((Fix)SuggestedFix.replace((Tree)tree, (String)String.format("new Locale.Builder().setLanguage(%s).setRegion(%s).build()", state.getSourceForNode((Tree)constructorArguments.get(0)), state.getSourceForNode((Tree)constructorArguments.get(1)))));
            }
            return descriptionBuilder.build();
        }
        return Description.NO_MATCH;
    }
}

