/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="TryWithResourcesVariable", summary="This variable is unnecessary, the try-with-resources resource can be a reference to a final or effectively final variable", severity=BugPattern.SeverityLevel.WARNING)
public class TryWithResourcesVariable
extends BugChecker
implements BugChecker.TryTreeMatcher {
    public Description matchTry(TryTree tree, VisitorState state) {
        for (Tree tree2 : tree.getResources()) {
            VariableTree variableTree;
            ExpressionTree initializer;
            if (!(tree2 instanceof VariableTree) || !((initializer = (variableTree = (VariableTree)tree2).getInitializer()) instanceof IdentifierTree) || !ASTHelpers.isConsideredFinal((Symbol)ASTHelpers.getSymbol((Tree)initializer))) continue;
            String name = ((IdentifierTree)initializer).getName().toString();
            state.reportMatch(this.describeMatch(tree2, (Fix)SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)variableTree), state.getEndPosition((Tree)initializer), name).merge(SuggestedFixes.renameVariableUsages((VariableTree)variableTree, (String)name, (VisitorState)state)).build()));
        }
        return Description.NO_MATCH;
    }
}

