/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.stream.Stream;

@BugPattern(name="OptionalNotPresent", summary="This Optional has been confirmed to be empty at this point, so the call to `get` will throw.", severity=BugPattern.SeverityLevel.WARNING)
public final class OptionalNotPresent
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> OPTIONAL_GET = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.base.Optional").named("get"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Optional").namedAnyOf(new String[]{"get", "orElseThrow"})});
    private final ConstantExpressions constantExpressions;

    public OptionalNotPresent(ErrorProneFlags flags) {
        this.constantExpressions = ConstantExpressions.fromFlags(flags);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        new IfScanner(state).scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private final class IfScanner
    extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
        private final Multiset<ConstantExpressions.ConstantExpression> truths;
        private final Multiset<ConstantExpressions.ConstantExpression> falsehoods;
        private final VisitorState state;

        private IfScanner(VisitorState state) {
            super((BugChecker)OptionalNotPresent.this);
            this.truths = HashMultiset.create();
            this.falsehoods = HashMultiset.create();
            this.state = state;
        }

        public Void visitIf(IfTree tree, Void unused) {
            ConstantExpressions.Truthiness truthiness = OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), false, this.state);
            this.withinScope(truthiness, tree.getThenStatement());
            this.withinScope(OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), true, this.state), tree.getElseStatement());
            return null;
        }

        private void withinScope(ConstantExpressions.Truthiness truthiness, Tree tree) {
            this.truths.addAll(truthiness.requiredTrue());
            this.falsehoods.addAll(truthiness.requiredFalse());
            this.scan(tree, null);
            Multisets.removeOccurrences(this.truths, truthiness.requiredTrue());
            Multisets.removeOccurrences(this.falsehoods, truthiness.requiredFalse());
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ExpressionTree receiver;
            if (OPTIONAL_GET.matches((Tree)tree, this.state) && (receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) != null) {
                OptionalNotPresent.this.constantExpressions.constantExpression(receiver, this.state).ifPresent(o -> this.checkForEmptiness(tree, (ConstantExpressions.ConstantExpression)o));
            }
            return (Void)super.visitMethodInvocation(tree, null);
        }

        private void checkForEmptiness(MethodInvocationTree tree, ConstantExpressions.ConstantExpression constantExpression) {
            block3: {
                block2: {
                    if (this.getMethodInvocations(this.truths).filter(truth -> truth.symbol() instanceof Symbol.MethodSymbol && truth.symbol().getSimpleName().contentEquals("isEmpty")).flatMap(truth -> truth.receiver().stream()).anyMatch(constantExpression::equals)) break block2;
                    if (!this.getMethodInvocations(this.falsehoods).filter(truth -> truth.symbol() instanceof Symbol.MethodSymbol && truth.symbol().getSimpleName().contentEquals("isPresent")).flatMap(truth -> truth.receiver().stream()).anyMatch(constantExpression::equals)) break block3;
                }
                this.state.reportMatch(OptionalNotPresent.this.describeMatch(tree));
            }
        }

        private Stream<ConstantExpressions.PureMethodInvocation> getMethodInvocations(Multiset<ConstantExpressions.ConstantExpression> truths) {
            return truths.stream().filter(truth -> truth.kind().equals((Object)ConstantExpressions.ConstantExpression.ConstantExpressionKind.PURE_METHOD)).map(ConstantExpressions.ConstantExpression::pureMethod);
        }
    }
}

