/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@BugPattern(name="LongLiteralLowerCaseSuffix", summary="Prefer 'L' to 'l' for the suffix to long literals", severity=BugPattern.SeverityLevel.ERROR)
public class LongLiteralLowerCaseSuffix
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final com.google.errorprone.matchers.Matcher<LiteralTree> matcher = new com.google.errorprone.matchers.Matcher<LiteralTree>(){

        public boolean matches(LiteralTree literalTree, VisitorState state) {
            if (literalTree.getKind() == Tree.Kind.LONG_LITERAL) {
                String longLiteral = LongLiteralLowerCaseSuffix.getLongLiteral(literalTree, state);
                return longLiteral != null && longLiteral.endsWith("l");
            }
            return false;
        }
    };
    private static final Pattern LONG_LITERAL_PATTERN = Pattern.compile("-? *(0[bBxX]?)?[0-9a-fA-F_]+[lL]?");

    @Nullable
    private static String getLongLiteral(LiteralTree literalTree, VisitorState state) {
        JCTree.JCLiteral longLiteral = (JCTree.JCLiteral)literalTree;
        CharSequence sourceFile = state.getSourceCode();
        if (sourceFile == null) {
            return null;
        }
        int start = longLiteral.getStartPosition();
        Matcher matcher = LONG_LITERAL_PATTERN.matcher(sourceFile.subSequence(start, sourceFile.length()));
        if (matcher.lookingAt()) {
            return matcher.group();
        }
        return null;
    }

    public Description matchLiteral(LiteralTree literalTree, VisitorState state) {
        if (!matcher.matches((Tree)literalTree, state)) {
            return Description.NO_MATCH;
        }
        StringBuilder longLiteral = new StringBuilder(LongLiteralLowerCaseSuffix.getLongLiteral(literalTree, state));
        longLiteral.setCharAt(longLiteral.length() - 1, 'L');
        SuggestedFix fix = SuggestedFix.replace((Tree)literalTree, (String)longLiteral.toString());
        return this.describeMatch(literalTree, (Fix)fix);
    }
}

