/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="CharacterGetNumericValue", summary="getNumericValue has unexpected behaviour: it interprets A-Z as base-36 digits with values 10-35, but also supports non-arabic numerals and miscellaneous numeric unicode characters like \u32b7; consider using Character.digit or UCharacter.getUnicodeNumericValue instead", severity=BugPattern.SeverityLevel.WARNING)
public class CharacterGetNumericValue
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> GET_NUMERIC_VALUE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.ibm.icu.lang.UCharacter").named("getNumericValue"), Matchers.staticMethod().onClass("java.lang.Character").named("getNumericValue")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return GET_NUMERIC_VALUE.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

