/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(name="BugPatternNaming", summary="Giving BugPatterns a name different to the enclosing class can be confusing", severity=BugPattern.SeverityLevel.WARNING)
public final class BugPatternNaming
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)tree), (Type)state.getTypeFromString(BugChecker.class.getName()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        Attribute.Compound attribute = classSymbol.attribute(state.getSymbolFromString(BugPattern.class.getName()));
        if (attribute == null) {
            return Description.NO_MATCH;
        }
        return MoreAnnotations.getValue((Attribute.Compound)attribute, (String)"name").flatMap(MoreAnnotations::asStringValue).filter(name -> !name.isEmpty()).flatMap(name -> {
            if (!classSymbol.name.contentEquals((CharSequence)name)) {
                return Optional.of(this.describeMatch(tree));
            }
            return this.removeName(tree, state);
        }).orElse(Description.NO_MATCH);
    }

    private Optional<Description> removeName(ClassTree tree, VisitorState state) {
        return tree.getModifiers().getAnnotations().stream().filter(anno -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)anno.getAnnotationType()), (Type)state.getTypeFromString(BugPattern.class.getName()), (VisitorState)state)).findFirst().flatMap(anno -> anno.getArguments().stream().filter(t -> t instanceof AssignmentTree && ((IdentifierTree)((AssignmentTree)t).getVariable()).getName().contentEquals("name")).findFirst().map(ele -> this.buildDescription((Tree)anno).setMessage("Setting @BugPattern.name to the class name of the check is redundant").addFix((Fix)SuggestedFixes.removeElement((ExpressionTree)ele, anno.getArguments(), (VisitorState)state)).build()));
    }
}

