/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String CRV_CONSTRUCTOR_FLAG = "CheckConstructorReturnValue";
    private final Supplier<Matcher<ExpressionTree>> methodInvocationMatcher = Suppliers.memoize(() -> Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{AbstractReturnValueIgnored::isVoidReturningLambdaExpression, Matchers.kindIs((Tree.Kind)Tree.Kind.EXPRESSION_STATEMENT)})), Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), this.specializedMatcher(), Matchers.not(AbstractReturnValueIgnored::mockitoInvocation), Matchers.not((Matcher & Serializable)(t, s) -> this.allowInExceptionThrowers() && AbstractReturnValueIgnored.expectedExceptionTest(t, s))}));
    private final Supplier<Matcher<MemberReferenceTree>> memberReferenceTreeMatcher = Suppliers.memoize(() -> Matchers.allOf((Matcher[])new Matcher[]{this::isValidMemberReferenceType, AbstractReturnValueIgnored::isVoidReturningMethodReferenceExpression, Matchers.not((Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.isVoidReturningMethod(ASTHelpers.getSymbol((MemberReferenceTree)t), s)), Matchers.not((Matcher & Serializable)(t, s) -> this.allowInExceptionThrowers() && Matchers.isThrowingFunctionalInterface((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), this.specializedMatcher()}));
    private final Supplier<Matcher<MemberReferenceTree>> lostReferenceTreeMatcher = Suppliers.memoize(() -> Matchers.allOf((Matcher[])new Matcher[]{this::isValidMemberReferenceType, AbstractReturnValueIgnored::isObjectReturningMethodReferenceExpression, Matchers.not((Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.getType((Tree)t), s)), Matchers.not((Matcher & Serializable)(t, s) -> Matchers.isThrowingFunctionalInterface((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), this.specializedMatcher()}));
    private final boolean checkConstructors;
    private static final Matcher<ExpressionTree> FAIL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.AbstractVerb").named("fail"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("fail"), MethodMatchers.staticMethod().onClass("org.junit.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("fail")});
    private static final Matcher<StatementTree> EXPECTED_EXCEPTION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.previousStatement((Matcher)Matchers.expressionStatement((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException")})))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.TRY)), Matchers.nextStatement((Matcher)Matchers.expressionStatement(FAIL_METHOD))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.LAMBDA_EXPRESSION))}), (Matcher & Serializable)(t, s) -> Matchers.methodCallInDeclarationOfThrowingRunnable((VisitorState)s)})});
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.InOrder").named("verify")});
    private static final ImmutableSet<String> EXEMPTED_TYPES = ImmutableSet.of((Object)"org.mockito.stubbing.Answer", (Object)"graphql.schema.DataFetcher", (Object)"org.jmock.lib.action.CustomAction", (Object)"net.sf.cglib.proxy.MethodInterceptor", (Object)"org.aopalliance.intercept.MethodInterceptor", (Object)InvocationHandler.class.getName(), (Object[])new String[0]);

    protected AbstractReturnValueIgnored() {
        this(ErrorProneFlags.empty());
    }

    protected AbstractReturnValueIgnored(ErrorProneFlags flags) {
        this.checkConstructors = flags.getBoolean(CRV_CONSTRUCTOR_FLAG).orElse(false);
    }

    private boolean isValidMemberReferenceType(MemberReferenceTree mrt, VisitorState state) {
        return this.checkConstructors || mrt.getMode() == MemberReferenceTree.ReferenceMode.INVOKE;
    }

    private static boolean isVoidReturningMethod(Symbol.MethodSymbol meth, VisitorState state) {
        return !meth.isConstructor() && ASTHelpers.isVoidType((Type)meth.getReturnType(), (VisitorState)state);
    }

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description description;
        Description description2 = description = this.methodInvocationMatcher.get().matches((Tree)methodInvocationTree, state) ? this.describeReturnValueIgnored(methodInvocationTree, state) : Description.NO_MATCH;
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        return this.checkLostType(methodInvocationTree, state);
    }

    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        return this.checkConstructors && this.methodInvocationMatcher.get().matches((Tree)newClassTree, state) ? this.describeReturnValueIgnored(newClassTree, state) : Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description;
        Description description2 = description = this.memberReferenceTreeMatcher.get().matches((Tree)tree, state) ? this.describeReturnValueIgnored(tree, state) : Description.NO_MATCH;
        if (!this.lostType(state).isPresent() || !description.equals(Description.NO_MATCH)) {
            return description;
        }
        if (this.lostReferenceTreeMatcher.get().matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return description;
    }

    private static boolean isVoidReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return AbstractReturnValueIgnored.functionalInterfaceReturnsExactlyVoid(ASTHelpers.getType((Tree)tree), state);
    }

    private static boolean isVoidReturningLambdaExpression(Tree tree, VisitorState state) {
        return tree instanceof LambdaExpressionTree && AbstractReturnValueIgnored.functionalInterfaceReturnsExactlyVoid(ASTHelpers.getType((Tree)tree), state);
    }

    private static boolean functionalInterfaceReturnsExactlyVoid(Type interfaceType, VisitorState state) {
        return state.getTypes().findDescriptorType(interfaceType).getReturnType().getKind() == TypeKind.VOID;
    }

    protected abstract Matcher<? super ExpressionTree> specializedMatcher();

    protected Optional<Type> lostType(VisitorState state) {
        return Optional.empty();
    }

    protected String lostTypeMessage(String returnedType, String declaredReturnType) {
        return String.format("Returning %s from method that returns %s.", returnedType, declaredReturnType);
    }

    protected boolean allowInExceptionThrowers() {
        return true;
    }

    protected Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree identifierExpr = ASTHelpers.getRootAssignable((MethodInvocationTree)methodInvocationTree);
        Type identifierType = null;
        if (identifierExpr != null) {
            if (identifierExpr instanceof JCTree.JCIdent) {
                identifierType = ((JCTree.JCIdent)identifierExpr).sym.type;
            } else if (identifierExpr instanceof JCTree.JCFieldAccess) {
                identifierType = ((JCTree.JCFieldAccess)identifierExpr).sym.type;
            } else {
                throw new IllegalStateException("Expected a JCIdent or a JCFieldAccess");
            }
        }
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect());
        SuggestedFix fix = SuggestedFix.emptyFix();
        Symbol symbol = ASTHelpers.getSymbol((Tree)identifierExpr);
        if (identifierExpr != null && symbol != null && !symbol.name.contentEquals("this") && returnType != null && state.getTypes().isAssignable(returnType, identifierType)) {
            fix = SuggestedFix.prefixWith((Tree)methodInvocationTree, (String)(state.getSourceForNode((Tree)identifierExpr) + " = "));
        } else {
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof ExpressionStatementTree) {
                fix = SuggestedFix.delete((Tree)parent);
            }
        }
        return this.buildDescription(methodInvocationTree).addFix((Fix)fix).setMessage(this.getMessage(ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getSimpleName())).build();
    }

    protected Description describeReturnValueIgnored(MemberReferenceTree memberReferenceTree, VisitorState state) {
        return this.buildDescription(memberReferenceTree).setMessage(this.getMessage(state.getName(AbstractReturnValueIgnored.descriptiveNameForMemberReference(memberReferenceTree, state)))).build();
    }

    protected Description describeReturnValueIgnored(NewClassTree newClassTree, VisitorState state) {
        return this.buildDescription(newClassTree).setMessage(String.format("Ignored return value of '%s'", state.getSourceForNode((Tree)newClassTree.getIdentifier()))).build();
    }

    private static String descriptiveNameForMemberReference(MemberReferenceTree memberReferenceTree, VisitorState state) {
        if (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            return state.getSourceForNode((Tree)memberReferenceTree.getQualifierExpression());
        }
        return memberReferenceTree.getName().toString();
    }

    protected String getMessage(Name name) {
        return this.message();
    }

    static boolean expectedExceptionTest(Tree tree, VisitorState state) {
        StatementTree statement = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), StatementTree.class);
        return statement != null && EXPECTED_EXCEPTION_MATCHER.matches((Tree)statement, state);
    }

    static boolean mockitoInvocation(Tree tree, VisitorState state) {
        if (!(tree instanceof JCTree.JCMethodInvocation)) {
            return false;
        }
        JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)tree;
        if (!(invocation.getMethodSelect() instanceof JCTree.JCFieldAccess)) {
            return false;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)invocation);
        return MOCKITO_MATCHER.matches((Tree)receiver, state);
    }

    private Description checkLostType(MethodInvocationTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type lostType = optionalType.get();
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Type returnType = ASTHelpers.getResultType((ExpressionTree)tree);
        Type returnedFutureType = state.getTypes().asSuper(returnType, lostType.tsym);
        if (returnedFutureType != null && !returnedFutureType.hasTag(TypeTag.ERROR) && !returnedFutureType.isRaw()) {
            if (ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnedFutureType.getTypeArguments().get(0), (Types)state.getTypes()), (Type)lostType, (VisitorState)state)) {
                return this.buildDescription(tree).setMessage(String.format("Method returns a nested type, %s", returnType)).build();
            }
            Type methodReturnType = sym.getReturnType();
            List typeParameters = sym.getTypeParameters();
            HashSet<Symbol.TypeVariableSymbol> returnTypeChoosing = new HashSet<Symbol.TypeVariableSymbol>();
            for (Symbol.TypeVariableSymbol tvs : typeParameters) {
                ArrayDeque<Symbol.TypeVariableSymbol> queue = new ArrayDeque<Symbol.TypeVariableSymbol>();
                queue.add(tvs);
                while (!queue.isEmpty()) {
                    Symbol.TypeVariableSymbol currentTypeParam = (Symbol.TypeVariableSymbol)queue.remove();
                    for (Type typeParam : methodReturnType.getTypeArguments()) {
                        if (typeParam.tsym != currentTypeParam) continue;
                        returnTypeChoosing.add(tvs);
                    }
                    for (Type toAdd : currentTypeParam.getBounds()) {
                        if (!(toAdd.tsym instanceof Symbol.TypeVariableSymbol)) continue;
                        queue.add((Symbol.TypeVariableSymbol)toAdd.tsym);
                    }
                }
            }
            if (!returnTypeChoosing.isEmpty()) {
                ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> resolved = AbstractReturnValueIgnored.getResolvedGenerics(tree);
                for (Symbol.TypeVariableSymbol returnTypeChoosingSymbol : returnTypeChoosing) {
                    List types = resolved.get((Object)returnTypeChoosingSymbol);
                    for (TypeInfo type : types) {
                        if (!ASTHelpers.isSubtype((Type)type.resolvedVariableType, (Type)lostType, (VisitorState)state)) continue;
                        return this.buildDescription(type.tree).setMessage(String.format("Invocation produces a nested type - Type variable %s, as part of return type %s resolved to %s.", returnTypeChoosingSymbol, methodReturnType, type.resolvedVariableType)).build();
                    }
                }
            }
        }
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode(AbstractReturnValueIgnored::isObjectReturningLambdaExpression), Matchers.not(AbstractReturnValueIgnored::mockitoInvocation), Matchers.not(AbstractReturnValueIgnored::expectedExceptionTest)}), this.specializedMatcher(), Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s))}).matches((Tree)tree, state)) {
            return this.describeReturnValueIgnored(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> getResolvedGenerics(MethodInvocationTree tree) {
        Type type = ASTHelpers.getType((Tree)tree.getMethodSelect());
        ImmutableListMultimap subst = ASTHelpers.getTypeSubstitution((Type)type, (Symbol)ASTHelpers.getSymbol((MethodInvocationTree)tree));
        return (ListMultimap)subst.entries().stream().map(e -> new TypeInfo((Symbol.TypeVariableSymbol)e.getKey(), (Type)e.getValue(), tree)).collect(Multimaps.toMultimap(k -> k.sym, k -> k, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.linkedHashKeys().arrayListValues()).build()));
    }

    private static boolean isObjectReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(ASTHelpers.getType((Tree)tree), state);
    }

    private static boolean isObjectReturningLambdaExpression(Tree tree, VisitorState state) {
        if (!(tree instanceof LambdaExpressionTree)) {
            return false;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(type, state) && !AbstractReturnValueIgnored.isExemptedInterfaceType(type, state);
    }

    private static boolean functionalInterfaceReturnsObject(Type interfaceType, VisitorState state) {
        Type objectType = state.getSymtab().objectType;
        return ASTHelpers.isSubtype((Type)objectType, (Type)ASTHelpers.getUpperBound((Type)state.getTypes().findDescriptorType(interfaceType).getReturnType(), (Types)state.getTypes()), (VisitorState)state);
    }

    private static boolean isExemptedInterfaceType(Type type, VisitorState state) {
        return EXEMPTED_TYPES.stream().map(arg_0 -> ((VisitorState)state).getTypeFromString(arg_0)).anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)t, (VisitorState)state));
    }

    private static boolean isExemptedInterfaceMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.enclosingClass((Symbol)symbol).type, state);
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type objectType = state.getSymtab().objectType;
        Type lostType = optionalType.get();
        Type resultType = ASTHelpers.getResultType((ExpressionTree)tree.getExpression());
        if (resultType == null) {
            return Description.NO_MATCH;
        }
        if (resultType.getKind() == TypeKind.NULL || resultType.getKind() == TypeKind.NONE) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)resultType, (Type)lostType, (VisitorState)state)) {
            for (Tree enclosing : state.getPath()) {
                if (enclosing instanceof MethodTree) {
                    MethodTree methodTree = (MethodTree)enclosing;
                    Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                    if (!ASTHelpers.isSubtype((Type)objectType, (Type)symbol.getReturnType(), (VisitorState)state) || AbstractReturnValueIgnored.isExemptedInterfaceMethod(symbol, state)) break;
                    return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), symbol.getReturnType().toString())).build();
                }
                if (!(enclosing instanceof LambdaExpressionTree)) continue;
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclosing;
                if (!AbstractReturnValueIgnored.isObjectReturningLambdaExpression(lambdaTree, state)) break;
                return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), "Object")).build();
            }
        }
        return Description.NO_MATCH;
    }

    private static final class TypeInfo {
        private final Symbol.TypeVariableSymbol sym;
        private final Type resolvedVariableType;
        private final Tree tree;

        private TypeInfo(Symbol.TypeVariableSymbol sym, Type resolvedVariableType, Tree tree) {
            this.sym = sym;
            this.resolvedVariableType = resolvedVariableType;
            this.tree = tree;
        }
    }
}

