/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;

@BugPattern(name="FromTemporalAccessor", summary="Certain combinations of javaTimeType.from(TemporalAccessor) will always throw a DateTimeException or return the parameter directly.", explanation="Not all java.time types can be created via from(TemporalAccessor). For example, you can create a Month from a LocalDate (Month.from(localDate)) because a LocalDate consists of a year, month, and day. However, you cannot create a LocalDate from a Month (since it doesn't have the year or day information). Instead of throwing a DateTimeException at runtime, this checker validates the type transformations at compile time using static type information.", severity=BugPattern.SeverityLevel.ERROR)
public final class FromTemporalAccessor
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String TEMPORAL_ACCESSOR = "java.time.temporal.TemporalAccessor";
    private static final Matcher<ExpressionTree> FROM_MATCHER = Matchers.staticMethod().anyClass().named("from").withParameters("java.time.temporal.TemporalAccessor", new String[0]);
    private static final Matcher<ExpressionTree> PACKAGE_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.packageStartsWith((String)"java.time"), Matchers.packageStartsWith((String)"org.threeten.extra"), Matchers.packageStartsWith((String)"tck.java.time")});
    private static final ImmutableMap<Matcher<Tree>, Matcher<ExpressionTree>> BAD_VALUE_FROM_KEY = new ImmutableMap.Builder().put((Object)Matchers.isSameType(DayOfWeek.class), FromTemporalAccessor.makeValue(Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(Instant.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(LocalDate.class), FromTemporalAccessor.makeValue(Instant.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm")).put((Object)Matchers.isSameType(LocalDateTime.class), FromTemporalAccessor.makeValue(Instant.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName())).put((Object)Matchers.isSameType(LocalTime.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(Month.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(MonthDay.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfYear", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(OffsetDateTime.class), FromTemporalAccessor.makeValue(new String[0])).put((Object)Matchers.isSameType(OffsetTime.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(Year.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(YearMonth.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType(ZonedDateTime.class), FromTemporalAccessor.makeValue(new String[0])).put((Object)Matchers.isSameType(ZoneOffset.class), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.AmPm"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.DayOfMonth"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.DayOfYear"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.Quarter"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.YearQuarter", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.YearQuarter"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.YearWeek")).put((Object)Matchers.isSameType((String)"org.threeten.extra.YearWeek"), FromTemporalAccessor.makeValue(DayOfWeek.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "org.threeten.extra.AmPm", "org.threeten.extra.DayOfMonth", "org.threeten.extra.DayOfYear", "org.threeten.extra.Quarter", "org.threeten.extra.YearQuarter")).buildOrThrow();
    private static final Supplier<Type> JAVA_TIME_TEMPORAL_TEMPORALACCESSOR = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(TEMPORAL_ACCESSOR));

    private static Matcher<ExpressionTree> makeValue(String ... classes) {
        return Matchers.staticMethod().onClassAny(classes).named("from").withParameters(TEMPORAL_ACCESSOR, new String[0]);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FROM_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (PACKAGE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree).toString();
        if (!receiverType.startsWith("java.time") && !receiverType.startsWith("org.threeten.extra")) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg0 = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        Type type0 = ASTHelpers.getType((Tree)arg0);
        if (ASTHelpers.isSameType((Type)type0, (Type)((Type)JAVA_TIME_TEMPORAL_TEMPORALACCESSOR.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)type0, (VisitorState)state)) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            builder.replace((Tree)tree, state.getSourceForNode((Tree)arg0));
            return this.describeMatch(tree, (Fix)builder.build());
        }
        for (Map.Entry entry : BAD_VALUE_FROM_KEY.entrySet()) {
            Matcher fromMatcher = (Matcher)entry.getValue();
            Matcher argumentMatcher = (Matcher)entry.getKey();
            if (!fromMatcher.matches((Tree)tree, state) || !argumentMatcher.matches((Tree)arg0, state)) continue;
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

