/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.platform;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformProvider;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;

public class JDKPlatformProvider
implements PlatformProvider {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final Set<String> SUPPORTED_JAVA_PLATFORM_VERSIONS = new TreeSet<String>();

    @Override
    public Iterable<String> getSupportedPlatformNames() {
        return SUPPORTED_JAVA_PLATFORM_VERSIONS;
    }

    @Override
    public PlatformDescription getPlatform(String string, String string2) {
        return new PlatformDescriptionImpl(string);
    }

    private static String targetNumericVersion(Target target) {
        return Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1);
    }

    static Path findCtSym() {
        String string = System.getProperty("java.home");
        Path path = Paths.get(string, new String[0]);
        for (String string2 : symbolFileLocation) {
            path = path.resolve(string2);
        }
        return path;
    }

    static {
        Path path = JDKPlatformProvider.findCtSym();
        if (Files.exists(path, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(path, null);
                 DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fileSystem.getRootDirectories().iterator().next());){
                for (Path path2 : directoryStream) {
                    for (char c : path2.getFileName().toString().toCharArray()) {
                        String string = Character.toString(c);
                        Target target = Target.lookup(string);
                        if (target == null) continue;
                        SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(target));
                    }
                }
            }
            catch (IOException | ProviderNotFoundException exception) {
                // empty catch block
            }
        }
    }

    static class PlatformDescriptionImpl
    implements PlatformDescription {
        private final Map<Path, FileSystem> ctSym2FileSystem = new HashMap<Path, FileSystem>();
        private final String version;

        PlatformDescriptionImpl(String string) {
            this.version = string;
        }

        @Override
        public Collection<Path> getPlatformPath() {
            ArrayList<Path> arrayList;
            block30: {
                arrayList = new ArrayList<Path>();
                Path path2 = JDKPlatformProvider.findCtSym();
                if (Files.exists(path2, new LinkOption[0])) {
                    FileSystem fileSystem = this.ctSym2FileSystem.get(path2);
                    if (fileSystem == null) {
                        try {
                            fileSystem = FileSystems.newFileSystem(path2, null);
                            this.ctSym2FileSystem.put(path2, fileSystem);
                        }
                        catch (IOException iOException) {
                            throw new IllegalStateException(iOException);
                        }
                    }
                    Path path3 = fileSystem.getRootDirectories().iterator().next();
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path3);){
                        for (Path path4 : directoryStream) {
                            if (!path4.getFileName().toString().contains(this.version)) continue;
                            Path path5 = path4.resolve("system-modules");
                            if (Files.isRegularFile(path5, new LinkOption[0])) {
                                Path path6 = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", new String[0]);
                                Stream<String> stream = Files.lines(path5, Charset.forName("UTF-8"));
                                Throwable throwable = null;
                                try {
                                    stream.map(string -> path6.resolve((String)string)).filter(path -> Files.exists(path, new LinkOption[0])).forEach(path -> arrayList.add((Path)path));
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (stream == null) continue;
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    stream.close();
                                    continue;
                                }
                            }
                            arrayList.add(path4);
                        }
                        break block30;
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException);
                    }
                }
                throw new IllegalStateException("Cannot find ct.sym!");
            }
            return arrayList;
        }

        @Override
        public String getSourceVersion() {
            return this.version;
        }

        @Override
        public String getTargetVersion() {
            return this.version;
        }

        @Override
        public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
            return Collections.emptyList();
        }

        @Override
        public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getAdditionalOptions() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws IOException {
            for (FileSystem fileSystem : this.ctSym2FileSystem.values()) {
                fileSystem.close();
            }
            this.ctSym2FileSystem.clear();
        }
    }
}

