/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Transitive {
    public static ImmutableMap<String, byte[]> collectDeps(ClassPath bootClassPath, Binder.BindingResult bound) {
        ImmutableMap.Builder transitive = ImmutableMap.builder();
        for (ClassSymbol sym : Transitive.superClosure(bound)) {
            BytecodeBoundClass info = bound.classPathEnv().get(sym);
            if (info == null || bootClassPath.env().get(sym) != null) continue;
            transitive.put((Object)sym.binaryName(), (Object)ClassWriter.writeClass(Transitive.trimClass(info.classFile())));
        }
        return transitive.build();
    }

    public static ClassFile trimClass(ClassFile cf) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ClassFile.FieldInfo f : cf.fields()) {
            if (f.value() == null) continue;
            fields.add((Object)f);
        }
        ImmutableList.Builder innerClasses = ImmutableList.builder();
        for (ClassFile.InnerClass i : cf.innerClasses()) {
            if (!i.innerClass().equals(cf.name()) && !i.outerClass().equals(cf.name())) continue;
            innerClasses.add((Object)i);
        }
        return new ClassFile(cf.access(), cf.name(), cf.signature(), cf.superName(), cf.interfaces(), (cf.access() & 0x2000) == 8192 ? cf.methods() : ImmutableList.of(), (List<ClassFile.FieldInfo>)fields.build(), cf.annotations(), (List<ClassFile.InnerClass>)innerClasses.build(), cf.typeAnnotations(), null);
    }

    private static Set<ClassSymbol> superClosure(Binder.BindingResult bound) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(bound.units())).append(bound.classPathEnv());
        LinkedHashSet<ClassSymbol> closure = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : bound.units().keySet()) {
            Transitive.addSuperTypes(closure, env, sym);
        }
        LinkedHashSet directChildren = new LinkedHashSet();
        for (ClassSymbol sym : closure) {
            TypeBoundClass info = (TypeBoundClass)env.get(sym);
            if (info == null) continue;
            directChildren.addAll(info.children().values());
        }
        closure.addAll(directChildren);
        return closure;
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        if (!closure.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return;
        }
        if (info.superclass() != null) {
            Transitive.addSuperTypes(closure, env, info.superclass());
        }
        for (ClassSymbol i : info.interfaces()) {
            Transitive.addSuperTypes(closure, env, i);
        }
    }
}

