/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ClusterMergeTask
implements Runnable {
    private static final long MIN_WAIT_ON_FUTURE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private final Node node;

    ClusterMergeTask(Node node) {
        this.node = node;
    }

    @Override
    public void run() {
        LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
        lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGING);
        this.resetState();
        Collection<Runnable> tasks = this.collectMergeTasks();
        this.resetServices();
        this.rejoin();
        this.executeMergeTasks(tasks);
        if (this.node.isRunning() && this.node.joined()) {
            lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGED);
        }
    }

    private void resetState() {
        this.node.reset();
        this.node.getClusterService().reset();
        this.node.connectionManager.stop();
        this.node.nodeEngine.reset();
    }

    private Collection<Runnable> collectMergeTasks() {
        Collection<SplitBrainHandlerService> services = this.node.nodeEngine.getServices(SplitBrainHandlerService.class);
        LinkedList<Runnable> tasks = new LinkedList<Runnable>();
        for (SplitBrainHandlerService service : services) {
            Runnable runnable = service.prepareMergeRunnable();
            if (runnable == null) continue;
            tasks.add(runnable);
        }
        return tasks;
    }

    private void resetServices() {
        Collection<ManagedService> managedServices = this.node.nodeEngine.getServices(ManagedService.class);
        for (ManagedService service : managedServices) {
            service.reset();
        }
    }

    private void rejoin() {
        this.node.connectionManager.start();
        this.node.join();
    }

    private void executeMergeTasks(Collection<Runnable> tasks) {
        LinkedList futures = new LinkedList();
        for (Runnable task : tasks) {
            Future<?> f = this.node.nodeEngine.getExecutionService().submit("hz:system", task);
            futures.add(f);
        }
        long callTimeoutMillis = this.node.groupProperties.getMillis(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS);
        for (Future future : futures) {
            try {
                this.waitOnFutureInterruptible(future, callTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (HazelcastInstanceNotActiveException e) {
                EmptyStatement.ignore(e);
            }
            catch (Exception e) {
                this.node.getLogger(this.getClass()).severe("While merging...", e);
            }
        }
    }

    private <V> V waitOnFutureInterruptible(Future<V> future, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.isNotNull(timeUnit, "timeUnit");
        long deadline = Clock.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            long localTimeoutMs = Math.min(MIN_WAIT_ON_FUTURE_TIMEOUT_MILLIS, deadline);
            try {
                return future.get(localTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException t) {
                if ((deadline -= localTimeoutMs) > 0L) continue;
                throw t;
                if (this.node.isRunning()) continue;
                future.cancel(true);
                throw new HazelcastInstanceNotActiveException();
            }
            break;
        }
    }
}

