/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.client;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.options.OptionHelper;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.server.CompilationResult;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.SjavacServer;
import com.sun.tools.sjavac.server.SysInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;

public class SjavacClient
implements Sjavac {
    private final String id;
    private final PortFile portFile;
    private final String logfile;
    private final String stdouterrfile;
    private final int keepalive;
    private final int poolsize;
    private final String sjavacForkCmd;
    static int CONNECTION_TIMEOUT = 2000;
    static int MAX_CONNECT_ATTEMPTS = 3;
    static int WAIT_BETWEEN_CONNECT_ATTEMPTS = 2000;
    private final String settings;

    public SjavacClient(Options options) throws FileNotFoundException {
        String tmpServerConf = options.getServerConf();
        String serverConf = tmpServerConf != null ? tmpServerConf : "";
        String tmpId = Util.extractStringOption("id", serverConf);
        this.id = tmpId != null ? tmpId : "id" + (new Random().nextLong() & Long.MAX_VALUE);
        String defaultPortfile = options.getStateDir().resolve("javac_server").toAbsolutePath().toString();
        String portfileName = Util.extractStringOption("portfile", serverConf, defaultPortfile);
        try {
            this.portFile = SjavacServer.getPortFile(portfileName);
        }
        catch (FileNotFoundException e) {
            Log.error("Port file inaccessable: " + e);
            throw e;
        }
        this.logfile = Util.extractStringOption("logfile", serverConf, portfileName + ".javaclog");
        this.stdouterrfile = Util.extractStringOption("stdouterrfile", serverConf, portfileName + ".stdouterr");
        this.sjavacForkCmd = Util.extractStringOption("sjavac", serverConf, "sjavac");
        int poolsize = Util.extractIntOption("poolsize", serverConf);
        this.keepalive = Util.extractIntOption("keepalive", serverConf, 120);
        this.poolsize = poolsize > 0 ? poolsize : Runtime.getRuntime().availableProcessors();
        this.settings = serverConf.equals("") ? "id=" + this.id + ",portfile=" + portfileName : serverConf;
    }

    @Override
    public String serverSettings() {
        return this.settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SysInfo getSysInfo() {
        try (Socket socket = this.tryConnect();){
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            oos.writeObject(this.id);
            oos.writeObject("sys-info");
            oos.flush();
            SysInfo sysInfo = (SysInfo)ois.readObject();
            return sysInfo;
        }
        catch (IOException | ClassNotFoundException ex) {
            Log.error("[CLIENT] Exception caught: " + ex);
            Log.debug(Util.getStackTrace(ex));
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Log.error("[CLIENT] getSysInfo interrupted.");
            Log.debug(Util.getStackTrace(ie));
        }
        return null;
    }

    @Override
    public CompilationResult compile(String protocolId, String invocationId, String[] args, List<File> explicitSources, Set<URI> sourcesToCompile, Set<URI> visibleSources) {
        CompilationResult result;
        try (Socket socket = this.tryConnect();){
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            oos.writeObject(this.id);
            oos.writeObject("compile");
            oos.writeObject(protocolId);
            oos.writeObject(invocationId);
            oos.writeObject(args);
            oos.writeObject(explicitSources);
            oos.writeObject(sourcesToCompile);
            oos.writeObject(visibleSources);
            oos.flush();
            result = (CompilationResult)ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Log.error("[CLIENT] Exception caught: " + ex);
            result = new CompilationResult(-1);
            result.stderr = Util.getStackTrace(ex);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Log.error("[CLIENT] compile interrupted.");
            result = new CompilationResult(-1);
            result.stderr = Util.getStackTrace(ie);
        }
        return result;
    }

    private Socket tryConnect() throws IOException, InterruptedException {
        this.makeSureServerIsRunning(this.portFile);
        int attempt = 0;
        while (true) {
            Log.info("Trying to connect. Attempt " + ++attempt + " of " + MAX_CONNECT_ATTEMPTS);
            try {
                return this.makeConnectionAttempt();
            }
            catch (IOException ex) {
                Log.error("Connection attempt failed: " + ex.getMessage());
                if (attempt >= MAX_CONNECT_ATTEMPTS) {
                    Log.error("Giving up");
                    throw new IOException("Could not connect to server", ex);
                }
                Thread.sleep(WAIT_BETWEEN_CONNECT_ATTEMPTS);
                continue;
            }
            break;
        }
    }

    private Socket makeConnectionAttempt() throws IOException {
        Socket socket = new Socket();
        InetAddress localhost = InetAddress.getByName(null);
        InetSocketAddress address = new InetSocketAddress(localhost, this.portFile.getPort());
        socket.connect(address, CONNECTION_TIMEOUT);
        Log.info("Connected");
        return socket;
    }

    private void makeSureServerIsRunning(PortFile portFile) throws IOException, InterruptedException {
        portFile.lock();
        portFile.getValues();
        portFile.unlock();
        if (portFile.containsPortInfo()) {
            return;
        }
        SjavacClient.fork(this.sjavacForkCmd, portFile, this.logfile, this.poolsize, this.keepalive, System.err, this.stdouterrfile);
    }

    @Override
    public void shutdown() {
    }

    public static void fork(String sjavacCmd, PortFile portFile, String logfile, int poolsize, int keepalive, PrintStream err, String stdouterrfile) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(OptionHelper.unescapeCmdArg(sjavacCmd).split(" ")));
        cmd.add("--startserver:portfile=" + portFile.getFilename() + ",logfile=" + logfile + ",stdouterrfile=" + stdouterrfile + ",poolsize=" + poolsize + ",keepalive=" + keepalive);
        Process p = null;
        Log.info("Starting server. Command: " + String.join((CharSequence)" ", cmd));
        try {
            p = new ProcessBuilder(cmd).redirectErrorStream(true).redirectOutput(new File(stdouterrfile)).start();
            portFile.waitForValidValues();
        }
        catch (IOException ex) {
            Log.error("Faild to launch server.");
            Log.error("    Message: " + ex.getMessage());
            String rc = p == null || p.isAlive() ? "n/a" : "" + p.exitValue();
            Log.error("    Server process exit code: " + rc);
            Log.error("Server log:");
            Log.error("------- Server log start -------");
            try (Scanner s = new Scanner(new File(stdouterrfile));){
                while (s.hasNextLine()) {
                    Log.error(s.nextLine());
                }
            }
            Log.error("------- Server log end ---------");
            throw ex;
        }
    }
}

