/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="QualifierOnMethodWithoutProvides", category=BugPattern.Category.INJECT, summary="Qualifier applied to a method that isn't a @Provides method. This method won't be used for dependency injection", severity=BugPattern.SeverityLevel.ERROR)
public class QualifierOnMethodWithoutProvides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> QUALIFIER_ANNOTATION_FINDER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{InjectMatchers.IS_BINDING_ANNOTATION, InjectMatchers.IS_SCOPING_ANNOTATION}));
    private static final Matcher<MethodTree> NOT_ABSTRACT = Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT));
    private static final Matcher<MethodTree> NOT_PROVIDES_METHOD = Matchers.not((Matcher)InjectMatchers.hasProvidesAnnotation());

    public Description matchMethod(MethodTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult qualifierAnnotations = QUALIFIER_ANNOTATION_FINDER.multiMatchResult((Tree)tree, state);
        if (qualifierAnnotations.matches() && NOT_ABSTRACT.matches((Tree)tree, state) && NOT_PROVIDES_METHOD.matches((Tree)tree, state)) {
            if (Matchers.not((Matcher)Matchers.methodReturns((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((Supplier)Suppliers.VOID_TYPE), Matchers.isSameType((Supplier)Suppliers.JAVA_LANG_VOID_TYPE)}))).matches((Tree)tree, state)) {
                if (InjectMatchers.INSIDE_GUICE_MODULE.matches((Tree)tree, state)) {
                    SuggestedFix fix = SuggestedFix.builder().addStaticImport("com.google.inject.Provides").prefixWith((Tree)tree, "@Provides ").build();
                    return this.describeMatch(tree, (Fix)fix);
                }
                if (Matchers.enclosingClass((Matcher)InjectMatchers.IS_DAGGER_COMPONENT_OR_MODULE).matches((Tree)tree, state)) {
                    SuggestedFix fix = SuggestedFix.builder().addStaticImport("dagger.Provides").prefixWith((Tree)tree, "@Provides ").build();
                    return this.describeMatch(tree, (Fix)fix);
                }
            }
            ImmutableList matchingNodes = qualifierAnnotations.matchingNodes();
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            matchingNodes.forEach(arg_0 -> ((SuggestedFix.Builder)fixBuilder).delete(arg_0));
            return this.describeMatch((Tree)matchingNodes.get(0), (Fix)fixBuilder.build());
        }
        return Description.NO_MATCH;
    }
}

