/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ChainingCredentialsProvider
extends CredentialsProvider {
    private List<CredentialsProvider> credentialProviders;

    public ChainingCredentialsProvider(CredentialsProvider ... providers) {
        this.credentialProviders = new ArrayList<CredentialsProvider>(Arrays.asList(providers));
        for (CredentialsProvider p : providers) {
            this.credentialProviders.add(p);
        }
    }

    @Override
    public boolean isInteractive() {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.isInteractive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items)) continue;
            p.get(uri, items);
            if (this.isAnyNull(items)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyNull(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i != null) continue;
            return true;
        }
        return false;
    }
}

