/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import dagger.Component;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_BuilderSpec;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentDescriptor {
    ComponentDescriptor() {
    }

    abstract Kind kind();

    abstract AnnotationMirror componentAnnotation();

    abstract TypeElement componentDefinitionType();

    abstract ImmutableSet<TypeElement> dependencies();

    abstract ImmutableSet<ModuleDescriptor> modules();

    ImmutableSet<ModuleDescriptor> transitiveModules() {
        LinkedHashSet<ModuleDescriptor> transitiveModules = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleDescriptor module : this.modules()) {
            ComponentDescriptor.addTransitiveModules(transitiveModules, module);
        }
        return ImmutableSet.copyOf(transitiveModules);
    }

    ImmutableSet<TypeElement> transitiveModuleTypes() {
        return FluentIterable.from(this.transitiveModules()).transform(ModuleDescriptor.getModuleElement()).toSet();
    }

    @CanIgnoreReturnValue
    private static Set<ModuleDescriptor> addTransitiveModules(Set<ModuleDescriptor> transitiveModules, ModuleDescriptor module) {
        if (transitiveModules.add(module)) {
            for (ModuleDescriptor includedModule : module.includedModules()) {
                ComponentDescriptor.addTransitiveModules(transitiveModules, includedModule);
            }
        }
        return transitiveModules;
    }

    abstract ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex();

    abstract ImmutableSet<Scope> scopes();

    abstract ImmutableMap<ComponentMethodDescriptor, ComponentDescriptor> subcomponents();

    abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    abstract Optional<BuilderSpec> builderSpec();

    static boolean isComponentContributionMethod(Elements elements, ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !elements.getTypeElement(Object.class.getCanonicalName()).equals(method.getEnclosingElement());
    }

    static boolean isComponentProductionMethod(Elements elements, ExecutableElement method) {
        return ComponentDescriptor.isComponentContributionMethod(elements, method) && MoreTypes.isTypeOf(ListenableFuture.class, method.getReturnType());
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;

        Factory(Elements elements, Types types, DependencyRequest.Factory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory) {
            this.elements = elements;
            this.types = types;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
        }

        ComponentDescriptor forComponent(TypeElement componentDefinitionType) {
            Optional<Kind> kind = Kind.forAnnotatedElement(componentDefinitionType);
            Preconditions.checkArgument((kind.isPresent() && ((Kind)((Object)kind.get())).isTopLevel() ? 1 : 0) != 0, (String)"%s must be annotated with @Component or @ProductionComponent", (Object[])new Object[]{componentDefinitionType});
            return this.create(componentDefinitionType, (Kind)((Object)kind.get()), (Optional<Kind>)Optional.absent());
        }

        private ComponentDescriptor create(TypeElement componentDefinitionType, Kind kind, Optional<Kind> parentKind) {
            DeclaredType declaredComponentType = MoreTypes.asDeclared(componentDefinitionType.asType());
            AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(componentDefinitionType, kind.annotationType()).get();
            ImmutableSet<TypeElement> componentDependencyTypes = kind.isTopLevel() ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentMirror)) : ImmutableSet.of();
            ImmutableMap.Builder dependencyMethodIndex = ImmutableMap.builder();
            for (TypeElement componentDependency : componentDependencyTypes) {
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement dependencyMethod : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, dependencyMethod)) continue;
                    dependencyMethodIndex.put((Object)dependencyMethod, (Object)componentDependency);
                }
            }
            ImmutableSet.Builder modules = ImmutableSet.builder();
            for (TypeMirror moduleIncludesType : ConfigurationAnnotations.getComponentModules(componentMirror)) {
                modules.add((Object)this.moduleDescriptorFactory.create(MoreTypes.asTypeElement(moduleIncludesType)));
            }
            if (kind.equals((Object)Kind.PRODUCTION_COMPONENT) || kind.equals((Object)Kind.PRODUCTION_SUBCOMPONENT) && parentKind.isPresent() && (((Kind)((Object)parentKind.get())).equals((Object)Kind.COMPONENT) || ((Kind)((Object)parentKind.get())).equals((Object)Kind.SUBCOMPONENT))) {
                modules.add((Object)this.descriptorForMonitoringModule(componentDefinitionType));
                modules.add((Object)this.descriptorForProductionExecutorModule(componentDefinitionType));
            }
            ImmutableSet<ExecutableElement> unimplementedMethods = Util.getUnimplementedMethods(this.elements, componentDefinitionType);
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableMap.Builder subcomponentDescriptors = ImmutableMap.builder();
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredComponentType, componentMethod));
                ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentDefinitionType, kind, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                switch (componentMethodDescriptor.kind()) {
                    case SUBCOMPONENT: 
                    case PRODUCTION_SUBCOMPONENT: {
                        subcomponentDescriptors.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType())), componentMethodDescriptor.kind().componentKind(), (Optional<Kind>)Optional.of((Object)((Object)kind))));
                        break;
                    }
                    case SUBCOMPONENT_BUILDER: 
                    case PRODUCTION_SUBCOMPONENT_BUILDER: {
                        subcomponentDescriptors.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType()).getEnclosingElement()), componentMethodDescriptor.kind().componentKind(), (Optional<Kind>)Optional.of((Object)((Object)kind))));
                        break;
                    }
                }
            }
            ImmutableList<DeclaredType> enclosedBuilders = kind.builderAnnotationType() == null ? ImmutableList.of() : ConfigurationAnnotations.enclosedBuilders(componentDefinitionType, kind.builderAnnotationType());
            Optional builderType = Optional.fromNullable((Object)Iterables.getOnlyElement(enclosedBuilders, null));
            Optional<BuilderSpec> builderSpec = this.createBuilderSpec((Optional<DeclaredType>)builderType);
            ImmutableSet scopes = Scope.scopesOf(componentDefinitionType);
            if (kind.isProducer()) {
                scopes = FluentIterable.from(scopes).append((Object[])new Scope[]{Scope.productionScope(this.elements)}).toSet();
            }
            return new AutoValue_ComponentDescriptor(kind, componentMirror, componentDefinitionType, componentDependencyTypes, (ImmutableSet<ModuleDescriptor>)modules.build(), (ImmutableMap<ExecutableElement, TypeElement>)dependencyMethodIndex.build(), (ImmutableSet<Scope>)scopes, (ImmutableMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentDescriptors.build(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build(), builderSpec);
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, Kind componentKind, ExecutableElement componentMethod) {
            ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
            TypeMirror returnType = resolvedComponentMethod.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED)) {
                if (MoreTypes.isTypeOf(Provider.class, returnType) || MoreTypes.isTypeOf(Lazy.class, returnType)) {
                    return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                }
                if (MoreTypes.isTypeOf(MembersInjector.class, returnType)) {
                    return ComponentMethodDescriptor.forMembersInjection(componentMethod, this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                }
                if (!InjectionAnnotations.getQualifier(componentMethod).isPresent()) {
                    if (MoreElements.isAnnotationPresent(MoreTypes.asElement(returnType), Subcomponent.class)) {
                        return ComponentMethodDescriptor.forSubcomponent(ComponentMethodKind.SUBCOMPONENT, componentMethod);
                    }
                    if (MoreElements.isAnnotationPresent(MoreTypes.asElement(returnType), ProductionSubcomponent.class)) {
                        return ComponentMethodDescriptor.forSubcomponent(ComponentMethodKind.PRODUCTION_SUBCOMPONENT, componentMethod);
                    }
                    if (MoreElements.isAnnotationPresent(MoreTypes.asElement(returnType), Subcomponent.Builder.class)) {
                        return ComponentMethodDescriptor.forSubcomponent(ComponentMethodKind.SUBCOMPONENT_BUILDER, componentMethod);
                    }
                    if (MoreElements.isAnnotationPresent(MoreTypes.asElement(returnType), ProductionSubcomponent.Builder.class)) {
                        return ComponentMethodDescriptor.forSubcomponent(ComponentMethodKind.PRODUCTION_SUBCOMPONENT_BUILDER, componentMethod);
                    }
                }
            }
            if (componentMethod.getParameters().isEmpty() && !componentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                switch (componentKind) {
                    case COMPONENT: 
                    case SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                    }
                    case PRODUCTION_COMPONENT: 
                    case PRODUCTION_SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod));
                    }
                }
                throw new AssertionError();
            }
            List<? extends TypeMirror> parameterTypes = resolvedComponentMethod.getParameterTypes();
            if (parameterTypes.size() == 1 && (returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)parameterTypes.get(0)))) {
                return ComponentMethodDescriptor.forMembersInjection(componentMethod, this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
            }
            String string = String.valueOf(componentMethod);
            throw new IllegalArgumentException(new StringBuilder(30 + String.valueOf(string).length()).append("not a valid component method: ").append(string).toString());
        }

        private Optional<BuilderSpec> createBuilderSpec(Optional<DeclaredType> builderType) {
            if (!builderType.isPresent()) {
                return Optional.absent();
            }
            TypeElement element = MoreTypes.asTypeElement((TypeMirror)builderType.get());
            ImmutableSet<ExecutableElement> methods = Util.getUnimplementedMethods(this.elements, element);
            ImmutableMap.Builder map = ImmutableMap.builder();
            ExecutableElement buildMethod = null;
            for (ExecutableElement method : methods) {
                if (method.getParameters().isEmpty()) {
                    buildMethod = method;
                    continue;
                }
                ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf((DeclaredType)builderType.get(), method));
                map.put((Object)MoreTypes.asTypeElement((TypeMirror)Iterables.getOnlyElement(resolved.getParameterTypes())), (Object)method);
            }
            Verify.verify((buildMethod != null ? 1 : 0) != 0);
            return Optional.of((Object)new AutoValue_ComponentDescriptor_BuilderSpec(element, (Map<TypeElement, ExecutableElement>)map.build(), buildMethod, element.getEnclosingElement().asType()));
        }

        private ModuleDescriptor descriptorForMonitoringModule(TypeElement componentDefinitionType) {
            ClassName monitoringModuleName = SourceFiles.generatedMonitoringModuleName(componentDefinitionType);
            String generatedMonitorModuleName = monitoringModuleName.toString();
            TypeElement monitoringModule = this.elements.getTypeElement(generatedMonitorModuleName);
            if (monitoringModule == null) {
                throw new TypeNotPresentException(generatedMonitorModuleName, null);
            }
            return this.moduleDescriptorFactory.create(monitoringModule);
        }

        private ModuleDescriptor descriptorForProductionExecutorModule(TypeElement componentDefinitionType) {
            ClassName productionExecutorModuleName = SourceFiles.generatedProductionExecutorModuleName(componentDefinitionType);
            String generatedProductionExecutorModuleName = productionExecutorModuleName.toString();
            TypeElement productionExecutorModule = this.elements.getTypeElement(generatedProductionExecutorModuleName);
            if (productionExecutorModule == null) {
                throw new TypeNotPresentException(generatedProductionExecutorModuleName, null);
            }
            return this.moduleDescriptorFactory.create(productionExecutorModule);
        }
    }

    static abstract class BuilderSpec {
        BuilderSpec() {
        }

        abstract TypeElement builderDefinitionType();

        abstract Map<TypeElement, ExecutableElement> methodMap();

        abstract ExecutableElement buildMethod();

        abstract TypeMirror componentType();
    }

    static enum ComponentMethodKind {
        PROVISION,
        PRODUCTION,
        MEMBERS_INJECTION,
        SUBCOMPONENT,
        SUBCOMPONENT_BUILDER,
        PRODUCTION_SUBCOMPONENT,
        PRODUCTION_SUBCOMPONENT_BUILDER;


        Kind componentKind() {
            switch (this) {
                case SUBCOMPONENT: 
                case SUBCOMPONENT_BUILDER: {
                    return Kind.SUBCOMPONENT;
                }
                case PRODUCTION_SUBCOMPONENT: 
                case PRODUCTION_SUBCOMPONENT_BUILDER: {
                    return Kind.PRODUCTION_SUBCOMPONENT;
                }
            }
            String string = String.valueOf((Object)this);
            throw new IllegalStateException(new StringBuilder(36 + String.valueOf(string).length()).append("no component associated with method ").append(string).toString());
        }
    }

    static abstract class ComponentMethodDescriptor {
        ComponentMethodDescriptor() {
        }

        abstract ComponentMethodKind kind();

        abstract Optional<DependencyRequest> dependencyRequest();

        abstract ExecutableElement methodElement();

        static Predicate<ComponentMethodDescriptor> isOfKind(ComponentMethodKind ... kinds) {
            final ImmutableSet kindSet = ImmutableSet.copyOf((Object[])kinds);
            return new Predicate<ComponentMethodDescriptor>(){

                public boolean apply(ComponentMethodDescriptor descriptor) {
                    return kindSet.contains((Object)descriptor.kind());
                }
            };
        }

        static ComponentMethodDescriptor create(ComponentMethodKind kind, Optional<DependencyRequest> dependencyRequest, ExecutableElement methodElement) {
            return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(kind, dependencyRequest, methodElement);
        }

        static ComponentMethodDescriptor forProvision(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.PROVISION, (Optional<DependencyRequest>)Optional.of((Object)dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forMembersInjection(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.MEMBERS_INJECTION, (Optional<DependencyRequest>)Optional.of((Object)dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forSubcomponent(ComponentMethodKind kind, ExecutableElement methodElement) {
            return ComponentMethodDescriptor.create(kind, (Optional<DependencyRequest>)Optional.absent(), methodElement);
        }
    }

    static enum Kind {
        COMPONENT(Component.class, Component.Builder.class, true),
        SUBCOMPONENT(Subcomponent.class, Subcomponent.Builder.class, false),
        PRODUCTION_COMPONENT(ProductionComponent.class, ProductionComponent.Builder.class, true),
        PRODUCTION_SUBCOMPONENT(ProductionSubcomponent.class, ProductionSubcomponent.Builder.class, false);

        private final Class<? extends Annotation> annotationType;
        private final Class<? extends Annotation> builderType;
        private final boolean isTopLevel;
        private static final Function<Kind, Class<? extends Annotation>> TO_ANNOTATION_TYPE;
        private static final Function<Kind, Class<? extends Annotation>> TO_BUILDER_ANNOTATION_TYPE;

        static Optional<Kind> forAnnotatedElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.annotationType())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object[])new Object[]{element, kinds});
            return Optional.fromNullable((Object)Iterables.getOnlyElement(kinds, null));
        }

        static Optional<Kind> forAnnotatedBuilderElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.builderAnnotationType())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object[])new Object[]{element, kinds});
            return Optional.fromNullable((Object)Iterables.getOnlyElement(kinds, null));
        }

        private Kind(Class<? extends Annotation> annotationType, Class<? extends Annotation> builderType, boolean isTopLevel) {
            this.annotationType = annotationType;
            this.builderType = builderType;
            this.isTopLevel = isTopLevel;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        Class<? extends Annotation> builderAnnotationType() {
            return this.builderType;
        }

        ImmutableSet<ModuleDescriptor.Kind> moduleKinds() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return Sets.immutableEnumSet((Enum)ModuleDescriptor.Kind.MODULE, (Enum[])new ModuleDescriptor.Kind[0]);
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return Sets.immutableEnumSet((Enum)ModuleDescriptor.Kind.MODULE, (Enum[])new ModuleDescriptor.Kind[]{ModuleDescriptor.Kind.PRODUCER_MODULE});
                }
            }
            throw new AssertionError((Object)this);
        }

        ImmutableSet<Kind> subcomponentKinds() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return ImmutableSet.of((Object)((Object)SUBCOMPONENT), (Object)((Object)PRODUCTION_SUBCOMPONENT));
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return ImmutableSet.of((Object)((Object)PRODUCTION_SUBCOMPONENT));
                }
            }
            throw new AssertionError();
        }

        boolean isTopLevel() {
            return this.isTopLevel;
        }

        boolean isProducer() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return false;
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        static Function<Kind, Class<? extends Annotation>> toAnnotationType() {
            return TO_ANNOTATION_TYPE;
        }

        static Function<Kind, Class<? extends Annotation>> toBuilderAnnotationType() {
            return TO_BUILDER_ANNOTATION_TYPE;
        }

        static {
            TO_ANNOTATION_TYPE = new Function<Kind, Class<? extends Annotation>>(){

                public Class<? extends Annotation> apply(Kind kind) {
                    return kind.annotationType();
                }
            };
            TO_BUILDER_ANNOTATION_TYPE = new Function<Kind, Class<? extends Annotation>>(){

                public Class<? extends Annotation> apply(Kind kind) {
                    return kind.builderAnnotationType();
                }
            };
        }
    }
}

