/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreElements;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

abstract class BindingDeclaration
implements Key.HasKey {
    static final Function<BindingDeclaration, Set<TypeElement>> CONTRIBUTING_MODULE = new Function<BindingDeclaration, Set<TypeElement>>(){

        public Set<TypeElement> apply(BindingDeclaration bindingDeclaration) {
            return bindingDeclaration.contributingModule().asSet();
        }
    };

    BindingDeclaration() {
    }

    abstract Element bindingElement();

    ExecutableElement bindingElementAsExecutable() {
        try {
            return MoreElements.asExecutable(this.bindingElement());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    TypeElement bindingTypeElement() {
        return Util.ENCLOSING_TYPE_ELEMENT.visit(this.bindingElement());
    }

    abstract Optional<TypeElement> contributingModule();

    Optional<DeclaredType> contributingModuleType() {
        return this.contributingModule().transform(Util.AS_DECLARED_TYPE);
    }

    static Predicate<BindingDeclaration> bindingElementHasModifier(final Modifier modifier) {
        return new Predicate<BindingDeclaration>(){

            public boolean apply(BindingDeclaration bindingDeclaration) {
                return bindingDeclaration.bindingElement().getModifiers().contains((Object)modifier);
            }
        };
    }
}

