/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class TypeCastNode
extends Node {
    protected final Tree tree;
    protected final Node operand;

    public TypeCastNode(Tree tree, Node operand, TypeMirror type) {
        super(type);
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitTypeCast(this, p);
    }

    public String toString() {
        return "(" + this.getType() + ")" + this.getOperand();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeCastNode)) {
            return false;
        }
        TypeCastNode other = (TypeCastNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.getType().equals(other.getType());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

