/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class SampleableConcurrentHashMap<K, V>
extends ConcurrentReferenceHashMap<K, V> {
    private static final float LOAD_FACTOR = 0.91f;
    private static final ThreadLocal<Random> THREAD_LOCAL_RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    public SampleableConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.91f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, null);
    }

    public SampleableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
    }

    public int fetch(int tableIndex, int size, List<Data> keys) {
        long now = Clock.currentTimeMillis();
        ConcurrentReferenceHashMap.Segment segment = this.segments[0];
        ConcurrentReferenceHashMap.HashEntry<K, V>[] currentTable = segment.table;
        int nextTableIndex = tableIndex >= 0 && tableIndex < segment.table.length ? tableIndex : currentTable.length - 1;
        int counter = 0;
        while (nextTableIndex >= 0 && counter < size) {
            ConcurrentReferenceHashMap.HashEntry nextEntry = currentTable[nextTableIndex--];
            while (nextEntry != null) {
                Object value;
                if (nextEntry.key() != null && this.isValidForFetching(value = nextEntry.value(), now)) {
                    keys.add((Data)nextEntry.key());
                    ++counter;
                }
                nextEntry = nextEntry.next;
            }
        }
        return nextTableIndex;
    }

    protected boolean isValidForFetching(V value, long now) {
        if (value instanceof Expirable) {
            return !((Expirable)value).isExpiredAt(now);
        }
        return true;
    }

    protected <E extends SamplingEntry> E createSamplingEntry(K key, V value) {
        return (E)new SamplingEntry(key, value);
    }

    public <E extends SamplingEntry> Iterable<E> getRandomSamples(int sampleCount) {
        if (sampleCount < 0) {
            throw new IllegalArgumentException("Sample count cannot be a negative value.");
        }
        if (sampleCount == 0 || this.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new LazySamplingEntryIterableIterator(sampleCount);
    }

    protected boolean isValidForSampling(V value) {
        return value != null;
    }

    private final class LazySamplingEntryIterableIterator<E extends SamplingEntry>
    implements Iterable<E>,
    Iterator<E> {
        private final int maxEntryCount;
        private final int randomNumber;
        private final int firstSegmentIndex;
        private int currentSegmentIndex;
        private int currentBucketIndex;
        private ConcurrentReferenceHashMap.HashEntry<K, V> currentEntry;
        private int returnedEntryCount;
        private boolean reachedToEnd;
        private E currentSample;

        private LazySamplingEntryIterableIterator(int maxEntryCount) {
            this.maxEntryCount = maxEntryCount;
            this.randomNumber = ((Random)THREAD_LOCAL_RANDOM.get()).nextInt(Integer.MAX_VALUE);
            this.currentSegmentIndex = this.firstSegmentIndex = this.randomNumber % SampleableConcurrentHashMap.this.segments.length;
            this.currentBucketIndex = -1;
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        private void iterate() {
            if (this.returnedEntryCount >= this.maxEntryCount || this.reachedToEnd) {
                this.currentSample = null;
                return;
            }
            do {
                ConcurrentReferenceHashMap.Segment segment;
                if ((segment = SampleableConcurrentHashMap.this.segments[this.currentSegmentIndex]) != null) {
                    ConcurrentReferenceHashMap.HashEntry<K, V>[] table = segment.table;
                    int firstBucketIndex = this.randomNumber % table.length;
                    if (this.currentBucketIndex == -1) {
                        this.currentBucketIndex = firstBucketIndex;
                    }
                    do {
                        if (this.currentEntry == null) {
                            this.currentEntry = table[this.currentBucketIndex];
                        }
                        while (this.currentEntry != null) {
                            Object value = this.currentEntry.value();
                            Object key = this.currentEntry.key();
                            this.currentEntry = this.currentEntry.next;
                            if (!SampleableConcurrentHashMap.this.isValidForSampling(value)) continue;
                            this.currentSample = SampleableConcurrentHashMap.this.createSamplingEntry(key, value);
                            if (this.currentEntry == null) {
                                this.currentBucketIndex = ++this.currentBucketIndex < table.length ? this.currentBucketIndex : 0;
                            }
                            ++this.returnedEntryCount;
                            return;
                        }
                        this.currentBucketIndex = ++this.currentBucketIndex < table.length ? this.currentBucketIndex : 0;
                        this.currentEntry = null;
                    } while (this.currentBucketIndex != firstBucketIndex);
                }
                this.currentSegmentIndex = ++this.currentSegmentIndex < SampleableConcurrentHashMap.this.segments.length ? this.currentSegmentIndex : 0;
                this.currentBucketIndex = -1;
                this.currentEntry = null;
            } while (this.currentSegmentIndex != this.firstSegmentIndex);
            this.reachedToEnd = true;
            this.currentSample = null;
        }

        @Override
        public boolean hasNext() {
            this.iterate();
            return this.currentSample != null;
        }

        @Override
        public E next() {
            if (this.currentSample != null) {
                return this.currentSample;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported");
        }
    }

    public class SamplingEntry
    extends ConcurrentReferenceHashMap.SimpleEntry<K, V> {
        public SamplingEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException("Setting value is not supported");
        }

        @Override
        public boolean equals(Object o) {
            if (SamplingEntry.class.isInstance(o)) {
                return super.equals(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

