/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.MathUtil;
import javax.annotation.Nullable;

public abstract class Correspondence<A, E> {
    public static Correspondence<Number, Number> tolerance(double tolerance) {
        return new TolerantNumericEquality(tolerance);
    }

    public abstract boolean compare(@Nullable A var1, @Nullable E var2);

    public abstract String toString();

    @Deprecated
    public final boolean equals(@Nullable Object o) {
        throw new UnsupportedOperationException("Correspondence.equals(object) is not supported. If you meant to compare objects, use .compare(actual, expected) instead.");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Correspondence.hashCode() is not supported.");
    }

    private static final class TolerantNumericEquality
    extends Correspondence<Number, Number> {
        private final double tolerance;

        private TolerantNumericEquality(double tolerance) {
            this.tolerance = tolerance;
        }

        @Override
        public boolean compare(Number actual, Number expected) {
            DoubleSubject.checkTolerance(this.tolerance);
            double actualDouble = ((Number)Preconditions.checkNotNull((Object)actual)).doubleValue();
            double expectedDouble = ((Number)Preconditions.checkNotNull((Object)expected)).doubleValue();
            return MathUtil.equalWithinTolerance(actualDouble, expectedDouble, this.tolerance);
        }

        @Override
        public String toString() {
            return "is a finite number within " + this.tolerance + " of";
        }
    }
}

