/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorPronePlugins;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.checkerframework.javacutil.AnnotationUtils;

public class BaseErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public BaseErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    BaseErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        ErrorProneOptions errorProneOptions = ErrorProneOptions.processArgs(options);
        List<String> remainingOptions = Arrays.asList(errorProneOptions.getRemainingArgs());
        ImmutableList<String> javacOpts = ImmutableList.copyOf(remainingOptions);
        javacOpts = BaseErrorProneJavaCompiler.defaultToLatestSupportedLanguageLevel(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setCompilePolicyToByFile(javacOpts);
        JavacTaskImpl task = (JavacTaskImpl)this.javacTool.getTask(out, fileManager, diagnosticListener, (Iterable<String>)javacOpts, classes, compilationUnits);
        BaseErrorProneJavaCompiler.setupMessageBundle(task.getContext());
        RefactoringCollection[] refactoringCollection = new RefactoringCollection[]{null};
        task.addTaskListener(BaseErrorProneJavaCompiler.createAnalyzer(this.scannerSupplier, errorProneOptions, task.getContext(), refactoringCollection));
        if (refactoringCollection[0] != null) {
            task.addTaskListener(new RefactoringTask(task.getContext(), refactoringCollection[0]));
        }
        task.addTaskListener(new CFCacheClearingListener());
        return task;
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }

    private static ImmutableList<String> defaultToLatestSupportedLanguageLevel(ImmutableList<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return ImmutableList.builder().add((Object[])new String[]{"-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel}).addAll(args).build();
    }

    private static ImmutableList<String> setCompilePolicyToByFile(ImmutableList<String> args) {
        for (String arg : args) {
            String value;
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            switch (value = arg.substring(arg.indexOf(61) + 1)) {
                case "byfile": 
                case "simple": {
                    break;
                }
                default: {
                    throw new InvalidCommandLineOptionException(String.format("-XDcompilePolicy=%s is not supported by Error Prone", value));
                }
            }
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-XDcompilePolicy=byfile").build();
    }

    public static void setupMessageBundle(Context context) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.google.errorprone.errors");
        JavacMessages.instance(context).add(l -> bundle);
    }

    static ErrorProneAnalyzer createAnalyzer(ScannerSupplier scannerSupplier, ErrorProneOptions epOptions, Context context, RefactoringCollection[] refactoringCollection) {
        if (!epOptions.patchingOptions().doRefactor()) {
            return ErrorProneAnalyzer.createByScanningForPlugins(scannerSupplier, epOptions, context);
        }
        refactoringCollection[0] = RefactoringCollection.refactor(epOptions.patchingOptions());
        CodeTransformer codeTransformer = (CodeTransformer)((Supplier)epOptions.patchingOptions().customRefactorer().or(() -> {
            ScannerSupplier toUse = ErrorPronePlugins.loadPlugins(scannerSupplier, context);
            Set<String> namedCheckers = epOptions.patchingOptions().namedCheckers();
            if (!namedCheckers.isEmpty()) {
                toUse = toUse.filter((Predicate<? super BugCheckerInfo>)((Predicate)bci -> namedCheckers.contains(bci.canonicalName())));
            }
            return ErrorProneScannerTransformer.create((Scanner)toUse.applyOverrides(epOptions).get());
        })).get();
        return ErrorProneAnalyzer.createWithCustomDescriptionListener(codeTransformer, epOptions, context, refactoringCollection[0]);
    }

    private static class CFCacheClearingListener
    implements TaskListener {
        private CFCacheClearingListener() {
        }

        @Override
        public void finished(TaskEvent e) {
            if (e.getKind() == TaskEvent.Kind.COMPILATION) {
                AnnotationUtils.clear();
            }
        }
    }

    static class RefactoringTask
    implements TaskListener {
        private final Context context;
        private final RefactoringCollection refactoringCollection;

        public RefactoringTask(Context context, RefactoringCollection refactoringCollection) {
            this.context = context;
            this.refactoringCollection = refactoringCollection;
        }

        @Override
        public void started(TaskEvent event) {
        }

        @Override
        public void finished(TaskEvent event) {
            RefactoringCollection.RefactoringResult refactoringResult;
            if (event.getKind() != TaskEvent.Kind.GENERATE) {
                return;
            }
            try {
                refactoringResult = this.refactoringCollection.applyChanges(event.getSourceFile().toUri());
            }
            catch (Exception e) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.ERROR);
                out.println(e.getMessage());
                out.flush();
                return;
            }
            if (refactoringResult.type() == RefactoringCollection.RefactoringResultType.CHANGED) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.NOTICE);
                out.println(refactoringResult.message());
                out.flush();
            }
        }
    }
}

