/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.ComparisonFailure;

final class Platform {
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?:[\\w$]+\\.)*([\\w\\.*$]+)");

    private Platform() {
    }

    static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        return Platform.isInstanceOfTypeJava(instance, clazz);
    }

    @GwtIncompatible(value="Reflection")
    static boolean isInstanceOfTypeJava(Object instance, Class<?> clazz) {
        return clazz.isInstance(instance);
    }

    static boolean isInstanceOfTypeGWT(Object instance, Class<?> clazz) {
        String className = clazz.getName();
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(instance.getClass().getCanonicalName());
        Platform.addTypeNames(instance.getClass(), types);
        return types.contains(className);
    }

    private static void addInterfaceNames(Class<?>[] interfaces, Set<String> types) {
        for (Class<?> interfaze : interfaces) {
            types.add(interfaze.getName());
            Platform.addInterfaceNames(interfaze.getInterfaces(), types);
        }
    }

    private static void addTypeNames(Class<?> clazz, Set<String> types) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            types.add(current.getName());
            Platform.addInterfaceNames(current.getInterfaces(), types);
        }
    }

    static String compressType(String type) {
        type = Platform.typeOnly(type);
        StringBuilder sb = new StringBuilder();
        Matcher m = TYPE_PATTERN.matcher(type);
        int pos = 0;
        while (true) {
            boolean found;
            int typeStart = (found = m.find(pos)) ? m.start() : type.length();
            sb.append(type, pos, typeStart);
            if (!found) break;
            String name = m.group(0);
            name = Platform.stripIfInPackage(name, "java.lang.");
            name = Platform.stripIfInPackage(name, "java.util.");
            sb.append(name);
            pos = m.end();
        }
        return sb.toString();
    }

    private static String typeOnly(String type) {
        type = Platform.stripIfPrefixed(type, "class ");
        type = Platform.stripIfPrefixed(type, "interface ");
        return type;
    }

    private static String stripIfPrefixed(String string, String prefix) {
        return string.startsWith(prefix) ? string.substring(prefix.length()) : string;
    }

    private static String stripIfInPackage(String type, String packagePrefix) {
        if (type.startsWith(packagePrefix) && type.indexOf(46, packagePrefix.length()) == -1 && Character.isUpperCase(type.charAt(packagePrefix.length()))) {
            return type.substring(packagePrefix.length());
        }
        return type;
    }

    static AssertionError comparisonFailure(String message, String expected, String actual) {
        return new ComparisonFailure(message, expected, actual);
    }

    static boolean containsMatch(String actual, String regex) {
        return Pattern.compile(regex).matcher(actual).find();
    }

    static int getArrayLength(Object array) {
        return Array.getLength(array);
    }

    static Object getFromArray(Object array, int i) {
        return Array.get(array, i);
    }
}

