/* unit-archives.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libinifile/inifile.h"
#include "libarch/archives.h"



/* typedefs */



/* local methods */



static void
test_locations(void)
{
  ar_archive_location foo = NULL;
  ar_insert_archive_location (&foo, 0, NULL);
  ar_free_archive_location (&foo);
}

int
main (int argc, char * argv[])
{
  int index;
  ar_archive_location locations;
  rel_table values;
  inifile_t inifile;
  test_locations();
  inifile_init (&inifile);
  inifile_process_text (&inifile, "url=theman master priority=90\n"
                        "url=public readonly\n"
                        "url=local priority=101\n"
                        "url=missing disabled\n");
  values = inifile_get_key_values (&inifile, "", "url");
  locations = locations_from_ini_values (values);
  ar_for_each (locations, index)
    {
//      safe_printfmt(2, "%s d:%d m:%d r:%d p:%d\n", locations[index]->url, locations[index]->disabled, locations[index]->master, locations[index]->readonly, locations[index]->priority);
      if (index == 2)
        {
          invariant_str_cmp (locations[index]->url, "theman");
          invariant_int_cmp (locations[index]->master, 2);
          invariant_int_cmp (locations[index]->readonly, 0);
          invariant_int_cmp (locations[index]->priority, 90);
        }
      if (index == 1)
        {
          invariant_str_cmp (locations[index]->url, "public");
          invariant_int_cmp (locations[index]->master, 0);
          invariant_int_cmp (locations[index]->readonly, 2);
          invariant_int_cmp (locations[index]->priority, 100);
        }
      if (index == 0)
        {
          invariant_str_cmp (locations[index]->url, "local");
          invariant_int_cmp (locations[index]->master, 0);
          invariant_int_cmp (locations[index]->readonly, 0);
          invariant_int_cmp (locations[index]->priority, 101);
        }
      if (index == 3)
        {
          panic ("disabled archive included");
        }
    }
  ar_free_archive_location (&locations);
    {
      arch_archive_location_t *temp_location = arch_archive_location_new_inivalue("foo priority=30");
      t_uchar * temp_value;
      invariant_int_cmp (temp_location->priority, 30);
      temp_value = arch_archive_location_to_ini_key (temp_location);
      invariant_str_cmp (temp_value, "foo priority=30");
      lim_free (0, temp_value);
      talloc_free (temp_location);
    }
  inifile_finalise (&inifile);
  return 0;
}

