#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test import
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_setup_archives

test_class "baz import"

begin_test "Simple import"
make_hello_world hello-world--mainline--1.0
cd hello-world--mainline--1.0
tla init-tree --nested jane@example.com--2003/hello-world--mainline--1.0
tla id-tagging-method explicit
tla add hello-world.c README
cd ..
tla import -d hello-world--mainline--1.0 -L 'initial import'
cd hello-world--mainline--1.0
tla categories jane@example.com--2003 >&2
test "$(tla categories jane@example.com--2003)" = "hello-world"
test "$(tla branches jane@example.com--2003/hello-world)" = "hello-world--mainline"
test "$(tla versions jane@example.com--2003/hello-world--mainline)" = "hello-world--mainline--1.0"
test -d $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world--mainline--1.0/base-0
test -f $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world--mainline--1.0/base-0/ancestry.gz || test_fail "Missing ancestry data file"
test -f $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world--mainline--1.0/base-0/ancestry.gz.checksum || test_fail "Missing ancestry checksum"
test "$(gunzip -c $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world--mainline--1.0/base-0/ancestry.gz)" = "$(echo -e 'arch ancestry version 1\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--base-0')" 
end_test 

begin_test "Import files in a directory (.)"
make_hello_world hello-world--mainline--1.0
cd hello-world--mainline--1.0
tla import --automatic jane@example.com--2003/hello-world--mainline1--1.0
tla inventory -s | sort > ,,actual-inventory
echo -e "README\nhello-world.c" | sort > ,,expected-inventory
diff -u ,,actual-inventory ,,expected-inventory
end_test

begin_test "Import files in a directory (hello-world--mainline--1.0)"
make_hello_world hello-world--mainline--1.0
tla import --automatic -d hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline2--1.0
tla inventory -s hello-world--mainline--1.0 | sort > ,,actual-inventory
echo -e "hello-world--mainline--1.0/README\nhello-world--mainline--1.0/hello-world.c" | sort > ,,expected-inventory
diff -u ,,actual-inventory ,,expected-inventory
end_test

begin_test "Import files in a subdir in a directory (.)"
make_hello_world hello-world--mainline--1.0
cd hello-world--mainline--1.0
mkdir X
touch X/Y
tla import --automatic jane@example.com--2003/hello-world--mainline3--1.0
tla inventory -sB | sort > ,,actual-inventory
echo -e "README\nhello-world.c\nX\nX/Y" | sort > ,,expected-inventory
diff -u ,,actual-inventory ,,expected-inventory
end_test

begin_test "Import files in a subdir in a directory (hello-world--mainline--1.0)"
make_hello_world hello-world--mainline--1.0
cd hello-world--mainline--1.0
mkdir X
touch X/Y
cd ..
tla import --automatic -d hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline4--1.0
tla inventory -sB hello-world--mainline--1.0 | sort > ,,actual-inventory
echo -e "hello-world--mainline--1.0/README\nhello-world--mainline--1.0/hello-world.c\nhello-world--mainline--1.0/X\nhello-world--mainline--1.0/X/Y" | sort > ,,expected-inventory
diff -u ,,actual-inventory ,,expected-inventory
end_test

begin_test "Import files in a deep subdir in a directory (hello-world--mainline--1.0)"
make_hello_world hello-world--mainline--1.0
cd hello-world--mainline--1.0
mkdir X
touch X/Y
mkdir X/x
touch X/x/y
cd ..
tla import --automatic -d hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline5--1.0
tla inventory -sB hello-world--mainline--1.0 | sort > ,,actual-inventory
echo -e "hello-world--mainline--1.0/README\nhello-world--mainline--1.0/hello-world.c\nhello-world--mainline--1.0/X\nhello-world--mainline--1.0/X/Y\nhello-world--mainline--1.0/X/x\nhello-world--mainline--1.0/X/x/y" | sort > ,,expected-inventory
diff -u ,,actual-inventory ,,expected-inventory
end_test

clean_workdir
