/* unit-cmd-diff.c
 *
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/reserv.h"
#include "hackerlab/bugs/exception.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/inv-ids.h"
#include "libarch/null-project-tree.h"
#include "libarch/my.h"
#include "libarch/pfs.h"


/* typedefs */



/* local methods */


#include "hackerlab/vu/safe.h"

int
main (int argc, char * argv[])
{
  arch_project_tree_t * tree;
  t_uchar * abs_path;
  t_uchar * rel_path;
  t_uchar * an_id;
  tree = arch_project_tree_new_ext (talloc_context, ".", 1, 0);
  abs_path = arch_abs_path ("unit-inv-ids.o");
  rel_path = arch_project_tree_rel_path_from_abs (tree, abs_path);
  safe_printfmt (2, "..%s %s %s\n", tree->root, abs_path, rel_path);
  an_id = arch_choose_explicit_id (tree, rel_path, "phwoar");
  invariant (!str_cmp(an_id, "phwoar"));
  lim_free (0, an_id);

  arch_my_id_memoise ("some id", 7);
  an_id = arch_choose_explicit_id (tree, rel_path, NULL);
  invariant (an_id != NULL);
  lim_free (0, an_id);

  an_id = arch_add_id ("DOESNOTEXIST", NULL);
  invariant (an_id == NULL);

  an_id = arch_add_id ("DOESNOTEXIST", "phwoar");
  invariant (an_id == NULL);
  
  invariant (str_cmp_suffix_n ("aa", "bb", 1) == -1);
  invariant (str_cmp_suffix_n ("a", "bb", 1) == -1);
  invariant (str_cmp_suffix_n ("aa", "b", 1) == -1);
  invariant (str_cmp_suffix_n ("aa", "aa", 1) == 0);
  invariant (str_cmp_suffix_n ("a", "aa", 1) == 0);
  invariant (str_cmp_suffix_n ("aa", "a", 1) == 0);
  invariant (str_cmp_suffix_n ("bb", "aa", 1) == 1);
  invariant (str_cmp_suffix_n ("b", "aa", 1) == 1);
  invariant (str_cmp_suffix_n ("bb", "a", 1) == 1);

  arch_project_tree_delete (tree);
  return 0;
}

