/* Opcode table for m680[012346]0/m6888[12]/m68851/mcf5200.
   Copyright 1989, 91, 92, 93, 94, 95, 96, 97, 98, 1999
   Free Software Foundation.

This file is part of GDB, GAS, and the GNU binutils.

GDB, GAS, and the GNU binutils are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
1, or (at your option) any later version.

GDB, GAS, and the GNU binutils are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "ansidecl.h"
#include "m68k.h"

#define one(x) ((unsigned int) (x) << 16)
#define two(x, y) (((unsigned int) (x) << 16) + (y))

/* The assembler requires that all instances of the same mnemonic must
   be consecutive.  If they aren't, the assembler will bomb at
   runtime.  */

const struct m68k_opcode m68k_opcodes[] =
{
{"abcd",	one(0140400),	one(0170770), "DsDd", m68000up },
{"abcd",	one(0140410),	one(0170770), "-s-d", m68000up },

{"adda.w",	one(0150300),	one(0170700), "*wAd", m68000up },
{"adda.l",	one(0150700),	one(0170700), "*lAd", m68000up | mcf5200 },

{"addi.b",	one(0003000),	one(0177700), "#b$s", m68000up },
{"addi.w",	one(0003100),	one(0177700), "#w$s", m68000up },
{"addi.l",	one(0003200),	one(0177700), "#l$s", m68000up },
{"addi.l",	one(0003200),	one(0177700), "#lDs", mcf5200 },

{"addq.b",	one(0050000),	one(0170700), "Qd$b", m68000up },
{"addq.w",	one(0050100),	one(0170700), "Qd%w", m68000up },
{"addq.l",	one(0050200),	one(0170700), "Qd%l", m68000up | mcf5200 },

/* The add opcode can generate the adda, addi, and addq instructions.  */
{"add.b",	one(0050000),	one(0170700), "Qd$b", m68000up },
{"add.b",	one(0003000),	one(0177700), "#b$s", m68000up },
{"add.b",	one(0150000),	one(0170700), ";bDd", m68000up },
{"add.b",	one(0150400),	one(0170700), "Dd~b", m68000up },
{"add.w",	one(0050100),	one(0170700), "Qd%w", m68000up },
{"add.w",	one(0150300),	one(0170700), "*wAd", m68000up },
{"add.w",	one(0003100),	one(0177700), "#w$s", m68000up },
{"add.w",	one(0150100),	one(0170700), "*wDd", m68000up },
{"add.w",	one(0150500),	one(0170700), "Dd~w", m68000up },
{"add.l",	one(0050200),	one(0170700), "Qd%l", m68000up | mcf5200 },
{"add.l",	one(0003200),	one(0177700), "#l$s", m68000up },
{"add.l",	one(0003200),	one(0177700), "#lDs", mcf5200 },
{"add.l",	one(0150700),	one(0170700), "*lAd", m68000up | mcf5200 },
{"add.l",	one(0150200),	one(0170700), "*lDd", m68000up | mcf5200 },
{"add.l",	one(0150600),	one(0170700), "Dd~l", m68000up | mcf5200 },

{"addx.b",	one(0150400),	one(0170770), "DsDd", m68000up },
{"addx.b",	one(0150410),	one(0170770), "-s-d", m68000up },
{"addx.w",	one(0150500),	one(0170770), "DsDd", m68000up },
{"addx.w",	one(0150510),	one(0170770), "-s-d", m68000up },
{"addx.l",	one(0150600),	one(0170770), "DsDd", m68000up | mcf5200 },
{"addx.l",	one(0150610),	one(0170770), "-s-d", m68000up },

{"andi.b",	one(0001000),	one(0177700), "#b$s", m68000up },
{"andi.w",	one(0001100),	one(0177700), "#w$s", m68000up },
{"andi.l",	one(0001200),	one(0177700), "#l$s", m68000up },
{"andi.l",	one(0001200),	one(0177700), "#lDs", mcf5200 },
{"andi",	one(0001100),	one(0177700), "#w$s", m68000up },
{"andi",	one(0001074),	one(0177777), "#bCs", m68000up },
{"andi",	one(0001174),	one(0177777), "#wSs", m68000up },

/* The and opcode can generate the andi instruction.  */
{"and.b",	one(0001000),	one(0177700), "#b$s", m68000up },
{"and.b",	one(0140000),	one(0170700), ";bDd", m68000up },
{"and.b",	one(0140400),	one(0170700), "Dd~b", m68000up },
{"and.w",	one(0001100),	one(0177700), "#w$s", m68000up },
{"and.w",	one(0140100),	one(0170700), ";wDd", m68000up },
{"and.w",	one(0140500),	one(0170700), "Dd~w", m68000up },
{"and.l",	one(0001200),	one(0177700), "#l$s", m68000up },
{"and.l",	one(0001200),	one(0177700), "#lDs", mcf5200 },
{"and.l",	one(0140200),	one(0170700), ";lDd", m68000up | mcf5200 },
{"and.l",	one(0140600),	one(0170700), "Dd~l", m68000up | mcf5200 },
{"and",		one(0001100),	one(0177700), "#w$w", m68000up },
{"and",		one(0001074),	one(0177777), "#bCs", m68000up },
{"and",		one(0001174),	one(0177777), "#wSs", m68000up },
{"and",		one(0140100),	one(0170700), ";wDd", m68000up },
{"and",		one(0140500),	one(0170700), "Dd~w", m68000up },

{"asl.b",	one(0160400),	one(0170770), "QdDs", m68000up },
{"asl.b",	one(0160440),	one(0170770), "DdDs", m68000up },
{"asl.w",	one(0160500),	one(0170770), "QdDs", m68000up },
{"asl.w",	one(0160540),	one(0170770), "DdDs", m68000up },
{"asl.w",	one(0160700),	one(0177700), "~s",   m68000up },
{"asl.l",	one(0160600),	one(0170770), "QdDs", m68000up | mcf5200 },
{"asl.l",	one(0160640),	one(0170770), "DdDs", m68000up | mcf5200 },

{"asr.b",	one(0160000),	one(0170770), "QdDs", m68000up },
{"asr.b",	one(0160040),	one(0170770), "DdDs", m68000up },
{"asr.w",	one(0160100),	one(0170770), "QdDs", m68000up },
{"asr.w",	one(0160140),	one(0170770), "DdDs", m68000up },
{"asr.w",	one(0160300),	one(0177700), "~s",   m68000up },
{"asr.l",	one(0160200),	one(0170770), "QdDs", m68000up | mcf5200 },
{"asr.l",	one(0160240),	one(0170770), "DdDs", m68000up | mcf5200 },

{"bhi",		one(0061000),	one(0177777), "BW", m68000up | mcf5200 },
{"bls",		one(0061400),	one(0177777), "BW", m68000up | mcf5200 },
{"bcc",		one(0062000),	one(0177777), "BW", m68000up | mcf5200 },
{"bcs",		one(0062400),	one(0177777), "BW", m68000up | mcf5200 },
{"bne",		one(0063000),	one(0177777), "BW", m68000up | mcf5200 },
{"beq",		one(0063400),	one(0177777), "BW", m68000up | mcf5200 },
{"bvc",		one(0064000),	one(0177777), "BW", m68000up | mcf5200 },
{"bvs",		one(0064400),	one(0177777), "BW", m68000up | mcf5200 },
{"bpl",		one(0065000),	one(0177777), "BW", m68000up | mcf5200 },
{"bmi",		one(0065400),	one(0177777), "BW", m68000up | mcf5200 },
{"bge",		one(0066000),	one(0177777), "BW", m68000up | mcf5200 },
{"blt",		one(0066400),	one(0177777), "BW", m68000up | mcf5200 },
{"bgt",		one(0067000),	one(0177777), "BW", m68000up | mcf5200 },
{"ble",		one(0067400),	one(0177777), "BW", m68000up | mcf5200 },

{"bhi.l",	one(0061377),	one(0177777), "BL", m68020up | cpu32 },
{"bls.l",	one(0061777),	one(0177777), "BL", m68020up | cpu32 },
{"bcc.l",	one(0062377),	one(0177777), "BL", m68020up | cpu32 },
{"bcs.l",	one(0062777),	one(0177777), "BL", m68020up | cpu32 },
{"bne.l",	one(0063377),	one(0177777), "BL", m68020up | cpu32 },
{"beq.l",	one(0063777),	one(0177777), "BL", m68020up | cpu32 },
{"bvc.l",	one(0064377),	one(0177777), "BL", m68020up | cpu32 },
{"bvs.l",	one(0064777),	one(0177777), "BL", m68020up | cpu32 },
{"bpl.l",	one(0065377),	one(0177777), "BL", m68020up | cpu32 },
{"bmi.l",	one(0065777),	one(0177777), "BL", m68020up | cpu32 },
{"bge.l",	one(0066377),	one(0177777), "BL", m68020up | cpu32 },
{"blt.l",	one(0066777),	one(0177777), "BL", m68020up | cpu32 },
{"bgt.l",	one(0067377),	one(0177777), "BL", m68020up | cpu32 },
{"ble.l",	one(0067777),	one(0177777), "BL", m68020up | cpu32 },

{"bhi.s",	one(0061000),	one(0177400), "BB", m68000up | mcf5200 },
{"bls.s",	one(0061400),	one(0177400), "BB", m68000up | mcf5200 },
{"bcc.s",	one(0062000),	one(0177400), "BB", m68000up | mcf5200 },
{"bcs.s",	one(0062400),	one(0177400), "BB", m68000up | mcf5200 },
{"bne.s",	one(0063000),	one(0177400), "BB", m68000up | mcf5200 },
{"beq.s",	one(0063400),	one(0177400), "BB", m68000up | mcf5200 },
{"bvc.s",	one(0064000),	one(0177400), "BB", m68000up | mcf5200 },
{"bvs.s",	one(0064400),	one(0177400), "BB", m68000up | mcf5200 },
{"bpl.s",	one(0065000),	one(0177400), "BB", m68000up | mcf5200 },
{"bmi.s",	one(0065400),	one(0177400), "BB", m68000up | mcf5200 },
{"bge.s",	one(0066000),	one(0177400), "BB", m68000up | mcf5200 },
{"blt.s",	one(0066400),	one(0177400), "BB", m68000up | mcf5200 },
{"bgt.s",	one(0067000),	one(0177400), "BB", m68000up | mcf5200 },
{"ble.s",	one(0067400),	one(0177400), "BB", m68000up | mcf5200 },

{"jhi",		one(0061000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jls",		one(0061400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jcc",		one(0062000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jcs",		one(0062400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jne",		one(0063000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jeq",		one(0063400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jvc",		one(0064000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jvs",		one(0064400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jpl",		one(0065000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jmi",		one(0065400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jge",		one(0066000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jlt",		one(0066400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jgt",		one(0067000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jle",		one(0067400),	one(0177400), "Bg", m68000up | mcf5200 },

{"bchg",	one(0000500),	one(0170700), "Dd$s", m68000up | mcf5200 },
{"bchg",	one(0004100),	one(0177700), "#b$s", m68000up },
{"bchg",	one(0004100),	one(0177700), "#bqs", mcf5200 },

{"bclr",	one(0000600),	one(0170700), "Dd$s", m68000up },
{"bclr",	one(0000600),	one(0170700), "Ddvs", mcf5200 },
{"bclr",	one(0004200),	one(0177700), "#b$s", m68000up },
{"bclr",	one(0004200),	one(0177700), "#bqs", mcf5200 },

{"bfchg",	two(0165300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bfclr",	two(0166300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bfexts",	two(0165700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfextu",	two(0164700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfffo",	two(0166700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfins",	two(0167700, 0), two(0177700, 0100000),	"D1?sO2O3", m68020up },
{"bfset",	two(0167300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bftst",	two(0164300, 0), two(0177700, 0170000),	"/sO2O3",   m68020up },

{"bgnd",	one(0045372),		one(0177777), "", cpu32 },

{"bkpt",	one(0044110),		one(0177770), "ts", m68010up },

{"bra",		one(0060000),	one(0177777), "BW", m68000up | mcf5200 },
{"bra.l",	one(0060377),	one(0177777), "BL", m68020up | cpu32 },
{"bra.s",	one(0060000),	one(0177400), "BB", m68000up | mcf5200 },

{"bset",	one(0000700),	one(0170700), "Dd$s", m68000up },
{"bset",	one(0000700),	one(0170700), "Ddvs", mcf5200 },
{"bset",	one(0004300),	one(0177700), "#b$s", m68000up },
{"bset",	one(0004300),	one(0177700), "#bqs", mcf5200 },

{"bsr",		one(0060400),	one(0177777), "BW", m68000up | mcf5200 },
{"bsr.l",	one(0060777),	one(0177777), "BL", m68020up | cpu32 },
{"bsr.s",	one(0060400),	one(0177400), "BB", m68000up | mcf5200 },

{"btst",	one(0000400),	one(0170700), "Dd;b", m68000up | mcf5200 },
{"btst",	one(0004000),	one(0177700), "#b@s", m68000up },
{"btst",	one(0004000),	one(0177700), "#bqs", mcf5200 },

{"callm",	one(0003300),		one(0177700), "#b!s", m68020 },

{"cas2.w",	two(0006374,0), two(0177777,0007070), "D3D6D2D5r1r4", m68020up },
{"cas2.w",	two(0006374,0), two(0177777,0007070), "D3D6D2D5R1R4", m68020up },
{"cas2.l",	two(0007374,0), two(0177777,0007070), "D3D6D2D5r1r4", m68020up },
{"cas2.l",	two(0007374,0), two(0177777,0007070), "D3D6D2D5R1R4", m68020up },

{"cas.b",	two(0005300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },
{"cas.w",	two(0006300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },
{"cas.l",	two(0007300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },

{"chk2.b",	two(0000300,0004000), two(0177700,07777), "!sR1", m68020up | cpu32 },
{"chk2.w",	two(0001300,0004000),	two(0177700,07777), "!sR1", m68020up | cpu32 },
{"chk2.l",	two(0002300,0004000),	two(0177700,07777), "!sR1", m68020up | cpu32 },

{"chk.l",	one(0040400),		one(0170700), ";lDd", m68000up },
{"chk.w",	one(0040600),		one(0170700), ";wDd", m68000up },

#define SCOPE_LINE (0x1 << 3)
#define SCOPE_PAGE (0x2 << 3)
#define SCOPE_ALL  (0x3 << 3)

{"cinva",	one(0xf400|SCOPE_ALL),  one(0xff38), "ce",   m68040up },
{"cinvl",	one(0xf400|SCOPE_LINE), one(0xff38), "ceas", m68040up },
{"cinvp",	one(0xf400|SCOPE_PAGE), one(0xff38), "ceas", m68040up },

{"cpusha",	one(0xf420|SCOPE_ALL),  one(0xff38), "ce",   m68040up },
{"cpushl",	one(0xf420|SCOPE_LINE), one(0xff38), "ceas", m68040up },
{"cpushl",	one(0x04e8),		one(0xfff8), "as",   mcf5200  },
{"cpushp",	one(0xf420|SCOPE_PAGE), one(0xff38), "ceas", m68040up },

#undef SCOPE_LINE
#undef SCOPE_PAGE
#undef SCOPE_ALL

{"clr.b",	one(0041000),	one(0177700), "$s", m68000up | mcf5200 },
{"clr.w",	one(0041100),	one(0177700), "$s", m68000up | mcf5200 },
{"clr.l",	one(0041200),	one(0177700), "$s", m68000up | mcf5200 },

{"cmp2.b",	two(0000300,0), two(0177700,07777), "!sR1", m68020up | cpu32 },
{"cmp2.w",	two(0001300,0),	two(0177700,07777), "!sR1", m68020up | cpu32 },
{"cmp2.l",	two(0002300,0),	two(0177700,07777), "!sR1", m68020up | cpu32 },

{"cmpa.w",	one(0130300),	one(0170700), "*wAd", m68000up },
{"cmpa.l",	one(0130700),	one(0170700), "*lAd", m68000up | mcf5200 },

{"cmpi.b",	one(0006000),	one(0177700), "#b;s", m68000up },
{"cmpi.w",	one(0006100),	one(0177700), "#w;s", m68000up },
{"cmpi.l",	one(0006200),	one(0177700), "#l;s", m68000up },
{"cmpi.l",	one(0006200),	one(0177700), "#lDs", mcf5200 },

{"cmpm.b",	one(0130410),	one(0170770), "+s+d", m68000up },
{"cmpm.w",	one(0130510),	one(0170770), "+s+d", m68000up },
{"cmpm.l",	one(0130610),	one(0170770), "+s+d", m68000up },

/* The cmp opcode can generate the cmpa, cmpm, and cmpi instructions.  */
{"cmp.b",	one(0006000),	one(0177700), "#b;s", m68000up },
{"cmp.b",	one(0130410),	one(0170770), "+s+d", m68000up },
{"cmp.b",	one(0130000),	one(0170700), ";bDd", m68000up },
{"cmp.w",	one(0130300),	one(0170700), "*wAd", m68000up },
{"cmp.w",	one(0006100),	one(0177700), "#w;s", m68000up },
{"cmp.w",	one(0130510),	one(0170770), "+s+d", m68000up },
{"cmp.w",	one(0130100),	one(0170700), "*wDd", m68000up },
{"cmp.l",	one(0130700),	one(0170700), "*lAd", m68000up | mcf5200 },
{"cmp.l",	one(0006200),	one(0177700), "#l;s", m68000up },
{"cmp.l",	one(0006200),	one(0177700), "#lDs", mcf5200 },
{"cmp.l",	one(0130610),	one(0170770), "+s+d", m68000up },
{"cmp.l",	one(0130200),	one(0170700), "*lDd", m68000up | mcf5200 },

{"dbcc",	one(0052310),	one(0177770), "DsBw", m68000up },
{"dbcs",	one(0052710),	one(0177770), "DsBw", m68000up },
{"dbeq",	one(0053710),	one(0177770), "DsBw", m68000up },
{"dbf",		one(0050710),	one(0177770), "DsBw", m68000up },
{"dbge",	one(0056310),	one(0177770), "DsBw", m68000up },
{"dbgt",	one(0057310),	one(0177770), "DsBw", m68000up },
{"dbhi",	one(0051310),	one(0177770), "DsBw", m68000up },
{"dble",	one(0057710),	one(0177770), "DsBw", m68000up },
{"dbls",	one(0051710),	one(0177770), "DsBw", m68000up },
{"dblt",	one(0056710),	one(0177770), "DsBw", m68000up },
{"dbmi",	one(0055710),	one(0177770), "DsBw", m68000up },
{"dbne",	one(0053310),	one(0177770), "DsBw", m68000up },
{"dbpl",	one(0055310),	one(0177770), "DsBw", m68000up },
{"dbt",		one(0050310),	one(0177770), "DsBw", m68000up },
{"dbvc",	one(0054310),	one(0177770), "DsBw", m68000up },
{"dbvs",	one(0054710),	one(0177770), "DsBw", m68000up },

{"divs.w",	one(0100700),		one(0170700), ";wDd", m68000up },

{"divs.l", two(0046100,0006000),two(0177700,0107770),";lD3D1", m68020up|cpu32 },
{"divs.l", two(0046100,0004000),two(0177700,0107770),";lDD",   m68020up|cpu32 },

{"divsl.l", two(0046100,0004000),two(0177700,0107770),";lD3D1",m68020up|cpu32 },
{"divsl.l", two(0046100,0004000),two(0177700,0107770),";lDD",  m68020up|cpu32 },

{"divu.w",	one(0100300),		one(0170700), ";wDd", m68000up },

{"divu.l", two(0046100,0002000),two(0177700,0107770),";lD3D1", m68020up|cpu32 },
{"divu.l", two(0046100,0000000),two(0177700,0107770),";lDD",   m68020up|cpu32 },

{"divul.l", two(0046100,0000000),two(0177700,0107770),";lD3D1",m68020up|cpu32 },
{"divul.l", two(0046100,0000000),two(0177700,0107770),";lDD",  m68020up|cpu32 },

{"eori.b",	one(0005000),	one(0177700), "#b$s", m68000up },
{"eori.w",	one(0005100),	one(0177700), "#w$s", m68000up },
{"eori.l",	one(0005200),	one(0177700), "#l$s", m68000up },
{"eori.l",	one(0005200),	one(0177700), "#lDs", mcf5200 },
{"eori",	one(0005074),	one(0177777), "#bCs", m68000up },
{"eori",	one(0005174),	one(0177777), "#wSs", m68000up },
{"eori",	one(0005100),	one(0177700), "#w$s", m68000up },

/* The eor opcode can generate the eori instruction.  */
{"eor.b",	one(0005000),	one(0177700), "#b$s", m68000up },
{"eor.b",	one(0130400),	one(0170700), "Dd$s", m68000up },
{"eor.w",	one(0005100),	one(0177700), "#w$s", m68000up },
{"eor.w",	one(0130500),	one(0170700), "Dd$s", m68000up },
{"eor.l",	one(0005200),	one(0177700), "#l$s", m68000up },
{"eor.l",	one(0005200),	one(0177700), "#lDs", mcf5200 },
{"eor.l",	one(0130600),	one(0170700), "Dd$s", m68000up | mcf5200 },
{"eor",		one(0005074),	one(0177777), "#bCs", m68000up },
{"eor",		one(0005174),	one(0177777), "#wSs", m68000up },
{"eor",		one(0005100),	one(0177700), "#w$s", m68000up },
{"eor",		one(0130500),	one(0170700), "Dd$s", m68000up },

{"exg",		one(0140500),	one(0170770), "DdDs", m68000up },
{"exg",		one(0140510),	one(0170770), "AdAs", m68000up },
{"exg",		one(0140610),	one(0170770), "DdAs", m68000up },
{"exg",		one(0140610),	one(0170770), "AsDd", m68000up },

{"ext.w",	one(0044200),	one(0177770), "Ds", m68000up|mcf5200 },
{"ext.l",	one(0044300),	one(0177770), "Ds", m68000up|mcf5200 },
{"extb.l",	one(0044700),	one(0177770), "Ds", m68020up|cpu32|mcf5200 },

/* float stuff starts here */

{"fabs.b",	two(0xF000, 0x5818), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fabs.d",	two(0xF000, 0x5418), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fabs.l",	two(0xF000, 0x4018), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fabs.p",	two(0xF000, 0x4C18), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fabs.s",	two(0xF000, 0x4418), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fabs.w",	two(0xF000, 0x5018), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fabs.x",	two(0xF000, 0x0018), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fabs.x",	two(0xF000, 0x4818), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fabs.x",	two(0xF000, 0x0018), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsabs.b",	two(0xF000, 0x5858), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsabs.d",	two(0xF000, 0x5458), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsabs.l",	two(0xF000, 0x4058), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsabs.p",	two(0xF000, 0x4C58), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsabs.s",	two(0xF000, 0x4458), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsabs.w",	two(0xF000, 0x5058), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsabs.x",	two(0xF000, 0x0058), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsabs.x",	two(0xF000, 0x4858), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsabs.x",	two(0xF000, 0x0058), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdabs.b",	two(0xF000, 0x585c), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up},
{"fdabs.d",	two(0xF000, 0x545c), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up},
{"fdabs.l",	two(0xF000, 0x405c), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up},
{"fdabs.p",	two(0xF000, 0x4C5c), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up},
{"fdabs.s",	two(0xF000, 0x445c), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up},
{"fdabs.w",	two(0xF000, 0x505c), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up},
{"fdabs.x",	two(0xF000, 0x005c), two(0xF1C0, 0xE07F), "IiF8F7", m68040up},
{"fdabs.x",	two(0xF000, 0x485c), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up},
{"fdabs.x",	two(0xF000, 0x005c), two(0xF1C0, 0xE07F), "IiFt",   m68040up},

{"facos.b",	two(0xF000, 0x581C), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"facos.d",	two(0xF000, 0x541C), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"facos.l",	two(0xF000, 0x401C), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"facos.p",	two(0xF000, 0x4C1C), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"facos.s",	two(0xF000, 0x441C), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"facos.w",	two(0xF000, 0x501C), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"facos.x",	two(0xF000, 0x001C), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"facos.x",	two(0xF000, 0x481C), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"facos.x",	two(0xF000, 0x001C), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fadd.b",	two(0xF000, 0x5822), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fadd.d",	two(0xF000, 0x5422), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fadd.l",	two(0xF000, 0x4022), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fadd.p",	two(0xF000, 0x4C22), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fadd.s",	two(0xF000, 0x4422), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fadd.w",	two(0xF000, 0x5022), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fadd.x",	two(0xF000, 0x0022), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fadd.x",	two(0xF000, 0x4822), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsadd.b",	two(0xF000, 0x5862), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsadd.d",	two(0xF000, 0x5462), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsadd.l",	two(0xF000, 0x4062), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsadd.p",	two(0xF000, 0x4C62), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsadd.s",	two(0xF000, 0x4462), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsadd.w",	two(0xF000, 0x5062), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsadd.x",	two(0xF000, 0x0062), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsadd.x",	two(0xF000, 0x4862), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fdadd.b",	two(0xF000, 0x5866), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdadd.d",	two(0xF000, 0x5466), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdadd.l",	two(0xF000, 0x4066), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdadd.p",	two(0xF000, 0x4C66), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdadd.s",	two(0xF000, 0x4466), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdadd.w",	two(0xF000, 0x5066), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdadd.x",	two(0xF000, 0x0066), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdadd.x",	two(0xF000, 0x4866), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fasin.b",	two(0xF000, 0x580C), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fasin.d",	two(0xF000, 0x540C), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fasin.l",	two(0xF000, 0x400C), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fasin.p",	two(0xF000, 0x4C0C), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fasin.s",	two(0xF000, 0x440C), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fasin.w",	two(0xF000, 0x500C), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fasin.x",	two(0xF000, 0x000C), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fasin.x",	two(0xF000, 0x480C), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fasin.x",	two(0xF000, 0x000C), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fatan.b",	two(0xF000, 0x580A), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fatan.d",	two(0xF000, 0x540A), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fatan.l",	two(0xF000, 0x400A), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fatan.p",	two(0xF000, 0x4C0A), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fatan.s",	two(0xF000, 0x440A), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fatan.w",	two(0xF000, 0x500A), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fatan.x",	two(0xF000, 0x000A), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fatan.x",	two(0xF000, 0x480A), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fatan.x",	two(0xF000, 0x000A), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fatanh.b",	two(0xF000, 0x580D), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fatanh.d",	two(0xF000, 0x540D), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fatanh.l",	two(0xF000, 0x400D), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fatanh.p",	two(0xF000, 0x4C0D), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fatanh.s",	two(0xF000, 0x440D), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fatanh.w",	two(0xF000, 0x500D), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fatanh.x",	two(0xF000, 0x000D), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fatanh.x",	two(0xF000, 0x480D), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fatanh.x",	two(0xF000, 0x000D), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fbeq",	one(0xF081),		one(0xF1FF), "IdBW", mfloat },
{"fbf",		one(0xF080),		one(0xF1FF), "IdBW", mfloat },
{"fbge",	one(0xF093),		one(0xF1FF), "IdBW", mfloat },
{"fbgl",	one(0xF096),		one(0xF1FF), "IdBW", mfloat },
{"fbgle",	one(0xF097),		one(0xF1FF), "IdBW", mfloat },
{"fbgt",	one(0xF092),		one(0xF1FF), "IdBW", mfloat },
{"fble",	one(0xF095),		one(0xF1FF), "IdBW", mfloat },
{"fblt",	one(0xF094),		one(0xF1FF), "IdBW", mfloat },
{"fbne",	one(0xF08E),		one(0xF1FF), "IdBW", mfloat },
{"fbnge",	one(0xF09C),		one(0xF1FF), "IdBW", mfloat },
{"fbngl",	one(0xF099),		one(0xF1FF), "IdBW", mfloat },
{"fbngle",	one(0xF098),		one(0xF1FF), "IdBW", mfloat },
{"fbngt",	one(0xF09D),		one(0xF1FF), "IdBW", mfloat },
{"fbnle",	one(0xF09A),		one(0xF1FF), "IdBW", mfloat },
{"fbnlt",	one(0xF09B),		one(0xF1FF), "IdBW", mfloat },
{"fboge",	one(0xF083),		one(0xF1FF), "IdBW", mfloat },
{"fbogl",	one(0xF086),		one(0xF1FF), "IdBW", mfloat },
{"fbogt",	one(0xF082),		one(0xF1FF), "IdBW", mfloat },
{"fbole",	one(0xF085),		one(0xF1FF), "IdBW", mfloat },
{"fbolt",	one(0xF084),		one(0xF1FF), "IdBW", mfloat },
{"fbor",	one(0xF087),		one(0xF1FF), "IdBW", mfloat },
{"fbseq",	one(0xF091),		one(0xF1FF), "IdBW", mfloat },
{"fbsf",	one(0xF090),		one(0xF1FF), "IdBW", mfloat },
{"fbsne",	one(0xF09E),		one(0xF1FF), "IdBW", mfloat },
{"fbst",	one(0xF09F),		one(0xF1FF), "IdBW", mfloat },
{"fbt",		one(0xF08F),		one(0xF1FF), "IdBW", mfloat },
{"fbueq",	one(0xF089),		one(0xF1FF), "IdBW", mfloat },
{"fbuge",	one(0xF08B),		one(0xF1FF), "IdBW", mfloat },
{"fbugt",	one(0xF08A),		one(0xF1FF), "IdBW", mfloat },
{"fbule",	one(0xF08D),		one(0xF1FF), "IdBW", mfloat },
{"fbult",	one(0xF08C),		one(0xF1FF), "IdBW", mfloat },
{"fbun",	one(0xF088),		one(0xF1FF), "IdBW", mfloat },

{"fbeq.l",	one(0xF0C1),		one(0xF1FF), "IdBC", mfloat },
{"fbf.l",	one(0xF0C0),		one(0xF1FF), "IdBC", mfloat },
{"fbge.l",	one(0xF0D3),		one(0xF1FF), "IdBC", mfloat },
{"fbgl.l",	one(0xF0D6),		one(0xF1FF), "IdBC", mfloat },
{"fbgle.l",	one(0xF0D7),		one(0xF1FF), "IdBC", mfloat },
{"fbgt.l",	one(0xF0D2),		one(0xF1FF), "IdBC", mfloat },
{"fble.l",	one(0xF0D5),		one(0xF1FF), "IdBC", mfloat },
{"fblt.l",	one(0xF0D4),		one(0xF1FF), "IdBC", mfloat },
{"fbne.l",	one(0xF0CE),		one(0xF1FF), "IdBC", mfloat },
{"fbnge.l",	one(0xF0DC),		one(0xF1FF), "IdBC", mfloat },
{"fbngl.l",	one(0xF0D9),		one(0xF1FF), "IdBC", mfloat },
{"fbngle.l",	one(0xF0D8),		one(0xF1FF), "IdBC", mfloat },
{"fbngt.l",	one(0xF0DD),		one(0xF1FF), "IdBC", mfloat },
{"fbnle.l",	one(0xF0DA),		one(0xF1FF), "IdBC", mfloat },
{"fbnlt.l",	one(0xF0DB),		one(0xF1FF), "IdBC", mfloat },
{"fboge.l",	one(0xF0C3),		one(0xF1FF), "IdBC", mfloat },
{"fbogl.l",	one(0xF0C6),		one(0xF1FF), "IdBC", mfloat },
{"fbogt.l",	one(0xF0C2),		one(0xF1FF), "IdBC", mfloat },
{"fbole.l",	one(0xF0C5),		one(0xF1FF), "IdBC", mfloat },
{"fbolt.l",	one(0xF0C4),		one(0xF1FF), "IdBC", mfloat },
{"fbor.l",	one(0xF0C7),		one(0xF1FF), "IdBC", mfloat },
{"fbseq.l",	one(0xF0D1),		one(0xF1FF), "IdBC", mfloat },
{"fbsf.l",	one(0xF0D0),		one(0xF1FF), "IdBC", mfloat },
{"fbsne.l",	one(0xF0DE),		one(0xF1FF), "IdBC", mfloat },
{"fbst.l",	one(0xF0DF),		one(0xF1FF), "IdBC", mfloat },
{"fbt.l",	one(0xF0CF),		one(0xF1FF), "IdBC", mfloat },
{"fbueq.l",	one(0xF0C9),		one(0xF1FF), "IdBC", mfloat },
{"fbuge.l",	one(0xF0CB),		one(0xF1FF), "IdBC", mfloat },
{"fbugt.l",	one(0xF0CA),		one(0xF1FF), "IdBC", mfloat },
{"fbule.l",	one(0xF0CD),		one(0xF1FF), "IdBC", mfloat },
{"fbult.l",	one(0xF0CC),		one(0xF1FF), "IdBC", mfloat },
{"fbun.l",	one(0xF0C8),		one(0xF1FF), "IdBC", mfloat },

{"fjeq",	one(0xF081),		one(0xF1BF), "IdBc", mfloat },
{"fjf",		one(0xF080),		one(0xF1BF), "IdBc", mfloat },
{"fjge",	one(0xF093),		one(0xF1BF), "IdBc", mfloat },
{"fjgl",	one(0xF096),		one(0xF1BF), "IdBc", mfloat },
{"fjgle",	one(0xF097),		one(0xF1BF), "IdBc", mfloat },
{"fjgt",	one(0xF092),		one(0xF1BF), "IdBc", mfloat },
{"fjle",	one(0xF095),		one(0xF1BF), "IdBc", mfloat },
{"fjlt",	one(0xF094),		one(0xF1BF), "IdBc", mfloat },
{"fjne",	one(0xF08E),		one(0xF1BF), "IdBc", mfloat },
{"fjnge",	one(0xF09C),		one(0xF1BF), "IdBc", mfloat },
{"fjngl",	one(0xF099),		one(0xF1BF), "IdBc", mfloat },
{"fjngle",	one(0xF098),		one(0xF1BF), "IdBc", mfloat },
{"fjngt",	one(0xF09D),		one(0xF1BF), "IdBc", mfloat },
{"fjnle",	one(0xF09A),		one(0xF1BF), "IdBc", mfloat },
{"fjnlt",	one(0xF09B),		one(0xF1BF), "IdBc", mfloat },
{"fjoge",	one(0xF083),		one(0xF1BF), "IdBc", mfloat },
{"fjogl",	one(0xF086),		one(0xF1BF), "IdBc", mfloat },
{"fjogt",	one(0xF082),		one(0xF1BF), "IdBc", mfloat },
{"fjole",	one(0xF085),		one(0xF1BF), "IdBc", mfloat },
{"fjolt",	one(0xF084),		one(0xF1BF), "IdBc", mfloat },
{"fjor",	one(0xF087),		one(0xF1BF), "IdBc", mfloat },
{"fjseq",	one(0xF091),		one(0xF1BF), "IdBc", mfloat },
{"fjsf",	one(0xF090),		one(0xF1BF), "IdBc", mfloat },
{"fjsne",	one(0xF09E),		one(0xF1BF), "IdBc", mfloat },
{"fjst",	one(0xF09F),		one(0xF1BF), "IdBc", mfloat },
{"fjt",		one(0xF08F),		one(0xF1BF), "IdBc", mfloat },
{"fjueq",	one(0xF089),		one(0xF1BF), "IdBc", mfloat },
{"fjuge",	one(0xF08B),		one(0xF1BF), "IdBc", mfloat },
{"fjugt",	one(0xF08A),		one(0xF1BF), "IdBc", mfloat },
{"fjule",	one(0xF08D),		one(0xF1BF), "IdBc", mfloat },
{"fjult",	one(0xF08C),		one(0xF1BF), "IdBc", mfloat },
{"fjun",	one(0xF088),		one(0xF1BF), "IdBc", mfloat },

{"fcmp.b",	two(0xF000, 0x5838), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcmp.d",	two(0xF000, 0x5438), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcmp.l",	two(0xF000, 0x4038), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcmp.p",	two(0xF000, 0x4C38), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcmp.s",	two(0xF000, 0x4438), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcmp.w",	two(0xF000, 0x5038), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcmp.x",	two(0xF000, 0x0038), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcmp.x",	two(0xF000, 0x4838), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fcos.b",	two(0xF000, 0x581D), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcos.d",	two(0xF000, 0x541D), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcos.l",	two(0xF000, 0x401D), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcos.p",	two(0xF000, 0x4C1D), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcos.s",	two(0xF000, 0x441D), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcos.w",	two(0xF000, 0x501D), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcos.x",	two(0xF000, 0x001D), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcos.x",	two(0xF000, 0x481D), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fcos.x",	two(0xF000, 0x001D), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fcosh.b",	two(0xF000, 0x5819), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcosh.d",	two(0xF000, 0x5419), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcosh.l",	two(0xF000, 0x4019), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcosh.p",	two(0xF000, 0x4C19), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcosh.s",	two(0xF000, 0x4419), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcosh.w",	two(0xF000, 0x5019), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcosh.x",	two(0xF000, 0x0019), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcosh.x",	two(0xF000, 0x4819), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fcosh.x",	two(0xF000, 0x0019), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fdbeq",	two(0xF048, 0x0001), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbf",	two(0xF048, 0x0000), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbge",	two(0xF048, 0x0013), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgl",	two(0xF048, 0x0016), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgle",	two(0xF048, 0x0017), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgt",	two(0xF048, 0x0012), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdble",	two(0xF048, 0x0015), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdblt",	two(0xF048, 0x0014), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbne",	two(0xF048, 0x000E), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnge",	two(0xF048, 0x001C), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngl",	two(0xF048, 0x0019), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngle",	two(0xF048, 0x0018), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngt",	two(0xF048, 0x001D), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnle",	two(0xF048, 0x001A), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnlt",	two(0xF048, 0x001B), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdboge",	two(0xF048, 0x0003), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbogl",	two(0xF048, 0x0006), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbogt",	two(0xF048, 0x0002), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbole",	two(0xF048, 0x0005), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbolt",	two(0xF048, 0x0004), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbor",	two(0xF048, 0x0007), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbseq",	two(0xF048, 0x0011), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbsf",	two(0xF048, 0x0010), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbsne",	two(0xF048, 0x001E), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbst",	two(0xF048, 0x001F), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbt",	two(0xF048, 0x000F), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbueq",	two(0xF048, 0x0009), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbuge",	two(0xF048, 0x000B), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbugt",	two(0xF048, 0x000A), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbule",	two(0xF048, 0x000D), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbult",	two(0xF048, 0x000C), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbun",	two(0xF048, 0x0008), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },

{"fdiv.b",	two(0xF000, 0x5820), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fdiv.d",	two(0xF000, 0x5420), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fdiv.l",	two(0xF000, 0x4020), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fdiv.p",	two(0xF000, 0x4C20), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fdiv.s",	two(0xF000, 0x4420), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fdiv.w",	two(0xF000, 0x5020), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fdiv.x",	two(0xF000, 0x0020), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fdiv.x",	two(0xF000, 0x4820), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsdiv.b",	two(0xF000, 0x5860), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsdiv.d",	two(0xF000, 0x5460), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsdiv.l",	two(0xF000, 0x4060), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsdiv.p",	two(0xF000, 0x4C60), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsdiv.s",	two(0xF000, 0x4460), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsdiv.w",	two(0xF000, 0x5060), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsdiv.x",	two(0xF000, 0x0060), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsdiv.x",	two(0xF000, 0x4860), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fddiv.b",	two(0xF000, 0x5864), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fddiv.d",	two(0xF000, 0x5464), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fddiv.l",	two(0xF000, 0x4064), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fddiv.p",	two(0xF000, 0x4C64), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fddiv.s",	two(0xF000, 0x4464), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fddiv.w",	two(0xF000, 0x5064), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fddiv.x",	two(0xF000, 0x0064), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fddiv.x",	two(0xF000, 0x4864), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fetox.b",	two(0xF000, 0x5810), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fetox.d",	two(0xF000, 0x5410), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fetox.l",	two(0xF000, 0x4010), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fetox.p",	two(0xF000, 0x4C10), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fetox.s",	two(0xF000, 0x4410), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fetox.w",	two(0xF000, 0x5010), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fetox.x",	two(0xF000, 0x0010), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fetox.x",	two(0xF000, 0x4810), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fetox.x",	two(0xF000, 0x0010), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fetoxm1.b",	two(0xF000, 0x5808), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fetoxm1.d",	two(0xF000, 0x5408), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fetoxm1.l",	two(0xF000, 0x4008), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fetoxm1.p",	two(0xF000, 0x4C08), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fetoxm1.s",	two(0xF000, 0x4408), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fetoxm1.w",	two(0xF000, 0x5008), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fetoxm1.x",	two(0xF000, 0x0008), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fetoxm1.x",	two(0xF000, 0x4808), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fetoxm1.x",	two(0xF000, 0x0008), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fgetexp.b",	two(0xF000, 0x581E), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fgetexp.d",	two(0xF000, 0x541E), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fgetexp.l",	two(0xF000, 0x401E), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fgetexp.p",	two(0xF000, 0x4C1E), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fgetexp.s",	two(0xF000, 0x441E), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fgetexp.w",	two(0xF000, 0x501E), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fgetexp.x",	two(0xF000, 0x001E), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fgetexp.x",	two(0xF000, 0x481E), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fgetexp.x",	two(0xF000, 0x001E), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fgetman.b",	two(0xF000, 0x581F), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fgetman.d",	two(0xF000, 0x541F), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fgetman.l",	two(0xF000, 0x401F), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fgetman.p",	two(0xF000, 0x4C1F), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fgetman.s",	two(0xF000, 0x441F), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fgetman.w",	two(0xF000, 0x501F), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fgetman.x",	two(0xF000, 0x001F), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fgetman.x",	two(0xF000, 0x481F), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fgetman.x",	two(0xF000, 0x001F), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fint.b",	two(0xF000, 0x5801), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fint.d",	two(0xF000, 0x5401), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fint.l",	two(0xF000, 0x4001), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fint.p",	two(0xF000, 0x4C01), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fint.s",	two(0xF000, 0x4401), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fint.w",	two(0xF000, 0x5001), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fint.x",	two(0xF000, 0x0001), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fint.x",	two(0xF000, 0x4801), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fint.x",	two(0xF000, 0x0001), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fintrz.b",	two(0xF000, 0x5803), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fintrz.d",	two(0xF000, 0x5403), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fintrz.l",	two(0xF000, 0x4003), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fintrz.p",	two(0xF000, 0x4C03), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fintrz.s",	two(0xF000, 0x4403), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fintrz.w",	two(0xF000, 0x5003), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fintrz.x",	two(0xF000, 0x0003), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fintrz.x",	two(0xF000, 0x4803), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fintrz.x",	two(0xF000, 0x0003), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flog10.b",	two(0xF000, 0x5815), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flog10.d",	two(0xF000, 0x5415), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flog10.l",	two(0xF000, 0x4015), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flog10.p",	two(0xF000, 0x4C15), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flog10.s",	two(0xF000, 0x4415), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flog10.w",	two(0xF000, 0x5015), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flog10.x",	two(0xF000, 0x0015), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flog10.x",	two(0xF000, 0x4815), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flog10.x",	two(0xF000, 0x0015), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flog2.b",	two(0xF000, 0x5816), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flog2.d",	two(0xF000, 0x5416), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flog2.l",	two(0xF000, 0x4016), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flog2.p",	two(0xF000, 0x4C16), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flog2.s",	two(0xF000, 0x4416), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flog2.w",	two(0xF000, 0x5016), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flog2.x",	two(0xF000, 0x0016), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flog2.x",	two(0xF000, 0x4816), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flog2.x",	two(0xF000, 0x0016), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flogn.b",	two(0xF000, 0x5814), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flogn.d",	two(0xF000, 0x5414), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flogn.l",	two(0xF000, 0x4014), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flogn.p",	two(0xF000, 0x4C14), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flogn.s",	two(0xF000, 0x4414), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flogn.w",	two(0xF000, 0x5014), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flogn.x",	two(0xF000, 0x0014), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flogn.x",	two(0xF000, 0x4814), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flogn.x",	two(0xF000, 0x0014), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flognp1.b",	two(0xF000, 0x5806), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flognp1.d",	two(0xF000, 0x5406), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flognp1.l",	two(0xF000, 0x4006), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flognp1.p",	two(0xF000, 0x4C06), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flognp1.s",	two(0xF000, 0x4406), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flognp1.w",	two(0xF000, 0x5006), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flognp1.x",	two(0xF000, 0x0006), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flognp1.x",	two(0xF000, 0x4806), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flognp1.x",	two(0xF000, 0x0006), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fmod.b",	two(0xF000, 0x5821), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmod.d",	two(0xF000, 0x5421), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmod.l",	two(0xF000, 0x4021), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmod.p",	two(0xF000, 0x4C21), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmod.s",	two(0xF000, 0x4421), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmod.w",	two(0xF000, 0x5021), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmod.x",	two(0xF000, 0x0021), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fmod.x",	two(0xF000, 0x4821), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fmove.b",	two(0xF000, 0x5800), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmove.b",	two(0xF000, 0x7800), two(0xF1C0, 0xFC7F), "IiF7$b", mfloat },
{"fmove.d",	two(0xF000, 0x5400), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmove.d",	two(0xF000, 0x7400), two(0xF1C0, 0xFC7F), "IiF7~F", mfloat },
{"fmove.l",	two(0xF000, 0x4000), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmove.l",	two(0xF000, 0x6000), two(0xF1C0, 0xFC7F), "IiF7$l", mfloat },
/* FIXME: the next two variants should not permit moving an address
   register to anything but the floating point instruction register.  */
{"fmove.l",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmove.l",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*ls8", mfloat },
{"fmove.p",	two(0xF000, 0x4C00), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmove.p",	two(0xF000, 0x6C00), two(0xF1C0, 0xFC00), "IiF7~pkC", mfloat },
{"fmove.p",	two(0xF000, 0x7C00), two(0xF1C0, 0xFC0F), "IiF7~pDk", mfloat },
{"fmove.s",	two(0xF000, 0x4400), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmove.s",	two(0xF000, 0x6400), two(0xF1C0, 0xFC7F), "IiF7$f", mfloat },
{"fmove.w",	two(0xF000, 0x5000), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmove.w",	two(0xF000, 0x7000), two(0xF1C0, 0xFC7F), "IiF7$w", mfloat },
{"fmove.x",	two(0xF000, 0x0000), two(0xF1FF, 0xE07F), "IiF8F7", mfloat },
{"fmove.x",	two(0xF000, 0x4800), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fmove.x",	two(0xF000, 0x6800), two(0xF1C0, 0xFC7F), "IiF7~x", mfloat },

{"fsmove.b",	two(0xF000, 0x5840), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsmove.d",	two(0xF000, 0x5440), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsmove.l",	two(0xF000, 0x4040), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsmove.s",	two(0xF000, 0x4440), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsmove.w",	two(0xF000, 0x5040), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsmove.x",	two(0xF000, 0x0040), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsmove.x",	two(0xF000, 0x4840), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsmove.p",	two(0xF000, 0x4C40), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },

{"fdmove.b",	two(0xF000, 0x5844), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdmove.d",	two(0xF000, 0x5444), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdmove.l",	two(0xF000, 0x4044), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdmove.s",	two(0xF000, 0x4444), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdmove.w",	two(0xF000, 0x5044), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdmove.x",	two(0xF000, 0x0044), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdmove.x",	two(0xF000, 0x4844), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdmove.p",	two(0xF000, 0x4C44), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },

{"fmovecr.x",	two(0xF000, 0x5C00), two(0xF1FF, 0xFC00), "Ii#CF7", mfloat },

{"fmovem.x",	two(0xF000, 0xF800), two(0xF1C0, 0xFF8F), "IiDk&s", mfloat },
{"fmovem.x",	two(0xF020, 0xE800), two(0xF1F8, 0xFF8F), "IiDk-s", mfloat },
{"fmovem.x",	two(0xF000, 0xD800), two(0xF1C0, 0xFF8F), "Ii&sDk", mfloat },
{"fmovem.x",	two(0xF018, 0xD800), two(0xF1F8, 0xFF8F), "Ii+sDk", mfloat },
{"fmovem.x",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Idl3&s", mfloat },
{"fmovem.x",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Id#3&s", mfloat },
{"fmovem.x",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&sl3", mfloat },
{"fmovem.x",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&s#3", mfloat },
{"fmovem.x",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "IdL3-s", mfloat },
{"fmovem.x",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "Id#3-s", mfloat },
{"fmovem.x",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+sl3", mfloat },
{"fmovem.x",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+s#3", mfloat },

{"fmovem.l",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmovem.l",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "IiL8~s", mfloat },
/* FIXME: In the next instruction, we should only permit %dn if the
   target is a single register.  We should only permit %an if the
   target is a single %fpiar.  */
{"fmovem.l",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*lL8", mfloat },

{"fmovem",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "IdL3-s", mfloat },
{"fmovem",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Idl3&s", mfloat },
{"fmovem",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+sl3", mfloat },
{"fmovem",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&sl3", mfloat },
{"fmovem",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "Id#3-s", mfloat },
{"fmovem",	two(0xF020, 0xE800), two(0xF1F8, 0xFF8F), "IiDk-s", mfloat },
{"fmovem",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Id#3&s", mfloat },
{"fmovem",	two(0xF000, 0xF800), two(0xF1C0, 0xFF8F), "IiDk&s", mfloat },
{"fmovem",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+s#3", mfloat },
{"fmovem",	two(0xF018, 0xD800), two(0xF1F8, 0xFF8F), "Ii+sDk", mfloat },
{"fmovem",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&s#3", mfloat },
{"fmovem",	two(0xF000, 0xD800), two(0xF1C0, 0xFF8F), "Ii&sDk", mfloat },
{"fmovem",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmovem",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*ss8", mfloat },
{"fmovem",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "IiL8~s", mfloat },
{"fmovem",	two(0xF000, 0x8000), two(0xF2C0, 0xE3FF), "Ii*sL8", mfloat },

{"fmul.b",	two(0xF000, 0x5823), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmul.d",	two(0xF000, 0x5423), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmul.l",	two(0xF000, 0x4023), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmul.p",	two(0xF000, 0x4C23), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmul.s",	two(0xF000, 0x4423), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmul.w",	two(0xF000, 0x5023), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmul.x",	two(0xF000, 0x0023), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fmul.x",	two(0xF000, 0x4823), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsmul.b",	two(0xF000, 0x5863), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsmul.d",	two(0xF000, 0x5463), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsmul.l",	two(0xF000, 0x4063), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsmul.p",	two(0xF000, 0x4C63), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsmul.s",	two(0xF000, 0x4463), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsmul.w",	two(0xF000, 0x5063), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsmul.x",	two(0xF000, 0x0063), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsmul.x",	two(0xF000, 0x4863), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fdmul.b",	two(0xF000, 0x5867), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdmul.d",	two(0xF000, 0x5467), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdmul.l",	two(0xF000, 0x4067), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdmul.p",	two(0xF000, 0x4C67), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdmul.s",	two(0xF000, 0x4467), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdmul.w",	two(0xF000, 0x5067), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdmul.x",	two(0xF000, 0x0067), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdmul.x",	two(0xF000, 0x4867), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fneg.b",	two(0xF000, 0x581A), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fneg.d",	two(0xF000, 0x541A), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fneg.l",	two(0xF000, 0x401A), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fneg.p",	two(0xF000, 0x4C1A), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fneg.s",	two(0xF000, 0x441A), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fneg.w",	two(0xF000, 0x501A), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fneg.x",	two(0xF000, 0x001A), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fneg.x",	two(0xF000, 0x481A), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fneg.x",	two(0xF000, 0x001A), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsneg.b",	two(0xF000, 0x585A), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsneg.d",	two(0xF000, 0x545A), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsneg.l",	two(0xF000, 0x405A), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsneg.p",	two(0xF000, 0x4C5A), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsneg.s",	two(0xF000, 0x445A), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsneg.w",	two(0xF000, 0x505A), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsneg.x",	two(0xF000, 0x005A), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsneg.x",	two(0xF000, 0x485A), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsneg.x",	two(0xF000, 0x005A), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdneg.b",	two(0xF000, 0x585E), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdneg.d",	two(0xF000, 0x545E), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdneg.l",	two(0xF000, 0x405E), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdneg.p",	two(0xF000, 0x4C5E), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdneg.s",	two(0xF000, 0x445E), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdneg.w",	two(0xF000, 0x505E), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdneg.x",	two(0xF000, 0x005E), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdneg.x",	two(0xF000, 0x485E), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdneg.x",	two(0xF000, 0x005E), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fnop",	two(0xF280, 0x0000), two(0xFFFF, 0xFFFF), "Ii", mfloat },

{"frem.b",	two(0xF000, 0x5825), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"frem.d",	two(0xF000, 0x5425), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"frem.l",	two(0xF000, 0x4025), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"frem.p",	two(0xF000, 0x4C25), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"frem.s",	two(0xF000, 0x4425), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"frem.w",	two(0xF000, 0x5025), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"frem.x",	two(0xF000, 0x0025), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"frem.x",	two(0xF000, 0x4825), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"frestore",	one(0xF140),		one(0xF1C0), "Id<s", mfloat },

{"fsave",	one(0xF100),		one(0xF1C0), "Id>s", mfloat },

{"fscale.b",	two(0xF000, 0x5826), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fscale.d",	two(0xF000, 0x5426), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fscale.l",	two(0xF000, 0x4026), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fscale.p",	two(0xF000, 0x4C26), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fscale.s",	two(0xF000, 0x4426), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fscale.w",	two(0xF000, 0x5026), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fscale.x",	two(0xF000, 0x0026), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fscale.x",	two(0xF000, 0x4826), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

/* $ is necessary to prevent the assembler from using PC-relative.
   If @ were used, "label: fseq label" could produce "ftrapeq",
   because "label" became "pc@label".  */
{"fseq",	two(0xF040, 0x0001), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsf",		two(0xF040, 0x0000), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsge",	two(0xF040, 0x0013), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgl",	two(0xF040, 0x0016), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgle",	two(0xF040, 0x0017), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgt",	two(0xF040, 0x0012), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsle",	two(0xF040, 0x0015), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fslt",	two(0xF040, 0x0014), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsne",	two(0xF040, 0x000E), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnge",	two(0xF040, 0x001C), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngl",	two(0xF040, 0x0019), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngle",	two(0xF040, 0x0018), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngt",	two(0xF040, 0x001D), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnle",	two(0xF040, 0x001A), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnlt",	two(0xF040, 0x001B), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsoge",	two(0xF040, 0x0003), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsogl",	two(0xF040, 0x0006), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsogt",	two(0xF040, 0x0002), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsole",	two(0xF040, 0x0005), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsolt",	two(0xF040, 0x0004), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsor",	two(0xF040, 0x0007), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsseq",	two(0xF040, 0x0011), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fssf",	two(0xF040, 0x0010), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fssne",	two(0xF040, 0x001E), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsst",	two(0xF040, 0x001F), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fst",		two(0xF040, 0x000F), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsueq",	two(0xF040, 0x0009), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsuge",	two(0xF040, 0x000B), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsugt",	two(0xF040, 0x000A), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsule",	two(0xF040, 0x000D), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsult",	two(0xF040, 0x000C), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsun",	two(0xF040, 0x0008), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },

{"fsgldiv.b",	two(0xF000, 0x5824), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsgldiv.d",	two(0xF000, 0x5424), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsgldiv.l",	two(0xF000, 0x4024), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsgldiv.p",	two(0xF000, 0x4C24), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsgldiv.s",	two(0xF000, 0x4424), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsgldiv.w",	two(0xF000, 0x5024), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsgldiv.x",	two(0xF000, 0x0024), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsgldiv.x",	two(0xF000, 0x4824), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsgldiv.x",	two(0xF000, 0x0024), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsglmul.b",	two(0xF000, 0x5827), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsglmul.d",	two(0xF000, 0x5427), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsglmul.l",	two(0xF000, 0x4027), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsglmul.p",	two(0xF000, 0x4C27), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsglmul.s",	two(0xF000, 0x4427), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsglmul.w",	two(0xF000, 0x5027), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsglmul.x",	two(0xF000, 0x0027), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsglmul.x",	two(0xF000, 0x4827), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsglmul.x",	two(0xF000, 0x0027), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsin.b",	two(0xF000, 0x580E), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsin.d",	two(0xF000, 0x540E), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsin.l",	two(0xF000, 0x400E), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsin.p",	two(0xF000, 0x4C0E), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsin.s",	two(0xF000, 0x440E), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsin.w",	two(0xF000, 0x500E), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsin.x",	two(0xF000, 0x000E), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsin.x",	two(0xF000, 0x480E), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsin.x",	two(0xF000, 0x000E), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsincos.b",	two(0xF000, 0x5830), two(0xF1C0, 0xFC78), "Ii;bF3F7", mfloat },
{"fsincos.d",	two(0xF000, 0x5430), two(0xF1C0, 0xFC78), "Ii;FF3F7", mfloat },
{"fsincos.l",	two(0xF000, 0x4030), two(0xF1C0, 0xFC78), "Ii;lF3F7", mfloat },
{"fsincos.p",	two(0xF000, 0x4C30), two(0xF1C0, 0xFC78), "Ii;pF3F7", mfloat },
{"fsincos.s",	two(0xF000, 0x4430), two(0xF1C0, 0xFC78), "Ii;fF3F7", mfloat },
{"fsincos.w",	two(0xF000, 0x5030), two(0xF1C0, 0xFC78), "Ii;wF3F7", mfloat },
{"fsincos.x",	two(0xF000, 0x0030), two(0xF1C0, 0xE078), "IiF8F3F7", mfloat },
{"fsincos.x",	two(0xF000, 0x4830), two(0xF1C0, 0xFC78), "Ii;xF3F7", mfloat },

{"fsinh.b",	two(0xF000, 0x5802), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsinh.d",	two(0xF000, 0x5402), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsinh.l",	two(0xF000, 0x4002), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsinh.p",	two(0xF000, 0x4C02), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsinh.s",	two(0xF000, 0x4402), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsinh.w",	two(0xF000, 0x5002), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsinh.x",	two(0xF000, 0x0002), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsinh.x",	two(0xF000, 0x4802), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsinh.x",	two(0xF000, 0x0002), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsqrt.b",	two(0xF000, 0x5804), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsqrt.d",	two(0xF000, 0x5404), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsqrt.l",	two(0xF000, 0x4004), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsqrt.p",	two(0xF000, 0x4C04), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsqrt.s",	two(0xF000, 0x4404), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsqrt.w",	two(0xF000, 0x5004), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsqrt.x",	two(0xF000, 0x0004), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsqrt.x",	two(0xF000, 0x4804), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsqrt.x",	two(0xF000, 0x0004), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fssqrt.b",	two(0xF000, 0x5841), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fssqrt.d",	two(0xF000, 0x5441), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fssqrt.l",	two(0xF000, 0x4041), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fssqrt.p",	two(0xF000, 0x4C41), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fssqrt.s",	two(0xF000, 0x4441), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fssqrt.w",	two(0xF000, 0x5041), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fssqrt.x",	two(0xF000, 0x0041), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fssqrt.x",	two(0xF000, 0x4841), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fssqrt.x",	two(0xF000, 0x0041), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdsqrt.b",	two(0xF000, 0x5845), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdsqrt.d",	two(0xF000, 0x5445), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdsqrt.l",	two(0xF000, 0x4045), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdsqrt.p",	two(0xF000, 0x4C45), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdsqrt.s",	two(0xF000, 0x4445), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdsqrt.w",	two(0xF000, 0x5045), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdsqrt.x",	two(0xF000, 0x0045), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdsqrt.x",	two(0xF000, 0x4845), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdsqrt.x",	two(0xF000, 0x0045), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fsub.b",	two(0xF000, 0x5828), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsub.d",	two(0xF000, 0x5428), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsub.l",	two(0xF000, 0x4028), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsub.p",	two(0xF000, 0x4C28), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsub.s",	two(0xF000, 0x4428), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsub.w",	two(0xF000, 0x5028), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsub.x",	two(0xF000, 0x0028), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsub.x",	two(0xF000, 0x4828), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsub.x",	two(0xF000, 0x0028), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fssub.b",	two(0xF000, 0x5868), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fssub.d",	two(0xF000, 0x5468), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fssub.l",	two(0xF000, 0x4068), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fssub.p",	two(0xF000, 0x4C68), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fssub.s",	two(0xF000, 0x4468), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fssub.w",	two(0xF000, 0x5068), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fssub.x",	two(0xF000, 0x0068), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fssub.x",	two(0xF000, 0x4868), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fssub.x",	two(0xF000, 0x0068), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdsub.b",	two(0xF000, 0x586c), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdsub.d",	two(0xF000, 0x546c), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdsub.l",	two(0xF000, 0x406c), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdsub.p",	two(0xF000, 0x4C6c), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdsub.s",	two(0xF000, 0x446c), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdsub.w",	two(0xF000, 0x506c), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdsub.x",	two(0xF000, 0x006c), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdsub.x",	two(0xF000, 0x486c), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdsub.x",	two(0xF000, 0x006c), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"ftan.b",	two(0xF000, 0x580F), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftan.d",	two(0xF000, 0x540F), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftan.l",	two(0xF000, 0x400F), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftan.p",	two(0xF000, 0x4C0F), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftan.s",	two(0xF000, 0x440F), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftan.w",	two(0xF000, 0x500F), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftan.x",	two(0xF000, 0x000F), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftan.x",	two(0xF000, 0x480F), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftan.x",	two(0xF000, 0x000F), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftanh.b",	two(0xF000, 0x5809), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftanh.d",	two(0xF000, 0x5409), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftanh.l",	two(0xF000, 0x4009), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftanh.p",	two(0xF000, 0x4C09), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftanh.s",	two(0xF000, 0x4409), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftanh.w",	two(0xF000, 0x5009), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftanh.x",	two(0xF000, 0x0009), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftanh.x",	two(0xF000, 0x4809), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftanh.x",	two(0xF000, 0x0009), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftentox.b",	two(0xF000, 0x5812), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftentox.d",	two(0xF000, 0x5412), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftentox.l",	two(0xF000, 0x4012), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftentox.p",	two(0xF000, 0x4C12), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftentox.s",	two(0xF000, 0x4412), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftentox.w",	two(0xF000, 0x5012), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftentox.x",	two(0xF000, 0x0012), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftentox.x",	two(0xF000, 0x4812), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftentox.x",	two(0xF000, 0x0012), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftrapeq",	two(0xF07C, 0x0001), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapf",	two(0xF07C, 0x0000), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapge",	two(0xF07C, 0x0013), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgl",	two(0xF07C, 0x0016), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgle",	two(0xF07C, 0x0017), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgt",	two(0xF07C, 0x0012), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftraple",	two(0xF07C, 0x0015), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftraplt",	two(0xF07C, 0x0014), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapne",	two(0xF07C, 0x000E), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnge",	two(0xF07C, 0x001C), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngl",	two(0xF07C, 0x0019), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngle",	two(0xF07C, 0x0018), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngt",	two(0xF07C, 0x001D), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnle",	two(0xF07C, 0x001A), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnlt",	two(0xF07C, 0x001B), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapoge",	two(0xF07C, 0x0003), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapogl",	two(0xF07C, 0x0006), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapogt",	two(0xF07C, 0x0002), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapole",	two(0xF07C, 0x0005), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapolt",	two(0xF07C, 0x0004), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapor",	two(0xF07C, 0x0007), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapseq",	two(0xF07C, 0x0011), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapsf",	two(0xF07C, 0x0010), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapsne",	two(0xF07C, 0x001E), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapst",	two(0xF07C, 0x001F), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapt",	two(0xF07C, 0x000F), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapueq",	two(0xF07C, 0x0009), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapuge",	two(0xF07C, 0x000B), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapugt",	two(0xF07C, 0x000A), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapule",	two(0xF07C, 0x000D), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapult",	two(0xF07C, 0x000C), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapun",	two(0xF07C, 0x0008), two(0xF1FF, 0xFFFF), "Ii", mfloat },
        
{"ftrapeq.w",	two(0xF07A, 0x0001), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapf.w",	two(0xF07A, 0x0000), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapge.w",	two(0xF07A, 0x0013), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapgl.w",	two(0xF07A, 0x0016), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapgle.w",	two(0xF07A, 0x0017), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapgt.w",	two(0xF07A, 0x0012), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftraple.w",	two(0xF07A, 0x0015), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftraplt.w",	two(0xF07A, 0x0014), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapne.w",	two(0xF07A, 0x000E), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnge.w",	two(0xF07A, 0x001C), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapngl.w",	two(0xF07A, 0x0019), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapngle.w",	two(0xF07A, 0x0018), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapngt.w",	two(0xF07A, 0x001D), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnle.w",	two(0xF07A, 0x001A), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnlt.w",	two(0xF07A, 0x001B), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapoge.w",	two(0xF07A, 0x0003), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapogl.w",	two(0xF07A, 0x0006), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapogt.w",	two(0xF07A, 0x0002), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapole.w",	two(0xF07A, 0x0005), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapolt.w",	two(0xF07A, 0x0004), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapor.w",	two(0xF07A, 0x0007), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapseq.w",	two(0xF07A, 0x0011), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapsf.w",	two(0xF07A, 0x0010), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapsne.w",	two(0xF07A, 0x001E), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapst.w",	two(0xF07A, 0x001F), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapt.w",	two(0xF07A, 0x000F), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapueq.w",	two(0xF07A, 0x0009), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapuge.w",	two(0xF07A, 0x000B), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapugt.w",	two(0xF07A, 0x000A), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapule.w",	two(0xF07A, 0x000D), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapult.w",	two(0xF07A, 0x000C), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapun.w",	two(0xF07A, 0x0008), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },

{"ftrapeq.l",	two(0xF07B, 0x0001), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapf.l",	two(0xF07B, 0x0000), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapge.l",	two(0xF07B, 0x0013), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgl.l",	two(0xF07B, 0x0016), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgle.l",	two(0xF07B, 0x0017), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgt.l",	two(0xF07B, 0x0012), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftraple.l",	two(0xF07B, 0x0015), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftraplt.l",	two(0xF07B, 0x0014), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapne.l",	two(0xF07B, 0x000E), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnge.l",	two(0xF07B, 0x001C), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngl.l",	two(0xF07B, 0x0019), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngle.l",	two(0xF07B, 0x0018), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngt.l",	two(0xF07B, 0x001D), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnle.l",	two(0xF07B, 0x001A), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnlt.l",	two(0xF07B, 0x001B), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapoge.l",	two(0xF07B, 0x0003), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapogl.l",	two(0xF07B, 0x0006), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapogt.l",	two(0xF07B, 0x0002), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapole.l",	two(0xF07B, 0x0005), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapolt.l",	two(0xF07B, 0x0004), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapor.l",	two(0xF07B, 0x0007), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapseq.l",	two(0xF07B, 0x0011), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapsf.l",	two(0xF07B, 0x0010), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapsne.l",	two(0xF07B, 0x001E), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapst.l",	two(0xF07B, 0x001F), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapt.l",	two(0xF07B, 0x000F), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapueq.l",	two(0xF07B, 0x0009), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapuge.l",	two(0xF07B, 0x000B), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapugt.l",	two(0xF07B, 0x000A), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapule.l",	two(0xF07B, 0x000D), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapult.l",	two(0xF07B, 0x000C), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapun.l",	two(0xF07B, 0x0008), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },

{"ftst.b",	two(0xF000, 0x583A), two(0xF1C0, 0xFC7F), "Ii;b", mfloat },
{"ftst.d",	two(0xF000, 0x543A), two(0xF1C0, 0xFC7F), "Ii;F", mfloat },
{"ftst.l",	two(0xF000, 0x403A), two(0xF1C0, 0xFC7F), "Ii;l", mfloat },
{"ftst.p",	two(0xF000, 0x4C3A), two(0xF1C0, 0xFC7F), "Ii;p", mfloat },
{"ftst.s",	two(0xF000, 0x443A), two(0xF1C0, 0xFC7F), "Ii;f", mfloat },
{"ftst.w",	two(0xF000, 0x503A), two(0xF1C0, 0xFC7F), "Ii;w", mfloat },
{"ftst.x",	two(0xF000, 0x003A), two(0xF1C0, 0xE07F), "IiF8", mfloat },
{"ftst.x",	two(0xF000, 0x483A), two(0xF1C0, 0xFC7F), "Ii;x", mfloat },

{"ftwotox.b",	two(0xF000, 0x5811), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftwotox.d",	two(0xF000, 0x5411), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftwotox.l",	two(0xF000, 0x4011), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftwotox.p",	two(0xF000, 0x4C11), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftwotox.s",	two(0xF000, 0x4411), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftwotox.w",	two(0xF000, 0x5011), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftwotox.x",	two(0xF000, 0x0011), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftwotox.x",	two(0xF000, 0x4811), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftwotox.x",	two(0xF000, 0x0011), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"halt",	one(0045310),	one(0177777), "",     m68060 | mcf5200 },

{"illegal",	one(0045374),	one(0177777), "",     m68000up },

{"jmp",		one(0047300),	one(0177700), "!s", m68000up | mcf5200 },

{"jra",		one(0060000),	one(0177400), "Bg", m68000up | mcf5200 },
{"jra",		one(0047300),	one(0177700), "!s", m68000up | mcf5200 },

{"jsr",		one(0047200),	one(0177700), "!s", m68000up | mcf5200 },

{"jbsr",	one(0060400),	one(0177400), "Bg", m68000up | mcf5200 },
{"jbsr",	one(0047200),	one(0177700), "!s", m68000up | mcf5200 },

{"lea",		one(0040700),	one(0170700), "!sAd", m68000up | mcf5200 },

{"lpstop",	two(0174000,0000700),two(0177777,0177777),"#w", cpu32|m68060 },

{"link.w",	one(0047120),	one(0177770), "As#w", m68000up | mcf5200 },
{"link.l",	one(0044010),	one(0177770), "As#l", m68020up | cpu32 },
{"link",	one(0047120),	one(0177770), "As#W", m68000up | mcf5200 },
{"link",	one(0044010),	one(0177770), "As#l", m68020up | cpu32 },

{"lsl.b",	one(0160410),	one(0170770), "QdDs", m68000up },
{"lsl.b",	one(0160450),	one(0170770), "DdDs", m68000up },
{"lsl.w",	one(0160510),	one(0170770), "QdDs", m68000up },
{"lsl.w",	one(0160550),	one(0170770), "DdDs", m68000up },
{"lsl.w",	one(0161700),	one(0177700), "~s",   m68000up },
{"lsl.l",	one(0160610),	one(0170770), "QdDs", m68000up | mcf5200 },
{"lsl.l",	one(0160650),	one(0170770), "DdDs", m68000up | mcf5200 },

{"lsr.b",	one(0160010),	one(0170770), "QdDs", m68000up },
{"lsr.b",	one(0160050),	one(0170770), "DdDs", m68000up },
{"lsr.w",	one(0160110),	one(0170770), "QdDs", m68000up },
{"lsr.w",	one(0160150),	one(0170770), "DdDs", m68000up },
{"lsr.w",	one(0161300),	one(0177700), "~s",   m68000up },
{"lsr.l",	one(0160210),	one(0170770), "QdDs", m68000up | mcf5200 },
{"lsr.l",	one(0160250),	one(0170770), "DdDs", m68000up | mcf5200 },

/* NOTE: The mcf5200 family programmer's reference manual does not 
   indicate the byte form of the movea instruction is invalid (as it
   is on 68000 family cpus).  However, experiments on the 5202 yeild
   unexpected results.  The value is copied, but it is not sign extended
   (as is done with movea.w) and the top three bytes in the address 
   register are not disturbed.  I don't know if this is the intended
   behavior --- it could be a hole in instruction decoding (Motorola
   decided not to trap all invalid instructions for performance reasons)
   --- but I suspect that it is not.   

   I reported this to Motorola ISD Technical Communications Support, 
   which replied that other coldfire assemblers reject movea.b.  For 
   this reason I've decided to not allow moveab. 

	jtc@cygnus.com - 97/01/24
 */

{"movea.l",	one(0020100),	one(0170700), "*lAd", m68000up | mcf5200 },
{"movea.w",	one(0030100),	one(0170700), "*wAd", m68000up | mcf5200 },

{"movec",	one(0047173),	one(0177777), "R1Jj", m68010up | mcf5200 },
{"movec",	one(0047173),	one(0177777), "R1#j", m68010up | mcf5200 },
{"movec",	one(0047172),	one(0177777), "JjR1", m68010up },
{"movec",	one(0047172),	one(0177777), "#jR1", m68010up },

{"movem.w",	one(0044200),	one(0177700), "Lw&s", m68000up },
{"movem.w",	one(0044240),	one(0177770), "lw-s", m68000up },
{"movem.w",	one(0044200),	one(0177700), "#w>s", m68000up },
{"movem.w",	one(0046200),	one(0177700), "<sLw", m68000up },
{"movem.w",	one(0046200),	one(0177700), "<s#w", m68000up },
{"movem.l",	one(0044300),	one(0177700), "Lw&s", m68000up },
{"movem.l",	one(0044340),	one(0177770), "lw-s", m68000up },
{"movem.l",	one(0044300),	one(0177700), "#w>s", m68000up },
{"movem.l",	one(0046300),	one(0177700), "<sLw", m68000up },
{"movem.l",	one(0046300),	one(0177700), "<s#w", m68000up },
/* FIXME: need specifier for mode 2 and 5 to simplify below insn patterns */
{"movem.l",	one(0044320),	one(0177770), "Lwas", mcf5200 },
{"movem.l",	one(0044320),	one(0177770), "#was", mcf5200 },
{"movem.l",	one(0044350),	one(0177770), "Lwds", mcf5200 },
{"movem.l",	one(0044350),	one(0177770), "#wds", mcf5200 },
{"movem.l",	one(0046320),	one(0177770), "asLw", mcf5200 },
{"movem.l",	one(0046320),	one(0177770), "as#w", mcf5200 },
{"movem.l",	one(0046350),	one(0177770), "dsLw", mcf5200 },
{"movem.l",	one(0046350),	one(0177770), "ds#w", mcf5200 },

{"movep.w",	one(0000410),	one(0170770), "dsDd", m68000up },
{"movep.w",	one(0000610),	one(0170770), "Ddds", m68000up },
{"movep.l",	one(0000510),	one(0170770), "dsDd", m68000up },
{"movep.l",	one(0000710),	one(0170770), "Ddds", m68000up },

{"moveq",	one(0070000),	one(0170400), "MsDd", m68000up | mcf5200 },
{"moveq",	one(0070000),	one(0170400), "#BDd", m68000up | mcf5200 },

/* The move opcode can generate the movea and moveq instructions.  */
{"move.b",	one(0010000),	one(0170000), ";b$d", m68000up },
{"move.b",	one(0010000),	one(0170000), "ms%d", mcf5200 },
{"move.b",	one(0010000),	one(0170000), "nspd", mcf5200 },
{"move.b",	one(0010000),	one(0170000), "obmd", mcf5200 },

{"move.w",	one(0030000),	one(0170000), "*w%d", m68000up },
{"move.w",	one(0030000),	one(0170000), "ms%d", mcf5200 },
{"move.w",	one(0030000),	one(0170000), "nspd", mcf5200 },
{"move.w",	one(0030000),	one(0170000), "owmd", mcf5200 },

{"move.l",	one(0070000),	one(0170400), "MsDd", m68000up | mcf5200 },
{"move.l",	one(0020000),	one(0170000), "*l%d", m68000up },
{"move.l",	one(0020000),	one(0170000), "ms%d", mcf5200 },
{"move.l",	one(0020000),	one(0170000), "nspd", mcf5200 },
{"move.l",	one(0020000),	one(0170000), "olmd", mcf5200 },

{"move",	one(0030000),	one(0170000), "*w%d", m68000up },
{"move",	one(0030000),	one(0170000), "ms%d", mcf5200 },
{"move",	one(0030000),	one(0170000), "nspd", mcf5200 },
{"move",	one(0030000),	one(0170000), "owmd", mcf5200 },
{"move",	one(0040300),	one(0177700), "Ss$s", m68000up },
{"move",	one(0040300),	one(0177770), "SsDs", mcf5200 },
{"move",	one(0041300),	one(0177700), "Cs$s", m68010up },
{"move",	one(0041300),	one(0177770), "CsDs", mcf5200 },
{"move",	one(0042300),	one(0177700), ";wCd", m68000up },
{"move",	one(0042300),	one(0177700), "DsCd", mcf5200 },
{"move",	one(0042374),	one(0177777), "#wCd", mcf5200 },
{"move",	one(0043300),	one(0177700), ";wSd", m68000up },
{"move",	one(0043300),	one(0177700), "DsSd", mcf5200 },
{"move",	one(0043374),	one(0177777), "#wSd", mcf5200 },

{"move",	one(0047140),	one(0177770), "AsUd", m68000up },
{"move",	one(0047150),	one(0177770), "UdAs", m68000up },

{"moves.b",	two(0007000, 0),     two(0177700, 07777), "~sR1", m68010up },
{"moves.b",	two(0007000, 04000), two(0177700, 07777), "R1~s", m68010up },
{"moves.w",	two(0007100, 0),     two(0177700, 07777), "~sR1", m68010up },
{"moves.w",	two(0007100, 04000), two(0177700, 07777), "R1~s", m68010up },
{"moves.l",	two(0007200, 0),     two(0177700, 07777), "~sR1", m68010up },
{"moves.l",	two(0007200, 04000), two(0177700, 07777), "R1~s", m68010up },

{"move16",	two(0xf620, 0x8000), two(0xfff8, 0x8fff), "+s+1", m68040up },
{"move16",	one(0xf600),		one(0xfff8), "+s_L", m68040up },
{"move16",	one(0xf608),		one(0xfff8), "_L+s", m68040up },
{"move16",	one(0xf610),		one(0xfff8), "as_L", m68040up },
{"move16",	one(0xf618),		one(0xfff8), "_Las", m68040up },

{"muls.w",	one(0140700),		one(0170700), ";wDd", m68000up|mcf5200 },
{"muls.l",	two(0046000,004000), two(0177700,0107770), ";lD1", m68020up|cpu32 },
{"muls.l",	two(0046000,004000), two(0177700,0107770), "qsD1", mcf5200 },
{"muls.l",	two(0046000,006000), two(0177700,0107770), ";lD3D1",m68020up|cpu32 },

{"mulu.w",	one(0140300),		one(0170700), ";wDd", m68000up|mcf5200 },
{"mulu.l",	two(0046000,000000), two(0177700,0107770), ";lD1", m68020up|cpu32 },
{"mulu.l",	two(0046000,000000), two(0177700,0107770), "qsD1", mcf5200 },
{"mulu.l",	two(0046000,002000), two(0177700,0107770), ";lD3D1",m68020up|cpu32 },

{"nbcd",	one(0044000),	one(0177700), "$s", m68000up },

{"neg.b",	one(0042000),	one(0177700), "$s", m68000up },
{"neg.w",	one(0042100),	one(0177700), "$s", m68000up },
{"neg.l",	one(0042200),	one(0177700), "$s", m68000up },
{"neg.l",	one(0042200),	one(0177700), "Ds", mcf5200},

{"negx.b",	one(0040000),	one(0177700), "$s", m68000up },
{"negx.w",	one(0040100),	one(0177700), "$s", m68000up },
{"negx.l",	one(0040200),	one(0177700), "$s", m68000up },
{"negx.l",	one(0040200),	one(0177700), "Ds", mcf5200},

{"nop",		one(0047161),	one(0177777), "", m68000up | mcf5200},

{"not.b",	one(0043000),	one(0177700), "$s", m68000up },
{"not.w",	one(0043100),	one(0177700), "$s", m68000up },
{"not.l",	one(0043200),	one(0177700), "$s", m68000up },
{"not.l",	one(0043200),	one(0177700), "Ds", mcf5200},

{"ori.b",	one(0000000),	one(0177700), "#b$s", m68000up },
{"ori.w",	one(0000100),	one(0177700), "#w$s", m68000up },
{"ori.l",	one(0000200),	one(0177700), "#l$s", m68000up },
{"ori.l",	one(0000200),	one(0177700), "#lDs", mcf5200 },
{"ori",		one(0000074),	one(0177777), "#bCs", m68000up },
{"ori",		one(0000100),	one(0177700), "#w$s", m68000up },
{"ori",		one(0000174),	one(0177777), "#wSs", m68000up },

/* The or opcode can generate the ori instruction.  */
{"or.b",		one(0000000),	one(0177700), "#b$s", m68000up },
{"or.b",		one(0100000),	one(0170700), ";bDd", m68000up },
{"or.b",		one(0100400),	one(0170700), "Dd~s", m68000up },
{"or.w",		one(0000100),	one(0177700), "#w$s", m68000up },
{"or.w",		one(0100100),	one(0170700), ";wDd", m68000up },
{"or.w",		one(0100500),	one(0170700), "Dd~s", m68000up },
{"or.l",		one(0000200),	one(0177700), "#l$s", m68000up },
{"or.l",		one(0000200),	one(0177700), "#lDs", mcf5200 },
{"or.l",		one(0100200),	one(0170700), ";lDd", m68000up | mcf5200 },
{"or.l",		one(0100600),	one(0170700), "Dd~s", m68000up | mcf5200 },
{"or",		one(0000074),	one(0177777), "#bCs", m68000up },
{"or",		one(0000100),	one(0177700), "#w$s", m68000up },
{"or",		one(0000174),	one(0177777), "#wSs", m68000up },
{"or",		one(0100100),	one(0170700), ";wDd", m68000up },
{"or",		one(0100500),	one(0170700), "Dd~s", m68000up },

{"pack",	one(0100500),	one(0170770), "DsDd#w", m68020up },
{"pack",	one(0100510),	one(0170770), "-s-d#w", m68020up },

{"pbac",	one(0xf087),		one(0xffbf), "Bc", m68851 },
{"pbac.w",	one(0xf087),		one(0xffff), "BW", m68851 },
{"pbas",	one(0xf086),		one(0xffbf), "Bc", m68851 },
{"pbas.w",	one(0xf086),		one(0xffff), "BW", m68851 },
{"pbbc",	one(0xf081),		one(0xffbf), "Bc", m68851 },
{"pbbc.w",	one(0xf081),		one(0xffff), "BW", m68851 },
{"pbbs",	one(0xf080),		one(0xffbf), "Bc", m68851 },
{"pbbs.w",	one(0xf080),		one(0xffff), "BW", m68851 },
{"pbcc",	one(0xf08f),		one(0xffbf), "Bc", m68851 },
{"pbcc.w",	one(0xf08f),		one(0xffff), "BW", m68851 },
{"pbcs",	one(0xf08e),		one(0xffbf), "Bc", m68851 },
{"pbcs.w",	one(0xf08e),		one(0xffff), "BW", m68851 },
{"pbgc",	one(0xf08d),		one(0xffbf), "Bc", m68851 },
{"pbgc.w",	one(0xf08d),		one(0xffff), "BW", m68851 },
{"pbgs",	one(0xf08c),		one(0xffbf), "Bc", m68851 },
{"pbgs.w",	one(0xf08c),		one(0xffff), "BW", m68851 },
{"pbic",	one(0xf08b),		one(0xffbf), "Bc", m68851 },
{"pbic.w",	one(0xf08b),		one(0xffff), "BW", m68851 },
{"pbis",	one(0xf08a),		one(0xffbf), "Bc", m68851 },
{"pbis.w",	one(0xf08a),		one(0xffff), "BW", m68851 },
{"pblc",	one(0xf083),		one(0xffbf), "Bc", m68851 },
{"pblc.w",	one(0xf083),		one(0xffff), "BW", m68851 },
{"pbls",	one(0xf082),		one(0xffbf), "Bc", m68851 },
{"pbls.w",	one(0xf082),		one(0xffff), "BW", m68851 },
{"pbsc",	one(0xf085),		one(0xffbf), "Bc", m68851 },
{"pbsc.w",	one(0xf085),		one(0xffff), "BW", m68851 },
{"pbss",	one(0xf084),		one(0xffbf), "Bc", m68851 },
{"pbss.w",	one(0xf084),		one(0xffff), "BW", m68851 },
{"pbwc",	one(0xf089),		one(0xffbf), "Bc", m68851 },
{"pbwc.w",	one(0xf089),		one(0xffff), "BW", m68851 },
{"pbws",	one(0xf088),		one(0xffbf), "Bc", m68851 },
{"pbws.w",	one(0xf088),		one(0xffff), "BW", m68851 },

{"pdbac",	two(0xf048, 0x0007),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbas",	two(0xf048, 0x0006),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbbc",	two(0xf048, 0x0001),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbbs",	two(0xf048, 0x0000),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbcc",	two(0xf048, 0x000f),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbcs",	two(0xf048, 0x000e),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbgc",	two(0xf048, 0x000d),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbgs",	two(0xf048, 0x000c),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbic",	two(0xf048, 0x000b),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbis",	two(0xf048, 0x000a),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdblc",	two(0xf048, 0x0003),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbls",	two(0xf048, 0x0002),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbsc",	two(0xf048, 0x0005),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbss",	two(0xf048, 0x0004),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbwc",	two(0xf048, 0x0009),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbws",	two(0xf048, 0x0008),	two(0xfff8, 0xffff), "DsBw", m68851 },

{"pea",		one(0044100),		one(0177700), "!s", m68000up|mcf5200 },

{"pflusha",	one(0xf518),		one(0xfff8), "", m68040up },
{"pflusha",	two(0xf000,0x2400), two(0xffff,0xffff), "", m68030 | m68851 },

{"pflush",   two(0xf000,0x3010), two(0xffc0,0xfe10), "T3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3810), two(0xffc0,0xfe10), "T3T9&s", m68030|m68851 },
{"pflush",   two(0xf000,0x3008), two(0xffc0,0xfe18), "D3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3808), two(0xffc0,0xfe18), "D3T9&s", m68030|m68851 },
{"pflush",   two(0xf000,0x3000), two(0xffc0,0xfe1e), "f3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3800), two(0xffc0,0xfe1e), "f3T9&s", m68030|m68851 },
{"pflush",	one(0xf508),		one(0xfff8), "as", m68040up },
{"pflush",	one(0xf508),		one(0xfff8), "As", m68040up },

{"pflushan",	one(0xf510),		one(0xfff8), "", m68040up },
{"pflushn",	one(0xf500),		one(0xfff8), "as", m68040up },
{"pflushn",	one(0xf500),		one(0xfff8), "As", m68040up },

{"pflushr",	two(0xf000, 0xa000), two(0xffc0, 0xffff), "|s", m68851 },

{"pflushs",	two(0xf000, 0x3410), two(0xfff8, 0xfe10), "T3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c10), two(0xfff8, 0xfe10), "T3T9&s", m68851 },
{"pflushs",	two(0xf000, 0x3408), two(0xfff8, 0xfe18), "D3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c08), two(0xfff8, 0xfe18), "D3T9&s", m68851 },
{"pflushs",	two(0xf000, 0x3400), two(0xfff8, 0xfe1e), "f3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c00), two(0xfff8, 0xfe1e), "f3T9&s", m68851 },

{"ploadr",     two(0xf000,0x2210), two(0xffc0,0xfff0), "T3&s", m68030|m68851 },
{"ploadr",     two(0xf000,0x2208), two(0xffc0,0xfff8), "D3&s", m68030|m68851 },
{"ploadr",     two(0xf000,0x2200), two(0xffc0,0xfffe), "f3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2010), two(0xffc0,0xfff0), "T3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2008), two(0xffc0,0xfff8), "D3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2000), two(0xffc0,0xfffe), "f3&s", m68030|m68851 },

{"plpar",	one(0xf5c8),		one(0xfff8), "as", m68060 },
{"plpaw",	one(0xf588),		one(0xfff8), "as", m68060 },

{"pmove",      two(0xf000,0x4000), two(0xffc0,0xffff), "*l08", m68030|m68851 },
{"pmove",      two(0xf000,0x5c00), two(0xffc0,0xffff), "*w18", m68851 },
{"pmove",      two(0xf000,0x4000), two(0xffc0,0xe3ff), "*b28", m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xffff), "08%s", m68030|m68851 },
{"pmove",      two(0xf000,0x5e00), two(0xffc0,0xffff), "18%s", m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xe3ff), "28%s", m68851 },
{"pmove",      two(0xf000,0x4000), two(0xffc0,0xe3ff), "|sW8", m68030|m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xe3ff), "W8~s", m68030|m68851 },
{"pmove",      two(0xf000,0x6200), two(0xffc0,0xe3e3), "*wX3", m68851 },
{"pmove",      two(0xf000,0x6000), two(0xffc0,0xe3e3), "X3%s", m68851 },
{"pmove",      two(0xf000,0x6000), two(0xffc0,0xffff), "*wY8", m68030|m68851 },
{"pmove",      two(0xf000,0x6200), two(0xffc0,0xffff), "Y8%s", m68030|m68851 },
{"pmove",      two(0xf000,0x6600), two(0xffc0,0xffff), "Z8%s", m68851 },
{"pmove",      two(0xf000,0x0800), two(0xffc0,0xfbff), "*l38", m68030 },
{"pmove",      two(0xf000,0x0a00), two(0xffc0,0xfbff), "38%s", m68030 },

{"pmovefd",	two(0xf000, 0x4100),	two(0xffc0, 0xe3ff), "*l08", m68030 },
{"pmovefd",	two(0xf000, 0x4100),	two(0xffc0, 0xe3ff), "|sW8", m68030 },
{"pmovefd",	two(0xf000, 0x0900),	two(0xffc0, 0xfbff), "*l38", m68030 },

{"prestore",	one(0xf140),		one(0xffc0), "<s", m68851 },

{"psave",	one(0xf100),		one(0xffc0), ">s", m68851 },

{"psac",	two(0xf040, 0x0007),	two(0xffc0, 0xffff), "$s", m68851 },
{"psas",	two(0xf040, 0x0006),	two(0xffc0, 0xffff), "$s", m68851 },
{"psbc",	two(0xf040, 0x0001),	two(0xffc0, 0xffff), "$s", m68851 },
{"psbs",	two(0xf040, 0x0000),	two(0xffc0, 0xffff), "$s", m68851 },
{"pscc",	two(0xf040, 0x000f),	two(0xffc0, 0xffff), "$s", m68851 },
{"pscs",	two(0xf040, 0x000e),	two(0xffc0, 0xffff), "$s", m68851 },
{"psgc",	two(0xf040, 0x000d),	two(0xffc0, 0xffff), "$s", m68851 },
{"psgs",	two(0xf040, 0x000c),	two(0xffc0, 0xffff), "$s", m68851 },
{"psic",	two(0xf040, 0x000b),	two(0xffc0, 0xffff), "$s", m68851 },
{"psis",	two(0xf040, 0x000a),	two(0xffc0, 0xffff), "$s", m68851 },
{"pslc",	two(0xf040, 0x0003),	two(0xffc0, 0xffff), "$s", m68851 },
{"psls",	two(0xf040, 0x0002),	two(0xffc0, 0xffff), "$s", m68851 },
{"pssc",	two(0xf040, 0x0005),	two(0xffc0, 0xffff), "$s", m68851 },
{"psss",	two(0xf040, 0x0004),	two(0xffc0, 0xffff), "$s", m68851 },
{"pswc",	two(0xf040, 0x0009),	two(0xffc0, 0xffff), "$s", m68851 },
{"psws",	two(0xf040, 0x0008),	two(0xffc0, 0xffff), "$s", m68851 },

{"ptestr", two(0xf000,0x8210), two(0xffc0, 0xe3f0), "T3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8310), two(0xffc0,0xe310), "T3&st8A9", m68030|m68851 },
{"ptestr", two(0xf000,0x8208), two(0xffc0,0xe3f8), "D3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8308), two(0xffc0,0xe318), "D3&st8A9", m68030|m68851 },
{"ptestr", two(0xf000,0x8200), two(0xffc0,0xe3fe), "f3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8300), two(0xffc0,0xe31e), "f3&st8A9", m68030|m68851 },
{"ptestr",	one(0xf568),		one(0xfff8), "as", m68040 },

{"ptestw", two(0xf000,0x8010), two(0xffc0,0xe3f0), "T3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8110), two(0xffc0,0xe310), "T3&st8A9", m68030|m68851 },
{"ptestw", two(0xf000,0x8008), two(0xffc0,0xe3f8), "D3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8108), two(0xffc0,0xe318), "D3&st8A9", m68030|m68851 },
{"ptestw", two(0xf000,0x8000), two(0xffc0,0xe3fe), "f3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8100), two(0xffc0,0xe31e), "f3&st8A9", m68030|m68851 },
{"ptestw",	one(0xf548),		one(0xfff8), "as", m68040 },

{"ptrapac.w",	two(0xf07a, 0x0007),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapac.l",	two(0xf07b, 0x0007),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapac",	two(0xf07c, 0x0007),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapas.w",	two(0xf07a, 0x0006),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapas.l",	two(0xf07b, 0x0006),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapas",	two(0xf07c, 0x0006),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapbc.w",	two(0xf07a, 0x0001),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapbc.l",	two(0xf07b, 0x0001),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapbc",	two(0xf07c, 0x0001),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapbs.w",	two(0xf07a, 0x0000),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapbs.l",	two(0xf07b, 0x0000),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapbs",	two(0xf07c, 0x0000),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapcc.w",	two(0xf07a, 0x000f),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapcc.l",	two(0xf07b, 0x000f),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapcc",	two(0xf07c, 0x000f),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapcs.w",	two(0xf07a, 0x000e),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapcs.l",	two(0xf07b, 0x000e),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapcs",	two(0xf07c, 0x000e),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapgc.w",	two(0xf07a, 0x000d),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapgc.l",	two(0xf07b, 0x000d),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapgc",	two(0xf07c, 0x000d),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapgs.w",	two(0xf07a, 0x000c),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapgs.l",	two(0xf07b, 0x000c),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapgs",	two(0xf07c, 0x000c),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapic.w",	two(0xf07a, 0x000b),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapic.l",	two(0xf07b, 0x000b),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapic",	two(0xf07c, 0x000b),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapis.w",	two(0xf07a, 0x000a),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapis.l",	two(0xf07b, 0x000a),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapis",	two(0xf07c, 0x000a),	two(0xffff, 0xffff), "",   m68851 },

{"ptraplc.w",	two(0xf07a, 0x0003),	two(0xffff, 0xffff), "#w", m68851 },
{"ptraplc.l",	two(0xf07b, 0x0003),	two(0xffff, 0xffff), "#l", m68851 },
{"ptraplc",	two(0xf07c, 0x0003),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapls.w",	two(0xf07a, 0x0002),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapls.l",	two(0xf07b, 0x0002),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapls",	two(0xf07c, 0x0002),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapsc.w",	two(0xf07a, 0x0005),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapsc.l",	two(0xf07b, 0x0005),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapsc",	two(0xf07c, 0x0005),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapss.w",	two(0xf07a, 0x0004),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapss.l",	two(0xf07b, 0x0004),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapss",	two(0xf07c, 0x0004),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapwc.w",	two(0xf07a, 0x0009),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapwc.l",	two(0xf07b, 0x0009),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapwc",	two(0xf07c, 0x0009),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapws.w",	two(0xf07a, 0x0008),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapws.l",	two(0xf07b, 0x0008),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapws",	two(0xf07c, 0x0008),	two(0xffff, 0xffff), "",   m68851 },

{"pulse",	one(0045314),		one(0177777), "", m68060 | mcf5200 },

{"pvalid",	two(0xf000, 0x2800),	two(0xffc0, 0xffff), "Vs&s", m68851 },
{"pvalid",	two(0xf000, 0x2c00),	two(0xffc0, 0xfff8), "A3&s", m68851 },


{"reset",	one(0047160),		one(0177777), "", m68000up },

{"rol.b",	one(0160430),		one(0170770), "QdDs", m68000up },
{"rol.b",	one(0160470),		one(0170770), "DdDs", m68000up },
{"rol.w",	one(0160530),		one(0170770), "QdDs", m68000up },
{"rol.w",	one(0160570),		one(0170770), "DdDs", m68000up },
{"rol.w",	one(0163700),		one(0177700), "~s",   m68000up },
{"rol.l",	one(0160630),		one(0170770), "QdDs", m68000up },
{"rol.l",	one(0160670),		one(0170770), "DdDs", m68000up },

{"ror.b",	one(0160030),		one(0170770), "QdDs", m68000up },
{"ror.b",	one(0160070),		one(0170770), "DdDs", m68000up },
{"ror.w",	one(0160130),		one(0170770), "QdDs", m68000up },
{"ror.w",	one(0160170),		one(0170770), "DdDs", m68000up },
{"ror.w",	one(0163300),		one(0177700), "~s",   m68000up },
{"ror.l",	one(0160230),		one(0170770), "QdDs", m68000up },
{"ror.l",	one(0160270),		one(0170770), "DdDs", m68000up },

{"roxl.b",	one(0160420),		one(0170770), "QdDs", m68000up },
{"roxl.b",	one(0160460),		one(0170770), "DdDs", m68000up },
{"roxl.w",	one(0160520),		one(0170770), "QdDs", m68000up },
{"roxl.w",	one(0160560),		one(0170770), "DdDs", m68000up },
{"roxl.w",	one(0162700),		one(0177700), "~s",   m68000up },
{"roxl.l",	one(0160620),		one(0170770), "QdDs", m68000up },
{"roxl.l",	one(0160660),		one(0170770), "DdDs", m68000up },

{"roxr.b",	one(0160020),		one(0170770), "QdDs", m68000up },
{"roxr.b",	one(0160060),		one(0170770), "DdDs", m68000up },
{"roxr.w",	one(0160120),		one(0170770), "QdDs", m68000up },
{"roxr.w",	one(0160160),		one(0170770), "DdDs", m68000up },
{"roxr.w",	one(0162300),		one(0177700), "~s",   m68000up },
{"roxr.l",	one(0160220),		one(0170770), "QdDs", m68000up },
{"roxr.l",	one(0160260),		one(0170770), "DdDs", m68000up },

{"rtd",		one(0047164),		one(0177777), "#w", m68010up },

{"rte",		one(0047163),		one(0177777), "",   m68000up|mcf5200 },

{"rtm",		one(0003300),		one(0177760), "Rs", m68020 },

{"rtr",		one(0047167),		one(0177777), "",   m68000up },

{"rts",		one(0047165),		one(0177777), "",   m68000up|mcf5200 },

{"sbcd",	one(0100400),		one(0170770), "DsDd", m68000up },
{"sbcd",	one(0100410),		one(0170770), "-s-d", m68000up },


{"scc",		one(0052300),	one(0177700), "$s", m68000up },
{"scc",		one(0052300),	one(0177700), "Ds", mcf5200 },
{"scs",		one(0052700),	one(0177700), "$s", m68000up },
{"scs",		one(0052700),	one(0177700), "Ds", mcf5200 },
{"seq",		one(0053700),	one(0177700), "$s", m68000up },
{"seq",		one(0053700),	one(0177700), "Ds", mcf5200 },
{"sf",		one(0050700),	one(0177700), "$s", m68000up },
{"sf",		one(0050700),	one(0177700), "Ds", mcf5200 },
{"sge",		one(0056300),	one(0177700), "$s", m68000up },
{"sge",		one(0056300),	one(0177700), "Ds", mcf5200 },
{"sgt",		one(0057300),	one(0177700), "$s", m68000up },
{"sgt",		one(0057300),	one(0177700), "Ds", mcf5200 },
{"shi",		one(0051300),	one(0177700), "$s", m68000up },
{"shi",		one(0051300),	one(0177700), "Ds", mcf5200 },
{"sle",		one(0057700),	one(0177700), "$s", m68000up },
{"sle",		one(0057700),	one(0177700), "Ds", mcf5200 },
{"sls",		one(0051700),	one(0177700), "$s", m68000up },
{"sls",		one(0051700),	one(0177700), "Ds", mcf5200 },
{"slt",		one(0056700),	one(0177700), "$s", m68000up },
{"slt",		one(0056700),	one(0177700), "Ds", mcf5200 },
{"smi",		one(0055700),	one(0177700), "$s", m68000up },
{"smi",		one(0055700),	one(0177700), "Ds", mcf5200 },
{"sne",		one(0053300),	one(0177700), "$s", m68000up },
{"sne",		one(0053300),	one(0177700), "Ds", mcf5200 },
{"spl",		one(0055300),	one(0177700), "$s", m68000up },
{"spl",		one(0055300),	one(0177700), "Ds", mcf5200 },
{"st",		one(0050300),	one(0177700), "$s", m68000up },
{"st",		one(0050300),	one(0177700), "Ds", mcf5200 },
{"svc",		one(0054300),	one(0177700), "$s", m68000up },
{"svc",		one(0054300),	one(0177700), "Ds", mcf5200 },
{"svs",		one(0054700),	one(0177700), "$s", m68000up },
{"svs",		one(0054700),	one(0177700), "Ds", mcf5200 },

{"stop",	one(0047162),	one(0177777), "#w", m68000up | mcf5200 },

{"suba.l",	one(0110700),	one(0170700), "*lAd", m68000up | mcf5200 },
{"suba.w",	one(0110300),	one(0170700), "*wAd", m68000up },

{"subi.b",	one(0002000),	one(0177700), "#b$s", m68000up },
{"subi.w",	one(0002100),	one(0177700), "#w$s", m68000up },
{"subi.l",	one(0002200),	one(0177700), "#l$s", m68000up },
{"subi.l",	one(0002200),	one(0177700), "#lDs", mcf5200 },

{"subq.b",	one(0050400),	one(0170700), "Qd%s", m68000up },
{"subq.w",	one(0050500),	one(0170700), "Qd%s", m68000up },
{"subq.l",	one(0050600),	one(0170700), "Qd%s", m68000up | mcf5200 },

/* The sub opcode can generate the suba, subi, and subq instructions.  */
{"sub.b",	one(0050400),	one(0170700), "Qd%s", m68000up },
{"sub.b",	one(0002000),	one(0177700), "#b$s", m68000up },
{"sub.b",	one(0110000),	one(0170700), ";bDd", m68000up },
{"sub.b",	one(0110400),	one(0170700), "Dd~s", m68000up },
{"sub.w",	one(0050500),	one(0170700), "Qd%s", m68000up },
{"sub.w",	one(0002100),	one(0177700), "#w$s", m68000up },
{"sub.w",	one(0110300),	one(0170700), "*wAd", m68000up },
{"sub.w",	one(0110100),	one(0170700), "*wDd", m68000up },
{"sub.w",	one(0110500),	one(0170700), "Dd~s", m68000up },
{"sub.l",	one(0050600),	one(0170700), "Qd%s", m68000up | mcf5200 },
{"sub.l",	one(0002200),	one(0177700), "#l$s", m68000up },
{"sub.l",	one(0002200),	one(0177700), "#lDs", mcf5200 },
{"sub.l",	one(0110700),	one(0170700), "*lAd", m68000up | mcf5200 },
{"sub.l",	one(0110200),	one(0170700), "*lDd", m68000up | mcf5200 },
{"sub.l",	one(0110600),	one(0170700), "Dd~s", m68000up | mcf5200 },

{"subx.b",	one(0110400),	one(0170770), "DsDd", m68000up },
{"subx.b",	one(0110410),	one(0170770), "-s-d", m68000up },
{"subx.w",	one(0110500),	one(0170770), "DsDd", m68000up },
{"subx.w",	one(0110510),	one(0170770), "-s-d", m68000up },
{"subx.l",	one(0110600),	one(0170770), "DsDd", m68000up | mcf5200 },
{"subx.l",	one(0110610),	one(0170770), "-s-d", m68000up },

{"swap",	one(0044100),	one(0177770), "Ds", m68000up | mcf5200 },

/* swbeg and swbegl are magic constants used on sysV68.  The compiler
   generates them before a switch table.  They tell the debugger and
   disassembler that a switch table follows.  The parameter is the
   number of elements in the table.  swbeg means that the entries in
   the table are word (2 byte) sized, and swbegl means that the
   entries in the table are longword (4 byte) sized.  */
{"swbeg",	one(0045374),	one(0177777), "#w",   m68000up | mcf5200 },
{"swbeg.l",	one(0045375),	one(0177777), "#l",   m68000up | mcf5200 },

{"tas",		one(0045300),		one(0177700), "$s", m68000up },

#define TBL1(name,signed,round,size)					\
  {name, two(0174000, (signed<<11)|(!round<<10)|(size<<6)|0000400),	\
     two(0177700,0107777), "!sD1", cpu32 },				\
  {name, two(0174000, (signed<<11)|(!round<<10)|(size<<6)),		\
     two(0177770,0107770), "DsD3D1", cpu32 }
#define TBL(name1, name2, name3, s, r) \
  TBL1(name1, s, r, 0), TBL1(name2, s, r, 1), TBL1(name3, s, r, 2)
TBL("tbls.b", "tbls.w", "tbls.l", 1, 1),
TBL("tblsn.b", "tblsn.w", "tblsn.l", 1, 0),
TBL("tblu.b", "tblu.w", "tblu.l", 0, 1),
TBL("tblun.b", "tblun.w", "tblun.l", 0, 0),

{"trap",	one(0047100),	one(0177760), "Ts", m68000up | mcf5200 },

{"trapcc",	one(0052374),	one(0177777), "", m68020up | cpu32 },
{"trapcs",	one(0052774),	one(0177777), "", m68020up | cpu32 },
{"trapeq",	one(0053774),	one(0177777), "", m68020up | cpu32 },
{"trapf",	one(0050774),	one(0177777), "", m68020up | cpu32 | mcf5200 },
{"trapge",	one(0056374),	one(0177777), "", m68020up | cpu32 },
{"trapgt",	one(0057374),	one(0177777), "", m68020up | cpu32 },
{"traphi",	one(0051374),	one(0177777), "", m68020up | cpu32 },
{"traple",	one(0057774),	one(0177777), "", m68020up | cpu32 },
{"trapls",	one(0051774),	one(0177777), "", m68020up | cpu32 },
{"traplt",	one(0056774),	one(0177777), "", m68020up | cpu32 },
{"trapmi",	one(0055774),	one(0177777), "", m68020up | cpu32 },
{"trapne",	one(0053374),	one(0177777), "", m68020up | cpu32 },
{"trappl",	one(0055374),	one(0177777), "", m68020up | cpu32 },
{"trapt",	one(0050374),	one(0177777), "", m68020up | cpu32 },
{"trapvc",	one(0054374),	one(0177777), "", m68020up | cpu32 },
{"trapvs",	one(0054774),	one(0177777), "", m68020up | cpu32 },

{"trapcc.w",	one(0052372),	one(0177777), "#w", m68020up|cpu32 },
{"trapcs.w",	one(0052772),	one(0177777), "#w", m68020up|cpu32 },
{"trapeq.w",	one(0053772),	one(0177777), "#w", m68020up|cpu32 },
{"trapf.w",	one(0050772),	one(0177777), "#w", m68020up|cpu32|mcf5200},
{"trapge.w",	one(0056372),	one(0177777), "#w", m68020up|cpu32 },
{"trapgt.w",	one(0057372),	one(0177777), "#w", m68020up|cpu32 },
{"traphi.w",	one(0051372),	one(0177777), "#w", m68020up|cpu32 },
{"traple.w",	one(0057772),	one(0177777), "#w", m68020up|cpu32 },
{"trapls.w",	one(0051772),	one(0177777), "#w", m68020up|cpu32 },
{"traplt.w",	one(0056772),	one(0177777), "#w", m68020up|cpu32 },
{"trapmi.w",	one(0055772),	one(0177777), "#w", m68020up|cpu32 },
{"trapne.w",	one(0053372),	one(0177777), "#w", m68020up|cpu32 },
{"trappl.w",	one(0055372),	one(0177777), "#w", m68020up|cpu32 },
{"trapt.w",	one(0050372),	one(0177777), "#w", m68020up|cpu32 },
{"trapvc.w",	one(0054372),	one(0177777), "#w", m68020up|cpu32 },
{"trapvs.w",	one(0054772),	one(0177777), "#w", m68020up|cpu32 },

{"trapcc.l",	one(0052373),	one(0177777), "#l", m68020up|cpu32 },
{"trapcs.l",	one(0052773),	one(0177777), "#l", m68020up|cpu32 },
{"trapeq.l",	one(0053773),	one(0177777), "#l", m68020up|cpu32 },
{"trapf.l",	one(0050773),	one(0177777), "#l", m68020up|cpu32|mcf5200},
{"trapge.l",	one(0056373),	one(0177777), "#l", m68020up|cpu32 },
{"trapgt.l",	one(0057373),	one(0177777), "#l", m68020up|cpu32 },
{"traphi.l",	one(0051373),	one(0177777), "#l", m68020up|cpu32 },
{"traple.l",	one(0057773),	one(0177777), "#l", m68020up|cpu32 },
{"trapls.l",	one(0051773),	one(0177777), "#l", m68020up|cpu32 },
{"traplt.l",	one(0056773),	one(0177777), "#l", m68020up|cpu32 },
{"trapmi.l",	one(0055773),	one(0177777), "#l", m68020up|cpu32 },
{"trapne.l",	one(0053373),	one(0177777), "#l", m68020up|cpu32 },
{"trappl.l",	one(0055373),	one(0177777), "#l", m68020up|cpu32 },
{"trapt.l",	one(0050373),	one(0177777), "#l", m68020up|cpu32 },
{"trapvc.l",	one(0054373),	one(0177777), "#l", m68020up|cpu32 },
{"trapvs.l",	one(0054773),	one(0177777), "#l", m68020up|cpu32 },

{"trapv",	one(0047166),	one(0177777), "", m68000up },

{"tst.b",	one(0045000),	one(0177700), ";b", m68020up|cpu32|mcf5200 },
{"tst.b",	one(0045000),	one(0177700), "$b", m68000up },
{"tst.w",	one(0045100),	one(0177700), "*w", m68020up|cpu32|mcf5200 },
{"tst.w",	one(0045100),	one(0177700), "$w", m68000up },
{"tst.l",	one(0045200),	one(0177700), "*l", m68020up|cpu32|mcf5200 },
{"tst.l",	one(0045200),	one(0177700), "$l", m68000up },

{"unlk",	one(0047130),	one(0177770), "As", m68000up | mcf5200 },

{"unpk",	one(0100600),	one(0170770), "DsDd#w", m68020up },
{"unpk",	one(0100610),	one(0170770), "-s-d#w", m68020up },

{"wddata.b",	one(0172000),   one(0177700), "~s", mcf5200 },
{"wddata.w",	one(0172100),   one(0177700), "~s", mcf5200 },
{"wddata.l",	one(0172200),   one(0177700), "~s", mcf5200 },

};

const int m68k_numopcodes = sizeof m68k_opcodes / sizeof m68k_opcodes[0];

/* These aliases used to be in the above table, each one duplicating
   all of the entries for its primary exactly.  This table was
   constructed by mechanical processing of the opcode table, with a
   small number of tweaks done by hand.  There are probably a lot more
   aliases above that could be moved down here, except for very minor
   differences.  */

const struct m68k_opcode_alias m68k_opcode_aliases[] =
{
  { "add",	"add.w", },
  { "adda",	"adda.w", },
  { "addi",	"addi.w", },
  { "addq",	"addq.w", },
  { "addx",	"addx.w", },
  { "asl",	"asl.w", },
  { "asr",	"asr.w", },
  { "bhi",	"bhi.w", },
  { "bls",	"bls.w", },
  { "bcc",	"bcc.w", },
  { "bcs",	"bcs.w", },
  { "bne",	"bne.w", },
  { "beq",	"beq.w", },
  { "bvc",	"bvc.w", },
  { "bvs",	"bvs.w", },
  { "bpl",	"bpl.w", },
  { "bmi",	"bmi.w", },
  { "bge",	"bge.w", },
  { "blt",	"blt.w", },
  { "bgt",	"bgt.w", },
  { "ble",	"ble.w", },
  { "bra",	"bra.w", },
  { "bsr",	"bsr.w", },
  { "bhi.b",	"bhi.s", },
  { "bls.b",	"bls.s", },
  { "bcc.b",	"bcc.s", },
  { "bcs.b",	"bcs.s", },
  { "bne.b",	"bne.s", },
  { "beq.b",	"beq.s", },
  { "bvc.b",	"bvc.s", },
  { "bvs.b",	"bvs.s", },
  { "bpl.b",	"bpl.s", },
  { "bmi.b",	"bmi.s", },
  { "bge.b",	"bge.s", },
  { "blt.b",	"blt.s", },
  { "bgt.b",	"bgt.s", },
  { "ble.b",	"ble.s", },
  { "bra.b",	"bra.s", },
  { "bsr.b",	"bsr.s", },
  { "bhs",	"bcc.w" },
  { "bhs.s",	"bcc.s" },
  { "bhs.b",	"bcc.s" },
  { "bhs.w",	"bcc.w" },
  { "bhs.l",	"bcc.l" },
  { "blo",	"bcs.w" },
  { "blo.s",	"bcs.s" },
  { "blo.b",	"bcs.s" },
  { "blo.w",	"bcs.w" },
  { "blo.l",	"bcs.l" },
  { "br",	"bra.w", },
  { "br.s",	"bra.s", },
  { "br.b",	"bra.s", },
  { "br.w",	"bra.w", },
  { "br.l",	"bra.l", },
  { "jfnlt",	"bcc", },	/* apparently a sun alias */
  { "jfngt",	"ble", },	/* apparently a sun alias */
  { "jfeq",	"beq.s", },	/* apparently a sun alias */
  { "bchg.b",	"bchg", },
  { "bchg.l",	"bchg", },
  { "bclr.b",	"bclr", },
  { "bclr.l",	"bclr", },
  { "bset.b",	"bset", },
  { "bset.l",	"bset", },
  { "btst.b",	"btst", },
  { "btst.l",	"btst", },
  { "cas2",	"cas2.w", },
  { "cas",	"cas.w", },
  { "chk2",	"chk2.w", },
  { "chk",	"chk.w", },
  { "clr",	"clr.w", },
  { "cmp2",	"cmp2.w", },
  { "cmpa",	"cmpa.w", },
  { "cmpi",	"cmpi.w", },
  { "cmpm",	"cmpm.w", },
  { "cmp",	"cmp.w", },
  { "dbcc.w",	"dbcc", },
  { "dbcs.w",	"dbcs", },
  { "dbeq.w",	"dbeq", },
  { "dbf.w",	"dbf", },
  { "dbge.w",	"dbge", },
  { "dbgt.w",	"dbgt", },
  { "dbhi.w",	"dbhi", },
  { "dble.w",	"dble", },
  { "dbls.w",	"dbls", },
  { "dblt.w",	"dblt", },
  { "dbmi.w",	"dbmi", },
  { "dbne.w",	"dbne", },
  { "dbpl.w",	"dbpl", },
  { "dbt.w",	"dbt", },
  { "dbvc.w",	"dbvc", },
  { "dbvs.w",	"dbvs", },
  { "dbhs",	"dbcc", },
  { "dbhs.w",	"dbcc", },
  { "dbra",	"dbf", },
  { "dbra.w",	"dbf", },
  { "tdivs.l",	"divs.l", },
  { "divs",	"divs.w", },
  { "divu",	"divu.w", },
  { "ext",	"ext.w", },
  { "extb.w",	"ext.w", },
  { "extw.l",	"ext.l", },
  { "fbneq",	"fbne", },
  { "fbsneq",	"fbsne", },
  { "fdbneq",	"fdbne", },
  { "fdbsneq",	"fdbsne", },
  { "fmovecr",	"fmovecrx", },
  { "fmovm",	"fmovem", },
  { "fsneq",	"fsne", },
  { "fssneq",	"fssne", },
  { "ftrapneq",	"ftrapne", },
  { "ftrapsneq", "ftrapsne", },
  { "fjneq",	"fjne", },
  { "fjsneq",	"fjsne", },
  { "jmp.l",	"jmp", },
  { "jmp.s",	"jmp", },
  { "jsr.l",	"jsr", },
  { "jsr.s",	"jsr", },
  { "lea.l",	"lea", },
  { "lsl",	"lsl.w", },
  { "lsr",	"lsr.w", },
  { "movea",	"movea.w", },
  { "movem",	"movem.w", },
  { "movm.l",	"movem.l", },
  { "movm.w",	"movem.w", },
  { "movm",	"movem.w", },
  { "movep",	"movep.w", },
  { "movp.w",	"movep.w", },
  { "moves",	"moves.w" },
  { "muls",	"muls.w", },
  { "mulu",	"mulu.w", },
  { "nbcd.b",	"nbcd" },
  { "neg",	"neg.w", },
  { "negx",	"negx.w", },
  { "not",	"not.w", },
  { "pea.l",	"pea", },
  { "rol",	"rol.w", },
  { "ror",	"ror.w", },
  { "roxl",	"roxl.w", },
  { "roxr",	"roxr.w", },
  { "sbcd.b",	"sbcd", },
  { "scc.b",	"scc", },
  { "scs.b",	"scs", },
  { "seq.b",	"seq", },
  { "sf.b",	"sf", },
  { "sge.b",	"sge", },
  { "sgt.b",	"sgt", },
  { "shi.b",	"shi", },
  { "sle.b",	"sle", },
  { "sls.b",	"sls", },
  { "slt.b",	"slt", },
  { "smi.b",	"smi", },
  { "sne.b",	"sne", },
  { "spl.b",	"spl", },
  { "st.b",	"st", },
  { "svc.b",	"svc", },
  { "svs.b",	"svs", },
  { "sfge",	"sge", },
  { "sfgt",	"sgt", },
  { "sfle",	"sle", },
  { "sflt",	"slt", },
  { "sfneq",	"sne", },
  { "suba",	"suba.w", },
  { "subi",	"subi.w", },
  { "subq",	"subq.w", },
  { "sub",	"sub.w", },
  { "subx",	"subx.w", },
  { "swap.w",	"swap", },
  { "tas.b",	"tas", },
  { "tpcc",	"trapcc", },
  { "tcc",	"trapcc", },
  { "tst",	"tst.w", },
  { "jbra",	"jra", },
  { "jbhi",	"jhi", },
  { "jbls",	"jls", },
  { "jbcc",	"jcc", },
  { "jbcs",	"jcs", },
  { "jbne",	"jne", },
  { "jbeq",	"jeq", },
  { "jbvc",	"jvc", },
  { "jbvs",	"jvs", },
  { "jbpl",	"jpl", },
  { "jbmi",	"jmi", },
  { "jbge",	"jge", },
  { "jblt",	"jlt", },
  { "jbgt",	"jgt", },
  { "jble",	"jle", },
  { "movq.l",	"moveq", },
  { "moveq.l",	"moveq", },
  { "mov.l",	"move.l", },
  { "movq",	"moveq", },
  { "mova.l",	"movea.l", },
  { "mova.w",	"movea.w", },
  { "mov.b",	"move.b", },
  { "movc",	"movec", },
  { "movec.l",	"movec", },
  { "movp.l",	"movep.l", },
  { "mov.w",	"move.w", },
  { "movs.b",	"moves.b", },
  { "movs.l",	"moves.l", },
  { "movs.w",	"moves.w", },

  { "tdivu.l",	"divu.l", },	/* for m68k-svr4 */
  { "fmov.b",	"fmove.b", },
  { "fsmov.b",	"fsmove.b", },
  { "fdmov.b",	"fdmove.b", },
  { "fmov.d",	"fmove.d", },
  { "fsmov.d",	"fsmove.d", },
  { "fmov.l",	"fmove.l", },
  { "fsmov.l",	"fsmove.l", },
  { "fdmov.l",	"fdmove.l", },
  { "fmov.p",	"fmove.p", },
  { "fsmov.p",	"fsmove.p", },
  { "fdmov.p",	"fdmove.p", },
  { "fmov.s",	"fmove.s", },
  { "fsmov.s",	"fsmove.s", },
  { "fdmov.s",	"fdmove.s", },
  { "fmov.w",	"fmove.w", },
  { "fsmov.w",	"fsmove.w", },
  { "fdmov.w",	"fdmove.w", },
  { "fmov.x",	"fmove.x", },
  { "fsmov.x",	"fsmove.x", },
  { "fdmov.x",	"fdmove.x", },
  { "fmovcr",	"fmovecr", },
  { "fmovcr.x",	"fmovecr.x", },
  { "ftest.b",	"ftst.b", },
  { "ftest.d",	"ftst.d", },
  { "ftest.l",	"ftst.l", },
  { "ftest.p",	"ftst.p", },
  { "ftest.s",	"ftst.s", },
  { "ftest.w",	"ftst.w", },
  { "ftest.x",	"ftst.x", },
};

const int m68k_numaliases =
  sizeof m68k_opcode_aliases / sizeof m68k_opcode_aliases[0];
