import { z } from 'zod';
export declare const ConfigSchema: z.ZodObject<{
    backgroundAnalysisMaxFiles: z.ZodDefault<z.ZodNumber>;
    enableSourceErrorDiagnostics: z.ZodDefault<z.ZodBoolean>;
    globPattern: z.ZodDefault<z.ZodString>;
    explainshellEndpoint: z.ZodDefault<z.ZodString>;
    logLevel: z.ZodDefault<z.ZodEnum<["debug", "info", "warning", "error"]>>;
    includeAllWorkspaceSymbols: z.ZodDefault<z.ZodBoolean>;
    shellcheckArguments: z.ZodDefault<z.ZodEffects<z.ZodArray<z.ZodString, "many">, string[], unknown>>;
    shellcheckPath: z.ZodDefault<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    globPattern: string;
    enableSourceErrorDiagnostics: boolean;
    includeAllWorkspaceSymbols: boolean;
    backgroundAnalysisMaxFiles: number;
    explainshellEndpoint: string;
    logLevel: "debug" | "info" | "warning" | "error";
    shellcheckArguments: string[];
    shellcheckPath: string;
}, {
    backgroundAnalysisMaxFiles?: number | undefined;
    enableSourceErrorDiagnostics?: boolean | undefined;
    globPattern?: string | undefined;
    explainshellEndpoint?: string | undefined;
    logLevel?: "debug" | "info" | "warning" | "error" | undefined;
    includeAllWorkspaceSymbols?: boolean | undefined;
    shellcheckArguments?: unknown;
    shellcheckPath?: string | undefined;
}>;
export type Config = z.infer<typeof ConfigSchema>;
export declare function getConfigFromEnvironmentVariables(): {
    config: Config;
    environmentVariablesUsed: string[];
};
export declare function getDefaultConfiguration(): Config;
