/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Dec
extends ANum {
    public static final BigDecimal BD_MINLONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal BD_MAXLONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal BD_1000000 = BigDecimal.valueOf(1000000L);
    public static final BigDecimal BD_864000 = BigDecimal.valueOf(86400L);
    public static final BigDecimal BD_146097 = BigDecimal.valueOf(146097L);
    public static final BigDecimal BD_36525 = BigDecimal.valueOf(36525L);
    public static final BigDecimal BD_36524 = BigDecimal.valueOf(36524L);
    public static final BigDecimal BD_3600 = BigDecimal.valueOf(3600L);
    public static final BigDecimal BD_1461 = BigDecimal.valueOf(1461L);
    public static final BigDecimal BD_1000 = BigDecimal.valueOf(1000L);
    public static final BigDecimal BD_366 = BigDecimal.valueOf(366L);
    public static final BigDecimal BD_365 = BigDecimal.valueOf(365L);
    public static final BigDecimal BD_153 = BigDecimal.valueOf(153L);
    public static final BigDecimal BD_100 = BigDecimal.valueOf(100L);
    public static final BigDecimal BD_60 = BigDecimal.valueOf(60L);
    public static final BigDecimal BD_5 = BigDecimal.valueOf(5L);
    public static final BigDecimal BD_4 = BigDecimal.valueOf(4L);
    public static final BigDecimal BD_2 = BigDecimal.valueOf(2L);
    public static final Dec ZERO = new Dec(BigDecimal.ZERO);
    public static final Dec ONE = new Dec(BigDecimal.ONE);
    private final BigDecimal value;

    private Dec(BigDecimal value) {
        super(AtomType.DECIMAL);
        this.value = value;
    }

    public static Dec get(BigDecimal value) {
        return value.signum() == 0 ? ZERO : new Dec(value);
    }

    @Override
    public byte[] string() {
        return Token.chopNumber(Token.token(this.value.toPlainString()));
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value.signum() != 0;
    }

    @Override
    public long itr() {
        return this.value.longValue();
    }

    @Override
    public float flt() {
        return this.value.floatValue();
    }

    @Override
    public double dbl() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.value;
    }

    @Override
    public Dec abs() {
        return this.value.signum() == -1 ? Dec.get(this.value.negate()) : this;
    }

    @Override
    public Dec ceiling() {
        return Dec.get(this.value.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public Dec floor() {
        return Dec.get(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public Dec round(int prec, FnRound.RoundMode mode) {
        if (this.value.signum() == 0) {
            return this;
        }
        BigDecimal v = Dec.round(this.value, prec, mode);
        return v.equals(this.value) ? this : Dec.get(v);
    }

    static BigDecimal round(BigDecimal value, int prec, FnRound.RoundMode mode) {
        if (prec >= value.scale()) {
            return value;
        }
        BigDecimal l = value.setScale(prec, RoundingMode.FLOOR);
        BigDecimal u = value.setScale(prec, RoundingMode.CEILING);
        boolean pos = value.signum() >= 0;
        BooleanSupplier mw = () -> l.add(u).divide(BigDecimal.valueOf(2L)).compareTo(value) == 0;
        Supplier<BigDecimal> n = () -> value.setScale(prec, RoundingMode.HALF_UP);
        return switch (mode) {
            case FnRound.RoundMode.FLOOR -> l;
            case FnRound.RoundMode.CEILING -> u;
            case FnRound.RoundMode.TOWARD_ZERO -> {
                if (pos) {
                    yield l;
                }
                yield u;
            }
            case FnRound.RoundMode.AWAY_FROM_ZERO -> {
                if (pos) {
                    yield u;
                }
                yield l;
            }
            case FnRound.RoundMode.HALF_TO_FLOOR -> {
                if (mw.getAsBoolean()) {
                    yield l;
                }
                yield n.get();
            }
            case FnRound.RoundMode.HALF_TO_CEILING -> {
                if (mw.getAsBoolean()) {
                    yield u;
                }
                yield n.get();
            }
            case FnRound.RoundMode.HALF_TOWARD_ZERO -> {
                if (mw.getAsBoolean()) {
                    if (pos) {
                        yield l;
                    }
                    yield u;
                }
                yield n.get();
            }
            case FnRound.RoundMode.HALF_AWAY_FROM_ZERO -> {
                if (mw.getAsBoolean()) {
                    if (pos) {
                        yield u;
                    }
                    yield l;
                }
                yield n.get();
            }
            default -> value.setScale(prec, RoundingMode.HALF_EVEN);
        };
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        int n;
        if (item instanceof Dec) {
            Dec dec = (Dec)item;
            n = this.value.compareTo(dec.value);
        } else {
            n = this.compare(item, transitive, ii);
        }
        return n;
    }

    @Override
    public Object toJava() {
        return this.value;
    }

    @Override
    public int hashCode() {
        BigInteger bi;
        if (this.value.stripTrailingZeros().scale() <= 0 && (bi = this.value.toBigInteger()).bitLength() < 32) {
            return bi.intValue();
        }
        return super.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Dec)) return false;
        Dec dec = (Dec)obj;
        if (this.value.compareTo(dec.value) != 0) return false;
        return true;
    }

    public static BigDecimal parse(byte[] value, InputInfo info, boolean error) throws QueryException {
        boolean valid = value.length != 0;
        boolean dot = false;
        if (valid) {
            for (byte v : value) {
                if (v == 46) {
                    dot = true;
                    continue;
                }
                if (Token.digit(v) || Token.ws(v) || v == 43 || v == 45) continue;
                valid = false;
                break;
            }
        }
        if (valid) {
            long l;
            if (!dot && (l = Token.toLong(value)) != Long.MIN_VALUE) {
                return BigDecimal.valueOf(l);
            }
            try {
                return new BigDecimal(Token.string(value).trim());
            }
            catch (NumberFormatException ex) {
                Util.debug(ex);
            }
        }
        if (error) {
            throw AtomType.DECIMAL.castError(value, info);
        }
        return null;
    }
}

