/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.expr.path.InvDocTest;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;

public final class DocTest
extends Test {
    private final Test child;

    public DocTest(Test child) {
        super(NodeType.DOCUMENT_NODE);
        this.child = child;
    }

    @Override
    public Test copy() {
        return new DocTest(this.child);
    }

    @Override
    public boolean matches(ANode node) {
        if (node.type != NodeType.DOCUMENT_NODE) {
            return false;
        }
        BasicNodeIter iter = node.childIter();
        boolean found = false;
        for (ANode n : iter) {
            if (n.type.oneOf(NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION)) continue;
            if (found || !this.child.matches(n)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public Test intersect(Test test) {
        if (test instanceof DocTest) {
            DocTest dt = (DocTest)test;
            if (this.child == null || dt.child == null || this.child.equals(dt.child)) {
                return this.child != null ? this : test;
            }
            Test tp = this.child.intersect(dt.child);
            return tp == null ? null : new DocTest(tp);
        }
        if (test instanceof NodeTest) {
            return this.type.instanceOf(test.type) ? this : null;
        }
        if (test instanceof UnionTest) {
            return test.intersect(this);
        }
        if (test instanceof InvDocTest) {
            return this;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DocTest)) return false;
        DocTest dt = (DocTest)obj;
        if (!obj.equals(dt.child)) return false;
        return true;
    }

    @Override
    public String toString(boolean full) {
        return this.type.toString(this.child.toString());
    }
}

