/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTWords;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTMode;
import org.basex.util.hash.IntObjectMap;

public final class FTIndexAccess
extends Simple {
    private IndexDb db;
    private FTExpr ftexpr;

    public FTIndexAccess(InputInfo info, FTExpr ftexpr, IndexDb db) {
        super(info, Types.TEXT_ZM);
        this.ftexpr = ftexpr;
        this.db = db;
        this.exprType.data(db.data());
    }

    @Override
    public NodeIter iter(final QueryContext qc) throws QueryException {
        final FTIter iter = this.ftexpr.iter(qc);
        return new NodeIter(){

            @Override
            public ANode next() throws QueryException {
                FTNode item = iter.next();
                if (item != null) {
                    if (qc.scoring) {
                        item.score();
                    }
                    if (qc.ftPosData != null) {
                        qc.ftPosData.add(item.data(), item.pre(), item.matches());
                    }
                    item.matches(null);
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.ftexpr.has(flags) || this.db.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.ftexpr.inlineable(ic) && this.db.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.ftexpr.count(var).plus(this.db.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        IndexDb inlined;
        FTExpr ftinlined = this.ftexpr.inline(ic);
        if (ftinlined != null) {
            this.ftexpr = ftinlined;
        }
        if ((inlined = this.db.inline(ic)) != null) {
            this.db = inlined;
        }
        return ftinlined != null || inlined != null ? this.optimize(ic.cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new FTIndexAccess(this.info, (FTExpr)this.ftexpr.copy(cc, (IntObjectMap)vm), (IndexDb)this.db.copy(cc, (IntObjectMap)vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.ftexpr.accept(visitor) && this.db.accept(visitor);
    }

    @Override
    public boolean ddo() {
        return true;
    }

    @Override
    public int exprSize() {
        return this.ftexpr.exprSize() + this.db.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FTIndexAccess)) return false;
        FTIndexAccess fti = (FTIndexAccess)obj;
        if (!this.ftexpr.equals(fti.ftexpr)) return false;
        if (!this.db.equals(fti.db)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.db, this.ftexpr);
    }

    @Override
    public void toString(QueryString qs) {
        Expr expr = this.ftexpr;
        FTExpr fTExpr = this.ftexpr;
        if (fTExpr instanceof FTWords) {
            FTWords ftw = (FTWords)fTExpr;
            if (ftw.mode == FTMode.ANY && ftw.occ == null && ftw.simple) {
                expr = ftw.query;
            }
        }
        qs.function(Function._FT_SEARCH, this.db, expr);
    }
}

